/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;
import org.keycloak.common.util.DurationConverter;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.models.workflow.WorkflowProvider;
import org.keycloak.models.workflow.WorkflowStepProvider;
import org.keycloak.models.workflow.WorkflowStepProviderFactory;
import org.keycloak.models.workflow.Workflows;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParser;
import org.keycloak.models.workflow.conditions.expression.ConditionNameCollector;
import org.keycloak.models.workflow.conditions.expression.EvaluatorUtils;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.utils.StringUtil;

public class WorkflowValidator {
    public static void validateWorkflow(KeycloakSession session, WorkflowProvider provider, WorkflowRepresentation rep) throws WorkflowInvalidStateException {
        List steps;
        WorkflowValidator.validateWorkflowName(provider, rep);
        if (StringUtil.isNotBlank((String)rep.getOn())) {
            WorkflowValidator.validateConditionExpression(session, rep.getOn(), "on");
        }
        if (StringUtil.isNotBlank((String)rep.getConditions())) {
            WorkflowValidator.validateConditionExpression(session, rep.getConditions(), "if");
        }
        if (StringUtil.isNotBlank((String)rep.getCancelInProgress())) {
            WorkflowValidator.validateConditionExpression(session, rep.getCancelInProgress(), "cancel-in-progress");
        }
        if (StringUtil.isNotBlank((String)rep.getRestartInProgress())) {
            WorkflowValidator.validateConditionExpression(session, rep.getRestartInProgress(), "restart-in-progress");
        }
        if ((steps = Optional.ofNullable(rep.getSteps()).orElse(List.of())).isEmpty()) {
            return;
        }
        steps.forEach(step -> WorkflowValidator.validateStep(session, step));
        List<WorkflowStepRepresentation> restartSteps = steps.stream().filter(step -> Objects.equals("restart", step.getUses())).toList();
        if (!restartSteps.isEmpty()) {
            int position;
            if (restartSteps.size() > 1) {
                throw new WorkflowInvalidStateException("Workflow can have only one restart step.");
            }
            WorkflowStepRepresentation restartStep = restartSteps.get(0);
            if (steps.indexOf(restartStep) != steps.size() - 1) {
                throw new WorkflowInvalidStateException("Workflow restart step must be the last step.");
            }
            MultivaluedHashMap config = restartStep.getConfig();
            int n = position = config == null ? 0 : Integer.parseInt((String)config.getFirstOrDefault((Object)"position", (Object)"0"));
            if (position < 0 || position >= steps.size()) {
                throw new WorkflowInvalidStateException("Workflow restart step has invalid position: " + position);
            }
            boolean hasScheduledStep = steps.stream().skip(position).anyMatch(step -> DurationConverter.isPositiveDuration((String)step.getAfter()));
            if (!hasScheduledStep) {
                throw new WorkflowInvalidStateException("No scheduled step found if restarting at position " + position);
            }
        }
    }

    private static void validateStep(KeycloakSession session, WorkflowStepRepresentation step) throws WorkflowInvalidStateException {
        if (StringUtil.isBlank((String)step.getUses())) {
            throw new WorkflowInvalidStateException("Step 'uses' cannot be null or empty.");
        }
        try {
            Duration duration = DurationConverter.parseDuration((String)step.getAfter());
            if (duration != null && duration.isNegative()) {
                throw new WorkflowInvalidStateException("Step 'after' configuration cannot be negative.");
            }
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowInvalidStateException("Step 'after' configuration is not valid: " + step.getAfter());
        }
        WorkflowStepProviderFactory factory = (WorkflowStepProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(WorkflowStepProvider.class, step.getUses());
        if (factory == null) {
            throw new WorkflowInvalidStateException("Could not find step provider: " + step.getUses());
        }
    }

    private static void validateConditionExpression(KeycloakSession session, String expression, String fieldName) throws WorkflowInvalidStateException {
        if (Boolean.parseBoolean(expression)) {
            return;
        }
        BooleanConditionParser.EvaluatorContext context = EvaluatorUtils.createEvaluatorContext(expression);
        ConditionNameCollector collector = new ConditionNameCollector();
        collector.visit((ParseTree)context);
        if ("on".equals(fieldName) || "restart-in-progress".equals(fieldName) || "cancel-in-progress".equals(fieldName)) {
            for (String name2 : collector.getConditionNames()) {
                try {
                    ResourceOperationType.valueOf((String)name2.replace("-", "_").toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    throw new WorkflowInvalidStateException("Could not find event: " + name2);
                }
            }
        } else if ("if".equals(fieldName)) {
            collector.getConditionNames().forEach(name -> Workflows.getConditionProvider((KeycloakSession)session, (String)name, (String)expression));
        }
    }

    private static void validateWorkflowName(WorkflowProvider provider, WorkflowRepresentation representation) throws WorkflowInvalidStateException {
        String name = representation.getName();
        if (StringUtil.isBlank((String)name)) {
            throw new WorkflowInvalidStateException("Workflow name cannot be null or empty.");
        }
        if (provider.getWorkflows().anyMatch(wf -> wf.getName().equals(name) && !wf.getId().equals(representation.getId()))) {
            throw new WorkflowInvalidStateException("Workflow name must be unique. A workflow with name '" + name + "' already exists.");
        }
    }
}

