/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;

public class DefaultLockOptions
implements LockOptions {
    private FileLockManager.LockMode mode;
    private boolean crossVersion;

    private DefaultLockOptions(FileLockManager.LockMode mode, boolean crossVersion) {
        this.mode = mode;
        this.crossVersion = crossVersion;
    }

    public static DefaultLockOptions mode(FileLockManager.LockMode lockMode) {
        return new DefaultLockOptions(lockMode, false);
    }

    public DefaultLockOptions useCrossVersionImplementation() {
        this.crossVersion = true;
        return this;
    }

    @Override
    public FileLockManager.LockMode getMode() {
        return this.mode;
    }

    @Override
    public boolean isUseCrossVersionImplementation() {
        return this.crossVersion;
    }

    @Override
    public LockOptions copyWithMode(FileLockManager.LockMode mode) {
        return new DefaultLockOptions(mode, this.crossVersion);
    }

    public String toString() {
        return "DefaultLockOptions{mode=" + (Object)((Object)this.mode) + ", crossVersion=" + this.crossVersion + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultLockOptions)) {
            return false;
        }
        DefaultLockOptions that = (DefaultLockOptions)o;
        if (this.crossVersion != that.crossVersion) {
            return false;
        }
        return this.mode == that.mode;
    }

    public int hashCode() {
        int result = this.mode.hashCode();
        result = 31 * result + (this.crossVersion ? 1 : 0);
        return result;
    }
}

