/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.internal.tasks.TaskLocalStateInternal;
import org.gradle.execution.plan.DefaultExecutionPlan;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeSets;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.OrdinalNodeAccess;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.properties.OutputFilePropertyType;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.reflect.validation.TypeValidationContext;

class DetermineExecutionPlanAction {
    private final DefaultExecutionPlan.NodeMapping nodeMapping;
    private final OrdinalNodeAccess ordinalNodeAccess;
    private final Set<Node> entryNodes;
    private final Set<Node> finalizers;
    private final LinkedList<NodeInVisitingSegment> nodeQueue = new LinkedList();
    private final HashMultimap<Node, Integer> visitingNodes = HashMultimap.create();
    private final Deque<GraphEdge> walkedShouldRunAfterEdges = new ArrayDeque<GraphEdge>();
    private final Deque<Node> path = new ArrayDeque<Node>();
    private final Map<Node, Integer> planBeforeVisiting = new HashMap<Node, Integer>();
    private int visitingSegmentCounter = 0;

    public DetermineExecutionPlanAction(DefaultExecutionPlan.NodeMapping nodeMapping, OrdinalNodeAccess ordinalNodeAccess, Set<Node> entryNodes, Set<Node> finalizers) {
        this.entryNodes = entryNodes;
        this.nodeMapping = nodeMapping;
        this.ordinalNodeAccess = ordinalNodeAccess;
        this.finalizers = finalizers;
    }

    public ImmutableList<Node> run() {
        this.updateFinalizerGroups();
        this.processEntryNodes();
        this.processNodeQueue();
        return this.createOrdinalRelationshipsAndCollectNodes();
    }

    private void updateFinalizerGroups() {
        if (this.finalizers.isEmpty()) {
            return;
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        HashSet<Node> visiting = new HashSet<Node>();
        HashSet<Node> visited = new HashSet<Node>();
        ArrayDeque<Node> queue = new ArrayDeque<Node>(this.finalizers);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.peek();
            if (node.isCannotRunInAnyPlan() || visited.contains(node)) {
                queue.remove();
                continue;
            }
            if (visiting.add(node)) {
                for (Node successor : node.getDependencySuccessors()) {
                    queue.addFirst(successor);
                }
                continue;
            }
            visiting.remove(node);
            visited.add(node);
            nodes.addFirst(node);
        }
        for (Node node : nodes) {
            node.maybeInheritFinalizerGroups();
        }
    }

    private void processEntryNodes() {
        for (Node node : this.entryNodes) {
            this.nodeQueue.add(new NodeInVisitingSegment(node, this.visitingSegmentCounter++));
        }
    }

    private void processNodeQueue() {
        while (!this.nodeQueue.isEmpty()) {
            NodeInVisitingSegment nodeInVisitingSegment = this.nodeQueue.peekFirst();
            int currentSegment = nodeInVisitingSegment.visitingSegment;
            Node node = nodeInVisitingSegment.node;
            if (node.isDoNotIncludeInPlan() || this.nodeMapping.contains(node)) {
                this.nodeQueue.removeFirst();
                this.visitingNodes.remove((Object)node, (Object)currentSegment);
                this.maybeRemoveProcessedShouldRunAfterEdge(node);
                continue;
            }
            if (this.visitingNodes.put((Object)node, (Object)currentSegment)) {
                if (node instanceof TaskNode) {
                    TaskNode taskNode = (TaskNode)node;
                    this.recordEdgeIfArrivedViaShouldRunAfter(this.path, taskNode);
                    this.removeShouldRunAfterSuccessorsIfTheyImposeACycle(taskNode, nodeInVisitingSegment.visitingSegment);
                    this.takePlanSnapshotIfCanBeRestoredToCurrentTask(this.planBeforeVisiting, taskNode);
                }
                for (Node finalizer : node.getFinalizers()) {
                    this.addFinalizerToQueue(this.visitingSegmentCounter++, finalizer);
                }
                ListIterator<NodeInVisitingSegment> insertPoint = this.nodeQueue.listIterator();
                for (Node successor : node.getAllSuccessors()) {
                    if (this.visitingNodes.containsEntry((Object)successor, (Object)currentSegment)) {
                        if (!this.walkedShouldRunAfterEdges.isEmpty()) {
                            GraphEdge toBeRemoved = this.walkedShouldRunAfterEdges.pop();
                            TaskNode sourceTask = (TaskNode)toBeRemoved.from;
                            TaskNode targetTask = (TaskNode)toBeRemoved.to;
                            sourceTask.removeShouldSuccessor(targetTask);
                            this.restorePath(this.path, toBeRemoved);
                            this.restoreQueue(toBeRemoved);
                            this.restoreExecutionPlan(this.planBeforeVisiting, toBeRemoved);
                            break;
                        }
                        this.onOrderingCycle(successor, node);
                    }
                    insertPoint.add(new NodeInVisitingSegment(successor, currentSegment));
                }
                this.path.push(node);
                continue;
            }
            this.nodeQueue.removeFirst();
            this.maybeRemoveProcessedShouldRunAfterEdge(node);
            this.visitingNodes.remove((Object)node, (Object)currentSegment);
            this.path.pop();
            this.nodeMapping.add(node);
        }
    }

    private ImmutableList<Node> createOrdinalRelationshipsAndCollectNodes() {
        ImmutableList.Builder scheduledNodes = ImmutableList.builderWithExpectedSize((int)this.nodeMapping.size());
        for (Node node : this.nodeMapping) {
            node.maybeUpdateOrdinalGroup();
            this.createOrdinalRelationships(node, (ImmutableList.Builder<Node>)scheduledNodes);
            scheduledNodes.add((Object)node);
        }
        this.nodeMapping.addAll(this.ordinalNodeAccess.getAllNodes());
        return scheduledNodes.build();
    }

    private void addFinalizerToQueue(int visitingSegmentCounter, Node finalizer) {
        int insertPosition = 1;
        int pos = 0;
        for (NodeInVisitingSegment segment : this.nodeQueue) {
            if (segment.node == finalizer) {
                return;
            }
            if (finalizer.getFinalizingSuccessors().contains(segment.node) && pos > insertPosition) {
                insertPosition = pos;
            }
            ++pos;
        }
        this.nodeQueue.add(insertPosition, new NodeInVisitingSegment(finalizer, visitingSegmentCounter));
    }

    private void maybeRemoveProcessedShouldRunAfterEdge(Node node) {
        GraphEdge edge = this.walkedShouldRunAfterEdges.peek();
        if (edge != null && edge.to.equals(node)) {
            this.walkedShouldRunAfterEdges.pop();
        }
    }

    private void restoreExecutionPlan(Map<Node, Integer> planBeforeVisiting, GraphEdge toBeRemoved) {
        int count = planBeforeVisiting.get(toBeRemoved.from);
        this.nodeMapping.retainFirst(count);
    }

    private void restoreQueue(GraphEdge toBeRemoved) {
        NodeInVisitingSegment nextInQueue = null;
        while (nextInQueue == null || !toBeRemoved.from.equals(nextInQueue.node)) {
            nextInQueue = this.nodeQueue.peekFirst();
            this.visitingNodes.remove((Object)nextInQueue.node, (Object)nextInQueue.visitingSegment);
            if (toBeRemoved.from.equals(nextInQueue.node)) continue;
            this.nodeQueue.removeFirst();
        }
    }

    private void restorePath(Deque<Node> path, GraphEdge toBeRemoved) {
        Node removedFromPath = null;
        while (!toBeRemoved.from.equals(removedFromPath)) {
            removedFromPath = path.pop();
        }
    }

    private void removeShouldRunAfterSuccessorsIfTheyImposeACycle(TaskNode node, int visitingSegment) {
        Iterables.removeIf(node.getShouldSuccessors(), input -> this.visitingNodes.containsEntry(input, (Object)visitingSegment));
    }

    private void takePlanSnapshotIfCanBeRestoredToCurrentTask(Map<Node, Integer> planBeforeVisiting, TaskNode node) {
        if (!node.getShouldSuccessors().isEmpty()) {
            planBeforeVisiting.put(node, this.nodeMapping.size());
        }
    }

    private void recordEdgeIfArrivedViaShouldRunAfter(Deque<Node> path, TaskNode node) {
        Node previous = path.peek();
        if (!(previous instanceof TaskNode)) {
            return;
        }
        TaskNode previousTaskNode = (TaskNode)previous;
        if (previousTaskNode.getShouldSuccessors().contains(node)) {
            this.walkedShouldRunAfterEdges.push(new GraphEdge(previous, node));
        }
    }

    private void onOrderingCycle(Node successor, Node currentNode) {
        List<Set<Node>> cycles = this.findCycles(successor);
        if (cycles.isEmpty()) {
            throw new GradleException("Misdetected cycle between " + currentNode + " and " + successor + ". Help us by reporting this to https://github.com/gradle/gradle/issues/2293");
        }
        StringWriter cycleString = this.renderOrderingCycle(cycles.get(0));
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", cycleString));
    }

    private List<Set<Node>> findCycles(Node successor) {
        CachingDirectedGraphWalker graphWalker = new CachingDirectedGraphWalker((node, values, connectedNodes) -> node.getHardSuccessors().forEach(connectedNodes::add));
        graphWalker.add((Object[])new Node[]{successor});
        return graphWalker.findCycles();
    }

    private StringWriter renderOrderingCycle(Set<Node> nodes) {
        List<Node> cycle = NodeSets.sortedListOf(nodes);
        DirectedGraphRenderer<Node> graphRenderer = new DirectedGraphRenderer<Node>((it, output, alreadySeen) -> output.withStyle(StyledTextOutput.Style.Identifier).text(it), (it, values, connectedNodes) -> {
            for (Node dependency : cycle) {
                HashSet successors = Sets.newHashSet(it.getHardSuccessors());
                if (!(dependency instanceof TaskNode) || !successors.contains(dependency)) continue;
                connectedNodes.add(dependency);
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo(cycle.get(0), writer);
        return writer;
    }

    private void createOrdinalRelationships(Node node, ImmutableList.Builder<Node> scheduleBuilder) {
        if (!(node instanceof LocalTaskNode)) {
            return;
        }
        OrdinalGroup ordinal = node.getOrdinal();
        if (ordinal == null) {
            return;
        }
        LocalTaskNode taskNode = (LocalTaskNode)node;
        TaskClassifier taskClassifier = this.classifyTask(taskNode);
        if (taskClassifier.isDestroyer()) {
            this.ordinalNodeAccess.addDestroyerNode(ordinal, taskNode, arg_0 -> scheduleBuilder.add(arg_0));
        } else if (taskClassifier.isProducer()) {
            this.ordinalNodeAccess.addProducerNode(ordinal, taskNode, arg_0 -> scheduleBuilder.add(arg_0));
        }
    }

    private TaskClassifier classifyTask(LocalTaskNode taskNode) {
        TaskClassifier taskClassifier = new TaskClassifier();
        TaskInternal task = taskNode.getTask();
        PropertyWalker propertyWalker = this.propertyWalkerOf(task);
        propertyWalker.visitProperties((Object)task, TypeValidationContext.NOOP, (PropertyVisitor)taskClassifier);
        task.getOutputs().visitRegisteredProperties(taskClassifier);
        if (taskClassifier.isDestroyer()) {
            return taskClassifier;
        }
        ((TaskDestroyablesInternal)task.getDestroyables()).visitRegisteredProperties(taskClassifier);
        if (taskClassifier.isDestroyer()) {
            return taskClassifier;
        }
        ((TaskLocalStateInternal)task.getLocalState()).visitRegisteredProperties(taskClassifier);
        return taskClassifier;
    }

    private PropertyWalker propertyWalkerOf(TaskInternal task) {
        return (PropertyWalker)((ProjectInternal)task.getProject()).getServices().get(PropertyWalker.class);
    }

    private static class NodeInVisitingSegment {
        private final Node node;
        private final int visitingSegment;

        private NodeInVisitingSegment(Node node, int visitingSegment) {
            this.node = node;
            this.visitingSegment = visitingSegment;
        }

        public String toString() {
            return "NodeInVisitingSegment{node=" + this.node + ", visitingSegment=" + this.visitingSegment + '}';
        }
    }

    private static class GraphEdge {
        private final Node from;
        private final Node to;

        private GraphEdge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return "GraphEdge{from=" + this.from + ", to=" + this.to + '}';
        }
    }

    private static class TaskClassifier
    implements PropertyVisitor {
        private boolean isProducer;
        private boolean isDestroyer;

        private TaskClassifier() {
        }

        public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
            this.isProducer = true;
        }

        public void visitDestroyableProperty(Object value) {
            this.isDestroyer = true;
        }

        public void visitLocalStateProperty(Object value) {
            this.isProducer = true;
        }

        public boolean isProducer() {
            return this.isProducer;
        }

        public boolean isDestroyer() {
            return this.isDestroyer;
        }
    }
}

