/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;

public class DelegatingGlobalSearchScope
extends GlobalSearchScope {
    protected final GlobalSearchScope myBaseScope;
    private final Object myEquality;

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope) {
        if (baseScope == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(0);
        }
        this(baseScope, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope, Object ... equality) {
        if (baseScope == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(1);
        }
        if (equality == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(2);
        }
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myEquality = equality.length == 0 ? Collections.emptyList() : Arrays.asList(equality);
    }

    public DelegatingGlobalSearchScope(@NotNull Project project, @NotNull GlobalSearchScope baseScope) {
        if (project == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(3);
        }
        if (baseScope == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(4);
        }
        super(project);
        this.myBaseScope = baseScope;
        this.myEquality = Collections.emptyList();
    }

    protected DelegatingGlobalSearchScope(@NotNull Project project) {
        if (project == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(5);
        }
        super(project);
        this.myBaseScope = null;
        this.myEquality = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(6);
        }
        return this.getDelegate().contains(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(8);
        }
        return this.getDelegate().compare(file1, file2);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(9);
        }
        return this.getDelegate().isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(10);
        }
        return this.getDelegate().isSearchInModuleContent(aModule, testSources);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.getDelegate().isSearchInLibraries();
    }

    @Override
    @NotNull
    public Collection<Object> getUnloadedModulesBelongingToScope() {
        Collection<Object> collection = this.getDelegate().getUnloadedModulesBelongingToScope();
        if (collection == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.getDelegate().getDisplayName();
        if (string == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.getDelegate().getIcon();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getDelegate() + "]";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DelegatingGlobalSearchScope that = (DelegatingGlobalSearchScope)o2;
        if (!this.getDelegate().equals(that.getDelegate())) {
            return false;
        }
        return this.myEquality.equals(that.myEquality);
    }

    @Override
    public int calcHashCode() {
        int result2 = this.getDelegate().calcHashCode();
        result2 = 31 * result2 + this.myEquality.hashCode();
        return result2;
    }

    @NotNull
    public GlobalSearchScope getDelegate() {
        GlobalSearchScope globalSearchScope = this.myBaseScope;
        if (globalSearchScope == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope unwrap() {
        GlobalSearchScope delegate = this.getDelegate();
        GlobalSearchScope globalSearchScope = delegate instanceof DelegatingGlobalSearchScope ? ((DelegatingGlobalSearchScope)delegate).unwrap() : delegate;
        if (globalSearchScope == null) {
            DelegatingGlobalSearchScope.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/DelegatingGlobalSearchScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/DelegatingGlobalSearchScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

