---
stage: AI-powered
group: Agent Foundations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GitLab Duo Agent Platformのトラブルシューティング
---

GitLab Duo Agent Platformを使用している場合、次の問題が発生する可能性があります。

## ジョブログを表示 {#view-logs}

フローの作成後、**自動化** > **セッション**に移動してフローのセッションを表示できます。

**詳細**タブには、CI/CDジョブログへのリンクが表示されます。これらのジョブログには、トラブルシューティング情報が含まれている場合があります。

## UIにフローが表示されない {#flows-not-visible-in-the-ui}

フローを実行しようとしているのに、GitLab UIに表示されない場合:

1. プロジェクトで少なくともデベロッパーロールを持っていることを確認してください。
1. GitLab Duoが[オンになっていて、フローの実行が許可されている](../gitlab_duo/turn_on_off.md)ことを確認してください。
1. 使用しようとしているフローに必要な機能フラグが有効になっていることを確認してください。最新のフラグ情報フローについては、機能のドキュメント履歴を確認してください。
1. それでも動作しない場合:
   1. トップレベルグループ内の影響を受けるフローを無効にし、設定を保存します。
   1. トップレベルグループ内の影響を受けるフローを有効にし、設定を保存します。
   1. 設定がグループ全体に反映されるまで数分待ちます。

## セッションが作成済みの状態から動かない {#session-is-stuck-in-created-state}

フローのセッションが開始されない場合:

- メンバーがプロジェクトに追加されるのを妨げていないことを確認してください。
- プッシュルールが構成されていることを確認してください。

### メンバーがプロジェクトに追加されることを許可する {#allow-members-to-be-added-to-projects}

[複合ID](composite_identity.md)を使用するフローは、`@duo-developer`サービスアカウントをプロジェクトに追加する必要があります。グループが制限されている場合、ユーザーをプロジェクトに直接追加できず、フローは実行されません。

プロジェクトでフローを実行する前に、[メンバーがプロジェクトに追加されるのを防ぐ]( ../group/access_and_permissions.md#prevent-members-from-being-added-to-projects-in-a-group)設定をオフにしてください。この手順は、最初のフローを実行するために1回だけ行う必要があります。その後、設定を元に戻すことができます。

### サービスアカウントを許可するようにプッシュルールを構成する {#configure-push-rules-to-allow-a-service-account}

GitLab UIでは、基本的なフローは次のサービスアカウントを使用します:

- 独自のメールアドレスでコミットを作成します。
- `workloads/`プレフィックス（例: `workloads/a1b2c3d4e5f`）を使用してブランチを作成します。

前提条件: 

- 管理者アクセス。

プロジェクトのプッシュルールを構成するには:

1. サービスアカウントに関連付けられたメールアドレスを見つけます:
   1. 右上隅で、**管理者**を選択します。
   1. 右上隅で、**概要** > **ユーザー**を選択し、`duo-developer`を検索します。
   1. `duo-developer`ユーザーを見つけて、メールアドレスをコピーします。

1. メールアドレスがプロジェクトにプッシュできるようにします:
   1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
   1. **設定** > **リポジトリ**を選択します。
   1. **プッシュルール**を展開します。
   1. **コミットの作成者のメール**で、コピーしたばかりのメールアドレスを許可する正規表現を追加します。
   1. **プッシュルールを保存**を選択します。

1. `workloads/`および`duo/feature/`ブランチのプレフィックスを許可します:
   1. **プッシュルール**セクションで、**ブランチ名**を見つけます。
   1. `workloads/`および`duo/feature/`で始まるブランチを許可する正規表現を追加します。例: `^(workloads|duo/feature)/.*$`。
   1. **プッシュルールを保存**を選択します。

インスタンスのプッシュルールを作成するには:

1. 右上隅で、**管理者**を選択します。
1. **プッシュルール**を選択します。
1. 前の手順に従って、**コミットの作成者のメール**と**ブランチ名**を許可します。
1. **プッシュルールを保存**を選択します。
