---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: ソフトウェア開発向けの、最もスケーラブルなGitベースの完全統合型プラットフォームであるGitLabの使用方法と管理方法について説明します。
title: 'GitLab: DevSecOpsプラットフォーム'
---

DevSecOpsは、開発、セキュリティ、運用を組み合わせたものです。これは、ソフトウェア開発ライフサイクル全体にセキュリティを統合するソフトウェア開発へのアプローチです。

## DevSecOpsとDevOpsの比較 {#devsecops-compared-to-devops}

DevOpsは、ソフトウェア開発とデリバリーの効率性、スピード、セキュリティを向上させることを目的として、開発と運用を組み合わせたものです。

DevOpsとは、最高のスピードで安全なソフトウェアを考案、ビルド、提供するために協力することです。DevOpsの実践には、自動化、コラボレーション、迅速なフィードバック、反復的な改善が含まれます。

DevSecOpsはDevOpsの進化形です。DevSecOpsには、ソフトウェア開発のすべての段階でアプリケーションセキュリティの実践が含まれています。

開発プロセス全体を通して、ツールと方法がライブアプリケーションを保護および監視します。新しいアタックサーフェス（コンテナやオーケストレーターなど）も監視および保護する必要があります。DevSecOpsツールは、セキュリティワークフローを自動化して、開発チームとセキュリティチームに適応可能なプロセスを作成し、コラボレーションを改善し、サイロを解消します。ソフトウェア開発ライフサイクルにセキュリティを組み込むことで、迅速かつ反復的なプロセスを継続的に保護し、品質を犠牲にすることなく効率性を向上させることができます。

## DevSecOpsの基礎 {#devsecops-fundamentals}

DevSecOpsの基礎には、以下が含まれます:

- 自動化
- コラボレーション
- ガードレールポリシー
- 表示レベル

詳細については、[DevSecOpsに関するこの記事](https://about.gitlab.com/topics/devsecops/)を参照してください。

## DevSecOpsはあなたに適していますか？ {#is-devsecops-right-for-you}

あなたの組織が以下の課題に直面している場合、DevSecOpsのアプローチが適しているかもしれません。

<!-- Do not delete the double spaces at the end of these lines. They improve the rendered view. -->

- 開発、セキュリティ、および運用チームがサイロ化されています。開発と運用がセキュリティの問題から隔離されている場合、安全なソフトウェアをビルドできません。また、セキュリティチームが開発プロセスに参加していない場合、事前にリスクを特定できません。DevSecOpsはチームをまとめてワークフローを改善し、アイデアを共有します。組織は、従業員の士気と保持の改善も見られるかもしれません。

- 開発サイクルが長いため、顧客または利害関係者の要求を満たすのが困難になっています。苦労の原因の1つは、セキュリティである可能性があります。DevSecOpsは、ソフトウェア開発ライフサイクルのすべてのステップでセキュリティを実装します。つまり、確実なセキュリティのためにプロセス全体を停止させる必要はありません。

- クラウドへ移行しようとしています（または検討しています）。クラウドに移行するということは、多くの場合、新しい開発プロセス、ツール、システムを導入することを意味します。プロセスをより速く、より安全にする絶好の機会であり、DevSecOpsはそれをはるかに簡単にします。

DevSecOpsを始めるには、[詳細を学び、GitLab Ultimateを無料でお試しください](https://about.gitlab.com/solutions/security-compliance/)。
