/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractElementLiveList;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.NDTNode;
import java.util.Locale;
import java.util.Objects;
import org.w3c.dom.Node;

class TagnameElementList
extends AbstractElementLiveList {
    private static final long serialVersionUID = 1L;
    private final String localName;
    private final String htmlLocalName;
    private final String prefix;
    private final boolean matchAll;
    private final boolean isHTML;

    TagnameElementList(NDTNode ndtNode, String localName, String prefix, boolean matchAll, boolean isHTML) {
        super(ndtNode);
        this.localName = localName;
        this.htmlLocalName = localName.toLowerCase(Locale.ROOT);
        this.prefix = prefix;
        this.matchAll = matchAll;
        this.isHTML = isHTML;
    }

    @Override
    boolean matches(DOMElement element, Node lookFor) {
        return element == lookFor && (this.matchAll || this.matchesLocalName(element)) && Objects.equals(this.prefix, element.getPrefix());
    }

    @Override
    boolean matches(DOMElement element) {
        return this.matchAll || this.matchesLocalName(element) && Objects.equals(this.prefix, element.getPrefix());
    }

    boolean matchesLocalName(DOMElement element) {
        String localNameToMatch = element.getLocalName();
        if (this.isHTML && element.getNamespaceURI() == "http://www.w3.org/1999/xhtml") {
            return localNameToMatch.equals(this.htmlLocalName);
        }
        return localNameToMatch.equals(this.localName);
    }
}

