/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.bootstrap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.ModeController;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.osgi.IModeControllerExtensionProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Java8BootstrapActivator
implements BundleActivator {
    static final int MINIMUM_SUPPORTED_JAVA_MAJOR_VERSION = 17;
    static final String RUNTIME_ACTIVATOR_CLASS_NAME = "org.freeplane.plugin.ai.Activator";
    private static final String RUNTIME_VERSION_TOO_LOW_MESSAGE_KEY = "ai_bootstrap_runtime_version_too_low";
    private static final String RUNTIME_ACTIVATION_FAILED_MESSAGE_KEY = "ai_bootstrap_runtime_activation_failed";
    private BundleActivator runtimeActivator;
    private ServiceRegistration<?> incompatibleModeExtensionRegistration;
    private BootstrapMessageProvider bootstrapMessageProvider;

    public void start(BundleContext context) throws Exception {
        this.bootstrapMessageProvider = this.createBootstrapMessageProvider();
        int runtimeJavaMajorVersion = this.resolveRuntimeJavaMajorVersion();
        if (runtimeJavaMajorVersion < 17) {
            String message = this.bootstrapMessageProvider.runtimeVersionTooLow(this.runtimeJavaMajorVersionString(runtimeJavaMajorVersion));
            LogUtils.info((String)message);
            this.registerIncompatibleModeExtension(context, message);
            return;
        }
        try {
            BundleActivator delegate = this.instantiateRuntimeActivator();
            delegate.start(context);
            this.runtimeActivator = delegate;
        }
        catch (Exception failure) {
            LogUtils.severe((String)"AI runtime activator failed to start", (Throwable)failure);
            String message = this.bootstrapMessageProvider.runtimeActivationFailed(this.runtimeJavaMajorVersionString(runtimeJavaMajorVersion));
            this.registerIncompatibleModeExtension(context, message);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.incompatibleModeExtensionRegistration != null) {
            this.incompatibleModeExtensionRegistration.unregister();
            this.incompatibleModeExtensionRegistration = null;
        }
        if (this.runtimeActivator != null) {
            this.runtimeActivator.stop(context);
            this.runtimeActivator = null;
        }
    }

    int resolveRuntimeJavaMajorVersion() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null || javaVersion.trim().isEmpty()) {
            return Integer.MAX_VALUE;
        }
        String normalizedJavaVersion = javaVersion.trim();
        if (normalizedJavaVersion.startsWith("1.")) {
            String[] segments = normalizedJavaVersion.split("\\.");
            if (segments.length > 1) {
                return this.parseJavaMajorVersionSegment(segments[1]);
            }
            return Integer.MAX_VALUE;
        }
        String[] segments = normalizedJavaVersion.split("\\.");
        return this.parseJavaMajorVersionSegment(segments[0]);
    }

    BundleActivator instantiateRuntimeActivator() throws Exception {
        Class<?> runtimeActivatorClass = Class.forName(RUNTIME_ACTIVATOR_CLASS_NAME);
        if (!BundleActivator.class.isAssignableFrom(runtimeActivatorClass)) {
            throw new IllegalStateException("Runtime activator class does not implement BundleActivator: org.freeplane.plugin.ai.Activator");
        }
        return (BundleActivator)runtimeActivatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    void registerIncompatibleModeExtension(BundleContext context, final String message) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("mode", new String[]{"MindMap"});
        this.incompatibleModeExtensionRegistration = context.registerService(IModeControllerExtensionProvider.class.getName(), (Object)new IModeControllerExtensionProvider(){

            public void installExtension(ModeController modeController, CommandLineOptions options) {
                Java8BootstrapActivator.this.addIncompatibleAiTab(message);
            }
        }, properties);
    }

    void addIncompatibleAiTab(String message) {
        JTabbedPane tabs = UITools.getFreeplaneTabbedPanel();
        JPanel messagePanel = new JPanel(new BorderLayout());
        JLabel messageLabel = new JLabel("<html><div style='text-align:center;padding:16px;'>" + this.escapeForHtml(message) + "</div></html>", 0);
        messagePanel.add((Component)messageLabel, "Center");
        tabs.addTab("", ResourceController.getResourceController().getIcon("/images/panelTabs/aiTab.svg?useAccentColor=true"), messagePanel, TextUtils.getText((String)"ai_panel"));
    }

    private int parseJavaMajorVersionSegment(String segment) {
        try {
            return Integer.parseInt(segment.replaceAll("[^0-9].*", ""));
        }
        catch (NumberFormatException ignored) {
            return Integer.MAX_VALUE;
        }
    }

    private String runtimeJavaMajorVersionString(int runtimeJavaMajorVersion) {
        return runtimeJavaMajorVersion == Integer.MAX_VALUE ? "unknown" : String.valueOf(runtimeJavaMajorVersion);
    }

    private String escapeForHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    BootstrapMessageProvider createBootstrapMessageProvider() {
        return new TextUtilsBootstrapMessageProvider();
    }

    static interface BootstrapMessageProvider {
        public String runtimeVersionTooLow(String var1);

        public String runtimeActivationFailed(String var1);
    }

    private static class TextUtilsBootstrapMessageProvider
    implements BootstrapMessageProvider {
        private TextUtilsBootstrapMessageProvider() {
        }

        @Override
        public String runtimeVersionTooLow(String runtimeJavaMajorVersion) {
            return this.formatTranslatedMessage(Java8BootstrapActivator.RUNTIME_VERSION_TOO_LOW_MESSAGE_KEY, runtimeJavaMajorVersion);
        }

        @Override
        public String runtimeActivationFailed(String runtimeJavaMajorVersion) {
            return this.formatTranslatedMessage(Java8BootstrapActivator.RUNTIME_ACTIVATION_FAILED_MESSAGE_KEY, runtimeJavaMajorVersion);
        }

        private String formatTranslatedMessage(String key, String runtimeJavaMajorVersion) {
            String pattern = TextUtils.getText((String)key);
            if (pattern == null) {
                return "-";
            }
            return new MessageFormat(pattern).format(new Object[]{runtimeJavaMajorVersion});
        }
    }
}

