/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.freeplane.view.swing.map.outline.MapTreeNode;

class TreeNode {
    static final int UNKNOWN_LEVEL = -1;
    private Supplier<String> titleSupplier;
    private String title;
    private final String id;
    private final List<TreeNode> children = new ArrayList<TreeNode>();
    private int expansionLevel = -1;
    private TreeNode parent = null;
    private int level = 0;

    TreeNode(String id, Supplier<String> titleSupplier) {
        this.id = id;
        this.titleSupplier = titleSupplier;
    }

    protected void setTitleSupplier(Supplier<String> titleSupplier) {
        this.titleSupplier = titleSupplier;
    }

    void update() {
        this.title = null;
    }

    void addChild(TreeNode child) {
        child.setParent(this);
        this.children.add(child);
        if (this.expansionLevel >= 0) {
            child.applyExpansionLevel(this.expansionLevel - 1);
        }
    }

    void applyExpansionLevel(int level) {
        this.applyExpansionLevel(level, LevelOperation.SET);
    }

    private void applyExpansionLevel(int level, LevelOperation expand) {
        if (expand.canApply(level, this.expansionLevel)) {
            this.setExpansionLevel(level);
        }
        if (level >= 0) {
            for (TreeNode child : this.getChildren()) {
                child.applyExpansionLevel(level - 1, expand);
            }
        } else {
            for (TreeNode child : this.getChildren()) {
                child.applyExpansionLevel(-1, expand);
            }
        }
    }

    void reduceNodeExpansion(int level) {
        this.applyExpansionLevel(level, LevelOperation.REDUCE);
    }

    void expandNodeMore(int level) {
        this.applyExpansionLevel(level, LevelOperation.EXPAND);
    }

    int getMaxExpansionLevel() {
        if (this.expansionLevel <= 0 || this.getChildren().isEmpty()) {
            return this.expansionLevel;
        }
        int maxLevel = 0;
        for (TreeNode child : this.getChildren()) {
            maxLevel = Math.max(maxLevel, 1 + child.getMaxExpansionLevel());
        }
        return maxLevel;
    }

    boolean isExpanded() {
        return this.expansionLevel > 0;
    }

    boolean isVisible() {
        return this.expansionLevel >= 0;
    }

    int getExpansionLevel() {
        return this.expansionLevel;
    }

    public String toString() {
        return "TreeNode [title=" + this.getTitle() + "]";
    }

    TreeNode getParent() {
        return this.parent;
    }

    void setParent(TreeNode parent) {
        this.parent = parent;
        if (parent != null) {
            this.refreshLevelsRecursively();
            this.applyExpansionLevel(Math.max(0, parent.expansionLevel) - 1);
        }
    }

    private void setExpansionLevel(int expansionLevel) {
        this.expansionLevel = expansionLevel;
    }

    List<TreeNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    int childCount() {
        return this.children.size();
    }

    void add(MapTreeNode node, int index) {
        if (index < this.children.size()) {
            this.children.add(index, node);
        } else {
            this.children.add(node);
        }
    }

    boolean remove(MapTreeNode toRemove) {
        return this.children.remove(toRemove);
    }

    String getId() {
        return this.id;
    }

    String getTitle() {
        if (this.title == null) {
            this.title = this.titleSupplier.get();
        }
        return this.title;
    }

    TreeNode findVisibleAncestorOrSelf() {
        for (TreeNode node = this; node != null; node = node.getParent()) {
            if (!node.isVisible()) continue;
            return node;
        }
        return null;
    }

    int getLevel() {
        return this.level;
    }

    private void refreshLevelsRecursively() {
        this.level = this.parent.level + 1;
        for (TreeNode child : this.children) {
            child.refreshLevelsRecursively();
        }
    }

    void setLevel(int level) {
        if (this.parent != null) {
            throw new IllegalStateException();
        }
        this.level = level;
    }

    boolean isAncestorOf(TreeNode node) {
        for (TreeNode ancestor = node.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (this != ancestor) continue;
            return true;
        }
        return false;
    }

    static enum LevelOperation {
        SET{

            @Override
            boolean canApply(int newLevel, int currentLevel) {
                return true;
            }
        }
        ,
        REDUCE{

            @Override
            boolean canApply(int newLevel, int currentLevel) {
                return newLevel < currentLevel;
            }
        }
        ,
        EXPAND{

            @Override
            boolean canApply(int newLevel, int currentLevel) {
                return newLevel > currentLevel;
            }
        };


        abstract boolean canApply(int var1, int var2);
    }
}

