/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class JDBCCompositeMap
extends JDBCComposite {
    private DBSDataType dataType;
    private Map<?, ?> map;

    public JDBCCompositeMap(@NotNull DBCSession session, DBSDataType dataType, @NotNull Map<?, ?> contents) throws DBCException {
        super(null);
        this.dataType = dataType;
        this.map = contents;
        this.type = new JDBCComposite.StructType(session.getDataSource());
        try {
            this.attributes = new DBSEntityAttribute[contents.size()];
            this.values = contents.values().toArray();
            int index = 0;
            for (Map.Entry<?, ?> entry : contents.entrySet()) {
                Object value = entry.getValue();
                JDBCComposite.StructAttribute attr = new JDBCComposite.StructAttribute(CommonUtils.toString(entry.getKey()), this.type, index, value);
                value = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)attr).getValueFromObject(session, (DBSTypedObject)attr, value, false, this.modified);
                this.attributes[index] = attr;
                this.values[index] = value;
                ++index;
            }
        }
        catch (DBException e) {
            throw new DBCException("Can't obtain attributes meta information", (Throwable)e);
        }
    }

    public JDBCCompositeMap(@NotNull DBRProgressMonitor monitor, @NotNull JDBCCompositeMap struct) throws DBCException {
        super(monitor, struct);
        this.dataType = struct.dataType;
        this.map = struct.map;
    }

    public JDBCCompositeMap cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new JDBCCompositeMap(monitor, this);
    }
}

