/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.util.Arrays;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionGeometry;

public final class PrecisionPointList
extends PointList {
    private static final Point PRIVATE_POINT = new Point();
    private double[] precisePoints = new double[0];

    public PrecisionPointList(int[] points) {
        super(points);
        this.precisePoints = Arrays.stream(points).asDoubleStream().toArray();
    }

    public PrecisionPointList(PointList points) {
        this(points.getCopy().toIntArray());
    }

    @Override
    public void performScale(double factor) {
        int i = 0;
        while (i < this.precisePoints.length) {
            int n = i++;
            this.precisePoints[n] = this.precisePoints[n] * factor;
        }
        i = 0;
        while (i < this.size()) {
            this.updateIntPoint(i);
            ++i;
        }
    }

    private void updateIntPoint(int i) {
        this.getPoint(PRIVATE_POINT, i);
        int preciseX = PrecisionGeometry.doubleToInteger(this.precisePoints[i * 2]);
        int preciseY = PrecisionGeometry.doubleToInteger(this.precisePoints[i * 2 + 1]);
        if (preciseX != PrecisionPointList.PRIVATE_POINT.x || preciseY != PrecisionPointList.PRIVATE_POINT.y) {
            PrecisionPointList.PRIVATE_POINT.x = preciseX;
            PrecisionPointList.PRIVATE_POINT.y = preciseY;
            this.setPoint(PRIVATE_POINT, i);
        }
    }
}

