﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/discovery/ApplicationDiscoveryService_EXPORTS.h>
#include <aws/discovery/model/OrderString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ApplicationDiscoveryService {
namespace Model {

/**
 * <p>A field and direction for ordered output.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/OrderByElement">AWS
 * API Reference</a></p>
 */
class OrderByElement {
 public:
  AWS_APPLICATIONDISCOVERYSERVICE_API OrderByElement() = default;
  AWS_APPLICATIONDISCOVERYSERVICE_API OrderByElement(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPLICATIONDISCOVERYSERVICE_API OrderByElement& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPLICATIONDISCOVERYSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The field on which to order.</p>
   */
  inline const Aws::String& GetFieldName() const { return m_fieldName; }
  inline bool FieldNameHasBeenSet() const { return m_fieldNameHasBeenSet; }
  template <typename FieldNameT = Aws::String>
  void SetFieldName(FieldNameT&& value) {
    m_fieldNameHasBeenSet = true;
    m_fieldName = std::forward<FieldNameT>(value);
  }
  template <typename FieldNameT = Aws::String>
  OrderByElement& WithFieldName(FieldNameT&& value) {
    SetFieldName(std::forward<FieldNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Ordering direction.</p>
   */
  inline OrderString GetSortOrder() const { return m_sortOrder; }
  inline bool SortOrderHasBeenSet() const { return m_sortOrderHasBeenSet; }
  inline void SetSortOrder(OrderString value) {
    m_sortOrderHasBeenSet = true;
    m_sortOrder = value;
  }
  inline OrderByElement& WithSortOrder(OrderString value) {
    SetSortOrder(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_fieldName;

  OrderString m_sortOrder{OrderString::NOT_SET};
  bool m_fieldNameHasBeenSet = false;
  bool m_sortOrderHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationDiscoveryService
}  // namespace Aws
