import type * as Models from "../../../models";
import type { BroadcastAddress } from "../../../zspec/enums";
import * as Zcl from "../../../zspec/zcl";
import * as Zdo from "../../../zspec/zdo";
import type * as ZdoTypes from "../../../zspec/zdo/definition/tstypes";
import Adapter from "../../adapter";
import type * as Events from "../../events";
import type * as TsType from "../../tstype";
export declare class ZiGateAdapter extends Adapter {
    private driver;
    private joinPermitted;
    private waitress;
    private closing;
    private queue;
    constructor(networkOptions: TsType.NetworkOptions, serialPortOptions: TsType.SerialPortOptions, backupPath: string, adapterOptions: TsType.AdapterOptions);
    /**
     * Adapter methods
     */
    start(): Promise<TsType.StartResult>;
    stop(): Promise<void>;
    getCoordinatorIEEE(): Promise<string>;
    getCoordinatorVersion(): Promise<TsType.CoordinatorVersion>;
    permitJoin(seconds: number, networkAddress?: number): Promise<void>;
    addInstallCode(_ieeeAddress: string, _key: Buffer, _hashed: boolean): Promise<void>;
    reset(type: "soft" | "hard"): Promise<void>;
    getNetworkParameters(): Promise<TsType.NetworkParameters>;
    /**
     * https://zigate.fr/documentation/deplacer-le-pdm-de-la-zigate/
     * pdm from host
     */
    supportsBackup(): Promise<boolean>;
    backup(): Promise<Models.Backup>;
    sendZdo(ieeeAddress: string, networkAddress: number, clusterId: Zdo.ClusterId, payload: Buffer, disableResponse: true): Promise<void>;
    sendZdo<K extends keyof ZdoTypes.RequestToResponseMap>(ieeeAddress: string, networkAddress: number, clusterId: K, payload: Buffer, disableResponse: false): Promise<ZdoTypes.RequestToResponseMap[K]>;
    sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number): Promise<Events.ZclPayload | undefined>;
    private sendZclFrameToEndpointInternal;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: BroadcastAddress): Promise<void>;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame, sourceEndpoint?: number): Promise<void>;
    /**
     * Supplementary functions
     */
    private initNetwork;
    waitFor(networkAddress: number | undefined, endpoint: number, frameType: Zcl.FrameType, direction: Zcl.Direction, transactionSequenceNumber: number | undefined, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<Events.ZclPayload>;
        cancel: () => void;
    };
    /**
     * InterPAN !!! not implemented
     */
    setChannelInterPAN(_channel: number): Promise<void>;
    sendZclFrameInterPANToIeeeAddr(_zclFrame: Zcl.Frame, _ieeeAddress: string): Promise<void>;
    sendZclFrameInterPANBroadcast(_zclFrame: Zcl.Frame, _timeout: number): Promise<Events.ZclPayload>;
    restoreChannelInterPAN(): Promise<void>;
    private deviceAnnounceListener;
    private onZdoResponse;
    private dataListener;
    private leaveIndicationListener;
    private waitressTimeoutFormatter;
    private waitressValidator;
    private onZiGateClose;
}
//# sourceMappingURL=zigateAdapter.d.ts.map