/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.plaf.BusyIcon;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

public abstract class BusyTabsSupport {
    private Timer animationTimer;
    private final ChangeListener modelListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            BusyTabsSupport.this.checkBusyTabs();
        }
    };
    private final Set<Tabbed> containers = new WeakSet(10);
    private final Set<Tabbed> busyContainers = new WeakSet(10);

    public static BusyTabsSupport getDefault() {
        return (BusyTabsSupport)Lookup.getDefault().lookup(BusyTabsSupport.class);
    }

    public final void install(Tabbed tabbed, TabDataModel tabDataModel) {
        if (this.containers.contains(tabbed)) {
            return;
        }
        tabDataModel.addChangeListener(this.modelListener);
        this.containers.add(tabbed);
        this.checkBusyTabs();
    }

    public final void uninstall(Tabbed tabbed, TabDataModel tabDataModel) {
        if (this.busyContainers.remove(tabbed)) {
            this.repaintAll(tabbed);
        }
        tabDataModel.removeChangeListener(this.modelListener);
        this.containers.remove(tabbed);
        this.checkBusyTabs();
    }

    public abstract Icon getBusyIcon(boolean var1);

    public final void makeTabBusy(Tabbed tabbed, int n, boolean bl) {
        Rectangle rectangle;
        if (!bl && null != (rectangle = tabbed.getTabBounds(n))) {
            tabbed.getComponent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.checkBusyTabs();
    }

    protected abstract int getRepaintTimerIntervalMillis();

    protected abstract void tick();

    private void startAnimationTimer() {
        if (null != this.animationTimer) {
            return;
        }
        int n = this.getRepaintTimerIntervalMillis();
        if (n <= 0) {
            return;
        }
        this.animationTimer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BusyTabsSupport.this.checkBusyTabs();
                BusyTabsSupport.this.repaintBusyTabs();
                BusyTabsSupport.this.tick();
            }
        });
        this.animationTimer.setRepeats(true);
        this.animationTimer.start();
    }

    private void stopAnimationTimer() {
        if (null == this.animationTimer) {
            return;
        }
        this.animationTimer.stop();
        this.animationTimer = null;
        this.repaintBusyTabs();
    }

    private void checkBusyTabs() {
        this.busyContainers.clear();
        for (Tabbed tabbed : this.containers) {
            if (!this.hasBusyTabs(tabbed)) continue;
            this.busyContainers.add(tabbed);
        }
        if (this.busyContainers.isEmpty()) {
            this.stopAnimationTimer();
        } else {
            this.startAnimationTimer();
        }
    }

    private void repaintBusyTabs() {
        for (Tabbed tabbed : this.busyContainers) {
            this.repaintBusy(tabbed);
        }
    }

    private void repaintBusy(Tabbed tabbed) {
        for (int i = 0; i < tabbed.getTabCount(); ++i) {
            TopComponent topComponent = tabbed.getTopComponentAt(i);
            if (!tabbed.isBusy(topComponent)) continue;
            Rectangle rectangle = tabbed.getTabBounds(i);
            tabbed.getComponent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void repaintAll(Tabbed tabbed) {
        Rectangle rectangle = tabbed.getTabsArea();
        tabbed.getComponent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private boolean hasBusyTabs(Tabbed tabbed) {
        boolean bl = false;
        for (int i = 0; i < tabbed.getTabCount(); ++i) {
            if (!tabbed.isBusy(tabbed.getTopComponentAt(i))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static final class DefaultBusyTabsSupport
    extends BusyTabsSupport {
        private BusyIcon busyIconSelected;
        private BusyIcon busyIconDefault;

        @Override
        public Icon getBusyIcon(boolean bl) {
            if (bl) {
                if (null == this.busyIconSelected) {
                    this.busyIconSelected = BusyIcon.create(bl);
                }
                return this.busyIconSelected;
            }
            if (null == this.busyIconDefault) {
                this.busyIconDefault = BusyIcon.create(bl);
            }
            return this.busyIconDefault;
        }

        @Override
        protected void tick() {
            if (null != this.busyIconSelected) {
                this.busyIconSelected.tick();
            }
            if (null != this.busyIconDefault) {
                this.busyIconDefault.tick();
            }
        }

        @Override
        protected int getRepaintTimerIntervalMillis() {
            return 150;
        }
    }
}

