/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.HeapViewer;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.java.impl.FilterUtils;
import org.graalvm.visualvm.heapviewer.java.impl.JavaDiffClassesProvider;
import org.graalvm.visualvm.heapviewer.java.impl.JavaDiffDumpSelector;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.ProgressNode;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.PluggableTreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.RelativeRenderer;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class JavaDiffObjectsView
extends HeapView {
    private final File file2;
    private final String file2Name;
    private final String file2Path;
    private final Object statusLock = new Object();
    private HeapViewerNode status;
    private List<ClassNode> diffClasses;
    private int maxDiffCount = 0;
    private long maxDiffSize = 0L;
    private long maxDiffRetained = 0L;
    private final PluggableTreeTableView objectsView;
    private ProfilerToolbar toolbar;
    private JComponent component;
    private Aggregation aggregation;
    private JToggleButton tbPackages;
    private JToggleButton tbClasses;

    JavaDiffObjectsView(HeapContext context1, File file2, final boolean compareRetained, HeapViewerActions actions) {
        super(Bundle.JavaDiffObjectsView_NamePrefix(JavaDiffObjectsView.formattedName(file2)), Bundle.JavaDiffObjectsView_NamePrefix(file2.getAbsolutePath()), Icons.getIcon((String)"ProfilerIcons.SnapshotsCompare"));
        TreeTableViewColumn[] columns;
        TreeTableViewColumn[] treeTableViewColumnArray;
        TreeTableViewColumn.RetainedSize retainedC;
        this.file2 = file2;
        this.file2Name = JavaDiffObjectsView.formattedName(file2);
        this.file2Path = file2.getAbsolutePath();
        final Heap heap = context1.getFragment().getHeap();
        final TreeTableViewColumn.Count countC = new TreeTableViewColumn.Count(heap, true, true){

            @Override
            public int getPreferredWidth() {
                return ((HideableBarRenderer)this.getRenderer()).getOptimalWidth();
            }
        };
        final TreeTableViewColumn.OwnSize sizeC = new TreeTableViewColumn.OwnSize(heap, true, false);
        TreeTableViewColumn.RetainedSize retainedSize = retainedC = compareRetained ? new TreeTableViewColumn.RetainedSize(heap) : null;
        if (compareRetained) {
            TreeTableViewColumn[] treeTableViewColumnArray2 = new TreeTableViewColumn[4];
            treeTableViewColumnArray2[0] = new TreeTableViewColumn.Name();
            treeTableViewColumnArray2[1] = countC;
            treeTableViewColumnArray2[2] = sizeC;
            treeTableViewColumnArray = treeTableViewColumnArray2;
            treeTableViewColumnArray2[3] = retainedC;
        } else {
            TreeTableViewColumn[] treeTableViewColumnArray3 = new TreeTableViewColumn[3];
            treeTableViewColumnArray3[0] = new TreeTableViewColumn.Name();
            treeTableViewColumnArray3[1] = countC;
            treeTableViewColumnArray = treeTableViewColumnArray3;
            treeTableViewColumnArray3[2] = sizeC;
        }
        for (TreeTableViewColumn column : columns = treeTableViewColumnArray) {
            ProfilerRenderer renderer = column.getRenderer();
            if (!(renderer instanceof RelativeRenderer)) continue;
            ((RelativeRenderer)renderer).setDiffMode(true);
        }
        this.status = new ProgressNode(Bundle.JavaDiffObjectsView_LoadingProgress());
        new RequestProcessor("Compare Heap Dumps Worker").post(new Runnable(){

            @Override
            public void run() {
                JavaDiffObjectsView.this.computeDiffClasses(heap, compareRetained);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((HideableBarRenderer)countC.getRenderer()).setMaxValue((long)JavaDiffObjectsView.this.maxDiffCount);
                        ((HideableBarRenderer)sizeC.getRenderer()).setMaxValue(JavaDiffObjectsView.this.maxDiffSize);
                        if (compareRetained) {
                            ((HideableBarRenderer)retainedC.getRenderer()).setMaxValue(JavaDiffObjectsView.this.maxDiffRetained);
                        }
                        if (JavaDiffObjectsView.this.objectsView != null) {
                            JavaDiffObjectsView.this.objectsView.getComponent().repaint();
                        }
                    }
                });
            }
        });
        this.objectsView = new PluggableTreeTableView("diff_java_objects", context1, actions, columns){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap2, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                Object object = JavaDiffObjectsView.this.statusLock;
                synchronized (object) {
                    if (JavaDiffObjectsView.this.diffClasses == null) {
                        return new HeapViewerNode[]{JavaDiffObjectsView.this.status};
                    }
                }
                switch (JavaDiffObjectsView.this.getAggregation()) {
                    case PACKAGES: {
                        return JavaDiffClassesProvider.getDiffHeapPackages(root, heap2, JavaDiffObjectsView.this.diffClasses, compareRetained, viewID, viewFilter, dataTypes, sortOrders, progress);
                    }
                    case CLASSES: {
                        return JavaDiffClassesProvider.getDiffHeapClasses(root, heap2, JavaDiffObjectsView.this.diffClasses, compareRetained, viewID, viewFilter, dataTypes, sortOrders, progress);
                    }
                }
                return null;
            }

            @Override
            protected JComponent createComponent() {
                JComponent comp = super.createComponent();
                this.setFilterComponent(FilterUtils.createFilterPanel(this));
                return comp;
            }

            @Override
            protected void populatePopupLast(HeapViewerNode node, JPopupMenu popup) {
                super.populatePopupLast(node, popup);
                JavaClass javaClass = HeapViewerNode.getValue(node, DataType.CLASS, heap);
                final String className = javaClass == null || javaClass.isArray() ? null : javaClass.getName();
                popup.add(new JMenuItem(Bundle.JavaObjectsView_FilterSubclasses()){
                    {
                        super(x0);
                        this.setEnabled(className != null);
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        JComponent filterComponent = this.getFilterComponent();
                        filterComponent.setVisible(true);
                        FilterUtils.filterSubclasses(className, filterComponent);
                    }
                });
            }
        };
        this.objectsView.setViewName(Bundle.JavaDiffObjectsView_Name());
    }

    @Override
    public JComponent getComponent() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    protected void closed() {
        this.objectsView.closed();
    }

    private synchronized void setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
        this.objectsView.reloadView();
    }

    private synchronized Aggregation getAggregation() {
        return this.aggregation;
    }

    private void initUI() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(3);
        JLabel refPresenter = new JLabel(this.file2Name, Icons.getIcon((String)"ProfilerIcons.SnapshotsCompare"), 10);
        refPresenter.setToolTipText(this.file2Path);
        this.toolbar.add((Component)refPresenter);
        this.toolbar.addSpace(5);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.JavaObjectsView_Aggregation()));
        this.toolbar.addSpace(2);
        final ButtonGroup aggregationBG = new ButtonGroup();
        class AggregationButton
        extends JToggleButton {
            private final Aggregation aggregation;

            AggregationButton(Aggregation aggregation) {
                super(aggregation.getIcon());
                this.aggregation = aggregation;
                this.setToolTipText(aggregation.toString());
                aggregationBG.add(this);
            }

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JavaDiffObjectsView.this.setAggregation(this.aggregation);
                }
            }
        }
        this.tbPackages = new AggregationButton(Aggregation.PACKAGES);
        this.tbPackages.putClientProperty("JButton.buttonType", "segmented");
        this.tbPackages.putClientProperty("JButton.segmentPosition", "first");
        this.toolbar.add((Component)this.tbPackages);
        this.tbClasses = new AggregationButton(Aggregation.CLASSES);
        this.tbClasses.putClientProperty("JButton.buttonType", "segmented");
        this.tbClasses.putClientProperty("JButton.segmentPosition", "last");
        this.toolbar.add((Component)this.tbClasses);
        this.tbClasses.setSelected(true);
        this.aggregation = Aggregation.CLASSES;
        if (this.objectsView.hasPlugins()) {
            this.toolbar.addSpace(8);
            this.toolbar.add((Component)new GrayLabel(Bundle.JavaDiffObjectsView_Details()));
            this.toolbar.addSpace(2);
            this.toolbar.add(this.objectsView.getToolbar());
        }
        this.component = new ViewContainer(this.objectsView.getComponent(), this.file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeDiffClasses(Heap heap, boolean compareRetained) {
        try {
            HeapViewer otherViewer = new HeapViewer(this.file2);
            Object object = this.statusLock;
            synchronized (object) {
                this.status = new ProgressNode(Bundle.JavaDiffObjectsView_ComparingProgress());
            }
            this.objectsView.reloadView();
            for (HeapContext otherContext : HeapContext.allContexts(otherViewer)) {
                if (!JavaHeapFragment.isJavaHeap(otherContext)) continue;
                Heap diffHeap = otherContext.getFragment().getHeap();
                Object object2 = this.statusLock;
                synchronized (object2) {
                    this.diffClasses = JavaDiffClassesProvider.createDiffClasses(heap, diffHeap, compareRetained);
                    for (ClassNode node : this.diffClasses) {
                        int count = Math.abs(node.getInstancesCount());
                        this.maxDiffCount = Math.max(this.maxDiffCount, count);
                        long size = Math.abs(node.getOwnSize());
                        this.maxDiffSize = Math.max(this.maxDiffSize, size);
                        if (!compareRetained) continue;
                        long retained = Math.abs(node.getRetainedSize(heap));
                        this.maxDiffRetained = Math.max(this.maxDiffRetained, retained);
                    }
                    this.status = null;
                }
                this.objectsView.reloadView();
                return;
            }
            Object object3 = this.statusLock;
            synchronized (object3) {
                this.status = new TextNode(Bundle.JavaDiffObjectsView_CompareNoJavaStatus());
            }
            this.objectsView.reloadView();
            ProfilerDialogs.displayError((String)Bundle.JavaDiffObjectsView_CompareNoJava());
        }
        catch (IOException e) {
            ProfilerDialogs.displayError((String)Bundle.JavaDiffObjectsView_CompareFailed());
            Object object = this.statusLock;
            synchronized (object) {
                this.status = new TextNode(Bundle.JavaDiffObjectsView_CompareFailedStatus());
            }
            this.objectsView.reloadView();
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private static String formattedName(File file) {
        String name = file.getName();
        int extIdx = name.lastIndexOf(46);
        if (extIdx != -1) {
            name = name.substring(0, extIdx);
        }
        return JavaDiffDumpSelector.getHeapDumpDisplayName(name);
    }

    private static class ViewContainer
    extends JPanel {
        private final File file;

        ViewContainer(JComponent view, File file) {
            super(new BorderLayout());
            this.file = file;
            this.setOpaque(false);
            this.setFocusable(false);
            this.add((Component)view, "Center");
        }

        @Override
        public boolean requestFocusInWindow() {
            if (this.getComponentCount() == 0) {
                return super.requestFocusInWindow();
            }
            return this.getComponent(0).requestFocusInWindow();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ViewContainer)) {
                return false;
            }
            return this.file.equals(((ViewContainer)o).file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }

    private static enum Aggregation {
        PACKAGES(Bundle.JavaObjectsView_Packages(), Icons.getIcon((String)"LanguageIcons.Package")),
        CLASSES(Bundle.JavaObjectsView_Classes(), Icons.getIcon((String)"LanguageIcons.Class"));

        private final String aggregationName;
        private final Icon aggregationIcon;

        private Aggregation(String aggregationName, Icon aggregationIcon) {
            this.aggregationName = aggregationName;
            this.aggregationIcon = aggregationIcon;
        }

        public String toString() {
            return this.aggregationName;
        }

        public Icon getIcon() {
            return this.aggregationIcon;
        }
    }
}

