"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListTypeVersions = void 0;
const CloudFormationClient_1 = require("../CloudFormationClient");
const ListTypeVersionsCommand_1 = require("../commands/ListTypeVersionsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListTypeVersionsCommand_1.ListTypeVersionsCommand(input), ...args);
};
async function* paginateListTypeVersions(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof CloudFormationClient_1.CloudFormationClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CloudFormation | CloudFormationClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListTypeVersions = paginateListTypeVersions;
