/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.audio;

import ai.djl.modality.audio.Audio;
import ai.djl.modality.audio.AudioFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.file.Path;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SampledAudioFactory
extends AudioFactory {
    @Override
    public AudioFactory setChannels(int channel) {
        if (channel != 0) {
            throw new UnsupportedOperationException("SampledAudioFactory only support 1 channel.");
        }
        return this;
    }

    @Override
    public AudioFactory setSampleRate(int sampleRate) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public AudioFactory setSampleFormat(int sampleFormat) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Audio fromFile(Path path) throws IOException {
        Audio audio;
        block8: {
            AudioInputStream ais = AudioSystem.getAudioInputStream(path.toFile());
            try {
                AudioFormat format = ais.getFormat();
                byte[] bytes = this.read(ais);
                float[] floats = this.bytesToFloats(bytes, format.isBigEndian());
                audio = new Audio(floats, format.getSampleRate(), format.getChannels());
                if (ais == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ais != null) {
                        try {
                            ais.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedAudioFileException e) {
                    throw new IOException("Unsupported Audio file", e);
                }
            }
            ais.close();
        }
        return audio;
    }

    @Override
    public Audio fromInputStream(InputStream is) throws IOException {
        Audio audio;
        block8: {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new BufferedInputStream(is));
            try {
                AudioFormat format = ais.getFormat();
                byte[] bytes = this.read(ais);
                float[] floats = this.bytesToFloats(bytes, format.isBigEndian());
                audio = new Audio(floats, format.getSampleRate(), format.getChannels());
                if (ais == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ais != null) {
                        try {
                            ais.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedAudioFileException e) {
                    throw new IOException("Unsupported Audio file", e);
                }
            }
            ais.close();
        }
        return audio;
    }

    private byte[] read(AudioInputStream ais) throws IOException {
        int read;
        AudioFormat format = ais.getFormat();
        int frameSize = format.getFrameSize();
        if (frameSize == -1) {
            frameSize = 1;
        }
        int size = (int)ais.getFrameLength() * frameSize;
        byte[] ret = new byte[size];
        byte[] buf = new byte[1024];
        int offset = 0;
        while ((read = ais.read(buf)) != -1) {
            System.arraycopy(buf, 0, ret, offset, read);
            offset += read;
        }
        return ret;
    }

    private float[] bytesToFloats(byte[] bytes, boolean isBigEndian) {
        ByteOrder order = isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ShortBuffer buffer = ByteBuffer.wrap(bytes).order(order).asShortBuffer();
        short[] shorts = new short[buffer.capacity()];
        buffer.get(shorts);
        float[] floats = new float[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            floats[i] = (float)shorts[i] / 32767.0f;
        }
        return floats;
    }
}

