/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper.annotatedtext;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.AttributeSource;
import org.opensearch.OpenSearchParseException;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TextFieldMapper;
import org.opensearch.index.mapper.TextParams;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.similarity.SimilarityProvider;

public class AnnotatedTextFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "annotated_text";
    private static final int POSITION_INCREMENT_GAP_USE_ANALYZER = -1;
    public static ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers()));
    private final FieldType fieldType;
    private final Builder builder;

    private static Builder builder(FieldMapper in) {
        return ((AnnotatedTextFieldMapper)in).builder;
    }

    static String readToString(Reader reader) {
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        try {
            int numCharsRead;
            while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
                buffer.append(arr, 0, numCharsRead);
            }
            reader.close();
            return buffer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("IO Error reading field content", e);
        }
    }

    protected AnnotatedTextFieldMapper(String simpleName, FieldType fieldType, AnnotatedTextFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, multiFields, copyTo);
        assert (fieldType.tokenized());
        this.fieldType = fieldType;
        this.builder = builder;
    }

    protected AnnotatedTextFieldMapper clone() {
        return (AnnotatedTextFieldMapper)super.clone();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field field = new Field(this.mappedFieldType.name(), (CharSequence)value, (IndexableFieldType)this.fieldType);
            context.doc().add((IndexableField)field);
            if (this.fieldType.omitNorms()) {
                this.createFieldNamesField(context);
            }
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.analyzers.indexAnalyzers).init((FieldMapper)this);
    }

    public static final class AnnotatedTextFieldType
    extends TextFieldMapper.TextFieldType {
        private AnnotatedTextFieldType(String name, boolean store, TextSearchInfo tsi, Map<String, String> meta) {
            super(name, true, store, tsi, meta);
        }

        public AnnotatedTextFieldType(String name, Map<String, String> meta) {
            super(name, true, false, meta);
        }

        public String typeName() {
            return AnnotatedTextFieldMapper.CONTENT_TYPE;
        }
    }

    public static final class AnnotationsInjector
    extends TokenFilter {
        private AnnotatedText annotatedText;
        AnnotatedText.AnnotationToken nextAnnotationForInjection = null;
        private int currentAnnotationIndex = 0;
        List<AttributeSource.State> pendingStates = new ArrayList<AttributeSource.State>();
        int pendingStatePos = 0;
        boolean inputExhausted = false;
        private final OffsetAttribute textOffsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute posAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

        public AnnotationsInjector(TokenStream in) {
            super(in);
        }

        public void setAnnotations(AnnotatedText annotatedText) {
            this.annotatedText = annotatedText;
            this.currentAnnotationIndex = 0;
            this.nextAnnotationForInjection = annotatedText != null && annotatedText.numAnnotations() > 0 ? annotatedText.getAnnotation(0) : null;
        }

        public void reset() throws IOException {
            this.pendingStates.clear();
            this.pendingStatePos = 0;
            this.inputExhausted = false;
            super.reset();
        }

        private boolean internalNextToken() throws IOException {
            if (this.pendingStatePos < this.pendingStates.size()) {
                this.restoreState(this.pendingStates.get(this.pendingStatePos));
                ++this.pendingStatePos;
                if (this.pendingStatePos >= this.pendingStates.size()) {
                    this.pendingStatePos = 0;
                    this.pendingStates.clear();
                }
                return true;
            }
            if (this.inputExhausted) {
                return false;
            }
            return this.input.incrementToken();
        }

        public boolean incrementToken() throws IOException {
            if (this.internalNextToken()) {
                if (this.nextAnnotationForInjection != null && this.textOffsetAtt.startOffset() >= this.nextAnnotationForInjection.offset) {
                    int firstSpannedTextPosInc = this.posAtt.getPositionIncrement();
                    int annotationPosLen = 1;
                    this.posAtt.setPositionIncrement(0);
                    this.pendingStates.add(this.captureState());
                    while (this.textOffsetAtt.endOffset() <= this.nextAnnotationForInjection.endOffset) {
                        if (this.input.incrementToken()) {
                            if (this.textOffsetAtt.endOffset() <= this.nextAnnotationForInjection.endOffset && this.textOffsetAtt.startOffset() < this.nextAnnotationForInjection.endOffset) {
                                annotationPosLen += this.posAtt.getPositionIncrement();
                            }
                            this.pendingStates.add(this.captureState());
                            continue;
                        }
                        this.inputExhausted = true;
                        break;
                    }
                    this.emitAnnotation(firstSpannedTextPosInc, annotationPosLen);
                    return true;
                }
                return true;
            }
            this.inputExhausted = true;
            return false;
        }

        private void setType() {
            this.typeAtt.setType("annotation");
        }

        private void emitAnnotation(int firstSpannedTextPosInc, int annotationPosLen) throws IOException {
            this.posLenAtt.setPositionLength(annotationPosLen);
            this.textOffsetAtt.setOffset(this.nextAnnotationForInjection.offset, this.nextAnnotationForInjection.endOffset);
            this.setType();
            int annotationOffset = this.nextAnnotationForInjection.offset;
            AnnotatedText.AnnotationToken firstAnnotationAtThisPos = this.nextAnnotationForInjection;
            while (this.nextAnnotationForInjection != null && this.nextAnnotationForInjection.offset == annotationOffset) {
                this.setType();
                this.termAtt.resizeBuffer(this.nextAnnotationForInjection.value.length());
                this.termAtt.copyBuffer(this.nextAnnotationForInjection.value.toCharArray(), 0, this.nextAnnotationForInjection.value.length());
                if (this.nextAnnotationForInjection == firstAnnotationAtThisPos) {
                    this.posAtt.setPositionIncrement(firstSpannedTextPosInc);
                    this.pendingStates.add(0, this.captureState());
                } else {
                    this.posAtt.setPositionIncrement(0);
                    this.pendingStates.add(1, this.captureState());
                }
                ++this.currentAnnotationIndex;
                if (this.currentAnnotationIndex < this.annotatedText.numAnnotations()) {
                    this.nextAnnotationForInjection = this.annotatedText.getAnnotation(this.currentAnnotationIndex);
                    continue;
                }
                this.nextAnnotationForInjection = null;
            }
            this.internalNextToken();
        }
    }

    public static final class AnnotationAnalyzerWrapper
    extends AnalyzerWrapper {
        private final Analyzer delegate;

        public AnnotationAnalyzerWrapper(Analyzer delegate) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
        }

        public Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            if (components.getTokenStream() instanceof AnnotationsInjector) {
                return components;
            }
            AnnotationsInjector injector = new AnnotationsInjector(components.getTokenStream());
            return new Analyzer.TokenStreamComponents(r -> {
                AnnotatedText annotations = AnnotatedText.parse(AnnotatedTextFieldMapper.readToString(r));
                injector.setAnnotations(annotations);
                components.getSource().accept(new StringReader(annotations.textMinusMarkup));
            }, (TokenStream)injector);
        }
    }

    public static final class AnnotatedHighlighterAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;
        private AnnotatedText[] annotations;

        public AnnotatedHighlighterAnalyzer(Analyzer delegate) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
        }

        public Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        public void setAnnotations(AnnotatedText[] annotations) {
            this.annotations = annotations;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            AnnotationsInjector injector = new AnnotationsInjector(components.getTokenStream());
            AtomicInteger readerNum = new AtomicInteger(0);
            return new Analyzer.TokenStreamComponents(r -> {
                String plainText = AnnotatedTextFieldMapper.readToString(r);
                AnnotatedText at = this.annotations[readerNum.getAndIncrement()];
                assert (at.textMinusMarkup.equals(plainText));
                injector.setAnnotations(at);
                components.getSource().accept(new StringReader(at.textMinusMarkup));
            }, (TokenStream)injector);
        }
    }

    public static final class AnnotatedText {
        public final String textPlusMarkup;
        public final String textMinusMarkup;
        List<AnnotationToken> annotations;
        static Pattern markdownPattern = Pattern.compile("\\[([^]\\[]*)]\\(([^)(]*)\\)");

        public static AnnotatedText parse(String textPlusMarkup) {
            ArrayList<AnnotationToken> annotations = new ArrayList<AnnotationToken>();
            Matcher m = markdownPattern.matcher(textPlusMarkup);
            int lastPos = 0;
            StringBuilder sb = new StringBuilder();
            while (m.find()) {
                if (m.start() > lastPos) {
                    sb.append(textPlusMarkup, lastPos, m.start());
                }
                int startOffset = sb.length();
                int endOffset = sb.length() + m.group(1).length();
                sb.append(m.group(1));
                lastPos = m.end();
                String[] pairs = m.group(2).split("&");
                String value = null;
                for (String pair : pairs) {
                    String[] kv = pair.split("=");
                    try {
                        if (kv.length == 2) {
                            throw new OpenSearchParseException("key=value pairs are not supported in annotations", new Object[0]);
                        }
                        if (kv.length == 1 && kv[0].length() == pair.length()) {
                            value = URLDecoder.decode(kv[0], "UTF-8");
                        }
                        if (value == null || value.length() <= 0) continue;
                        annotations.add(new AnnotationToken(startOffset, endOffset, value));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new OpenSearchParseException("Unsupported encoding parsing annotated text", (Throwable)e, new Object[0]);
                    }
                }
            }
            if (lastPos < textPlusMarkup.length()) {
                sb.append(textPlusMarkup.substring(lastPos));
            }
            return new AnnotatedText(sb.toString(), textPlusMarkup, annotations);
        }

        protected AnnotatedText(String textMinusMarkup, String textPlusMarkup, List<AnnotationToken> annotations) {
            this.textMinusMarkup = textMinusMarkup;
            this.textPlusMarkup = textPlusMarkup;
            this.annotations = annotations;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.textMinusMarkup);
            sb.append("\n");
            this.annotations.forEach(a -> {
                sb.append(a);
                sb.append("\n");
            });
            return sb.toString();
        }

        public int numAnnotations() {
            return this.annotations.size();
        }

        public AnnotationToken getAnnotation(int index) {
            return this.annotations.get(index);
        }

        public static final class AnnotationToken {
            public final int offset;
            public final int endOffset;
            public final String value;

            public AnnotationToken(int offset, int endOffset, String value) {
                this.offset = offset;
                this.endOffset = endOffset;
                this.value = value;
            }

            public String toString() {
                return this.value + " (" + this.offset + " - " + this.endOffset + ")";
            }

            public boolean intersects(int start, int end) {
                return start <= this.offset && end >= this.offset || start <= this.endOffset && end >= this.endOffset || start >= this.offset && end <= this.endOffset;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.endOffset;
                result = 31 * result + this.offset;
                result = 31 * result + Objects.hashCode(this.value);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                AnnotationToken other = (AnnotationToken)obj;
                return Objects.equals(this.endOffset, other.endOffset) && Objects.equals(this.offset, other.offset) && Objects.equals(this.value, other.value);
            }
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> store = ParametrizedFieldMapper.Parameter.storeParam(m -> (Boolean)AnnotatedTextFieldMapper.builder((FieldMapper)m).store.getValue(), (boolean)false);
        final TextParams.Analyzers analyzers;
        final ParametrizedFieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> (SimilarityProvider)AnnotatedTextFieldMapper.builder((FieldMapper)m).similarity.getValue());
        final ParametrizedFieldMapper.Parameter<String> indexOptions = TextParams.indexOptions(m -> (String)AnnotatedTextFieldMapper.builder((FieldMapper)m).indexOptions.getValue());
        final ParametrizedFieldMapper.Parameter<Boolean> norms = TextParams.norms((boolean)true, m -> (Boolean)AnnotatedTextFieldMapper.builder((FieldMapper)m).norms.getValue());
        final ParametrizedFieldMapper.Parameter<String> termVectors = TextParams.termVectors(m -> (String)AnnotatedTextFieldMapper.builder((FieldMapper)m).termVectors.getValue());
        final ParametrizedFieldMapper.Parameter<Integer> positionIncrementGap = ParametrizedFieldMapper.Parameter.intParam((String)"position_increment_gap", (boolean)false, m -> (Integer)AnnotatedTextFieldMapper.builder((FieldMapper)m).positionIncrementGap.getValue(), (int)-1).setValidator(v -> {
            if (v != -1 && v < 0) {
                throw new MapperParsingException("[positions_increment_gap] must be positive, got [" + v + "]");
            }
        });
        private final ParametrizedFieldMapper.Parameter<Float> boost = ParametrizedFieldMapper.Parameter.boostParam();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.analyzers = new TextParams.Analyzers(indexAnalyzers);
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.store, this.indexOptions, this.norms, this.termVectors, this.similarity, this.analyzers.indexAnalyzer, this.analyzers.searchAnalyzer, this.analyzers.searchQuoteAnalyzer, this.positionIncrementGap, this.boost, this.meta);
        }

        private NamedAnalyzer wrapAnalyzer(NamedAnalyzer in, int positionIncrementGap) {
            return new NamedAnalyzer(in.name(), AnalyzerScope.INDEX, (Analyzer)new AnnotationAnalyzerWrapper(in.analyzer()), positionIncrementGap);
        }

        private AnnotatedTextFieldType buildFieldType(FieldType fieldType, Mapper.BuilderContext context) {
            int posGap;
            if ((Integer)this.positionIncrementGap.get() == -1) {
                posGap = 100;
            } else {
                if (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name() + "] without positions enabled");
                }
                posGap = (Integer)this.positionIncrementGap.get();
            }
            TextSearchInfo tsi = new TextSearchInfo(fieldType, (SimilarityProvider)this.similarity.get(), this.wrapAnalyzer(this.analyzers.getSearchAnalyzer(), posGap), this.wrapAnalyzer(this.analyzers.getSearchQuoteAnalyzer(), posGap));
            AnnotatedTextFieldType ft = new AnnotatedTextFieldType(this.buildFullName(context), (Boolean)this.store.getValue(), tsi, (Map)this.meta.getValue());
            ft.setIndexAnalyzer(this.wrapAnalyzer(this.analyzers.getIndexAnalyzer(), posGap));
            ft.setBoost(((Float)this.boost.getValue()).floatValue());
            return ft;
        }

        public AnnotatedTextFieldMapper build(Mapper.BuilderContext context) {
            FieldType fieldType = TextParams.buildFieldType(() -> true, this.store, this.indexOptions, this.norms, this.termVectors);
            if (fieldType.indexOptions() == IndexOptions.NONE) {
                throw new IllegalArgumentException("[annotated_text] fields must be indexed");
            }
            return new AnnotatedTextFieldMapper(this.name, fieldType, this.buildFieldType(fieldType, context), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), this);
        }
    }
}

