/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.ssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.opensearch.common.ssl.SslConfigException;

public final class SslUtil {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private SslUtil() {
    }

    public static String calculateFingerprint(X509Certificate certificate) throws CertificateEncodingException {
        MessageDigest sha1 = SslUtil.messageDigest("SHA-1");
        sha1.update(certificate.getEncoded());
        return SslUtil.toHexString(sha1.digest());
    }

    static MessageDigest messageDigest(String digestAlgorithm) {
        try {
            return MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SslConfigException("unexpected exception creating MessageDigest instance for [" + digestAlgorithm + "]", e);
        }
    }

    static String toHexString(byte[] bytes) {
        return new String(SslUtil.toHexCharArray(bytes));
    }

    static char[] toHexCharArray(byte[] bytes) {
        Objects.requireNonNull(bytes);
        char[] result = new char[2 * bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result[2 * i] = HEX_DIGITS[b >> 4 & 0xF];
            result[2 * i + 1] = HEX_DIGITS[b & 0xF];
        }
        return result;
    }
}

