/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.util.Map;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public final class DotExpanderProcessor
extends AbstractProcessor {
    static final String TYPE = "dot_expander";
    private final String path;
    private final String field;

    DotExpanderProcessor(String tag, String description, String path, String field) {
        super(tag, description);
        this.path = path;
        this.field = field;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        Map map;
        Object path;
        if (this.path != null) {
            path = this.path + "." + this.field;
            map = (Map)ingestDocument.getFieldValue(this.path, Map.class);
        } else {
            path = this.field;
            map = ingestDocument.getSourceAndMetadata();
        }
        if (map.containsKey(this.field)) {
            if (ingestDocument.hasField((String)path)) {
                Object value = map.remove(this.field);
                ingestDocument.appendFieldValue((String)path, value);
            } else {
                String partialPath;
                int index = ((String)path).indexOf(46);
                while (index != -1 && ingestDocument.hasField(partialPath = ((String)path).substring(0, index))) {
                    Object val = ingestDocument.getFieldValue(partialPath, Object.class);
                    if (!(val instanceof Map)) {
                        throw new IllegalArgumentException("cannot expend [" + (String)path + "], because [" + partialPath + "] is not an object field, but a value field");
                    }
                    index = ((String)path).indexOf(46, index + 1);
                }
                Object value = map.remove(this.field);
                ingestDocument.setFieldValue((String)path, value);
            }
        }
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    String getPath() {
        return this.path;
    }

    String getField() {
        return this.field;
    }

    public static final class Factory
    implements Processor.Factory {
        public Processor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)DotExpanderProcessor.TYPE, (String)tag, config, (String)"field");
            if (!field.contains(".")) {
                throw ConfigurationUtils.newConfigurationException((String)"tag", (String)tag, (String)"field", (String)"field does not contain a dot");
            }
            if (field.indexOf(46) == 0 || field.lastIndexOf(46) == field.length() - 1) {
                throw ConfigurationUtils.newConfigurationException((String)"tag", (String)tag, (String)"field", (String)"Field can't start or end with a dot");
            }
            int firstIndex = -1;
            int index = field.indexOf(46);
            while (index != -1) {
                if (index - firstIndex == 1) {
                    throw ConfigurationUtils.newConfigurationException((String)"tag", (String)tag, (String)"field", (String)"No space between dots");
                }
                firstIndex = index;
                index = field.indexOf(46, index + 1);
            }
            String path = ConfigurationUtils.readOptionalStringProperty((String)DotExpanderProcessor.TYPE, (String)tag, config, (String)"path");
            return new DotExpanderProcessor(tag, null, path, field);
        }
    }
}

