/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.history;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import mediathek.config.StandardLocations;
import mediathek.controller.history.MVUsedUrl;
import mediathek.gui.messages.history.AboHistoryChangedEvent;
import mediathek.tool.MessageBus;
import okhttp3.HttpUrl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AboHistoryController {
    private static final String FILENAME = "downloadAbos.txt";
    private static final Logger logger = LogManager.getLogger();
    private final Set<String> urlCacheSet = ConcurrentHashMap.newKeySet();
    private final EventList<MVUsedUrl> baseDataEventList = new BasicEventList<MVUsedUrl>();
    private Path urlPath;

    public AboHistoryController() {
        Path settingsDir = StandardLocations.getSettingsDirectory();
        try {
            this.urlPath = settingsDir.resolve(FILENAME);
            if (Files.notExists(this.urlPath, new LinkOption[0])) {
                Files.createFile(this.urlPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            logger.error("I/O error occured", (Throwable)e);
            this.urlPath = null;
        }
        this.listeBauen();
    }

    public EventList<MVUsedUrl> getDataList() {
        return this.baseDataEventList;
    }

    private void sendChangeMessage() {
        MessageBus.getMessageBus().publishAsync(new AboHistoryChangedEvent());
    }

    private void clearLists() {
        try {
            this.baseDataEventList.getReadWriteLock().writeLock().lock();
            this.baseDataEventList.clear();
            this.urlCacheSet.clear();
        }
        finally {
            this.baseDataEventList.getReadWriteLock().writeLock().unlock();
        }
    }

    public void removeAll() {
        this.clearLists();
        try (FileChannel fc = FileChannel.open(this.urlPath, StandardOpenOption.WRITE);){
            fc.truncate(0L);
        }
        catch (IOException e) {
            logger.error("Could not empty abo history file", (Throwable)e);
        }
        this.sendChangeMessage();
    }

    public boolean urlExists(@NotNull String urlFilm) {
        return this.urlCacheSet.contains(urlFilm);
    }

    public synchronized void removeUrl(@NotNull String urlFilm) {
        boolean entryFound = false;
        if (!this.urlExists(urlFilm)) {
            return;
        }
        ArrayList<String> liste = new ArrayList<String>();
        try (InputStream is = Files.newInputStream(this.urlPath, new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(is);
             LineNumberReader in = new LineNumberReader(isr);){
            String zeile;
            while ((zeile = in.readLine()) != null) {
                if (MVUsedUrl.getUrlAusZeile(zeile).getUrl().equals(urlFilm)) {
                    entryFound = true;
                    continue;
                }
                liste.add(zeile);
            }
        }
        catch (Exception ex) {
            logger.error("urlAusLogfileLoeschen(String)", (Throwable)ex);
        }
        if (entryFound) {
            try (OutputStream os = Files.newOutputStream(this.urlPath, new OpenOption[0]);
                 OutputStreamWriter osw = new OutputStreamWriter(os);
                 BufferedWriter bufferedWriter = new BufferedWriter(osw);){
                for (String entry : liste) {
                    bufferedWriter.write(entry + "\n");
                }
            }
            catch (Exception ex) {
                logger.error("urlAusLogfileLoeschen(String)", (Throwable)ex);
            }
            this.clearLists();
            this.listeBauen();
            this.sendChangeMessage();
        }
    }

    public void add(@NotNull MVUsedUrl usedUrl) {
        try {
            this.baseDataEventList.getReadWriteLock().writeLock().lock();
            this.baseDataEventList.add(usedUrl);
            this.urlCacheSet.add(usedUrl.getUrl());
        }
        finally {
            this.baseDataEventList.getReadWriteLock().writeLock().unlock();
        }
        try (OutputStream os = Files.newOutputStream(this.urlPath, StandardOpenOption.APPEND);
             OutputStreamWriter osw = new OutputStreamWriter(os);
             BufferedWriter bufferedWriter = new BufferedWriter(osw);){
            bufferedWriter.write(usedUrl.getPreparedRowString());
        }
        catch (Exception ex) {
            logger.error("Single add failed", (Throwable)ex);
        }
        this.sendChangeMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listeBauen() {
        ArrayList<String> badEntriesList = new ArrayList<String>();
        try (InputStream is = Files.newInputStream(this.urlPath, new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(is);
             LineNumberReader in = new LineNumberReader(isr);){
            String zeile;
            this.baseDataEventList.getReadWriteLock().writeLock().lock();
            while ((zeile = in.readLine()) != null) {
                MVUsedUrl mvuu = MVUsedUrl.getUrlAusZeile(zeile);
                String url = mvuu.getUrl();
                if (url.startsWith("rtmp:")) {
                    badEntriesList.add(zeile);
                    continue;
                }
                HttpUrl okHttpUrl = HttpUrl.parse(url);
                if (okHttpUrl == null) {
                    badEntriesList.add(zeile);
                    continue;
                }
                this.baseDataEventList.add(mvuu);
                this.urlCacheSet.add(url);
            }
        }
        catch (Exception ex) {
            logger.error("listeBauen()", (Throwable)ex);
        }
        finally {
            this.baseDataEventList.getReadWriteLock().writeLock().unlock();
        }
        this.checkBadEntries(badEntriesList);
        this.printDebugInfo();
    }

    private void printDebugInfo() {
        try {
            this.baseDataEventList.getReadWriteLock().readLock().lock();
            logger.trace("urlCacheSet size: {} for file {}", (Object)this.urlCacheSet.size(), (Object)this.urlPath);
            logger.trace("dataList size: {} for file {}", (Object)this.baseDataEventList.size(), (Object)this.urlPath);
        }
        finally {
            this.baseDataEventList.getReadWriteLock().readLock().unlock();
        }
    }

    private void checkBadEntries(@NotNull List<String> badEntriesList) {
        if (!badEntriesList.isEmpty()) {
            logger.warn("File {} contained {} invalid entries ", (Object)this.urlPath, (Object)badEntriesList.size());
            this.removeIllegalEntries(badEntriesList);
            badEntriesList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull List<MVUsedUrl> mvuuList) {
        try (OutputStream os = Files.newOutputStream(this.urlPath, StandardOpenOption.APPEND);
             OutputStreamWriter osw = new OutputStreamWriter(os);
             BufferedWriter bufferedWriter = new BufferedWriter(osw);){
            this.baseDataEventList.getReadWriteLock().writeLock().lock();
            for (MVUsedUrl mvuu : mvuuList) {
                this.baseDataEventList.add(mvuu);
                this.urlCacheSet.add(mvuu.getUrl());
                bufferedWriter.write(mvuu.getPreparedRowString());
            }
        }
        catch (Exception ex) {
            logger.error("zeilenSchreiben()", (Throwable)ex);
        }
        finally {
            this.baseDataEventList.getReadWriteLock().writeLock().unlock();
        }
        this.sendChangeMessage();
    }

    private synchronized void removeIllegalEntries(@NotNull List<String> badEntriesList) {
        logger.trace("Cleaning entries for {}", (Object)this.urlPath);
        ArrayList<String> cleanedEntriesList = new ArrayList<String>();
        try (InputStream is = Files.newInputStream(this.urlPath, new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(is);
             LineNumberReader in = new LineNumberReader(isr);){
            String zeile;
            while ((zeile = in.readLine()) != null) {
                if (badEntriesList.contains(zeile)) continue;
                cleanedEntriesList.add(zeile);
            }
        }
        catch (Exception ex) {
            logger.error("removeIllegalEntries()", (Throwable)ex);
        }
        try (OutputStream os = Files.newOutputStream(this.urlPath, new OpenOption[0]);
             OutputStreamWriter osw = new OutputStreamWriter(os);
             BufferedWriter bufferedWriter = new BufferedWriter(osw);){
            for (String entry : cleanedEntriesList) {
                bufferedWriter.write(entry + "\n");
            }
        }
        catch (Exception ex) {
            logger.error("removeIllegalEntries()", (Throwable)ex);
        }
        cleanedEntriesList.clear();
        logger.trace("Finished cleaning entries for {}", (Object)this.urlPath);
    }
}

