/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.summary;

import com.hankcs.hanlp.algorithm.MaxHeap;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.summary.KeywordExtractor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TextRankKeyword
extends KeywordExtractor {
    static final float d = 0.85f;
    public static int max_iter = 200;
    static final float min_diff = 0.001f;

    public TextRankKeyword(Segment defaultSegment) {
        super(defaultSegment);
    }

    public TextRankKeyword() {
    }

    public static List<String> getKeywordList(String document, int size) {
        TextRankKeyword textRankKeyword = new TextRankKeyword();
        return textRankKeyword.getKeywords(document, size);
    }

    public List<String> getKeyword(String content) {
        return this.getKeywords(content);
    }

    public Map<String, Float> getTermAndRank(String content) {
        assert (content != null);
        List<Term> termList = this.defaultSegment.seg(content);
        return this.getTermAndRank(termList);
    }

    public Map<String, Float> getTermAndRank(String content, int size) {
        Map<String, Float> map = this.getTermAndRank(content);
        Map<String, Float> result = this.top(size, map);
        return result;
    }

    private Map<String, Float> top(int size, Map<String, Float> map) {
        LinkedHashMap<String, Float> result = new LinkedHashMap<String, Float>();
        for (Map.Entry<String, Float> entry : new MaxHeap<Map.Entry<String, Float>>(size, new Comparator<Map.Entry<String, Float>>(){

            @Override
            public int compare(Map.Entry<String, Float> o1, Map.Entry<String, Float> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        }).addAll(map.entrySet()).toList()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Float> getTermAndRank(List<Term> termList) {
        void var6_9;
        ArrayList<String> wordList = new ArrayList<String>(termList.size());
        for (Term t : termList) {
            if (!this.shouldInclude(t)) continue;
            wordList.add(t.word);
        }
        TreeMap words = new TreeMap();
        LinkedList<String> que = new LinkedList<String>();
        for (String string : wordList) {
            if (!words.containsKey(string)) {
                words.put(string, new TreeSet());
            }
            if (que.size() >= 5) {
                que.poll();
            }
            for (String string2 : que) {
                if (string.equals(string2)) continue;
                ((Set)words.get(string)).add(string2);
                ((Set)words.get(string2)).add(string);
            }
            que.offer(string);
        }
        HashMap<String, Float> score = new HashMap<String, Float>();
        for (Map.Entry entry : words.entrySet()) {
            score.put((String)entry.getKey(), Float.valueOf(TextRankKeyword.sigMoid(((Set)entry.getValue()).size())));
        }
        boolean bl = false;
        while (var6_9 < max_iter) {
            HashMap<String, Float> hashMap = new HashMap<String, Float>();
            float f = 0.0f;
            for (Map.Entry entry : words.entrySet()) {
                String key = (String)entry.getKey();
                Set value = (Set)entry.getValue();
                hashMap.put(key, Float.valueOf(0.14999998f));
                for (String element : value) {
                    int size = ((Set)words.get(element)).size();
                    if (key.equals(element) || size == 0) continue;
                    hashMap.put(key, Float.valueOf(((Float)hashMap.get(key)).floatValue() + 0.85f / (float)size * (score.get(element) == null ? 0.0f : ((Float)score.get(element)).floatValue())));
                }
                f = Math.max(f, Math.abs(((Float)hashMap.get(key)).floatValue() - (score.get(key) == null ? 0.0f : ((Float)score.get(key)).floatValue())));
            }
            score = hashMap;
            if (f <= 0.001f) break;
            ++var6_9;
        }
        return score;
    }

    public static float sigMoid(float value) {
        return (float)(1.0 / (1.0 + Math.exp(-value)));
    }

    @Override
    public List<String> getKeywords(List<Term> termList, int size) {
        Set<Map.Entry<String, Float>> entrySet = this.top(size, this.getTermAndRank(termList)).entrySet();
        ArrayList<String> result = new ArrayList<String>(entrySet.size());
        for (Map.Entry<String, Float> entry : entrySet) {
            result.add(entry.getKey());
        }
        return result;
    }
}

