/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;

@FunctionalInterface
public interface DataSelectionListener {
    public void selectionChanged(SelectionChangeEvent var1);

    public static class SelectionToggleEvent
    extends AbstractSelectionEvent {
        private final Set<OsmPrimitive> current;
        private final Set<OsmPrimitive> remove;
        private final Set<OsmPrimitive> add;

        public SelectionToggleEvent(DataSet source, Set<OsmPrimitive> old, Stream<OsmPrimitive> toToggle) {
            super(source, old);
            LinkedHashSet<OsmPrimitive> currentSet = new LinkedHashSet<OsmPrimitive>(old);
            LinkedHashSet removeSet = new LinkedHashSet();
            LinkedHashSet addSet = new LinkedHashSet();
            toToggle.forEach(p -> {
                if (currentSet.remove(p)) {
                    removeSet.add(p);
                } else {
                    addSet.add(p);
                    currentSet.add((OsmPrimitive)p);
                }
            });
            this.current = Collections.unmodifiableSet(currentSet);
            this.remove = Collections.unmodifiableSet(removeSet);
            this.add = Collections.unmodifiableSet(addSet);
        }

        @Override
        public Set<OsmPrimitive> getSelection() {
            return Collections.unmodifiableSet(this.current);
        }

        @Override
        public Set<OsmPrimitive> getRemoved() {
            return Collections.unmodifiableSet(this.remove);
        }

        @Override
        public Set<OsmPrimitive> getAdded() {
            return Collections.unmodifiableSet(this.add);
        }

        public String toString() {
            return "SelectionToggleEvent [current=" + this.current + ", remove=" + this.remove + ", add=" + this.add + "]";
        }
    }

    public static class SelectionRemoveEvent
    extends AbstractSelectionEvent {
        private final Set<OsmPrimitive> remove;
        private final Set<OsmPrimitive> current;

        public SelectionRemoveEvent(DataSet source, Set<OsmPrimitive> old, Stream<OsmPrimitive> toRemove) {
            super(source, old);
            this.remove = toRemove.filter(old::contains).collect(Collectors.toCollection(LinkedHashSet::new));
            if (this.remove.isEmpty()) {
                this.current = this.getOldSelection();
            } else {
                LinkedHashSet<OsmPrimitive> currentSet = new LinkedHashSet<OsmPrimitive>(old);
                currentSet.removeAll(this.remove);
                this.current = currentSet;
            }
        }

        @Override
        public Set<OsmPrimitive> getSelection() {
            return Collections.unmodifiableSet(this.current);
        }

        @Override
        public Set<OsmPrimitive> getRemoved() {
            return Collections.unmodifiableSet(this.remove);
        }

        @Override
        public Set<OsmPrimitive> getAdded() {
            return Collections.emptySet();
        }

        public String toString() {
            return "SelectionRemoveEvent [remove=" + this.remove + ", current=" + this.current + "]";
        }
    }

    public static class SelectionAddEvent
    extends AbstractSelectionEvent {
        private final Set<OsmPrimitive> add;
        private final Set<OsmPrimitive> current;

        public SelectionAddEvent(DataSet source, Set<OsmPrimitive> old, Stream<OsmPrimitive> toAdd) {
            super(source, old);
            this.add = toAdd.filter(p -> !old.contains(p)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (this.add.isEmpty()) {
                this.current = this.getOldSelection();
            } else {
                this.current = new LinkedHashSet<OsmPrimitive>(old);
                this.current.addAll(this.add);
            }
        }

        @Override
        public Set<OsmPrimitive> getSelection() {
            return Collections.unmodifiableSet(this.current);
        }

        @Override
        public Set<OsmPrimitive> getRemoved() {
            return Collections.emptySet();
        }

        @Override
        public Set<OsmPrimitive> getAdded() {
            return Collections.unmodifiableSet(this.add);
        }

        public String toString() {
            return "SelectionAddEvent [add=" + this.add + ", current=" + this.current + "]";
        }
    }

    public static class SelectionReplaceEvent
    extends AbstractSelectionEvent {
        private final Set<OsmPrimitive> current;
        private Set<OsmPrimitive> removed;
        private Set<OsmPrimitive> added;

        public SelectionReplaceEvent(DataSet source, Set<OsmPrimitive> old, Stream<OsmPrimitive> newSelection) {
            super(source, old);
            this.current = newSelection.collect(Collectors.toCollection(LinkedHashSet::new));
        }

        @Override
        public Set<OsmPrimitive> getSelection() {
            return this.current;
        }

        @Override
        public synchronized Set<OsmPrimitive> getRemoved() {
            if (this.removed == null) {
                this.removed = this.getOldSelection().stream().filter(p -> !this.current.contains(p)).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            return this.removed;
        }

        @Override
        public synchronized Set<OsmPrimitive> getAdded() {
            if (this.added == null) {
                this.added = this.current.stream().filter(p -> !this.getOldSelection().contains(p)).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            return this.added;
        }

        public String toString() {
            return "SelectionReplaceEvent [current=" + this.current + ", removed=" + this.removed + ", added=" + this.added + "]";
        }
    }

    public static abstract class AbstractSelectionEvent
    implements SelectionChangeEvent {
        private final DataSet source;
        private final Set<OsmPrimitive> old;

        protected AbstractSelectionEvent(DataSet source, Set<OsmPrimitive> old) {
            CheckParameterUtil.ensureParameterNotNull(source, "source");
            CheckParameterUtil.ensureParameterNotNull(old, "old");
            this.source = source;
            this.old = Collections.unmodifiableSet(old);
        }

        @Override
        public Set<OsmPrimitive> getOldSelection() {
            return this.old;
        }

        @Override
        public DataSet getSource() {
            return this.source;
        }
    }

    public static interface SelectionChangeEvent {
        public Set<OsmPrimitive> getOldSelection();

        public Set<OsmPrimitive> getSelection();

        public Set<OsmPrimitive> getRemoved();

        public Set<OsmPrimitive> getAdded();

        public DataSet getSource();

        default public boolean isNop() {
            return this.getAdded().isEmpty() && this.getRemoved().isEmpty();
        }
    }
}

