/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.OCFCheckerState;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.xml.SAXAbortException;
import io.mola.galimatias.URL;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class PackageDocumentPeekerHandler
extends DefaultHandler {
    private static final String VERSION_3 = "3.0";
    private static final String VERSION_2 = "2.0";
    private final URL documentURL;
    private final OCFCheckerState state;
    private boolean isPackageRoot = false;
    private String currentText = null;
    private String uniqueId = null;
    private boolean isUniqueId = false;

    public PackageDocumentPeekerHandler(ValidationContext context, OCFCheckerState state) {
        this.state = state;
        this.documentURL = context.url;
        state.errorReset();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("package".equals(localName)) {
            this.processPackage(attributes);
            this.isPackageRoot = true;
        } else {
            if (!this.isPackageRoot) {
                this.state.addError("Package element must be the first element in the package file");
                throw new SAXAbortException();
            }
            if ("type".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                this.currentText = "";
            } else if ("identifier".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
                String id = attributes.getValue("id");
                boolean bl = this.isUniqueId = id != null && id.trim().equals(this.uniqueId);
                if (this.isUniqueId) {
                    this.currentText = "";
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentText != null) {
            this.currentText = this.currentText + String.valueOf(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("metadata".equals(localName) || "package".equals(localName)) {
            throw new SAXAbortException();
        }
        if ("type".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
            this.currentText = this.currentText.trim();
            if (this.currentText.length() > 0) {
                this.state.addType(this.documentURL, this.currentText);
            }
            this.currentText = null;
        } else if (this.isUniqueId && "identifier".equals(localName) && "http://purl.org/dc/elements/1.1/".equals(uri)) {
            this.currentText = this.currentText.trim();
            if (this.currentText.length() > 0) {
                this.state.addUniqueId(this.documentURL, this.currentText);
            }
            this.isUniqueId = false;
            this.currentText = null;
        }
    }

    private void processPackage(Attributes attributes) throws SAXException {
        String version = attributes.getValue("version");
        if (version == null) {
            this.state.addError("Version attribute not found");
            throw new SAXAbortException();
        }
        if (VERSION_3.equals(version)) {
            this.state.addVersion(this.documentURL, EPUBVersion.VERSION_3);
        } else if (VERSION_2.equals(version)) {
            this.state.addVersion(this.documentURL, EPUBVersion.VERSION_2);
        } else {
            this.state.addError("Version not supported");
            throw new SAXAbortException();
        }
        String uniqueId = attributes.getValue("unique-identifier");
        if (uniqueId != null) {
            this.uniqueId = uniqueId;
        }
    }
}

