/* transaction-cli.c generated by valac 0.56.18, the Vala compiler
 * generated from transaction-cli.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2019-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <pamac.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <signal.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <errno.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_TRANSACTION_CLI (pamac_transaction_cli_get_type ())
#define PAMAC_TRANSACTION_CLI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCli))
#define PAMAC_TRANSACTION_CLI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCliClass))
#define PAMAC_IS_TRANSACTION_CLI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_TRANSACTION_CLI))
#define PAMAC_IS_TRANSACTION_CLI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_TRANSACTION_CLI))
#define PAMAC_TRANSACTION_CLI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCliClass))

typedef struct _PamacTransactionCli PamacTransactionCli;
typedef struct _PamacTransactionCliClass PamacTransactionCliClass;
typedef struct _PamacTransactionCliPrivate PamacTransactionCliPrivate;
enum  {
	PAMAC_TRANSACTION_CLI_0_PROPERTY,
	PAMAC_TRANSACTION_CLI_NO_CONFIRM_PROPERTY,
	PAMAC_TRANSACTION_CLI_NUM_PROPERTIES
};
static GParamSpec* pamac_transaction_cli_properties[PAMAC_TRANSACTION_CLI_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PamacTransactionCliRunCmdLineAsyncData PamacTransactionCliRunCmdLineAsyncData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _PamacTransactionCliChooseOptdepsData PamacTransactionCliChooseOptdepsData;
typedef struct _PamacTransactionCliChooseProviderData PamacTransactionCliChooseProviderData;
typedef struct _PamacTransactionCliAskImportKeyData PamacTransactionCliAskImportKeyData;
typedef struct _PamacTransactionCliAskEditBuildFilesData PamacTransactionCliAskEditBuildFilesData;
typedef struct _PamacTransactionCliAskCommitData PamacTransactionCliAskCommitData;
typedef struct _PamacTransactionCliEditSingleBuildFilesData PamacTransactionCliEditSingleBuildFilesData;
typedef struct _PamacTransactionCliEditBuildFilesData PamacTransactionCliEditBuildFilesData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _PamacTransactionCli {
	PamacTransaction parent_instance;
	PamacTransactionCliPrivate * priv;
};

struct _PamacTransactionCliClass {
	PamacTransactionClass parent_class;
};

struct _PamacTransactionCliPrivate {
	gchar* current_line;
	gchar* current_action;
	gboolean summary_shown;
	gboolean commit_transaction_answer;
	gboolean _no_confirm;
};

struct _PamacTransactionCliRunCmdLineAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacTransactionCli* self;
	GPtrArray* args;
	gchar* working_directory;
	GCancellable* cancellable;
	gint result;
	gint status;
	GSubprocessLauncher* launcher;
	GSubprocessLauncher* _tmp0_;
	GSubprocessLauncher* _tmp1_;
	GSubprocessLauncher* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GPtrArray* args_copy;
	GPtrArray* _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GSubprocess* process;
	GSubprocessLauncher* _tmp11_;
	GPtrArray* _tmp12_;
	gpointer* _tmp13_;
	gint _tmp13__length1;
	GSubprocess* _tmp14_;
	GSubprocess* _tmp15_;
	GSubprocess* _tmp16_;
	GSubprocess* _tmp17_;
	GSubprocess* _tmp18_;
	GSubprocess* _tmp19_;
	GError* e;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GPtrArray* _tmp22_;
	GPtrArray* _tmp23_;
	GError* _inner_error0_;
};

struct _PamacTransactionCliChooseOptdepsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacTransactionCli* self;
	gchar* pkgname;
	GPtrArray* optdeps;
	GPtrArray* result;
	GPtrArray* optdeps_to_install;
	GPtrArray* _tmp0_;
	gboolean _tmp1_;
	FILE* _tmp2_;
	gint num_length;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	FILE* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint num;
	GPtrArray* name_collection;
	guint name_index;
	const gchar* name;
	FILE* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gint _tmp19_;
	FILE* _tmp20_;
	FILE* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	FILE* _tmp24_;
	FILE* _tmp25_;
	gchar* ans;
	FILE* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	guint nb;
	guint* numbers;
	guint* _tmp29_;
	gint numbers_length1;
	gint _numbers_size_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar** splitted;
	const gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint splitted_length1;
	gint _splitted_size_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gchar** part_collection;
	gint part_collection_length1;
	gint _part_collection_size_;
	gint part_it;
	const gchar* part;
	const gchar* _tmp37_;
	gchar** splitted2;
	const gchar* _tmp38_;
	gchar** _tmp39_;
	gchar** _tmp40_;
	gint splitted2_length1;
	gint _splitted2_size_;
	guint beg_num;
	guint end_num;
	gchar** _tmp41_;
	gint _tmp41__length1;
	const gchar* _tmp42_;
	gint _tmp43_;
	gboolean _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	const gchar* _tmp46_;
	gint _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	guint _tmp52_;
	const gchar* _tmp53_;
	guint _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	guint* _tmp59_;
	gint _tmp59__length1;
	guint* _tmp60_;
	gint _tmp60__length1;
	guint* number_collection;
	gint number_collection_length1;
	gint _number_collection_size_;
	gint number_it;
	guint number;
	GPtrArray* _tmp61_;
	gconstpointer _tmp62_;
	gchar* _tmp63_;
	FILE* _tmp64_;
};

struct _PamacTransactionCliChooseProviderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacTransactionCli* self;
	gchar* depend;
	GPtrArray* providers;
	gint result;
	gboolean _tmp0_;
	GPtrArray* pkgs;
	GPtrArray* _tmp1_;
	GPtrArray* provider_collection;
	guint provider_index;
	const gchar* provider;
	PamacAlpmPackage* pkg;
	PamacDatabase* _tmp2_;
	PamacDatabase* _tmp3_;
	const gchar* _tmp4_;
	PamacAlpmPackage* _tmp5_;
	PamacAlpmPackage* _tmp6_;
	PamacAlpmPackage* _tmp7_;
	PamacDatabase* _tmp8_;
	PamacDatabase* _tmp9_;
	const gchar* _tmp10_;
	PamacAURPackage* _tmp11_;
	PamacAlpmPackage* _tmp12_;
	PamacAlpmPackage* _tmp13_;
	GPtrArray* _tmp14_;
	PamacAlpmPackage* _tmp15_;
	PamacPackage* _tmp16_;
	gint name_length;
	gint version_length;
	GPtrArray* _tmp17_;
	GPtrArray* pkg_collection;
	guint pkg_index;
	PamacPackage* _vala1_pkg;
	PamacPackage* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	PamacPackage* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	PamacPackage* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	PamacPackage* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint num_length;
	gint _tmp38_;
	gint _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	FILE* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gint num;
	GPtrArray* _tmp50_;
	GPtrArray* _vala1_pkg_collection;
	guint _vala1_pkg_index;
	PamacPackage* _vala2_pkg;
	FILE* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	PamacPackage* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	PamacPackage* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	PamacPackage* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	gint _tmp63_;
	FILE* _tmp64_;
	FILE* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	FILE* _tmp68_;
	FILE* _tmp69_;
	gchar* ans;
	FILE* _tmp70_;
	gchar* _tmp71_;
	const gchar* _tmp72_;
	FILE* _tmp73_;
	gint64 nb;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	gint64 _tmp78_;
	gboolean _tmp79_;
	gboolean _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	gint index;
	FILE* _tmp83_;
};

struct _PamacTransactionCliAskImportKeyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacTransactionCli* self;
	gchar* pkgname;
	gchar* key;
	gchar* owner;
	gboolean result;
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gchar* question;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
};

struct _PamacTransactionCliAskEditBuildFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacTransactionCli* self;
	PamacTransactionSummary* summary;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean answer;
	FILE* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	FILE* _tmp7_;
	gchar buf[32];
	FILE* _tmp8_;
	const gchar* _tmp9_;
	gchar* ans;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	FILE* _tmp26_;
};

struct _PamacTransactionCliAskCommitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacTransactionCli* self;
	PamacTransactionSummary* summary;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
};

struct _PamacTransactionCliEditSingleBuildFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacTransactionCli* self;
	gchar* pkgname;
	GPtrArray* files;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar** cmds;
	gchar** _tmp4_;
	gint cmds_length1;
	gint _cmds_size_;
	const gchar* editor;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gchar** str_collection;
	gint str_collection_length1;
	gint _str_collection_size_;
	gint str_it;
	const gchar* str;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GPtrArray* _tmp16_;
	GPtrArray* file_collection;
	guint file_index;
	const gchar* file;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GSubprocess* process;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GSubprocess* _tmp20_;
	GSubprocess* _tmp21_;
	GError* e;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _inner_error0_;
};

struct _PamacTransactionCliEditBuildFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacTransactionCli* self;
	GPtrArray* pkgnames;
	gint _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	GPtrArray* pkgname_collection;
	guint pkgname_index;
	const gchar* pkgname;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
};

struct _Block1Data {
	int _ref_count_;
	PamacTransactionCli* self;
	GMainLoop* loop;
};

static gint PamacTransactionCli_private_offset;
static gpointer pamac_transaction_cli_parent_class = NULL;

VALA_EXTERN GType pamac_transaction_cli_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacTransactionCli, g_object_unref)
VALA_EXTERN PamacTransactionCli* pamac_transaction_cli_new (PamacDatabase* database);
VALA_EXTERN PamacTransactionCli* pamac_transaction_cli_construct (GType object_type,
                                                      PamacDatabase* database);
static void pamac_transaction_cli_real_run_cmd_line_async_data_free (gpointer _data);
static void pamac_transaction_cli_real_run_cmd_line_async (PamacTransaction* base,
                                                    GPtrArray* args,
                                                    const gchar* working_directory,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean pamac_transaction_cli_real_run_cmd_line_async_co (PamacTransactionCliRunCmdLineAsyncData* _data_);
static gpointer _g_strdup_gcopy_func (gconstpointer src,
                               gpointer self);
static void pamac_transaction_cli_run_cmd_line_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void pamac_transaction_cli_print_error (PamacTransactionCli* self,
                                        const gchar* message,
                                        GPtrArray* details);
static void _g_free0_ (gpointer var);
static gint pamac_transaction_cli_get_term_width (PamacTransactionCli* self);
static void pamac_transaction_cli_display_current_line (PamacTransactionCli* self);
static void pamac_transaction_cli_on_emit_script_output (PamacTransactionCli* self,
                                                  const gchar* line);
static void pamac_transaction_cli_print_action (PamacTransactionCli* self,
                                         const gchar* action);
static void pamac_transaction_cli_print_download_progress (PamacTransactionCli* self,
                                                    const gchar* action,
                                                    const gchar* status,
                                                    gdouble progress);
static void pamac_transaction_cli_print_action_progress (PamacTransactionCli* self,
                                                  const gchar* action,
                                                  const gchar* status,
                                                  gdouble progress);
static void pamac_transaction_cli_print_hook_progress (PamacTransactionCli* self,
                                                const gchar* action,
                                                const gchar* details,
                                                const gchar* status,
                                                gdouble progress);
static void pamac_transaction_cli_print_warning (PamacTransactionCli* self,
                                          const gchar* line);
static void pamac_transaction_cli_real_choose_optdeps_data_free (gpointer _data);
static void pamac_transaction_cli_real_choose_optdeps (PamacTransaction* base,
                                                const gchar* pkgname,
                                                GPtrArray* optdeps,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean pamac_transaction_cli_real_choose_optdeps_co (PamacTransactionCliChooseOptdepsData* _data_);
VALA_EXTERN gboolean pamac_transaction_cli_get_no_confirm (PamacTransactionCli* self);
static void _vala_array_add1 (guint* * array,
                       gint* length,
                       gint* size,
                       guint value);
static void _vala_array_add2 (guint* * array,
                       gint* length,
                       gint* size,
                       guint value);
static void pamac_transaction_cli_real_choose_provider_data_free (gpointer _data);
static void pamac_transaction_cli_real_choose_provider (PamacTransaction* base,
                                                 const gchar* depend,
                                                 GPtrArray* providers,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean pamac_transaction_cli_real_choose_provider_co (PamacTransactionCliChooseProviderData* _data_);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN gboolean pamac_transaction_cli_ask_user (PamacTransactionCli* self,
                                         const gchar* question);
static void pamac_transaction_cli_real_ask_import_key_data_free (gpointer _data);
static void pamac_transaction_cli_real_ask_import_key (PamacTransaction* base,
                                                const gchar* pkgname,
                                                const gchar* key,
                                                const gchar* owner,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean pamac_transaction_cli_real_ask_import_key_co (PamacTransactionCliAskImportKeyData* _data_);
static void pamac_transaction_cli_real_ask_edit_build_files_data_free (gpointer _data);
static void pamac_transaction_cli_real_ask_edit_build_files (PamacTransaction* base,
                                                      PamacTransactionSummary* summary,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean pamac_transaction_cli_real_ask_edit_build_files_co (PamacTransactionCliAskEditBuildFilesData* _data_);
static void pamac_transaction_cli_show_summary (PamacTransactionCli* self,
                                         PamacTransactionSummary* summary);
static void pamac_transaction_cli_real_ask_commit_data_free (gpointer _data);
static void pamac_transaction_cli_real_ask_commit (PamacTransaction* base,
                                            PamacTransactionSummary* summary,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean pamac_transaction_cli_real_ask_commit_co (PamacTransactionCliAskCommitData* _data_);
static void pamac_transaction_cli_ask_view_diff (PamacTransactionCli* self,
                                          const gchar* pkgname);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void pamac_transaction_cli_edit_single_build_files_data_free (gpointer _data);
static void pamac_transaction_cli_edit_single_build_files (PamacTransactionCli* self,
                                                    const gchar* pkgname,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static void pamac_transaction_cli_edit_single_build_files_finish (PamacTransactionCli* self,
                                                           GAsyncResult* _res_);
static gboolean pamac_transaction_cli_edit_single_build_files_co (PamacTransactionCliEditSingleBuildFilesData* _data_);
static void pamac_transaction_cli_edit_single_build_files_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void pamac_transaction_cli_real_edit_build_files_data_free (gpointer _data);
static void pamac_transaction_cli_real_edit_build_files (PamacTransaction* base,
                                                  GPtrArray* pkgnames,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean pamac_transaction_cli_real_edit_build_files_co (PamacTransactionCliEditBuildFilesData* _data_);
static void pamac_transaction_cli_edit_build_files_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
VALA_EXTERN void pamac_transaction_cli_set_no_confirm (PamacTransactionCli* self,
                                           gboolean value);
static GObject * pamac_transaction_cli_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _pamac_transaction_cli_print_action_pamac_transaction_emit_action (PamacTransaction* _sender,
                                                                        const gchar* action,
                                                                        gpointer self);
static void _pamac_transaction_cli_print_action_progress_pamac_transaction_emit_action_progress (PamacTransaction* _sender,
                                                                                          const gchar* action,
                                                                                          const gchar* status,
                                                                                          gdouble progress,
                                                                                          gpointer self);
static void _pamac_transaction_cli_print_download_progress_pamac_transaction_emit_download_progress (PamacTransaction* _sender,
                                                                                              const gchar* action,
                                                                                              const gchar* status,
                                                                                              gdouble progress,
                                                                                              gpointer self);
static void _pamac_transaction_cli_print_hook_progress_pamac_transaction_emit_hook_progress (PamacTransaction* _sender,
                                                                                      const gchar* action,
                                                                                      const gchar* details,
                                                                                      const gchar* status,
                                                                                      gdouble progress,
                                                                                      gpointer self);
static void _pamac_transaction_cli_on_emit_script_output_pamac_transaction_emit_script_output (PamacTransaction* _sender,
                                                                                        const gchar* message,
                                                                                        gpointer self);
static void _pamac_transaction_cli_print_warning_pamac_transaction_emit_warning (PamacTransaction* _sender,
                                                                          const gchar* message,
                                                                          gpointer self);
static void _pamac_transaction_cli_print_error_pamac_transaction_emit_error (PamacTransaction* _sender,
                                                                      const gchar* message,
                                                                      GPtrArray* details,
                                                                      gpointer self);
static void _pamac_transaction_cli___lambda4_ (Block1Data* _data1_,
                                        GObject* obj,
                                        GAsyncResult* res);
static void __pamac_transaction_cli___lambda4__gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self);
static void pamac_transaction_cli_finalize (GObject * obj);
static GType pamac_transaction_cli_get_type_once (void);
static void _vala_pamac_transaction_cli_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_pamac_transaction_cli_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pamac_transaction_cli_get_instance_private (PamacTransactionCli* self)
{
	return G_STRUCT_MEMBER_P (self, PamacTransactionCli_private_offset);
}

PamacTransactionCli*
pamac_transaction_cli_construct (GType object_type,
                                 PamacDatabase* database)
{
	PamacTransactionCli * self = NULL;
	g_return_val_if_fail (database != NULL, NULL);
	self = (PamacTransactionCli*) g_object_new (object_type, "database", database, NULL);
	return self;
}

PamacTransactionCli*
pamac_transaction_cli_new (PamacDatabase* database)
{
	return pamac_transaction_cli_construct (PAMAC_TYPE_TRANSACTION_CLI, database);
}

static void
pamac_transaction_cli_real_run_cmd_line_async_data_free (gpointer _data)
{
	PamacTransactionCliRunCmdLineAsyncData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->args);
	_g_free0 (_data_->working_directory);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacTransactionCliRunCmdLineAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
pamac_transaction_cli_real_run_cmd_line_async (PamacTransaction* base,
                                               GPtrArray* args,
                                               const gchar* working_directory,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	PamacTransactionCli * self;
	PamacTransactionCliRunCmdLineAsyncData* _data_;
	PamacTransactionCli* _tmp0_;
	GPtrArray* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (args != NULL);
	g_return_if_fail (cancellable != NULL);
	self = (PamacTransactionCli*) base;
	_data_ = g_slice_new0 (PamacTransactionCliRunCmdLineAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_transaction_cli_real_run_cmd_line_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_ptr_array_ref0 (args);
	_g_ptr_array_unref0 (_data_->args);
	_data_->args = _tmp1_;
	_tmp2_ = g_strdup (working_directory);
	_g_free0 (_data_->working_directory);
	_data_->working_directory = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	pamac_transaction_cli_real_run_cmd_line_async_co (_data_);
}

static gint
pamac_transaction_cli_run_cmd_line_finish (PamacTransaction* base,
                                           GAsyncResult* _res_)
{
	gint result;
	PamacTransactionCliRunCmdLineAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gint _tmp0_ = 0;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gpointer
_g_strdup_gcopy_func (gconstpointer src,
                      gpointer self)
{
	gpointer result;
	result = g_strdup ((const gchar*) src);
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
pamac_transaction_cli_run_cmd_line_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	PamacTransactionCliRunCmdLineAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pamac_transaction_cli_real_run_cmd_line_async_co (_data_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gboolean
pamac_transaction_cli_real_run_cmd_line_async_co (PamacTransactionCliRunCmdLineAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->status = 1;
	_data_->_tmp0_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_STDIN_INHERIT);
	_data_->launcher = _data_->_tmp0_;
	if (_data_->working_directory != NULL) {
		_data_->_tmp1_ = _data_->launcher;
		g_subprocess_launcher_set_cwd (_data_->_tmp1_, _data_->working_directory);
	}
	_data_->_tmp2_ = _data_->launcher;
	_data_->_tmp4_ = _data_->_tmp3_ = g_get_environ ();
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp5__length1 = _vala_array_length (_data_->_tmp3_);
	g_subprocess_launcher_set_environ (_data_->_tmp2_, _data_->_tmp5_);
	_data_->_tmp5_ = (_vala_array_free (_data_->_tmp5_, _data_->_tmp5__length1, (GDestroyNotify) g_free), NULL);
	{
		_data_->_tmp6_ = g_ptr_array_copy (_data_->args, _g_strdup_gcopy_func, NULL);
		_data_->args_copy = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->args_copy;
		_data_->_tmp8_ = _data_->args_copy;
		_data_->_tmp9_ = vala_g_ptr_array_get_length (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		g_ptr_array_set_size (_data_->_tmp7_, _data_->_tmp10_ + 1);
		_data_->_tmp11_ = _data_->launcher;
		_data_->_tmp12_ = _data_->args_copy;
		_data_->_tmp13_ = _data_->_tmp12_->pdata;
		_data_->_tmp13__length1 = _data_->_tmp12_->len;
		_data_->_tmp14_ = g_subprocess_launcher_spawnv (_data_->_tmp11_, _data_->_tmp13_, &_data_->_inner_error0_);
		_data_->process = _data_->_tmp14_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_ptr_array_unref0 (_data_->args_copy);
			goto __catch0_g_error;
		}
		{
			_data_->_tmp15_ = _data_->process;
			_data_->_state_ = 1;
			g_subprocess_wait_async (_data_->_tmp15_, _data_->cancellable, pamac_transaction_cli_run_cmd_line_async_ready, _data_);
			return FALSE;
			_state_1:
			g_subprocess_wait_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp16_ = _data_->process;
			if (g_subprocess_get_if_exited (_data_->_tmp16_)) {
				_data_->_tmp17_ = _data_->process;
				_data_->status = g_subprocess_get_exit_status (_data_->_tmp17_);
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_data_->_tmp18_ = _data_->process;
			g_subprocess_send_signal (_data_->_tmp18_, (gint) SIGINT);
			_data_->_tmp19_ = _data_->process;
			g_subprocess_send_signal (_data_->_tmp19_, (gint) SIGKILL);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->process);
			_g_ptr_array_unref0 (_data_->args_copy);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->process);
		_g_ptr_array_unref0 (_data_->args_copy);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp20_ = _data_->e;
		_data_->_tmp21_ = _data_->_tmp20_->message;
		_data_->_tmp22_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_data_->_tmp23_ = _data_->_tmp22_;
		pamac_transaction_cli_print_error (_data_->self, _data_->_tmp21_, _data_->_tmp23_);
		_g_ptr_array_unref0 (_data_->_tmp23_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->launcher);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->status;
	_g_object_unref0 (_data_->launcher);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
pamac_transaction_cli_get_term_width (PamacTransactionCli* self)
{
	gint width = 0;
	struct winsize win = {0};
	struct winsize _tmp0_ = {0};
	gint _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	width = 80;
	_tmp1_ = ioctl (STDOUT_FILENO, TIOCGWINSZ, &_tmp0_);
	 (&win);
	win = _tmp0_;
	if (_tmp1_ == 0) {
		struct winsize _tmp2_;
		_tmp2_ = win;
		width = (gint) _tmp2_.ws_col;
	}
	result = width;
	 (&win);
	return result;
}

static void
pamac_transaction_cli_display_current_line (PamacTransactionCli* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_line;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		FILE* _tmp1_;
		FILE* _tmp2_;
		const gchar* _tmp3_;
		FILE* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "\r%*s\r", pamac_transaction_cli_get_term_width (self), "");
		_tmp2_ = stdout;
		_tmp3_ = self->priv->current_line;
		fprintf (_tmp2_, "%s", _tmp3_);
		_tmp4_ = stdout;
		fprintf (_tmp4_, "\n");
		_tmp5_ = g_strdup ("");
		_g_free0 (self->priv->current_line);
		self->priv->current_line = _tmp5_;
	}
}

static void
pamac_transaction_cli_on_emit_script_output (PamacTransactionCli* self,
                                             const gchar* line)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	pamac_transaction_cli_display_current_line (self);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", line);
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n");
}

static void
pamac_transaction_cli_print_action (PamacTransactionCli* self,
                                    const gchar* action)
{
	gchar* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	pamac_transaction_cli_display_current_line (self);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->current_line);
	self->priv->current_line = _tmp0_;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "%s", action);
	_tmp2_ = stdout;
	fprintf (_tmp2_, "\n");
}

static void
pamac_transaction_cli_print_download_progress (PamacTransactionCli* self,
                                               const gchar* action,
                                               const gchar* status,
                                               gdouble progress)
{
	const gchar* _tmp0_;
	FILE* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->current_action;
	if (g_strcmp0 (action, _tmp0_) == 0) {
		gchar* _tmp1_;
		FILE* _tmp2_;
		FILE* _tmp3_;
		_tmp1_ = g_strdup (status);
		_g_free0 (self->priv->current_line);
		self->priv->current_line = _tmp1_;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "\r%*s\r", pamac_transaction_cli_get_term_width (self), "");
		_tmp3_ = stdout;
		fprintf (_tmp3_, "%s", status);
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		FILE* _tmp6_;
		FILE* _tmp7_;
		FILE* _tmp8_;
		FILE* _tmp9_;
		_tmp4_ = g_strdup (action);
		_g_free0 (self->priv->current_action);
		self->priv->current_action = _tmp4_;
		_tmp5_ = g_strdup (status);
		_g_free0 (self->priv->current_line);
		self->priv->current_line = _tmp5_;
		_tmp6_ = stdout;
		fprintf (_tmp6_, "\r%*s\r", pamac_transaction_cli_get_term_width (self), "");
		_tmp7_ = stdout;
		fprintf (_tmp7_, "%s", action);
		_tmp8_ = stdout;
		fprintf (_tmp8_, "\n");
		_tmp9_ = stdout;
		fprintf (_tmp9_, "%s", status);
	}
	if (progress == ((gdouble) 1)) {
		gchar* _tmp10_;
		FILE* _tmp11_;
		_tmp10_ = g_strdup ("");
		_g_free0 (self->priv->current_line);
		self->priv->current_line = _tmp10_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "\r%*s\r", pamac_transaction_cli_get_term_width (self), "");
	}
	_tmp12_ = stdout;
	fflush (_tmp12_);
}

static void
pamac_transaction_cli_print_action_progress (PamacTransactionCli* self,
                                             const gchar* action,
                                             const gchar* status,
                                             gdouble progress)
{
	const gchar* _tmp0_;
	gint width = 0;
	gchar* current_status = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	FILE* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->current_action;
	if (g_strcmp0 (action, _tmp0_) != 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (action);
		_g_free0 (self->priv->current_action);
		self->priv->current_action = _tmp1_;
		pamac_transaction_cli_display_current_line (self);
	}
	width = (pamac_transaction_cli_get_term_width (self) - g_utf8_strlen (action, (gssize) -1)) - 1;
	_tmp2_ = g_strdup_printf ("[%s]", status);
	current_status = _tmp2_;
	_tmp3_ = current_status;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (width > _tmp5_) {
		if (progress == ((gdouble) 1)) {
			gchar* _tmp6_;
			FILE* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp6_ = g_strdup ("");
			_g_free0 (self->priv->current_line);
			self->priv->current_line = _tmp6_;
			_tmp7_ = stdout;
			_tmp8_ = current_status;
			_tmp9_ = g_strdup_printf ("%s %*s\n", action, width, _tmp8_);
			_tmp10_ = _tmp9_;
			fprintf (_tmp7_, "%s", _tmp10_);
			_g_free0 (_tmp10_);
		} else {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			FILE* _tmp13_;
			const gchar* _tmp14_;
			FILE* _tmp15_;
			_tmp11_ = current_status;
			_tmp12_ = g_strdup_printf ("%s %*s", action, width, _tmp11_);
			_g_free0 (self->priv->current_line);
			self->priv->current_line = _tmp12_;
			_tmp13_ = stdout;
			_tmp14_ = self->priv->current_line;
			fprintf (_tmp13_, "%s", _tmp14_);
			_tmp15_ = stdout;
			fprintf (_tmp15_, "\r");
		}
	} else {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		FILE* _tmp18_;
		const gchar* _tmp19_;
		FILE* _tmp20_;
		_tmp16_ = current_status;
		_tmp17_ = g_strdup_printf ("%s %s", action, _tmp16_);
		_g_free0 (self->priv->current_line);
		self->priv->current_line = _tmp17_;
		_tmp18_ = stdout;
		_tmp19_ = self->priv->current_line;
		fprintf (_tmp18_, "%s", _tmp19_);
		_tmp20_ = stdout;
		fprintf (_tmp20_, "\n");
	}
	_tmp21_ = stdout;
	fflush (_tmp21_);
	_g_free0 (current_status);
}

static void
pamac_transaction_cli_print_hook_progress (PamacTransactionCli* self,
                                           const gchar* action,
                                           const gchar* details,
                                           const gchar* status,
                                           gdouble progress)
{
	const gchar* _tmp0_;
	gint width = 0;
	gchar* current_status = NULL;
	gchar* _tmp4_;
	FILE* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->current_action;
	if (g_strcmp0 (action, _tmp0_) != 0) {
		gchar* _tmp1_;
		FILE* _tmp2_;
		FILE* _tmp3_;
		_tmp1_ = g_strdup (action);
		_g_free0 (self->priv->current_action);
		self->priv->current_action = _tmp1_;
		pamac_transaction_cli_display_current_line (self);
		_tmp2_ = stdout;
		fprintf (_tmp2_, "%s", action);
		_tmp3_ = stdout;
		fprintf (_tmp3_, "\n");
	}
	width = (pamac_transaction_cli_get_term_width (self) - g_utf8_strlen (details, (gssize) -1)) - 1;
	_tmp4_ = g_strdup_printf ("[%s]", status);
	current_status = _tmp4_;
	_tmp5_ = stdout;
	_tmp6_ = g_strdup_printf ("%s %*s\n", details, width, current_status);
	_tmp7_ = _tmp6_;
	fprintf (_tmp5_, "%s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (current_status);
}

static void
pamac_transaction_cli_print_warning (PamacTransactionCli* self,
                                     const gchar* line)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	pamac_transaction_cli_display_current_line (self);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", line);
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n");
}

static void
pamac_transaction_cli_print_error (PamacTransactionCli* self,
                                   const gchar* message,
                                   GPtrArray* details)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (details != NULL);
	pamac_transaction_cli_display_current_line (self);
	_tmp0_ = vala_g_ptr_array_get_length (details);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 0) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = vala_g_ptr_array_get_length (details);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == 1) {
			FILE* _tmp4_;
			gconstpointer _tmp5_;
			_tmp4_ = stdout;
			_tmp5_ = g_ptr_array_index (details, (guint) 0);
			fprintf (_tmp4_, "%s: %s: %s\n", g_dgettext (NULL, "Error"), message, (const gchar*) _tmp5_);
		} else {
			FILE* _tmp6_;
			_tmp6_ = stdout;
			fprintf (_tmp6_, "%s: %s:\n", g_dgettext (NULL, "Error"), message);
			{
				GPtrArray* detail_collection = NULL;
				guint detail_index = 0U;
				detail_collection = details;
				for (detail_index = 0; detail_index < detail_collection->len; detail_index = detail_index + 1) {
					const gchar* detail = NULL;
					detail = (const gchar*) g_ptr_array_index (detail_collection, detail_index);
					{
						FILE* _tmp7_;
						const gchar* _tmp8_;
						_tmp7_ = stdout;
						_tmp8_ = detail;
						fprintf (_tmp7_, "%s\n", _tmp8_);
					}
				}
			}
		}
	} else {
		FILE* _tmp9_;
		_tmp9_ = stdout;
		fprintf (_tmp9_, "%s: %s\n", g_dgettext (NULL, "Error"), message);
	}
}

static void
pamac_transaction_cli_real_choose_optdeps_data_free (gpointer _data)
{
	PamacTransactionCliChooseOptdepsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->pkgname);
	_g_ptr_array_unref0 (_data_->optdeps);
	_g_ptr_array_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacTransactionCliChooseOptdepsData, _data_);
}

static void
pamac_transaction_cli_real_choose_optdeps (PamacTransaction* base,
                                           const gchar* pkgname,
                                           GPtrArray* optdeps,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	PamacTransactionCli * self;
	PamacTransactionCliChooseOptdepsData* _data_;
	PamacTransactionCli* _tmp0_;
	gchar* _tmp1_;
	GPtrArray* _tmp2_;
	g_return_if_fail (pkgname != NULL);
	g_return_if_fail (optdeps != NULL);
	self = (PamacTransactionCli*) base;
	_data_ = g_slice_new0 (PamacTransactionCliChooseOptdepsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_transaction_cli_real_choose_optdeps_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (pkgname);
	_g_free0 (_data_->pkgname);
	_data_->pkgname = _tmp1_;
	_tmp2_ = _g_ptr_array_ref0 (optdeps);
	_g_ptr_array_unref0 (_data_->optdeps);
	_data_->optdeps = _tmp2_;
	pamac_transaction_cli_real_choose_optdeps_co (_data_);
}

static GPtrArray*
pamac_transaction_cli_choose_optdeps_finish (PamacTransaction* base,
                                             GAsyncResult* _res_)
{
	GPtrArray* result;
	PamacTransactionCliChooseOptdepsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_string_free0 (ret);
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
_vala_array_add1 (guint* * array,
                  gint* length,
                  gint* size,
                  guint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static gboolean
uint_try_parse (const gchar* str,
                guint* _result_,
                const gchar** unparsed,
                guint _base)
{
	guint _vala__result_ = 0U;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gulong ulong_result = 0UL;
	gchar* _tmp0_ = NULL;
	gulong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gulong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtoul (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	ulong_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = ulong_result;
	if ((((gulong) 0) <= _tmp6_) && (_tmp6_ <= ((gulong) G_MAXUINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (guint) ulong_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXUINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
_vala_array_add2 (guint* * array,
                  gint* length,
                  gint* size,
                  guint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static gboolean
pamac_transaction_cli_real_choose_optdeps_co (PamacTransactionCliChooseOptdepsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_data_->optdeps_to_install = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->_no_confirm;
	if (_data_->_tmp1_) {
		_data_->result = _data_->optdeps_to_install;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = stdout;
	fprintf (_data_->_tmp2_, "\n");
	_data_->_tmp3_ = vala_g_ptr_array_get_length (_data_->optdeps);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%i", _data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = strlen (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->_tmp8_ + 1;
	_g_free0 (_data_->_tmp6_);
	_data_->num_length = _data_->_tmp9_;
	_data_->_tmp10_ = stdout;
	_data_->_tmp11_ = g_strdup_printf (g_dgettext (NULL, "Choose optional dependencies for %s"), _data_->pkgname);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s:\n", _data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	fprintf (_data_->_tmp10_, "%s", _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	_g_free0 (_data_->_tmp12_);
	_data_->num = 1;
	{
		_data_->name_collection = _data_->optdeps;
		for (_data_->name_index = 0; _data_->name_index < _data_->name_collection->len; _data_->name_index = _data_->name_index + 1) {
			_data_->name = (const gchar*) g_ptr_array_index (_data_->name_collection, _data_->name_index);
			{
				_data_->_tmp15_ = stdout;
				_data_->_tmp16_ = g_strdup_printf ("%i:", _data_->num);
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_tmp18_ = _data_->name;
				fprintf (_data_->_tmp15_, "%*s  %s\n", _data_->num_length, _data_->_tmp17_, _data_->_tmp18_);
				_g_free0 (_data_->_tmp17_);
				_data_->_tmp19_ = _data_->num;
				_data_->num = _data_->_tmp19_ + 1;
			}
		}
	}
	while (TRUE) {
		_data_->_tmp20_ = stdout;
		fprintf (_data_->_tmp20_, "\n");
		_data_->_tmp21_ = stdout;
		_data_->_tmp22_ = g_strdup_printf (g_dgettext (NULL, "Enter a selection (default=%s)"), g_dgettext (NULL, "none"));
		_data_->_tmp23_ = _data_->_tmp22_;
		fprintf (_data_->_tmp21_, "%s: ", _data_->_tmp23_);
		_g_free0 (_data_->_tmp23_);
		_data_->_tmp24_ = stdout;
		fflush (_data_->_tmp24_);
		_data_->_tmp25_ = stdin;
		tcflush (fileno (_data_->_tmp25_), TCIFLUSH);
		_data_->_tmp26_ = stdin;
		_data_->_tmp27_ = g_file_stream_read_line (_data_->_tmp26_);
		_data_->ans = _data_->_tmp27_;
		_data_->_tmp28_ = _data_->ans;
		if (_data_->_tmp28_ == NULL) {
			_g_free0 (_data_->ans);
			break;
		}
		_data_->_tmp29_ = g_new0 (guint, 0);
		_data_->numbers = _data_->_tmp29_;
		_data_->numbers_length1 = 0;
		_data_->_numbers_size_ = _data_->numbers_length1;
		_data_->_tmp30_ = _data_->ans;
		_data_->_tmp31_ = string_replace (_data_->_tmp30_, "\n", "");
		_g_free0 (_data_->ans);
		_data_->ans = _data_->_tmp31_;
		_data_->_tmp32_ = _data_->ans;
		if (g_strcmp0 (_data_->_tmp32_, "") == 0) {
			_data_->numbers = (g_free (_data_->numbers), NULL);
			_g_free0 (_data_->ans);
			break;
		} else {
			_data_->_tmp33_ = _data_->ans;
			_data_->_tmp35_ = _data_->_tmp34_ = g_strsplit_set (_data_->_tmp33_, ", ", 0);
			_data_->splitted = _data_->_tmp35_;
			_data_->splitted_length1 = _vala_array_length (_data_->_tmp34_);
			_data_->_splitted_size_ = _data_->splitted_length1;
			_data_->_tmp36_ = _data_->splitted;
			_data_->_tmp36__length1 = _data_->splitted_length1;
			{
				_data_->part_collection_length1 = 0;
				_data_->_part_collection_size_ = 0;
				_data_->part_collection = _data_->_tmp36_;
				_data_->part_collection_length1 = _data_->_tmp36__length1;
				for (_data_->part_it = 0; _data_->part_it < _data_->part_collection_length1; _data_->part_it = _data_->part_it + 1) {
					_data_->part = _data_->part_collection[_data_->part_it];
					{
						_data_->_tmp37_ = _data_->part;
						if (string_contains (_data_->_tmp37_, "-")) {
							_data_->_tmp38_ = _data_->part;
							_data_->_tmp40_ = _data_->_tmp39_ = g_strsplit (_data_->_tmp38_, "-", 2);
							_data_->splitted2 = _data_->_tmp40_;
							_data_->splitted2_length1 = _vala_array_length (_data_->_tmp39_);
							_data_->_splitted2_size_ = _data_->splitted2_length1;
							_data_->_tmp41_ = _data_->splitted2;
							_data_->_tmp41__length1 = _data_->splitted2_length1;
							_data_->_tmp42_ = _data_->_tmp41_[0];
							_data_->_tmp43_ = 0;
							_data_->_tmp44_ = int_try_parse (_data_->_tmp42_, &_data_->_tmp43_, NULL, (guint) 0);
							_data_->beg_num = (guint) _data_->_tmp43_;
							if (_data_->_tmp44_) {
								_data_->_tmp45_ = _data_->splitted2;
								_data_->_tmp45__length1 = _data_->splitted2_length1;
								_data_->_tmp46_ = _data_->_tmp45_[1];
								_data_->_tmp47_ = 0;
								_data_->_tmp48_ = int_try_parse (_data_->_tmp46_, &_data_->_tmp47_, NULL, (guint) 0);
								_data_->end_num = (guint) _data_->_tmp47_;
								if (_data_->_tmp48_) {
									_data_->nb = _data_->beg_num;
									while (TRUE) {
										if (!(_data_->nb <= _data_->end_num)) {
											break;
										}
										if (_data_->nb >= ((guint) 1)) {
											_data_->_tmp50_ = vala_g_ptr_array_get_length (_data_->optdeps);
											_data_->_tmp51_ = _data_->_tmp50_;
											_data_->_tmp49_ = _data_->nb <= ((guint) _data_->_tmp51_);
										} else {
											_data_->_tmp49_ = FALSE;
										}
										if (_data_->_tmp49_) {
											_vala_array_add1 (&_data_->numbers, &_data_->numbers_length1, &_data_->_numbers_size_, _data_->nb);
										}
										_data_->_tmp52_ = _data_->nb;
										_data_->nb = _data_->_tmp52_ + 1;
									}
								}
							}
							_data_->splitted2 = (_vala_array_free (_data_->splitted2, _data_->splitted2_length1, (GDestroyNotify) g_free), NULL);
						} else {
							_data_->_tmp53_ = _data_->part;
							_data_->_tmp54_ = 0U;
							_data_->_tmp55_ = uint_try_parse (_data_->_tmp53_, &_data_->_tmp54_, NULL, (guint) 0);
							_data_->nb = _data_->_tmp54_;
							if (_data_->_tmp55_) {
								if (_data_->nb >= ((guint) 1)) {
									_data_->_tmp57_ = vala_g_ptr_array_get_length (_data_->optdeps);
									_data_->_tmp58_ = _data_->_tmp57_;
									_data_->_tmp56_ = _data_->nb <= ((guint) _data_->_tmp58_);
								} else {
									_data_->_tmp56_ = FALSE;
								}
								if (_data_->_tmp56_) {
									_vala_array_add2 (&_data_->numbers, &_data_->numbers_length1, &_data_->_numbers_size_, _data_->nb);
								}
							}
						}
					}
				}
			}
			_data_->splitted = (_vala_array_free (_data_->splitted, _data_->splitted_length1, (GDestroyNotify) g_free), NULL);
		}
		_data_->_tmp59_ = _data_->numbers;
		_data_->_tmp59__length1 = _data_->numbers_length1;
		if (_data_->_tmp59__length1 > 0) {
			_data_->_tmp60_ = _data_->numbers;
			_data_->_tmp60__length1 = _data_->numbers_length1;
			{
				_data_->number_collection_length1 = 0;
				_data_->_number_collection_size_ = 0;
				_data_->number_collection = _data_->_tmp60_;
				_data_->number_collection_length1 = _data_->_tmp60__length1;
				for (_data_->number_it = 0; _data_->number_it < _data_->number_collection_length1; _data_->number_it = _data_->number_it + 1) {
					_data_->number = _data_->number_collection[_data_->number_it];
					{
						_data_->_tmp61_ = _data_->optdeps_to_install;
						_data_->_tmp62_ = g_ptr_array_index (_data_->optdeps, _data_->number - 1);
						_data_->_tmp63_ = g_strdup ((const gchar*) _data_->_tmp62_);
						g_ptr_array_add (_data_->_tmp61_, _data_->_tmp63_);
					}
				}
			}
			_data_->numbers = (g_free (_data_->numbers), NULL);
			_g_free0 (_data_->ans);
			break;
		}
		_data_->numbers = (g_free (_data_->numbers), NULL);
		_g_free0 (_data_->ans);
	}
	_data_->_tmp64_ = stdout;
	fprintf (_data_->_tmp64_, "\n");
	_data_->result = _data_->optdeps_to_install;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pamac_transaction_cli_real_choose_provider_data_free (gpointer _data)
{
	PamacTransactionCliChooseProviderData* _data_;
	_data_ = _data;
	_g_free0 (_data_->depend);
	_g_ptr_array_unref0 (_data_->providers);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacTransactionCliChooseProviderData, _data_);
}

static void
pamac_transaction_cli_real_choose_provider (PamacTransaction* base,
                                            const gchar* depend,
                                            GPtrArray* providers,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	PamacTransactionCli * self;
	PamacTransactionCliChooseProviderData* _data_;
	PamacTransactionCli* _tmp0_;
	gchar* _tmp1_;
	GPtrArray* _tmp2_;
	g_return_if_fail (depend != NULL);
	g_return_if_fail (providers != NULL);
	self = (PamacTransactionCli*) base;
	_data_ = g_slice_new0 (PamacTransactionCliChooseProviderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_transaction_cli_real_choose_provider_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (depend);
	_g_free0 (_data_->depend);
	_data_->depend = _tmp1_;
	_tmp2_ = _g_ptr_array_ref0 (providers);
	_g_ptr_array_unref0 (_data_->providers);
	_data_->providers = _tmp2_;
	pamac_transaction_cli_real_choose_provider_co (_data_);
}

static gint
pamac_transaction_cli_choose_provider_finish (PamacTransaction* base,
                                              GAsyncResult* _res_)
{
	gint result;
	PamacTransactionCliChooseProviderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar** unparsed,
                 guint _base)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gboolean
pamac_transaction_cli_real_choose_provider_co (PamacTransactionCliChooseProviderData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_no_confirm;
	if (_data_->_tmp0_) {
		_data_->result = 0;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->pkgs = _data_->_tmp1_;
	{
		_data_->provider_collection = _data_->providers;
		for (_data_->provider_index = 0; _data_->provider_index < _data_->provider_collection->len; _data_->provider_index = _data_->provider_index + 1) {
			_data_->provider = (const gchar*) g_ptr_array_index (_data_->provider_collection, _data_->provider_index);
			{
				_data_->_tmp2_ = pamac_transaction_get_database ((PamacTransaction*) _data_->self);
				_data_->_tmp3_ = _data_->_tmp2_;
				_data_->_tmp4_ = _data_->provider;
				_data_->_tmp5_ = pamac_database_get_sync_pkg (_data_->_tmp3_, _data_->_tmp4_);
				_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
				_data_->pkg = _data_->_tmp6_;
				_data_->_tmp7_ = _data_->pkg;
				if (_data_->_tmp7_ == NULL) {
					_data_->_tmp8_ = pamac_transaction_get_database ((PamacTransaction*) _data_->self);
					_data_->_tmp9_ = _data_->_tmp8_;
					_data_->_tmp10_ = _data_->provider;
					_data_->_tmp11_ = pamac_database_get_aur_pkg (_data_->_tmp9_, _data_->_tmp10_);
					_data_->_tmp12_ = _g_object_ref0 ((PamacAlpmPackage*) _data_->_tmp11_);
					_g_object_unref0 (_data_->pkg);
					_data_->pkg = _data_->_tmp12_;
				}
				_data_->_tmp13_ = _data_->pkg;
				if (_data_->_tmp13_ != NULL) {
					_data_->_tmp14_ = _data_->pkgs;
					_data_->_tmp15_ = _data_->pkg;
					_data_->_tmp16_ = _g_object_ref0 ((PamacPackage*) _data_->_tmp15_);
					g_ptr_array_add (_data_->_tmp14_, _data_->_tmp16_);
				}
				_g_object_unref0 (_data_->pkg);
			}
		}
	}
	_data_->name_length = 0;
	_data_->version_length = 0;
	_data_->_tmp17_ = _data_->pkgs;
	{
		_data_->pkg_collection = _data_->_tmp17_;
		for (_data_->pkg_index = 0; _data_->pkg_index < _data_->pkg_collection->len; _data_->pkg_index = _data_->pkg_index + 1) {
			_data_->_vala1_pkg = (PamacPackage*) g_ptr_array_index (_data_->pkg_collection, _data_->pkg_index);
			{
				_data_->_tmp18_ = _data_->_vala1_pkg;
				_data_->_tmp19_ = pamac_package_get_name (_data_->_tmp18_);
				_data_->_tmp20_ = _data_->_tmp19_;
				_data_->_tmp21_ = strlen (_data_->_tmp20_);
				_data_->_tmp22_ = _data_->_tmp21_;
				if (_data_->_tmp22_ > _data_->name_length) {
					_data_->_tmp23_ = _data_->_vala1_pkg;
					_data_->_tmp24_ = pamac_package_get_name (_data_->_tmp23_);
					_data_->_tmp25_ = _data_->_tmp24_;
					_data_->_tmp26_ = strlen (_data_->_tmp25_);
					_data_->_tmp27_ = _data_->_tmp26_;
					_data_->name_length = _data_->_tmp27_;
				}
				_data_->_tmp28_ = _data_->_vala1_pkg;
				_data_->_tmp29_ = pamac_package_get_version (_data_->_tmp28_);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = strlen (_data_->_tmp30_);
				_data_->_tmp32_ = _data_->_tmp31_;
				if (_data_->_tmp32_ > _data_->version_length) {
					_data_->_tmp33_ = _data_->_vala1_pkg;
					_data_->_tmp34_ = pamac_package_get_version (_data_->_tmp33_);
					_data_->_tmp35_ = _data_->_tmp34_;
					_data_->_tmp36_ = strlen (_data_->_tmp35_);
					_data_->_tmp37_ = _data_->_tmp36_;
					_data_->version_length = _data_->_tmp37_;
				}
			}
		}
	}
	_data_->_tmp38_ = vala_g_ptr_array_get_length (_data_->providers);
	_data_->_tmp39_ = _data_->_tmp38_;
	_data_->_tmp40_ = g_strdup_printf ("%i", _data_->_tmp39_);
	_data_->_tmp41_ = _data_->_tmp40_;
	_data_->_tmp42_ = strlen (_data_->_tmp41_);
	_data_->_tmp43_ = _data_->_tmp42_;
	_data_->_tmp44_ = _data_->_tmp43_ + 1;
	_g_free0 (_data_->_tmp41_);
	_data_->num_length = _data_->_tmp44_;
	_data_->_tmp45_ = stdout;
	_data_->_tmp46_ = g_strdup_printf (g_dgettext (NULL, "Choose a provider for %s"), _data_->depend);
	_data_->_tmp47_ = _data_->_tmp46_;
	_data_->_tmp48_ = g_strdup_printf ("%s:\n", _data_->_tmp47_);
	_data_->_tmp49_ = _data_->_tmp48_;
	fprintf (_data_->_tmp45_, "%s", _data_->_tmp49_);
	_g_free0 (_data_->_tmp49_);
	_g_free0 (_data_->_tmp47_);
	_data_->num = 1;
	_data_->_tmp50_ = _data_->pkgs;
	{
		_data_->_vala1_pkg_collection = _data_->_tmp50_;
		for (_data_->_vala1_pkg_index = 0; _data_->_vala1_pkg_index < _data_->_vala1_pkg_collection->len; _data_->_vala1_pkg_index = _data_->_vala1_pkg_index + 1) {
			_data_->_vala2_pkg = (PamacPackage*) g_ptr_array_index (_data_->_vala1_pkg_collection, _data_->_vala1_pkg_index);
			{
				_data_->_tmp51_ = stdout;
				_data_->_tmp52_ = g_strdup_printf ("%i:", _data_->num);
				_data_->_tmp53_ = _data_->_tmp52_;
				_data_->_tmp54_ = _data_->_vala2_pkg;
				_data_->_tmp55_ = pamac_package_get_name (_data_->_tmp54_);
				_data_->_tmp56_ = _data_->_tmp55_;
				_data_->_tmp57_ = _data_->_vala2_pkg;
				_data_->_tmp58_ = pamac_package_get_version (_data_->_tmp57_);
				_data_->_tmp59_ = _data_->_tmp58_;
				_data_->_tmp60_ = _data_->_vala2_pkg;
				_data_->_tmp61_ = pamac_package_get_repo (_data_->_tmp60_);
				_data_->_tmp62_ = _data_->_tmp61_;
				fprintf (_data_->_tmp51_, "%*s  %-*s  %-*s  %s\n", _data_->num_length, _data_->_tmp53_, _data_->name_length, _data_->_tmp56_, _data_->version_length, _data_->_tmp59_, _data_->_tmp62_);
				_g_free0 (_data_->_tmp53_);
				_data_->_tmp63_ = _data_->num;
				_data_->num = _data_->_tmp63_ + 1;
			}
		}
	}
	while (TRUE) {
		_data_->_tmp64_ = stdout;
		fprintf (_data_->_tmp64_, "\n");
		_data_->_tmp65_ = stdout;
		_data_->_tmp66_ = g_strdup_printf (g_dgettext (NULL, "Enter a number (default=%d)"), 1);
		_data_->_tmp67_ = _data_->_tmp66_;
		fprintf (_data_->_tmp65_, "%s: ", _data_->_tmp67_);
		_g_free0 (_data_->_tmp67_);
		_data_->_tmp68_ = stdout;
		fflush (_data_->_tmp68_);
		_data_->_tmp69_ = stdin;
		tcflush (fileno (_data_->_tmp69_), TCIFLUSH);
		_data_->_tmp70_ = stdin;
		_data_->_tmp71_ = g_file_stream_read_line (_data_->_tmp70_);
		_data_->ans = _data_->_tmp71_;
		_data_->_tmp72_ = _data_->ans;
		if (_data_->_tmp72_ == NULL) {
			_data_->_tmp73_ = stdout;
			fprintf (_data_->_tmp73_, "\n");
			_data_->result = 1;
			_g_free0 (_data_->ans);
			_g_ptr_array_unref0 (_data_->pkgs);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp74_ = _data_->ans;
		_data_->_tmp75_ = string_replace (_data_->_tmp74_, "\n", "");
		_g_free0 (_data_->ans);
		_data_->ans = _data_->_tmp75_;
		_data_->_tmp76_ = _data_->ans;
		if (g_strcmp0 (_data_->_tmp76_, "") == 0) {
			_data_->nb = (gint64) 1;
		} else {
			_data_->_tmp77_ = _data_->ans;
			_data_->_tmp78_ = 0LL;
			_data_->_tmp79_ = int64_try_parse (_data_->_tmp77_, &_data_->_tmp78_, NULL, (guint) 0);
			_data_->nb = _data_->_tmp78_;
			if (!_data_->_tmp79_) {
				_data_->nb = (gint64) 0;
			}
		}
		if (_data_->nb >= ((gint64) 1)) {
			_data_->_tmp81_ = vala_g_ptr_array_get_length (_data_->providers);
			_data_->_tmp82_ = _data_->_tmp81_;
			_data_->_tmp80_ = _data_->nb <= ((gint64) _data_->_tmp82_);
		} else {
			_data_->_tmp80_ = FALSE;
		}
		if (_data_->_tmp80_) {
			_data_->index = ((gint) _data_->nb) - 1;
			_data_->_tmp83_ = stdout;
			fprintf (_data_->_tmp83_, "\n");
			_data_->result = _data_->index;
			_g_free0 (_data_->ans);
			_g_ptr_array_unref0 (_data_->pkgs);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->ans);
	}
}

gboolean
pamac_transaction_cli_ask_user (PamacTransactionCli* self,
                                const gchar* question)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar buf[32] = {0};
	FILE* _tmp3_;
	const gchar* _tmp4_;
	FILE* _tmp18_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (question != NULL, FALSE);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s ? %s ", question, g_dgettext (NULL, "[y/N]"));
	_tmp1_ = stdout;
	fflush (_tmp1_);
	_tmp2_ = stdin;
	tcflush (fileno (_tmp2_), TCIFLUSH);
	_tmp3_ = stdin;
	_tmp4_ = fgets (buf, (gint) 32, _tmp3_);
	if (_tmp4_ != NULL) {
		gchar* ans = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp5_ = g_strdup ((const gchar*) buf);
		ans = _tmp5_;
		_tmp6_ = ans;
		_tmp7_ = string_replace (_tmp6_, "\n", "");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
		_g_free0 (ans);
		ans = _tmp9_;
		_g_free0 (_tmp8_);
		_tmp10_ = ans;
		if (g_strcmp0 (_tmp10_, "") != 0) {
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = ans;
			if (g_strcmp0 (_tmp14_, g_dgettext (NULL, "y")) == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = ans;
				_tmp13_ = g_strcmp0 (_tmp15_, g_dgettext (NULL, "yes")) == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = ans;
				_tmp12_ = g_strcmp0 (_tmp16_, "y") == 0;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				const gchar* _tmp17_;
				_tmp17_ = ans;
				_tmp11_ = g_strcmp0 (_tmp17_, "yes") == 0;
			}
			if (_tmp11_) {
				result = TRUE;
				_g_free0 (ans);
				return result;
			}
		}
		_g_free0 (ans);
	}
	_tmp18_ = stdout;
	fprintf (_tmp18_, "\n");
	result = FALSE;
	return result;
}

static void
pamac_transaction_cli_real_ask_import_key_data_free (gpointer _data)
{
	PamacTransactionCliAskImportKeyData* _data_;
	_data_ = _data;
	_g_free0 (_data_->pkgname);
	_g_free0 (_data_->key);
	_g_free0 (_data_->owner);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacTransactionCliAskImportKeyData, _data_);
}

static void
pamac_transaction_cli_real_ask_import_key (PamacTransaction* base,
                                           const gchar* pkgname,
                                           const gchar* key,
                                           const gchar* owner,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	PamacTransactionCli * self;
	PamacTransactionCliAskImportKeyData* _data_;
	PamacTransactionCli* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (pkgname != NULL);
	g_return_if_fail (key != NULL);
	self = (PamacTransactionCli*) base;
	_data_ = g_slice_new0 (PamacTransactionCliAskImportKeyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_transaction_cli_real_ask_import_key_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (pkgname);
	_g_free0 (_data_->pkgname);
	_data_->pkgname = _tmp1_;
	_tmp2_ = g_strdup (key);
	_g_free0 (_data_->key);
	_data_->key = _tmp2_;
	_tmp3_ = g_strdup (owner);
	_g_free0 (_data_->owner);
	_data_->owner = _tmp3_;
	pamac_transaction_cli_real_ask_import_key_co (_data_);
}

static gboolean
pamac_transaction_cli_ask_import_key_finish (PamacTransaction* base,
                                             GAsyncResult* _res_)
{
	gboolean result;
	PamacTransactionCliAskImportKeyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gboolean
pamac_transaction_cli_real_ask_import_key_co (PamacTransactionCliAskImportKeyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = stdout;
	_data_->_tmp1_ = g_strdup_printf (g_dgettext (NULL, "The PGP key %1$s is needed to verify %2$s source files"), _data_->key, _data_->pkgname);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_strdup_printf ("%s.\n", _data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	fprintf (_data_->_tmp0_, "%s", _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	_g_free0 (_data_->_tmp2_);
	_data_->_tmp5_ = _data_->self->priv->_no_confirm;
	if (_data_->_tmp5_) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->owner == NULL) {
		_data_->_tmp6_ = g_strdup (g_dgettext (NULL, "Import the PGP key"));
		_g_free0 (_data_->question);
		_data_->question = _data_->_tmp6_;
	} else {
		_data_->_tmp7_ = g_strdup_printf (g_dgettext (NULL, "Trust %s and import the PGP key"), _data_->owner);
		_g_free0 (_data_->question);
		_data_->question = _data_->_tmp7_;
	}
	_data_->_tmp8_ = _data_->question;
	_data_->result = pamac_transaction_cli_ask_user (_data_->self, _data_->_tmp8_);
	_g_free0 (_data_->question);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pamac_transaction_cli_real_ask_edit_build_files_data_free (gpointer _data)
{
	PamacTransactionCliAskEditBuildFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->summary);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacTransactionCliAskEditBuildFilesData, _data_);
}

static void
pamac_transaction_cli_real_ask_edit_build_files (PamacTransaction* base,
                                                 PamacTransactionSummary* summary,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	PamacTransactionCli * self;
	PamacTransactionCliAskEditBuildFilesData* _data_;
	PamacTransactionCli* _tmp0_;
	PamacTransactionSummary* _tmp1_;
	g_return_if_fail (summary != NULL);
	self = (PamacTransactionCli*) base;
	_data_ = g_slice_new0 (PamacTransactionCliAskEditBuildFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_transaction_cli_real_ask_edit_build_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (summary);
	_g_object_unref0 (_data_->summary);
	_data_->summary = _tmp1_;
	pamac_transaction_cli_real_ask_edit_build_files_co (_data_);
}

static gboolean
pamac_transaction_cli_ask_edit_build_files_finish (PamacTransaction* base,
                                                   GAsyncResult* _res_)
{
	gboolean result;
	PamacTransactionCliAskEditBuildFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gboolean
pamac_transaction_cli_real_ask_edit_build_files_co (PamacTransactionCliAskEditBuildFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	pamac_transaction_cli_show_summary (_data_->self, _data_->summary);
	_data_->self->priv->summary_shown = TRUE;
	_data_->_tmp0_ = pamac_transaction_get_dry_run ((PamacTransaction*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_) {
		_data_->self->priv->commit_transaction_answer = FALSE;
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_no_confirm;
	if (_data_->_tmp2_) {
		_data_->self->priv->commit_transaction_answer = TRUE;
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->answer = FALSE;
	_data_->_tmp3_ = stdout;
	fprintf (_data_->_tmp3_, "%s : %s ", g_dgettext (NULL, "Edit build files"), g_dgettext (NULL, "[e]"));
	_data_->_tmp4_ = stdout;
	fprintf (_data_->_tmp4_, "\n");
	_data_->_tmp5_ = stdout;
	fprintf (_data_->_tmp5_, "%s ? %s ", g_dgettext (NULL, "Apply transaction"), g_dgettext (NULL, "[e/y/N]"));
	_data_->_tmp6_ = stdout;
	fflush (_data_->_tmp6_);
	_data_->_tmp7_ = stdin;
	tcflush (fileno (_data_->_tmp7_), TCIFLUSH);
	_data_->_tmp8_ = stdin;
	_data_->_tmp9_ = fgets (_data_->buf, (gint) 32, _data_->_tmp8_);
	if (_data_->_tmp9_ != NULL) {
		_data_->_tmp10_ = g_strdup ((const gchar*) _data_->buf);
		_data_->ans = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->ans;
		_data_->_tmp12_ = string_replace (_data_->_tmp11_, "\n", "");
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = g_utf8_strdown (_data_->_tmp13_, (gssize) -1);
		_g_free0 (_data_->ans);
		_data_->ans = _data_->_tmp14_;
		_g_free0 (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->ans;
		if (g_strcmp0 (_data_->_tmp15_, "") != 0) {
			_data_->_tmp19_ = _data_->ans;
			if (g_strcmp0 (_data_->_tmp19_, g_dgettext (NULL, "y")) == 0) {
				_data_->_tmp18_ = TRUE;
			} else {
				_data_->_tmp20_ = _data_->ans;
				_data_->_tmp18_ = g_strcmp0 (_data_->_tmp20_, g_dgettext (NULL, "yes")) == 0;
			}
			if (_data_->_tmp18_) {
				_data_->_tmp17_ = TRUE;
			} else {
				_data_->_tmp21_ = _data_->ans;
				_data_->_tmp17_ = g_strcmp0 (_data_->_tmp21_, "y") == 0;
			}
			if (_data_->_tmp17_) {
				_data_->_tmp16_ = TRUE;
			} else {
				_data_->_tmp22_ = _data_->ans;
				_data_->_tmp16_ = g_strcmp0 (_data_->_tmp22_, "yes") == 0;
			}
			if (_data_->_tmp16_) {
				_data_->self->priv->commit_transaction_answer = TRUE;
			} else {
				_data_->_tmp24_ = _data_->ans;
				if (g_strcmp0 (_data_->_tmp24_, g_dgettext (NULL, "e")) == 0) {
					_data_->_tmp23_ = TRUE;
				} else {
					_data_->_tmp25_ = _data_->ans;
					_data_->_tmp23_ = g_strcmp0 (_data_->_tmp25_, "e") == 0;
				}
				if (_data_->_tmp23_) {
					_data_->answer = TRUE;
				}
			}
		}
		_g_free0 (_data_->ans);
	}
	_data_->_tmp26_ = stdout;
	fprintf (_data_->_tmp26_, "\n");
	_data_->result = _data_->answer;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pamac_transaction_cli_show_summary (PamacTransactionCli* self,
                                    PamacTransactionSummary* summary)
{
	guint64 dsize = 0ULL;
	guint64 rsize = 0ULL;
	gint64 isize = 0LL;
	gint name_length = 0;
	gint version_length = 0;
	gint installed_version_length = 0;
	gint repo_length = 0;
	gint pkg_name_length = 0;
	gint pkg_version_length = 0;
	gint pkg_installed_version_length = 0;
	gint pkg_repo_length = 0;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GPtrArray* _tmp49_;
	GPtrArray* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	GPtrArray* _tmp88_;
	GPtrArray* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	GPtrArray* _tmp136_;
	GPtrArray* _tmp137_;
	gint _tmp138_;
	gint _tmp139_;
	GPtrArray* _tmp181_;
	GPtrArray* _tmp182_;
	gint _tmp183_;
	gint _tmp184_;
	GPtrArray* _tmp233_;
	GPtrArray* _tmp234_;
	gint _tmp235_;
	gint _tmp236_;
	GPtrArray* _tmp259_;
	GPtrArray* _tmp260_;
	gint _tmp261_;
	gint _tmp262_;
	FILE* _tmp307_;
	GPtrArray* _tmp308_;
	GPtrArray* _tmp309_;
	gint _tmp310_;
	gint _tmp311_;
	GPtrArray* _tmp352_;
	GPtrArray* _tmp353_;
	gint _tmp354_;
	gint _tmp355_;
	GPtrArray* _tmp391_;
	GPtrArray* _tmp392_;
	gint _tmp393_;
	gint _tmp394_;
	GPtrArray* _tmp467_;
	GPtrArray* _tmp468_;
	gint _tmp469_;
	gint _tmp470_;
	GPtrArray* _tmp538_;
	GPtrArray* _tmp539_;
	gint _tmp540_;
	gint _tmp541_;
	gboolean _tmp582_ = FALSE;
	GPtrArray* _tmp583_;
	GPtrArray* _tmp584_;
	gint _tmp585_;
	gint _tmp586_;
	FILE* _tmp699_;
	FILE* _tmp712_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (summary != NULL);
	dsize = (guint64) 0;
	rsize = (guint64) 0;
	isize = (gint64) 0;
	name_length = 0;
	version_length = 0;
	installed_version_length = 0;
	repo_length = 0;
	_tmp0_ = pamac_transaction_summary_get_to_remove (summary);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_g_ptr_array_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != 0) {
		GPtrArray* _tmp4_;
		GPtrArray* _tmp5_;
		_tmp4_ = pamac_transaction_summary_get_to_remove (summary);
		_tmp5_ = _tmp4_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp5_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					PamacPackage* _tmp6_;
					guint64 _tmp7_;
					guint64 _tmp8_;
					PamacPackage* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					PamacPackage* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					PamacAlpmPackage* alpm_pkg = NULL;
					PamacPackage* _tmp19_;
					PamacAlpmPackage* _tmp20_;
					PamacAlpmPackage* _tmp21_;
					const gchar* repo = NULL;
					PamacPackage* _tmp42_;
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					_tmp6_ = pkg;
					_tmp7_ = pamac_package_get_installed_size (_tmp6_);
					_tmp8_ = _tmp7_;
					rsize += _tmp8_;
					_tmp9_ = pkg;
					_tmp10_ = pamac_package_get_name (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = strlen (_tmp11_);
					_tmp13_ = _tmp12_;
					pkg_name_length = _tmp13_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp14_ = pkg;
					_tmp15_ = pamac_package_get_version (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = strlen (_tmp16_);
					_tmp18_ = _tmp17_;
					pkg_version_length = _tmp18_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
					_tmp19_ = pkg;
					_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp19_) : NULL);
					alpm_pkg = _tmp20_;
					_tmp21_ = alpm_pkg;
					if (_tmp21_ != NULL) {
						GPtrArray* dep_list = NULL;
						PamacAlpmPackage* _tmp22_;
						GPtrArray* _tmp23_;
						GPtrArray* _tmp24_;
						GPtrArray* _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
						_tmp22_ = alpm_pkg;
						_tmp23_ = pamac_alpm_package_get_depends (_tmp22_);
						_tmp24_ = _tmp23_;
						dep_list = _tmp24_;
						_tmp25_ = dep_list;
						_tmp26_ = vala_g_ptr_array_get_length (_tmp25_);
						_tmp27_ = _tmp26_;
						if (_tmp27_ != 0) {
							gchar* dep = NULL;
							GPtrArray* _tmp28_;
							gconstpointer _tmp29_;
							gchar* _tmp30_;
							gint dep_length = 0;
							const gchar* _tmp31_;
							_tmp28_ = dep_list;
							_tmp29_ = g_ptr_array_index (_tmp28_, (guint) 0);
							_tmp30_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Depends On"), (const gchar*) _tmp29_);
							dep = _tmp30_;
							_tmp31_ = dep;
							dep_length = g_utf8_strlen (_tmp31_, (gssize) -1);
							if (dep_length > installed_version_length) {
								installed_version_length = dep_length;
							}
							_g_free0 (dep);
						} else {
							GPtrArray* requiredby_list = NULL;
							PamacAlpmPackage* _tmp32_;
							GPtrArray* _tmp33_;
							GPtrArray* _tmp34_;
							GPtrArray* _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							_tmp32_ = alpm_pkg;
							_tmp33_ = pamac_alpm_package_get_requiredby (_tmp32_);
							_tmp34_ = _tmp33_;
							requiredby_list = _tmp34_;
							_tmp35_ = requiredby_list;
							_tmp36_ = vala_g_ptr_array_get_length (_tmp35_);
							_tmp37_ = _tmp36_;
							if (_tmp37_ != 0) {
								gchar* requiredby = NULL;
								GPtrArray* _tmp38_;
								gconstpointer _tmp39_;
								gchar* _tmp40_;
								gint requiredby_length = 0;
								const gchar* _tmp41_;
								_tmp38_ = requiredby_list;
								_tmp39_ = g_ptr_array_index (_tmp38_, (guint) 0);
								_tmp40_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Orphan Of"), (const gchar*) _tmp39_);
								requiredby = _tmp40_;
								_tmp41_ = requiredby;
								requiredby_length = g_utf8_strlen (_tmp41_, (gssize) -1);
								if (requiredby_length > installed_version_length) {
									installed_version_length = requiredby_length;
								}
								_g_free0 (requiredby);
							}
						}
					}
					_tmp42_ = pkg;
					_tmp43_ = pamac_package_get_repo (_tmp42_);
					_tmp44_ = _tmp43_;
					repo = _tmp44_;
					_tmp45_ = repo;
					if (_tmp45_ != NULL) {
						const gchar* _tmp46_;
						gint _tmp47_;
						gint _tmp48_;
						_tmp46_ = repo;
						_tmp47_ = strlen (_tmp46_);
						_tmp48_ = _tmp47_;
						pkg_repo_length = _tmp48_;
						if (pkg_repo_length > repo_length) {
							repo_length = pkg_repo_length;
						}
					}
					_g_object_unref0 (alpm_pkg);
				}
			}
		}
	}
	_tmp49_ = pamac_transaction_summary_get_conflicts_to_remove (summary);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_g_ptr_array_get_length (_tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp52_ != 0) {
		GPtrArray* _tmp53_;
		GPtrArray* _tmp54_;
		_tmp53_ = pamac_transaction_summary_get_conflicts_to_remove (summary);
		_tmp54_ = _tmp53_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp54_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					PamacPackage* _tmp55_;
					guint64 _tmp56_;
					guint64 _tmp57_;
					PamacPackage* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					gint _tmp61_;
					gint _tmp62_;
					PamacPackage* _tmp63_;
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					PamacAlpmPackage* alpm_pkg = NULL;
					PamacPackage* _tmp68_;
					PamacAlpmPackage* _tmp69_;
					PamacAlpmPackage* _tmp70_;
					const gchar* repo = NULL;
					PamacPackage* _tmp81_;
					const gchar* _tmp82_;
					const gchar* _tmp83_;
					const gchar* _tmp84_;
					_tmp55_ = pkg;
					_tmp56_ = pamac_package_get_installed_size (_tmp55_);
					_tmp57_ = _tmp56_;
					rsize += _tmp57_;
					_tmp58_ = pkg;
					_tmp59_ = pamac_package_get_name (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = strlen (_tmp60_);
					_tmp62_ = _tmp61_;
					pkg_name_length = _tmp62_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp63_ = pkg;
					_tmp64_ = pamac_package_get_version (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = strlen (_tmp65_);
					_tmp67_ = _tmp66_;
					pkg_version_length = _tmp67_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
					_tmp68_ = pkg;
					_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp68_) : NULL);
					alpm_pkg = _tmp69_;
					_tmp70_ = alpm_pkg;
					if (_tmp70_ != NULL) {
						GPtrArray* dep_list = NULL;
						PamacAlpmPackage* _tmp71_;
						GPtrArray* _tmp72_;
						GPtrArray* _tmp73_;
						GPtrArray* _tmp74_;
						gint _tmp75_;
						gint _tmp76_;
						_tmp71_ = alpm_pkg;
						_tmp72_ = pamac_alpm_package_get_conflicts (_tmp71_);
						_tmp73_ = _tmp72_;
						dep_list = _tmp73_;
						_tmp74_ = dep_list;
						_tmp75_ = vala_g_ptr_array_get_length (_tmp74_);
						_tmp76_ = _tmp75_;
						if (_tmp76_ != 0) {
							gchar* conflict = NULL;
							GPtrArray* _tmp77_;
							gconstpointer _tmp78_;
							gchar* _tmp79_;
							gint conflict_length = 0;
							const gchar* _tmp80_;
							_tmp77_ = dep_list;
							_tmp78_ = g_ptr_array_index (_tmp77_, (guint) 0);
							_tmp79_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Conflicts With"), (const gchar*) _tmp78_);
							conflict = _tmp79_;
							_tmp80_ = conflict;
							conflict_length = g_utf8_strlen (_tmp80_, (gssize) -1);
							if (conflict_length > installed_version_length) {
								installed_version_length = conflict_length;
							}
							_g_free0 (conflict);
						}
					}
					_tmp81_ = pkg;
					_tmp82_ = pamac_package_get_repo (_tmp81_);
					_tmp83_ = _tmp82_;
					repo = _tmp83_;
					_tmp84_ = repo;
					if (_tmp84_ != NULL) {
						const gchar* _tmp85_;
						gint _tmp86_;
						gint _tmp87_;
						_tmp85_ = repo;
						_tmp86_ = strlen (_tmp85_);
						_tmp87_ = _tmp86_;
						pkg_repo_length = _tmp87_;
						if (pkg_repo_length > repo_length) {
							repo_length = pkg_repo_length;
						}
					}
					_g_object_unref0 (alpm_pkg);
				}
			}
		}
	}
	_tmp88_ = pamac_transaction_summary_get_to_downgrade (summary);
	_tmp89_ = _tmp88_;
	_tmp90_ = vala_g_ptr_array_get_length (_tmp89_);
	_tmp91_ = _tmp90_;
	if (_tmp91_ != 0) {
		GPtrArray* _tmp92_;
		GPtrArray* _tmp93_;
		_tmp92_ = pamac_transaction_summary_get_to_downgrade (summary);
		_tmp93_ = _tmp92_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp93_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					PamacPackage* _tmp94_;
					guint64 _tmp95_;
					guint64 _tmp96_;
					PamacAlpmPackage* installed_pkg = NULL;
					PamacDatabase* _tmp97_;
					PamacDatabase* _tmp98_;
					PamacPackage* _tmp99_;
					const gchar* _tmp100_;
					const gchar* _tmp101_;
					PamacAlpmPackage* _tmp102_;
					PamacAlpmPackage* _tmp103_;
					PamacPackage* _tmp104_;
					guint64 _tmp105_;
					guint64 _tmp106_;
					PamacAlpmPackage* _tmp107_;
					guint64 _tmp108_;
					guint64 _tmp109_;
					PamacPackage* _tmp110_;
					const gchar* _tmp111_;
					const gchar* _tmp112_;
					gint _tmp113_;
					gint _tmp114_;
					PamacPackage* _tmp115_;
					const gchar* _tmp116_;
					const gchar* _tmp117_;
					gint _tmp118_;
					gint _tmp119_;
					const gchar* repo = NULL;
					PamacPackage* _tmp120_;
					const gchar* _tmp121_;
					const gchar* _tmp122_;
					const gchar* _tmp123_;
					const gchar* installed_version = NULL;
					PamacPackage* _tmp127_;
					const gchar* _tmp128_;
					const gchar* _tmp129_;
					const gchar* _tmp130_;
					_tmp94_ = pkg;
					_tmp95_ = pamac_package_get_download_size (_tmp94_);
					_tmp96_ = _tmp95_;
					dsize += _tmp96_;
					_tmp97_ = pamac_transaction_get_database ((PamacTransaction*) self);
					_tmp98_ = _tmp97_;
					_tmp99_ = pkg;
					_tmp100_ = pamac_package_get_name (_tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = pamac_database_get_installed_pkg (_tmp98_, _tmp101_);
					_tmp103_ = _g_object_ref0 (_tmp102_);
					installed_pkg = _tmp103_;
					_tmp104_ = pkg;
					_tmp105_ = pamac_package_get_installed_size (_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = installed_pkg;
					_tmp108_ = pamac_package_get_installed_size ((PamacPackage*) _tmp107_);
					_tmp109_ = _tmp108_;
					isize += ((gint64) _tmp106_) - ((gint64) _tmp109_);
					_tmp110_ = pkg;
					_tmp111_ = pamac_package_get_name (_tmp110_);
					_tmp112_ = _tmp111_;
					_tmp113_ = strlen (_tmp112_);
					_tmp114_ = _tmp113_;
					pkg_name_length = _tmp114_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp115_ = pkg;
					_tmp116_ = pamac_package_get_version (_tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = strlen (_tmp117_);
					_tmp119_ = _tmp118_;
					pkg_version_length = _tmp119_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
					_tmp120_ = pkg;
					_tmp121_ = pamac_package_get_repo (_tmp120_);
					_tmp122_ = _tmp121_;
					repo = _tmp122_;
					_tmp123_ = repo;
					if (_tmp123_ != NULL) {
						const gchar* _tmp124_;
						gint _tmp125_;
						gint _tmp126_;
						_tmp124_ = repo;
						_tmp125_ = strlen (_tmp124_);
						_tmp126_ = _tmp125_;
						pkg_repo_length = _tmp126_;
						if (pkg_repo_length > repo_length) {
							repo_length = pkg_repo_length;
						}
					}
					_tmp127_ = pkg;
					_tmp128_ = pamac_package_get_installed_version (_tmp127_);
					_tmp129_ = _tmp128_;
					installed_version = _tmp129_;
					_tmp130_ = installed_version;
					if (_tmp130_ != NULL) {
						PamacPackage* _tmp131_;
						const gchar* _tmp132_;
						const gchar* _tmp133_;
						gint _tmp134_;
						gint _tmp135_;
						_tmp131_ = pkg;
						_tmp132_ = pamac_package_get_installed_version (_tmp131_);
						_tmp133_ = _tmp132_;
						_tmp134_ = strlen (_tmp133_);
						_tmp135_ = _tmp134_;
						pkg_installed_version_length = _tmp135_ + 2;
						if (pkg_installed_version_length > installed_version_length) {
							installed_version_length = pkg_installed_version_length;
						}
					}
					_g_object_unref0 (installed_pkg);
				}
			}
		}
	}
	_tmp136_ = pamac_transaction_summary_get_to_build (summary);
	_tmp137_ = _tmp136_;
	_tmp138_ = vala_g_ptr_array_get_length (_tmp137_);
	_tmp139_ = _tmp138_;
	if (_tmp139_ != 0) {
		GPtrArray* _tmp140_;
		GPtrArray* _tmp141_;
		_tmp140_ = pamac_transaction_summary_get_to_build (summary);
		_tmp141_ = _tmp140_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp141_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					PamacPackage* _tmp142_;
					const gchar* _tmp143_;
					const gchar* _tmp144_;
					gint _tmp145_;
					gint _tmp146_;
					PamacPackage* _tmp147_;
					const gchar* _tmp148_;
					const gchar* _tmp149_;
					gint _tmp150_;
					gint _tmp151_;
					const gchar* installed_version = NULL;
					PamacPackage* _tmp152_;
					const gchar* _tmp153_;
					const gchar* _tmp154_;
					const gchar* _tmp155_;
					PamacAlpmPackage* alpm_pkg = NULL;
					PamacPackage* _tmp161_;
					PamacAlpmPackage* _tmp162_;
					PamacAlpmPackage* _tmp163_;
					const gchar* repo = NULL;
					PamacPackage* _tmp174_;
					const gchar* _tmp175_;
					const gchar* _tmp176_;
					const gchar* _tmp177_;
					_tmp142_ = pkg;
					_tmp143_ = pamac_package_get_name (_tmp142_);
					_tmp144_ = _tmp143_;
					_tmp145_ = strlen (_tmp144_);
					_tmp146_ = _tmp145_;
					pkg_name_length = _tmp146_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp147_ = pkg;
					_tmp148_ = pamac_package_get_version (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = strlen (_tmp149_);
					_tmp151_ = _tmp150_;
					pkg_version_length = _tmp151_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
					_tmp152_ = pkg;
					_tmp153_ = pamac_package_get_installed_version (_tmp152_);
					_tmp154_ = _tmp153_;
					installed_version = _tmp154_;
					_tmp155_ = installed_version;
					if (_tmp155_ != NULL) {
						PamacPackage* _tmp156_;
						const gchar* _tmp157_;
						const gchar* _tmp158_;
						gint _tmp159_;
						gint _tmp160_;
						_tmp156_ = pkg;
						_tmp157_ = pamac_package_get_installed_version (_tmp156_);
						_tmp158_ = _tmp157_;
						_tmp159_ = strlen (_tmp158_);
						_tmp160_ = _tmp159_;
						pkg_installed_version_length = _tmp160_ + 2;
						if (pkg_installed_version_length > installed_version_length) {
							installed_version_length = pkg_installed_version_length;
						}
					}
					_tmp161_ = pkg;
					_tmp162_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp161_) : NULL);
					alpm_pkg = _tmp162_;
					_tmp163_ = alpm_pkg;
					if (_tmp163_ != NULL) {
						GPtrArray* dep_list = NULL;
						PamacAlpmPackage* _tmp164_;
						GPtrArray* _tmp165_;
						GPtrArray* _tmp166_;
						GPtrArray* _tmp167_;
						gint _tmp168_;
						gint _tmp169_;
						_tmp164_ = alpm_pkg;
						_tmp165_ = pamac_alpm_package_get_requiredby (_tmp164_);
						_tmp166_ = _tmp165_;
						dep_list = _tmp166_;
						_tmp167_ = dep_list;
						_tmp168_ = vala_g_ptr_array_get_length (_tmp167_);
						_tmp169_ = _tmp168_;
						if (_tmp169_ != 0) {
							gchar* requiredby = NULL;
							GPtrArray* _tmp170_;
							gconstpointer _tmp171_;
							gchar* _tmp172_;
							gint requiredby_length = 0;
							const gchar* _tmp173_;
							_tmp170_ = dep_list;
							_tmp171_ = g_ptr_array_index (_tmp170_, (guint) 0);
							_tmp172_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Required By"), (const gchar*) _tmp171_);
							requiredby = _tmp172_;
							_tmp173_ = requiredby;
							requiredby_length = g_utf8_strlen (_tmp173_, (gssize) -1);
							if (requiredby_length > installed_version_length) {
								installed_version_length = requiredby_length;
							}
							_g_free0 (requiredby);
						}
					}
					_tmp174_ = pkg;
					_tmp175_ = pamac_package_get_repo (_tmp174_);
					_tmp176_ = _tmp175_;
					repo = _tmp176_;
					_tmp177_ = repo;
					if (_tmp177_ != NULL) {
						const gchar* _tmp178_;
						gint _tmp179_;
						gint _tmp180_;
						_tmp178_ = repo;
						_tmp179_ = strlen (_tmp178_);
						_tmp180_ = _tmp179_;
						pkg_repo_length = _tmp180_;
						if (pkg_repo_length > repo_length) {
							repo_length = pkg_repo_length;
						}
					}
					_g_object_unref0 (alpm_pkg);
				}
			}
		}
	}
	_tmp181_ = pamac_transaction_summary_get_to_install (summary);
	_tmp182_ = _tmp181_;
	_tmp183_ = vala_g_ptr_array_get_length (_tmp182_);
	_tmp184_ = _tmp183_;
	if (_tmp184_ != 0) {
		GPtrArray* _tmp185_;
		GPtrArray* _tmp186_;
		_tmp185_ = pamac_transaction_summary_get_to_install (summary);
		_tmp186_ = _tmp185_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp186_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					PamacPackage* _tmp187_;
					guint64 _tmp188_;
					guint64 _tmp189_;
					PamacPackage* _tmp190_;
					guint64 _tmp191_;
					guint64 _tmp192_;
					PamacPackage* _tmp193_;
					const gchar* _tmp194_;
					const gchar* _tmp195_;
					gint _tmp196_;
					gint _tmp197_;
					PamacPackage* _tmp198_;
					const gchar* _tmp199_;
					const gchar* _tmp200_;
					gint _tmp201_;
					gint _tmp202_;
					PamacAlpmPackage* alpm_pkg = NULL;
					PamacPackage* _tmp203_;
					PamacAlpmPackage* _tmp204_;
					PamacAlpmPackage* _tmp205_;
					const gchar* repo = NULL;
					PamacPackage* _tmp226_;
					const gchar* _tmp227_;
					const gchar* _tmp228_;
					const gchar* _tmp229_;
					_tmp187_ = pkg;
					_tmp188_ = pamac_package_get_download_size (_tmp187_);
					_tmp189_ = _tmp188_;
					dsize += _tmp189_;
					_tmp190_ = pkg;
					_tmp191_ = pamac_package_get_installed_size (_tmp190_);
					_tmp192_ = _tmp191_;
					isize += (gint64) _tmp192_;
					_tmp193_ = pkg;
					_tmp194_ = pamac_package_get_name (_tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = strlen (_tmp195_);
					_tmp197_ = _tmp196_;
					pkg_name_length = _tmp197_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp198_ = pkg;
					_tmp199_ = pamac_package_get_version (_tmp198_);
					_tmp200_ = _tmp199_;
					_tmp201_ = strlen (_tmp200_);
					_tmp202_ = _tmp201_;
					pkg_version_length = _tmp202_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
					_tmp203_ = pkg;
					_tmp204_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp203_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp203_) : NULL);
					alpm_pkg = _tmp204_;
					_tmp205_ = alpm_pkg;
					if (_tmp205_ != NULL) {
						gboolean requiredby_found = FALSE;
						GPtrArray* dep_list = NULL;
						PamacAlpmPackage* _tmp206_;
						GPtrArray* _tmp207_;
						GPtrArray* _tmp208_;
						GPtrArray* _tmp209_;
						gint _tmp210_;
						gint _tmp211_;
						requiredby_found = FALSE;
						_tmp206_ = alpm_pkg;
						_tmp207_ = pamac_alpm_package_get_requiredby (_tmp206_);
						_tmp208_ = _tmp207_;
						dep_list = _tmp208_;
						_tmp209_ = dep_list;
						_tmp210_ = vala_g_ptr_array_get_length (_tmp209_);
						_tmp211_ = _tmp210_;
						if (_tmp211_ != 0) {
							gchar* requiredby = NULL;
							GPtrArray* _tmp212_;
							gconstpointer _tmp213_;
							gchar* _tmp214_;
							gint requiredby_length = 0;
							const gchar* _tmp215_;
							requiredby_found = TRUE;
							_tmp212_ = dep_list;
							_tmp213_ = g_ptr_array_index (_tmp212_, (guint) 0);
							_tmp214_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Required By"), (const gchar*) _tmp213_);
							requiredby = _tmp214_;
							_tmp215_ = requiredby;
							requiredby_length = g_utf8_strlen (_tmp215_, (gssize) -1);
							if (requiredby_length > installed_version_length) {
								installed_version_length = requiredby_length;
							}
							_g_free0 (requiredby);
						}
						if (!requiredby_found) {
							PamacAlpmPackage* _tmp216_;
							GPtrArray* _tmp217_;
							GPtrArray* _tmp218_;
							GPtrArray* _tmp219_;
							gint _tmp220_;
							gint _tmp221_;
							_tmp216_ = alpm_pkg;
							_tmp217_ = pamac_alpm_package_get_replaces (_tmp216_);
							_tmp218_ = _tmp217_;
							dep_list = _tmp218_;
							_tmp219_ = dep_list;
							_tmp220_ = vala_g_ptr_array_get_length (_tmp219_);
							_tmp221_ = _tmp220_;
							if (_tmp221_ != 0) {
								gchar* replace = NULL;
								GPtrArray* _tmp222_;
								gconstpointer _tmp223_;
								gchar* _tmp224_;
								gint replace_length = 0;
								const gchar* _tmp225_;
								_tmp222_ = dep_list;
								_tmp223_ = g_ptr_array_index (_tmp222_, (guint) 0);
								_tmp224_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Replaces"), (const gchar*) _tmp223_);
								replace = _tmp224_;
								_tmp225_ = replace;
								replace_length = g_utf8_strlen (_tmp225_, (gssize) -1);
								if (replace_length > installed_version_length) {
									installed_version_length = replace_length;
								}
								_g_free0 (replace);
							}
						}
					}
					_tmp226_ = pkg;
					_tmp227_ = pamac_package_get_repo (_tmp226_);
					_tmp228_ = _tmp227_;
					repo = _tmp228_;
					_tmp229_ = repo;
					if (_tmp229_ != NULL) {
						const gchar* _tmp230_;
						gint _tmp231_;
						gint _tmp232_;
						_tmp230_ = repo;
						_tmp231_ = strlen (_tmp230_);
						_tmp232_ = _tmp231_;
						pkg_repo_length = _tmp232_;
						if (pkg_repo_length > repo_length) {
							repo_length = pkg_repo_length;
						}
					}
					_g_object_unref0 (alpm_pkg);
				}
			}
		}
	}
	_tmp233_ = pamac_transaction_summary_get_to_reinstall (summary);
	_tmp234_ = _tmp233_;
	_tmp235_ = vala_g_ptr_array_get_length (_tmp234_);
	_tmp236_ = _tmp235_;
	if (_tmp236_ != 0) {
		GPtrArray* _tmp237_;
		GPtrArray* _tmp238_;
		_tmp237_ = pamac_transaction_summary_get_to_reinstall (summary);
		_tmp238_ = _tmp237_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp238_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					PamacPackage* _tmp239_;
					guint64 _tmp240_;
					guint64 _tmp241_;
					PamacPackage* _tmp242_;
					const gchar* _tmp243_;
					const gchar* _tmp244_;
					gint _tmp245_;
					gint _tmp246_;
					PamacPackage* _tmp247_;
					const gchar* _tmp248_;
					const gchar* _tmp249_;
					gint _tmp250_;
					gint _tmp251_;
					const gchar* repo = NULL;
					PamacPackage* _tmp252_;
					const gchar* _tmp253_;
					const gchar* _tmp254_;
					const gchar* _tmp255_;
					_tmp239_ = pkg;
					_tmp240_ = pamac_package_get_download_size (_tmp239_);
					_tmp241_ = _tmp240_;
					dsize += _tmp241_;
					_tmp242_ = pkg;
					_tmp243_ = pamac_package_get_name (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = strlen (_tmp244_);
					_tmp246_ = _tmp245_;
					pkg_name_length = _tmp246_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp247_ = pkg;
					_tmp248_ = pamac_package_get_version (_tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = strlen (_tmp249_);
					_tmp251_ = _tmp250_;
					pkg_version_length = _tmp251_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
					_tmp252_ = pkg;
					_tmp253_ = pamac_package_get_repo (_tmp252_);
					_tmp254_ = _tmp253_;
					repo = _tmp254_;
					_tmp255_ = repo;
					if (_tmp255_ != NULL) {
						const gchar* _tmp256_;
						gint _tmp257_;
						gint _tmp258_;
						_tmp256_ = repo;
						_tmp257_ = strlen (_tmp256_);
						_tmp258_ = _tmp257_;
						pkg_repo_length = _tmp258_;
						if (pkg_repo_length > repo_length) {
							repo_length = pkg_repo_length;
						}
					}
				}
			}
		}
	}
	_tmp259_ = pamac_transaction_summary_get_to_upgrade (summary);
	_tmp260_ = _tmp259_;
	_tmp261_ = vala_g_ptr_array_get_length (_tmp260_);
	_tmp262_ = _tmp261_;
	if (_tmp262_ != 0) {
		GPtrArray* _tmp263_;
		GPtrArray* _tmp264_;
		_tmp263_ = pamac_transaction_summary_get_to_upgrade (summary);
		_tmp264_ = _tmp263_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp264_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					PamacPackage* _tmp265_;
					guint64 _tmp266_;
					guint64 _tmp267_;
					PamacAlpmPackage* installed_pkg = NULL;
					PamacDatabase* _tmp268_;
					PamacDatabase* _tmp269_;
					PamacPackage* _tmp270_;
					const gchar* _tmp271_;
					const gchar* _tmp272_;
					PamacAlpmPackage* _tmp273_;
					PamacAlpmPackage* _tmp274_;
					PamacPackage* _tmp275_;
					guint64 _tmp276_;
					guint64 _tmp277_;
					PamacAlpmPackage* _tmp278_;
					guint64 _tmp279_;
					guint64 _tmp280_;
					PamacPackage* _tmp281_;
					const gchar* _tmp282_;
					const gchar* _tmp283_;
					gint _tmp284_;
					gint _tmp285_;
					PamacPackage* _tmp286_;
					const gchar* _tmp287_;
					const gchar* _tmp288_;
					gint _tmp289_;
					gint _tmp290_;
					const gchar* repo = NULL;
					PamacPackage* _tmp291_;
					const gchar* _tmp292_;
					const gchar* _tmp293_;
					const gchar* _tmp294_;
					const gchar* installed_version = NULL;
					PamacPackage* _tmp298_;
					const gchar* _tmp299_;
					const gchar* _tmp300_;
					const gchar* _tmp301_;
					_tmp265_ = pkg;
					_tmp266_ = pamac_package_get_download_size (_tmp265_);
					_tmp267_ = _tmp266_;
					dsize += _tmp267_;
					_tmp268_ = pamac_transaction_get_database ((PamacTransaction*) self);
					_tmp269_ = _tmp268_;
					_tmp270_ = pkg;
					_tmp271_ = pamac_package_get_name (_tmp270_);
					_tmp272_ = _tmp271_;
					_tmp273_ = pamac_database_get_installed_pkg (_tmp269_, _tmp272_);
					_tmp274_ = _g_object_ref0 (_tmp273_);
					installed_pkg = _tmp274_;
					_tmp275_ = pkg;
					_tmp276_ = pamac_package_get_installed_size (_tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = installed_pkg;
					_tmp279_ = pamac_package_get_installed_size ((PamacPackage*) _tmp278_);
					_tmp280_ = _tmp279_;
					isize += ((gint64) _tmp277_) - ((gint64) _tmp280_);
					_tmp281_ = pkg;
					_tmp282_ = pamac_package_get_name (_tmp281_);
					_tmp283_ = _tmp282_;
					_tmp284_ = strlen (_tmp283_);
					_tmp285_ = _tmp284_;
					pkg_name_length = _tmp285_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp286_ = pkg;
					_tmp287_ = pamac_package_get_version (_tmp286_);
					_tmp288_ = _tmp287_;
					_tmp289_ = strlen (_tmp288_);
					_tmp290_ = _tmp289_;
					pkg_version_length = _tmp290_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
					_tmp291_ = pkg;
					_tmp292_ = pamac_package_get_repo (_tmp291_);
					_tmp293_ = _tmp292_;
					repo = _tmp293_;
					_tmp294_ = repo;
					if (_tmp294_ != NULL) {
						const gchar* _tmp295_;
						gint _tmp296_;
						gint _tmp297_;
						_tmp295_ = repo;
						_tmp296_ = strlen (_tmp295_);
						_tmp297_ = _tmp296_;
						pkg_repo_length = _tmp297_;
						if (pkg_repo_length > repo_length) {
							repo_length = pkg_repo_length;
						}
					}
					_tmp298_ = pkg;
					_tmp299_ = pamac_package_get_installed_version (_tmp298_);
					_tmp300_ = _tmp299_;
					installed_version = _tmp300_;
					_tmp301_ = installed_version;
					if (_tmp301_ != NULL) {
						PamacPackage* _tmp302_;
						const gchar* _tmp303_;
						const gchar* _tmp304_;
						gint _tmp305_;
						gint _tmp306_;
						_tmp302_ = pkg;
						_tmp303_ = pamac_package_get_installed_version (_tmp302_);
						_tmp304_ = _tmp303_;
						_tmp305_ = strlen (_tmp304_);
						_tmp306_ = _tmp305_;
						pkg_installed_version_length = _tmp306_ + 2;
						if (pkg_installed_version_length > installed_version_length) {
							installed_version_length = pkg_installed_version_length;
						}
					}
					_g_object_unref0 (installed_pkg);
				}
			}
		}
	}
	_tmp307_ = stdout;
	fprintf (_tmp307_, "\n");
	_tmp308_ = pamac_transaction_summary_get_to_upgrade (summary);
	_tmp309_ = _tmp308_;
	_tmp310_ = vala_g_ptr_array_get_length (_tmp309_);
	_tmp311_ = _tmp310_;
	if (_tmp311_ != 0) {
		FILE* _tmp312_;
		GPtrArray* _tmp313_;
		GPtrArray* _tmp314_;
		gint _tmp315_;
		gint _tmp316_;
		gchar* _tmp317_;
		gchar* _tmp318_;
		gchar* _tmp319_;
		gchar* _tmp320_;
		GPtrArray* _tmp321_;
		GPtrArray* _tmp322_;
		_tmp312_ = stdout;
		_tmp313_ = pamac_transaction_summary_get_to_upgrade (summary);
		_tmp314_ = _tmp313_;
		_tmp315_ = vala_g_ptr_array_get_length (_tmp314_);
		_tmp316_ = _tmp315_;
		_tmp317_ = g_strdup_printf (" (%u):\n", (guint) _tmp316_);
		_tmp318_ = _tmp317_;
		_tmp319_ = g_strconcat (g_dgettext (NULL, "To upgrade"), _tmp318_, NULL);
		_tmp320_ = _tmp319_;
		fprintf (_tmp312_, "%s", _tmp320_);
		_g_free0 (_tmp320_);
		_g_free0 (_tmp318_);
		_tmp321_ = pamac_transaction_summary_get_to_upgrade (summary);
		_tmp322_ = _tmp321_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp322_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gchar* _tmp323_ = NULL;
					PamacPackage* _tmp324_;
					guint64 _tmp325_;
					guint64 _tmp326_;
					gchar* size = NULL;
					gchar* _tmp332_;
					const gchar* _tmp333_ = NULL;
					PamacPackage* _tmp334_;
					const gchar* _tmp335_;
					const gchar* _tmp336_;
					gchar* repo = NULL;
					gchar* _tmp337_;
					FILE* _tmp338_;
					PamacPackage* _tmp339_;
					const gchar* _tmp340_;
					const gchar* _tmp341_;
					PamacPackage* _tmp342_;
					const gchar* _tmp343_;
					const gchar* _tmp344_;
					PamacPackage* _tmp345_;
					const gchar* _tmp346_;
					const gchar* _tmp347_;
					gchar* _tmp348_;
					gchar* _tmp349_;
					const gchar* _tmp350_;
					const gchar* _tmp351_;
					_tmp324_ = pkg;
					_tmp325_ = pamac_package_get_download_size (_tmp324_);
					_tmp326_ = _tmp325_;
					if (_tmp326_ == ((guint64) 0)) {
						gchar* _tmp327_;
						_tmp327_ = g_strdup ("");
						_g_free0 (_tmp323_);
						_tmp323_ = _tmp327_;
					} else {
						PamacPackage* _tmp328_;
						guint64 _tmp329_;
						guint64 _tmp330_;
						gchar* _tmp331_;
						_tmp328_ = pkg;
						_tmp329_ = pamac_package_get_download_size (_tmp328_);
						_tmp330_ = _tmp329_;
						_tmp331_ = g_format_size_full (_tmp330_, G_FORMAT_SIZE_DEFAULT);
						_g_free0 (_tmp323_);
						_tmp323_ = _tmp331_;
					}
					_tmp332_ = g_strdup (_tmp323_);
					size = _tmp332_;
					_tmp334_ = pkg;
					_tmp335_ = pamac_package_get_repo (_tmp334_);
					_tmp336_ = _tmp335_;
					_tmp333_ = _tmp336_;
					if (_tmp333_ == NULL) {
						_tmp333_ = "";
					}
					_tmp337_ = g_strdup (_tmp333_);
					repo = _tmp337_;
					_tmp338_ = stdout;
					_tmp339_ = pkg;
					_tmp340_ = pamac_package_get_name (_tmp339_);
					_tmp341_ = _tmp340_;
					_tmp342_ = pkg;
					_tmp343_ = pamac_package_get_version (_tmp342_);
					_tmp344_ = _tmp343_;
					_tmp345_ = pkg;
					_tmp346_ = pamac_package_get_installed_version (_tmp345_);
					_tmp347_ = _tmp346_;
					_tmp348_ = g_strdup_printf ("(%s)", _tmp347_);
					_tmp349_ = _tmp348_;
					_tmp350_ = repo;
					_tmp351_ = size;
					fprintf (_tmp338_, "  %-*s  %-*s  %-*s  %-*s  %s\n", name_length, _tmp341_, version_length, _tmp344_, installed_version_length, _tmp349_, repo_length, _tmp350_, _tmp351_);
					_g_free0 (_tmp349_);
					_g_free0 (repo);
					_g_free0 (size);
					_g_free0 (_tmp323_);
				}
			}
		}
	}
	_tmp352_ = pamac_transaction_summary_get_to_reinstall (summary);
	_tmp353_ = _tmp352_;
	_tmp354_ = vala_g_ptr_array_get_length (_tmp353_);
	_tmp355_ = _tmp354_;
	if (_tmp355_ != 0) {
		FILE* _tmp356_;
		GPtrArray* _tmp357_;
		GPtrArray* _tmp358_;
		gint _tmp359_;
		gint _tmp360_;
		gchar* _tmp361_;
		gchar* _tmp362_;
		gchar* _tmp363_;
		gchar* _tmp364_;
		GPtrArray* _tmp365_;
		GPtrArray* _tmp366_;
		_tmp356_ = stdout;
		_tmp357_ = pamac_transaction_summary_get_to_reinstall (summary);
		_tmp358_ = _tmp357_;
		_tmp359_ = vala_g_ptr_array_get_length (_tmp358_);
		_tmp360_ = _tmp359_;
		_tmp361_ = g_strdup_printf (" (%u):\n", (guint) _tmp360_);
		_tmp362_ = _tmp361_;
		_tmp363_ = g_strconcat (g_dgettext (NULL, "To reinstall"), _tmp362_, NULL);
		_tmp364_ = _tmp363_;
		fprintf (_tmp356_, "%s", _tmp364_);
		_g_free0 (_tmp364_);
		_g_free0 (_tmp362_);
		_tmp365_ = pamac_transaction_summary_get_to_reinstall (summary);
		_tmp366_ = _tmp365_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp366_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gchar* _tmp367_ = NULL;
					PamacPackage* _tmp368_;
					guint64 _tmp369_;
					guint64 _tmp370_;
					gchar* size = NULL;
					gchar* _tmp376_;
					const gchar* _tmp377_ = NULL;
					PamacPackage* _tmp378_;
					const gchar* _tmp379_;
					const gchar* _tmp380_;
					gchar* repo = NULL;
					gchar* _tmp381_;
					FILE* _tmp382_;
					PamacPackage* _tmp383_;
					const gchar* _tmp384_;
					const gchar* _tmp385_;
					PamacPackage* _tmp386_;
					const gchar* _tmp387_;
					const gchar* _tmp388_;
					const gchar* _tmp389_;
					const gchar* _tmp390_;
					_tmp368_ = pkg;
					_tmp369_ = pamac_package_get_download_size (_tmp368_);
					_tmp370_ = _tmp369_;
					if (_tmp370_ == ((guint64) 0)) {
						gchar* _tmp371_;
						_tmp371_ = g_strdup ("");
						_g_free0 (_tmp367_);
						_tmp367_ = _tmp371_;
					} else {
						PamacPackage* _tmp372_;
						guint64 _tmp373_;
						guint64 _tmp374_;
						gchar* _tmp375_;
						_tmp372_ = pkg;
						_tmp373_ = pamac_package_get_download_size (_tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = g_format_size_full (_tmp374_, G_FORMAT_SIZE_DEFAULT);
						_g_free0 (_tmp367_);
						_tmp367_ = _tmp375_;
					}
					_tmp376_ = g_strdup (_tmp367_);
					size = _tmp376_;
					_tmp378_ = pkg;
					_tmp379_ = pamac_package_get_repo (_tmp378_);
					_tmp380_ = _tmp379_;
					_tmp377_ = _tmp380_;
					if (_tmp377_ == NULL) {
						_tmp377_ = "";
					}
					_tmp381_ = g_strdup (_tmp377_);
					repo = _tmp381_;
					_tmp382_ = stdout;
					_tmp383_ = pkg;
					_tmp384_ = pamac_package_get_name (_tmp383_);
					_tmp385_ = _tmp384_;
					_tmp386_ = pkg;
					_tmp387_ = pamac_package_get_version (_tmp386_);
					_tmp388_ = _tmp387_;
					_tmp389_ = repo;
					_tmp390_ = size;
					fprintf (_tmp382_, "  %-*s  %-*s  %-*s  %-*s  %s\n", name_length, _tmp385_, version_length, _tmp388_, installed_version_length, "", repo_length, _tmp389_, _tmp390_);
					_g_free0 (repo);
					_g_free0 (size);
					_g_free0 (_tmp367_);
				}
			}
		}
	}
	_tmp391_ = pamac_transaction_summary_get_to_install (summary);
	_tmp392_ = _tmp391_;
	_tmp393_ = vala_g_ptr_array_get_length (_tmp392_);
	_tmp394_ = _tmp393_;
	if (_tmp394_ != 0) {
		FILE* _tmp395_;
		GPtrArray* _tmp396_;
		GPtrArray* _tmp397_;
		gint _tmp398_;
		gint _tmp399_;
		gchar* _tmp400_;
		gchar* _tmp401_;
		gchar* _tmp402_;
		gchar* _tmp403_;
		GPtrArray* _tmp404_;
		GPtrArray* _tmp405_;
		_tmp395_ = stdout;
		_tmp396_ = pamac_transaction_summary_get_to_install (summary);
		_tmp397_ = _tmp396_;
		_tmp398_ = vala_g_ptr_array_get_length (_tmp397_);
		_tmp399_ = _tmp398_;
		_tmp400_ = g_strdup_printf (" (%u):\n", (guint) _tmp399_);
		_tmp401_ = _tmp400_;
		_tmp402_ = g_strconcat (g_dgettext (NULL, "To install"), _tmp401_, NULL);
		_tmp403_ = _tmp402_;
		fprintf (_tmp395_, "%s", _tmp403_);
		_g_free0 (_tmp403_);
		_g_free0 (_tmp401_);
		_tmp404_ = pamac_transaction_summary_get_to_install (summary);
		_tmp405_ = _tmp404_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp405_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gchar* _tmp406_ = NULL;
					PamacPackage* _tmp407_;
					guint64 _tmp408_;
					guint64 _tmp409_;
					gchar* size = NULL;
					gchar* _tmp415_;
					const gchar* _tmp416_ = NULL;
					PamacPackage* _tmp417_;
					const gchar* _tmp418_;
					const gchar* _tmp419_;
					gchar* repo = NULL;
					gchar* _tmp420_;
					gchar* requiredby = NULL;
					gchar* _tmp421_;
					PamacAlpmPackage* alpm_pkg = NULL;
					PamacPackage* _tmp422_;
					PamacAlpmPackage* _tmp423_;
					PamacAlpmPackage* _tmp424_;
					GString* str_builder = NULL;
					PamacPackage* _tmp443_;
					const gchar* _tmp444_;
					const gchar* _tmp445_;
					PamacPackage* _tmp446_;
					const gchar* _tmp447_;
					const gchar* _tmp448_;
					gchar* _tmp449_;
					gchar* _tmp450_;
					GString* _tmp451_;
					GString* _tmp452_;
					GString* _tmp453_;
					GString* _tmp454_;
					const gchar* _tmp455_;
					gint space_count = 0;
					const gchar* _tmp456_;
					GString* _tmp459_;
					const gchar* _tmp460_;
					const gchar* _tmp461_;
					gchar* _tmp462_;
					gchar* _tmp463_;
					FILE* _tmp464_;
					GString* _tmp465_;
					const gchar* _tmp466_;
					_tmp407_ = pkg;
					_tmp408_ = pamac_package_get_download_size (_tmp407_);
					_tmp409_ = _tmp408_;
					if (_tmp409_ == ((guint64) 0)) {
						gchar* _tmp410_;
						_tmp410_ = g_strdup ("");
						_g_free0 (_tmp406_);
						_tmp406_ = _tmp410_;
					} else {
						PamacPackage* _tmp411_;
						guint64 _tmp412_;
						guint64 _tmp413_;
						gchar* _tmp414_;
						_tmp411_ = pkg;
						_tmp412_ = pamac_package_get_download_size (_tmp411_);
						_tmp413_ = _tmp412_;
						_tmp414_ = g_format_size_full (_tmp413_, G_FORMAT_SIZE_DEFAULT);
						_g_free0 (_tmp406_);
						_tmp406_ = _tmp414_;
					}
					_tmp415_ = g_strdup (_tmp406_);
					size = _tmp415_;
					_tmp417_ = pkg;
					_tmp418_ = pamac_package_get_repo (_tmp417_);
					_tmp419_ = _tmp418_;
					_tmp416_ = _tmp419_;
					if (_tmp416_ == NULL) {
						_tmp416_ = "";
					}
					_tmp420_ = g_strdup (_tmp416_);
					repo = _tmp420_;
					_tmp421_ = g_strdup ("");
					requiredby = _tmp421_;
					_tmp422_ = pkg;
					_tmp423_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp422_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp422_) : NULL);
					alpm_pkg = _tmp423_;
					_tmp424_ = alpm_pkg;
					if (_tmp424_ != NULL) {
						gboolean requiredby_found = FALSE;
						GPtrArray* dep_list = NULL;
						PamacAlpmPackage* _tmp425_;
						GPtrArray* _tmp426_;
						GPtrArray* _tmp427_;
						GPtrArray* _tmp428_;
						gint _tmp429_;
						gint _tmp430_;
						requiredby_found = FALSE;
						_tmp425_ = alpm_pkg;
						_tmp426_ = pamac_alpm_package_get_requiredby (_tmp425_);
						_tmp427_ = _tmp426_;
						dep_list = _tmp427_;
						_tmp428_ = dep_list;
						_tmp429_ = vala_g_ptr_array_get_length (_tmp428_);
						_tmp430_ = _tmp429_;
						if (_tmp430_ != 0) {
							GPtrArray* _tmp431_;
							gconstpointer _tmp432_;
							gchar* _tmp433_;
							requiredby_found = TRUE;
							_tmp431_ = dep_list;
							_tmp432_ = g_ptr_array_index (_tmp431_, (guint) 0);
							_tmp433_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Required By"), (const gchar*) _tmp432_);
							_g_free0 (requiredby);
							requiredby = _tmp433_;
						}
						if (!requiredby_found) {
							PamacAlpmPackage* _tmp434_;
							GPtrArray* _tmp435_;
							GPtrArray* _tmp436_;
							GPtrArray* _tmp437_;
							gint _tmp438_;
							gint _tmp439_;
							_tmp434_ = alpm_pkg;
							_tmp435_ = pamac_alpm_package_get_replaces (_tmp434_);
							_tmp436_ = _tmp435_;
							dep_list = _tmp436_;
							_tmp437_ = dep_list;
							_tmp438_ = vala_g_ptr_array_get_length (_tmp437_);
							_tmp439_ = _tmp438_;
							if (_tmp439_ != 0) {
								GPtrArray* _tmp440_;
								gconstpointer _tmp441_;
								gchar* _tmp442_;
								_tmp440_ = dep_list;
								_tmp441_ = g_ptr_array_index (_tmp440_, (guint) 0);
								_tmp442_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Replaces"), (const gchar*) _tmp441_);
								_g_free0 (requiredby);
								requiredby = _tmp442_;
							}
						}
					}
					_tmp443_ = pkg;
					_tmp444_ = pamac_package_get_name (_tmp443_);
					_tmp445_ = _tmp444_;
					_tmp446_ = pkg;
					_tmp447_ = pamac_package_get_version (_tmp446_);
					_tmp448_ = _tmp447_;
					_tmp449_ = g_strdup_printf ("  %-*s  %-*s", name_length, _tmp445_, version_length, _tmp448_);
					_tmp450_ = _tmp449_;
					_tmp451_ = g_string_new (_tmp450_);
					_tmp452_ = _tmp451_;
					_g_free0 (_tmp450_);
					str_builder = _tmp452_;
					_tmp453_ = str_builder;
					g_string_append (_tmp453_, "  ");
					_tmp454_ = str_builder;
					_tmp455_ = requiredby;
					g_string_append (_tmp454_, _tmp455_);
					_tmp456_ = requiredby;
					space_count = g_utf8_strlen (_tmp456_, (gssize) -1);
					while (TRUE) {
						GString* _tmp457_;
						gint _tmp458_;
						if (!(space_count < installed_version_length)) {
							break;
						}
						_tmp457_ = str_builder;
						g_string_append (_tmp457_, " ");
						_tmp458_ = space_count;
						space_count = _tmp458_ + 1;
					}
					_tmp459_ = str_builder;
					_tmp460_ = repo;
					_tmp461_ = size;
					_tmp462_ = g_strdup_printf ("  %-*s  %s\n", repo_length, _tmp460_, _tmp461_);
					_tmp463_ = _tmp462_;
					g_string_append (_tmp459_, _tmp463_);
					_g_free0 (_tmp463_);
					_tmp464_ = stdout;
					_tmp465_ = str_builder;
					_tmp466_ = _tmp465_->str;
					fprintf (_tmp464_, "%s", _tmp466_);
					_g_string_free0 (str_builder);
					_g_object_unref0 (alpm_pkg);
					_g_free0 (requiredby);
					_g_free0 (repo);
					_g_free0 (size);
					_g_free0 (_tmp406_);
				}
			}
		}
	}
	_tmp467_ = pamac_transaction_summary_get_to_build (summary);
	_tmp468_ = _tmp467_;
	_tmp469_ = vala_g_ptr_array_get_length (_tmp468_);
	_tmp470_ = _tmp469_;
	if (_tmp470_ != 0) {
		FILE* _tmp471_;
		GPtrArray* _tmp472_;
		GPtrArray* _tmp473_;
		gint _tmp474_;
		gint _tmp475_;
		gchar* _tmp476_;
		gchar* _tmp477_;
		gchar* _tmp478_;
		gchar* _tmp479_;
		GPtrArray* _tmp480_;
		GPtrArray* _tmp481_;
		_tmp471_ = stdout;
		_tmp472_ = pamac_transaction_summary_get_to_build (summary);
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_g_ptr_array_get_length (_tmp473_);
		_tmp475_ = _tmp474_;
		_tmp476_ = g_strdup_printf (" (%u):\n", (guint) _tmp475_);
		_tmp477_ = _tmp476_;
		_tmp478_ = g_strconcat (g_dgettext (NULL, "To build"), _tmp477_, NULL);
		_tmp479_ = _tmp478_;
		fprintf (_tmp471_, "%s", _tmp479_);
		_g_free0 (_tmp479_);
		_g_free0 (_tmp477_);
		_tmp480_ = pamac_transaction_summary_get_to_build (summary);
		_tmp481_ = _tmp480_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp481_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					const gchar* _tmp482_ = NULL;
					PamacPackage* _tmp483_;
					const gchar* _tmp484_;
					const gchar* _tmp485_;
					gchar* repo = NULL;
					gchar* _tmp486_;
					gchar* installed_version = NULL;
					gchar* _tmp487_;
					gboolean _tmp488_ = FALSE;
					PamacPackage* _tmp489_;
					const gchar* _tmp490_;
					const gchar* _tmp491_;
					const gchar* _tmp502_;
					GString* str_builder = NULL;
					PamacPackage* _tmp515_;
					const gchar* _tmp516_;
					const gchar* _tmp517_;
					PamacPackage* _tmp518_;
					const gchar* _tmp519_;
					const gchar* _tmp520_;
					gchar* _tmp521_;
					gchar* _tmp522_;
					GString* _tmp523_;
					GString* _tmp524_;
					GString* _tmp525_;
					GString* _tmp526_;
					const gchar* _tmp527_;
					gint space_count = 0;
					const gchar* _tmp528_;
					GString* _tmp531_;
					const gchar* _tmp532_;
					gchar* _tmp533_;
					gchar* _tmp534_;
					FILE* _tmp535_;
					GString* _tmp536_;
					const gchar* _tmp537_;
					_tmp483_ = pkg;
					_tmp484_ = pamac_package_get_repo (_tmp483_);
					_tmp485_ = _tmp484_;
					_tmp482_ = _tmp485_;
					if (_tmp482_ == NULL) {
						_tmp482_ = "";
					}
					_tmp486_ = g_strdup (_tmp482_);
					repo = _tmp486_;
					_tmp487_ = g_strdup ("");
					installed_version = _tmp487_;
					_tmp489_ = pkg;
					_tmp490_ = pamac_package_get_installed_version (_tmp489_);
					_tmp491_ = _tmp490_;
					if (_tmp491_ != NULL) {
						PamacPackage* _tmp492_;
						const gchar* _tmp493_;
						const gchar* _tmp494_;
						PamacPackage* _tmp495_;
						const gchar* _tmp496_;
						const gchar* _tmp497_;
						_tmp492_ = pkg;
						_tmp493_ = pamac_package_get_installed_version (_tmp492_);
						_tmp494_ = _tmp493_;
						_tmp495_ = pkg;
						_tmp496_ = pamac_package_get_version (_tmp495_);
						_tmp497_ = _tmp496_;
						_tmp488_ = g_strcmp0 (_tmp494_, _tmp497_) != 0;
					} else {
						_tmp488_ = FALSE;
					}
					if (_tmp488_) {
						PamacPackage* _tmp498_;
						const gchar* _tmp499_;
						const gchar* _tmp500_;
						gchar* _tmp501_;
						_tmp498_ = pkg;
						_tmp499_ = pamac_package_get_installed_version (_tmp498_);
						_tmp500_ = _tmp499_;
						_tmp501_ = g_strdup_printf ("(%s)", _tmp500_);
						_g_free0 (installed_version);
						installed_version = _tmp501_;
					}
					_tmp502_ = installed_version;
					if (_tmp502_ == NULL) {
						PamacAlpmPackage* alpm_pkg = NULL;
						PamacPackage* _tmp503_;
						PamacAlpmPackage* _tmp504_;
						PamacAlpmPackage* _tmp505_;
						_tmp503_ = pkg;
						_tmp504_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp503_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp503_) : NULL);
						alpm_pkg = _tmp504_;
						_tmp505_ = alpm_pkg;
						if (_tmp505_ != NULL) {
							GPtrArray* dep_list = NULL;
							PamacAlpmPackage* _tmp506_;
							GPtrArray* _tmp507_;
							GPtrArray* _tmp508_;
							GPtrArray* _tmp509_;
							gint _tmp510_;
							gint _tmp511_;
							_tmp506_ = alpm_pkg;
							_tmp507_ = pamac_alpm_package_get_requiredby (_tmp506_);
							_tmp508_ = _tmp507_;
							dep_list = _tmp508_;
							_tmp509_ = dep_list;
							_tmp510_ = vala_g_ptr_array_get_length (_tmp509_);
							_tmp511_ = _tmp510_;
							if (_tmp511_ != 0) {
								GPtrArray* _tmp512_;
								gconstpointer _tmp513_;
								gchar* _tmp514_;
								_tmp512_ = dep_list;
								_tmp513_ = g_ptr_array_index (_tmp512_, (guint) 0);
								_tmp514_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Required By"), (const gchar*) _tmp513_);
								_g_free0 (installed_version);
								installed_version = _tmp514_;
							}
						}
						_g_object_unref0 (alpm_pkg);
					}
					_tmp515_ = pkg;
					_tmp516_ = pamac_package_get_name (_tmp515_);
					_tmp517_ = _tmp516_;
					_tmp518_ = pkg;
					_tmp519_ = pamac_package_get_version (_tmp518_);
					_tmp520_ = _tmp519_;
					_tmp521_ = g_strdup_printf ("  %-*s  %-*s", name_length, _tmp517_, version_length, _tmp520_);
					_tmp522_ = _tmp521_;
					_tmp523_ = g_string_new (_tmp522_);
					_tmp524_ = _tmp523_;
					_g_free0 (_tmp522_);
					str_builder = _tmp524_;
					_tmp525_ = str_builder;
					g_string_append (_tmp525_, "  ");
					_tmp526_ = str_builder;
					_tmp527_ = installed_version;
					g_string_append (_tmp526_, _tmp527_);
					_tmp528_ = installed_version;
					space_count = g_utf8_strlen (_tmp528_, (gssize) -1);
					while (TRUE) {
						GString* _tmp529_;
						gint _tmp530_;
						if (!(space_count < installed_version_length)) {
							break;
						}
						_tmp529_ = str_builder;
						g_string_append (_tmp529_, " ");
						_tmp530_ = space_count;
						space_count = _tmp530_ + 1;
					}
					_tmp531_ = str_builder;
					_tmp532_ = repo;
					_tmp533_ = g_strdup_printf ("  %s\n", _tmp532_);
					_tmp534_ = _tmp533_;
					g_string_append (_tmp531_, _tmp534_);
					_g_free0 (_tmp534_);
					_tmp535_ = stdout;
					_tmp536_ = str_builder;
					_tmp537_ = _tmp536_->str;
					fprintf (_tmp535_, "%s", _tmp537_);
					_g_string_free0 (str_builder);
					_g_free0 (installed_version);
					_g_free0 (repo);
				}
			}
		}
	}
	_tmp538_ = pamac_transaction_summary_get_to_downgrade (summary);
	_tmp539_ = _tmp538_;
	_tmp540_ = vala_g_ptr_array_get_length (_tmp539_);
	_tmp541_ = _tmp540_;
	if (_tmp541_ != 0) {
		FILE* _tmp542_;
		GPtrArray* _tmp543_;
		GPtrArray* _tmp544_;
		gint _tmp545_;
		gint _tmp546_;
		gchar* _tmp547_;
		gchar* _tmp548_;
		gchar* _tmp549_;
		gchar* _tmp550_;
		GPtrArray* _tmp551_;
		GPtrArray* _tmp552_;
		_tmp542_ = stdout;
		_tmp543_ = pamac_transaction_summary_get_to_downgrade (summary);
		_tmp544_ = _tmp543_;
		_tmp545_ = vala_g_ptr_array_get_length (_tmp544_);
		_tmp546_ = _tmp545_;
		_tmp547_ = g_strdup_printf (" (%u):\n", (guint) _tmp546_);
		_tmp548_ = _tmp547_;
		_tmp549_ = g_strconcat (g_dgettext (NULL, "To downgrade"), _tmp548_, NULL);
		_tmp550_ = _tmp549_;
		fprintf (_tmp542_, "%s", _tmp550_);
		_g_free0 (_tmp550_);
		_g_free0 (_tmp548_);
		_tmp551_ = pamac_transaction_summary_get_to_downgrade (summary);
		_tmp552_ = _tmp551_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp552_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gchar* _tmp553_ = NULL;
					PamacPackage* _tmp554_;
					guint64 _tmp555_;
					guint64 _tmp556_;
					gchar* size = NULL;
					gchar* _tmp562_;
					const gchar* _tmp563_ = NULL;
					PamacPackage* _tmp564_;
					const gchar* _tmp565_;
					const gchar* _tmp566_;
					gchar* repo = NULL;
					gchar* _tmp567_;
					FILE* _tmp568_;
					PamacPackage* _tmp569_;
					const gchar* _tmp570_;
					const gchar* _tmp571_;
					PamacPackage* _tmp572_;
					const gchar* _tmp573_;
					const gchar* _tmp574_;
					PamacPackage* _tmp575_;
					const gchar* _tmp576_;
					const gchar* _tmp577_;
					gchar* _tmp578_;
					gchar* _tmp579_;
					const gchar* _tmp580_;
					const gchar* _tmp581_;
					_tmp554_ = pkg;
					_tmp555_ = pamac_package_get_download_size (_tmp554_);
					_tmp556_ = _tmp555_;
					if (_tmp556_ == ((guint64) 0)) {
						gchar* _tmp557_;
						_tmp557_ = g_strdup ("");
						_g_free0 (_tmp553_);
						_tmp553_ = _tmp557_;
					} else {
						PamacPackage* _tmp558_;
						guint64 _tmp559_;
						guint64 _tmp560_;
						gchar* _tmp561_;
						_tmp558_ = pkg;
						_tmp559_ = pamac_package_get_download_size (_tmp558_);
						_tmp560_ = _tmp559_;
						_tmp561_ = g_format_size_full (_tmp560_, G_FORMAT_SIZE_DEFAULT);
						_g_free0 (_tmp553_);
						_tmp553_ = _tmp561_;
					}
					_tmp562_ = g_strdup (_tmp553_);
					size = _tmp562_;
					_tmp564_ = pkg;
					_tmp565_ = pamac_package_get_repo (_tmp564_);
					_tmp566_ = _tmp565_;
					_tmp563_ = _tmp566_;
					if (_tmp563_ == NULL) {
						_tmp563_ = "";
					}
					_tmp567_ = g_strdup (_tmp563_);
					repo = _tmp567_;
					_tmp568_ = stdout;
					_tmp569_ = pkg;
					_tmp570_ = pamac_package_get_name (_tmp569_);
					_tmp571_ = _tmp570_;
					_tmp572_ = pkg;
					_tmp573_ = pamac_package_get_version (_tmp572_);
					_tmp574_ = _tmp573_;
					_tmp575_ = pkg;
					_tmp576_ = pamac_package_get_installed_version (_tmp575_);
					_tmp577_ = _tmp576_;
					_tmp578_ = g_strdup_printf ("(%s)", _tmp577_);
					_tmp579_ = _tmp578_;
					_tmp580_ = repo;
					_tmp581_ = size;
					fprintf (_tmp568_, "  %-*s  %-*s  %-*s  %-*s  %s\n", name_length, _tmp571_, version_length, _tmp574_, installed_version_length, _tmp579_, repo_length, _tmp580_, _tmp581_);
					_g_free0 (_tmp579_);
					_g_free0 (repo);
					_g_free0 (size);
					_g_free0 (_tmp553_);
				}
			}
		}
	}
	_tmp583_ = pamac_transaction_summary_get_to_remove (summary);
	_tmp584_ = _tmp583_;
	_tmp585_ = vala_g_ptr_array_get_length (_tmp584_);
	_tmp586_ = _tmp585_;
	if (_tmp586_ != 0) {
		_tmp582_ = TRUE;
	} else {
		GPtrArray* _tmp587_;
		GPtrArray* _tmp588_;
		gint _tmp589_;
		gint _tmp590_;
		_tmp587_ = pamac_transaction_summary_get_conflicts_to_remove (summary);
		_tmp588_ = _tmp587_;
		_tmp589_ = vala_g_ptr_array_get_length (_tmp588_);
		_tmp590_ = _tmp589_;
		_tmp582_ = _tmp590_ != 0;
	}
	if (_tmp582_) {
		FILE* _tmp591_;
		GPtrArray* _tmp592_;
		GPtrArray* _tmp593_;
		gint _tmp594_;
		gint _tmp595_;
		GPtrArray* _tmp596_;
		GPtrArray* _tmp597_;
		gint _tmp598_;
		gint _tmp599_;
		gchar* _tmp600_;
		gchar* _tmp601_;
		gchar* _tmp602_;
		gchar* _tmp603_;
		GPtrArray* _tmp604_;
		GPtrArray* _tmp605_;
		GPtrArray* _tmp656_;
		GPtrArray* _tmp657_;
		_tmp591_ = stdout;
		_tmp592_ = pamac_transaction_summary_get_to_remove (summary);
		_tmp593_ = _tmp592_;
		_tmp594_ = vala_g_ptr_array_get_length (_tmp593_);
		_tmp595_ = _tmp594_;
		_tmp596_ = pamac_transaction_summary_get_conflicts_to_remove (summary);
		_tmp597_ = _tmp596_;
		_tmp598_ = vala_g_ptr_array_get_length (_tmp597_);
		_tmp599_ = _tmp598_;
		_tmp600_ = g_strdup_printf (" (%u):\n", (guint) (_tmp595_ + _tmp599_));
		_tmp601_ = _tmp600_;
		_tmp602_ = g_strconcat (g_dgettext (NULL, "To remove"), _tmp601_, NULL);
		_tmp603_ = _tmp602_;
		fprintf (_tmp591_, "%s", _tmp603_);
		_g_free0 (_tmp603_);
		_g_free0 (_tmp601_);
		_tmp604_ = pamac_transaction_summary_get_to_remove (summary);
		_tmp605_ = _tmp604_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp605_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					const gchar* _tmp606_ = NULL;
					PamacPackage* _tmp607_;
					const gchar* _tmp608_;
					const gchar* _tmp609_;
					gchar* repo = NULL;
					gchar* _tmp610_;
					gchar* dep = NULL;
					gchar* _tmp611_;
					PamacAlpmPackage* alpm_pkg = NULL;
					PamacPackage* _tmp612_;
					PamacAlpmPackage* _tmp613_;
					PamacAlpmPackage* _tmp614_;
					GString* str_builder = NULL;
					PamacPackage* _tmp633_;
					const gchar* _tmp634_;
					const gchar* _tmp635_;
					PamacPackage* _tmp636_;
					const gchar* _tmp637_;
					const gchar* _tmp638_;
					gchar* _tmp639_;
					gchar* _tmp640_;
					GString* _tmp641_;
					GString* _tmp642_;
					GString* _tmp643_;
					GString* _tmp644_;
					const gchar* _tmp645_;
					gint space_count = 0;
					const gchar* _tmp646_;
					GString* _tmp649_;
					const gchar* _tmp650_;
					gchar* _tmp651_;
					gchar* _tmp652_;
					FILE* _tmp653_;
					GString* _tmp654_;
					const gchar* _tmp655_;
					_tmp607_ = pkg;
					_tmp608_ = pamac_package_get_repo (_tmp607_);
					_tmp609_ = _tmp608_;
					_tmp606_ = _tmp609_;
					if (_tmp606_ == NULL) {
						_tmp606_ = "";
					}
					_tmp610_ = g_strdup (_tmp606_);
					repo = _tmp610_;
					_tmp611_ = g_strdup ("");
					dep = _tmp611_;
					_tmp612_ = pkg;
					_tmp613_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp612_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp612_) : NULL);
					alpm_pkg = _tmp613_;
					_tmp614_ = alpm_pkg;
					if (_tmp614_ != NULL) {
						GPtrArray* dep_list = NULL;
						PamacAlpmPackage* _tmp615_;
						GPtrArray* _tmp616_;
						GPtrArray* _tmp617_;
						GPtrArray* _tmp618_;
						gint _tmp619_;
						gint _tmp620_;
						_tmp615_ = alpm_pkg;
						_tmp616_ = pamac_alpm_package_get_depends (_tmp615_);
						_tmp617_ = _tmp616_;
						dep_list = _tmp617_;
						_tmp618_ = dep_list;
						_tmp619_ = vala_g_ptr_array_get_length (_tmp618_);
						_tmp620_ = _tmp619_;
						if (_tmp620_ != 0) {
							GPtrArray* _tmp621_;
							gconstpointer _tmp622_;
							gchar* _tmp623_;
							_tmp621_ = dep_list;
							_tmp622_ = g_ptr_array_index (_tmp621_, (guint) 0);
							_tmp623_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Depends On"), (const gchar*) _tmp622_);
							_g_free0 (dep);
							dep = _tmp623_;
						} else {
							GPtrArray* requiredby_list = NULL;
							PamacAlpmPackage* _tmp624_;
							GPtrArray* _tmp625_;
							GPtrArray* _tmp626_;
							GPtrArray* _tmp627_;
							gint _tmp628_;
							gint _tmp629_;
							_tmp624_ = alpm_pkg;
							_tmp625_ = pamac_alpm_package_get_requiredby (_tmp624_);
							_tmp626_ = _tmp625_;
							requiredby_list = _tmp626_;
							_tmp627_ = requiredby_list;
							_tmp628_ = vala_g_ptr_array_get_length (_tmp627_);
							_tmp629_ = _tmp628_;
							if (_tmp629_ != 0) {
								GPtrArray* _tmp630_;
								gconstpointer _tmp631_;
								gchar* _tmp632_;
								_tmp630_ = requiredby_list;
								_tmp631_ = g_ptr_array_index (_tmp630_, (guint) 0);
								_tmp632_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Orphan Of"), (const gchar*) _tmp631_);
								_g_free0 (dep);
								dep = _tmp632_;
							}
						}
					}
					_tmp633_ = pkg;
					_tmp634_ = pamac_package_get_name (_tmp633_);
					_tmp635_ = _tmp634_;
					_tmp636_ = pkg;
					_tmp637_ = pamac_package_get_version (_tmp636_);
					_tmp638_ = _tmp637_;
					_tmp639_ = g_strdup_printf ("  %-*s  %-*s", name_length, _tmp635_, version_length, _tmp638_);
					_tmp640_ = _tmp639_;
					_tmp641_ = g_string_new (_tmp640_);
					_tmp642_ = _tmp641_;
					_g_free0 (_tmp640_);
					str_builder = _tmp642_;
					_tmp643_ = str_builder;
					g_string_append (_tmp643_, "  ");
					_tmp644_ = str_builder;
					_tmp645_ = dep;
					g_string_append (_tmp644_, _tmp645_);
					_tmp646_ = dep;
					space_count = g_utf8_strlen (_tmp646_, (gssize) -1);
					while (TRUE) {
						GString* _tmp647_;
						gint _tmp648_;
						if (!(space_count < installed_version_length)) {
							break;
						}
						_tmp647_ = str_builder;
						g_string_append (_tmp647_, " ");
						_tmp648_ = space_count;
						space_count = _tmp648_ + 1;
					}
					_tmp649_ = str_builder;
					_tmp650_ = repo;
					_tmp651_ = g_strdup_printf ("  %s\n", _tmp650_);
					_tmp652_ = _tmp651_;
					g_string_append (_tmp649_, _tmp652_);
					_g_free0 (_tmp652_);
					_tmp653_ = stdout;
					_tmp654_ = str_builder;
					_tmp655_ = _tmp654_->str;
					fprintf (_tmp653_, "%s", _tmp655_);
					_g_string_free0 (str_builder);
					_g_object_unref0 (alpm_pkg);
					_g_free0 (dep);
					_g_free0 (repo);
				}
			}
		}
		_tmp656_ = pamac_transaction_summary_get_conflicts_to_remove (summary);
		_tmp657_ = _tmp656_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp657_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacPackage* pkg = NULL;
				pkg = (PamacPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					const gchar* _tmp658_ = NULL;
					PamacPackage* _tmp659_;
					const gchar* _tmp660_;
					const gchar* _tmp661_;
					gchar* repo = NULL;
					gchar* _tmp662_;
					gchar* conflict = NULL;
					gchar* _tmp663_;
					PamacAlpmPackage* alpm_pkg = NULL;
					PamacPackage* _tmp664_;
					PamacAlpmPackage* _tmp665_;
					PamacAlpmPackage* _tmp666_;
					GString* str_builder = NULL;
					PamacPackage* _tmp676_;
					const gchar* _tmp677_;
					const gchar* _tmp678_;
					PamacPackage* _tmp679_;
					const gchar* _tmp680_;
					const gchar* _tmp681_;
					gchar* _tmp682_;
					gchar* _tmp683_;
					GString* _tmp684_;
					GString* _tmp685_;
					GString* _tmp686_;
					GString* _tmp687_;
					const gchar* _tmp688_;
					gint space_count = 0;
					const gchar* _tmp689_;
					GString* _tmp692_;
					const gchar* _tmp693_;
					gchar* _tmp694_;
					gchar* _tmp695_;
					FILE* _tmp696_;
					GString* _tmp697_;
					const gchar* _tmp698_;
					_tmp659_ = pkg;
					_tmp660_ = pamac_package_get_repo (_tmp659_);
					_tmp661_ = _tmp660_;
					_tmp658_ = _tmp661_;
					if (_tmp658_ == NULL) {
						_tmp658_ = "";
					}
					_tmp662_ = g_strdup (_tmp658_);
					repo = _tmp662_;
					_tmp663_ = g_strdup ("");
					conflict = _tmp663_;
					_tmp664_ = pkg;
					_tmp665_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp664_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp664_) : NULL);
					alpm_pkg = _tmp665_;
					_tmp666_ = alpm_pkg;
					if (_tmp666_ != NULL) {
						GPtrArray* dep_list = NULL;
						PamacAlpmPackage* _tmp667_;
						GPtrArray* _tmp668_;
						GPtrArray* _tmp669_;
						GPtrArray* _tmp670_;
						gint _tmp671_;
						gint _tmp672_;
						_tmp667_ = alpm_pkg;
						_tmp668_ = pamac_alpm_package_get_conflicts (_tmp667_);
						_tmp669_ = _tmp668_;
						dep_list = _tmp669_;
						_tmp670_ = dep_list;
						_tmp671_ = vala_g_ptr_array_get_length (_tmp670_);
						_tmp672_ = _tmp671_;
						if (_tmp672_ != 0) {
							GPtrArray* _tmp673_;
							gconstpointer _tmp674_;
							gchar* _tmp675_;
							_tmp673_ = dep_list;
							_tmp674_ = g_ptr_array_index (_tmp673_, (guint) 0);
							_tmp675_ = g_strdup_printf ("(%s: %s)", g_dgettext (NULL, "Conflicts With"), (const gchar*) _tmp674_);
							_g_free0 (conflict);
							conflict = _tmp675_;
						}
					}
					_tmp676_ = pkg;
					_tmp677_ = pamac_package_get_name (_tmp676_);
					_tmp678_ = _tmp677_;
					_tmp679_ = pkg;
					_tmp680_ = pamac_package_get_version (_tmp679_);
					_tmp681_ = _tmp680_;
					_tmp682_ = g_strdup_printf ("  %-*s  %-*s", name_length, _tmp678_, version_length, _tmp681_);
					_tmp683_ = _tmp682_;
					_tmp684_ = g_string_new (_tmp683_);
					_tmp685_ = _tmp684_;
					_g_free0 (_tmp683_);
					str_builder = _tmp685_;
					_tmp686_ = str_builder;
					g_string_append (_tmp686_, "  ");
					_tmp687_ = str_builder;
					_tmp688_ = conflict;
					g_string_append (_tmp687_, _tmp688_);
					_tmp689_ = conflict;
					space_count = g_utf8_strlen (_tmp689_, (gssize) -1);
					while (TRUE) {
						GString* _tmp690_;
						gint _tmp691_;
						if (!(space_count < installed_version_length)) {
							break;
						}
						_tmp690_ = str_builder;
						g_string_append (_tmp690_, " ");
						_tmp691_ = space_count;
						space_count = _tmp691_ + 1;
					}
					_tmp692_ = str_builder;
					_tmp693_ = repo;
					_tmp694_ = g_strdup_printf ("  %s\n", _tmp693_);
					_tmp695_ = _tmp694_;
					g_string_append (_tmp692_, _tmp695_);
					_g_free0 (_tmp695_);
					_tmp696_ = stdout;
					_tmp697_ = str_builder;
					_tmp698_ = _tmp697_->str;
					fprintf (_tmp696_, "%s", _tmp698_);
					_g_string_free0 (str_builder);
					_g_object_unref0 (alpm_pkg);
					_g_free0 (conflict);
					_g_free0 (repo);
				}
			}
		}
	}
	_tmp699_ = stdout;
	fprintf (_tmp699_, "\n");
	if (dsize > ((guint64) 0)) {
		FILE* _tmp700_;
		gchar* _tmp701_;
		gchar* _tmp702_;
		_tmp700_ = stdout;
		_tmp701_ = g_format_size_full (dsize, G_FORMAT_SIZE_DEFAULT);
		_tmp702_ = _tmp701_;
		fprintf (_tmp700_, "%s: %s\n", g_dgettext (NULL, "Total download size"), _tmp702_);
		_g_free0 (_tmp702_);
	}
	if (isize > ((gint64) 0)) {
		FILE* _tmp703_;
		gchar* _tmp704_;
		gchar* _tmp705_;
		_tmp703_ = stdout;
		_tmp704_ = g_format_size_full ((guint64) isize, G_FORMAT_SIZE_DEFAULT);
		_tmp705_ = _tmp704_;
		fprintf (_tmp703_, "%s: %s\n", g_dgettext (NULL, "Total installed size"), _tmp705_);
		_g_free0 (_tmp705_);
	} else {
		if (isize < ((gint64) 0)) {
			FILE* _tmp706_;
			gchar* _tmp707_;
			gchar* _tmp708_;
			_tmp706_ = stdout;
			_tmp707_ = g_format_size_full ((guint64) llabs (isize), G_FORMAT_SIZE_DEFAULT);
			_tmp708_ = _tmp707_;
			fprintf (_tmp706_, "%s: -%s\n", g_dgettext (NULL, "Total installed size"), _tmp708_);
			_g_free0 (_tmp708_);
		}
	}
	if (rsize > ((guint64) 0)) {
		FILE* _tmp709_;
		gchar* _tmp710_;
		gchar* _tmp711_;
		_tmp709_ = stdout;
		_tmp710_ = g_format_size_full (rsize, G_FORMAT_SIZE_DEFAULT);
		_tmp711_ = _tmp710_;
		fprintf (_tmp709_, "%s: %s\n", g_dgettext (NULL, "Total removed size"), _tmp711_);
		_g_free0 (_tmp711_);
	}
	_tmp712_ = stdout;
	fprintf (_tmp712_, "\n");
}

static void
pamac_transaction_cli_real_ask_commit_data_free (gpointer _data)
{
	PamacTransactionCliAskCommitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->summary);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacTransactionCliAskCommitData, _data_);
}

static void
pamac_transaction_cli_real_ask_commit (PamacTransaction* base,
                                       PamacTransactionSummary* summary,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	PamacTransactionCli * self;
	PamacTransactionCliAskCommitData* _data_;
	PamacTransactionCli* _tmp0_;
	PamacTransactionSummary* _tmp1_;
	g_return_if_fail (summary != NULL);
	self = (PamacTransactionCli*) base;
	_data_ = g_slice_new0 (PamacTransactionCliAskCommitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_transaction_cli_real_ask_commit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (summary);
	_g_object_unref0 (_data_->summary);
	_data_->summary = _tmp1_;
	pamac_transaction_cli_real_ask_commit_co (_data_);
}

static gboolean
pamac_transaction_cli_ask_commit_finish (PamacTransaction* base,
                                         GAsyncResult* _res_)
{
	gboolean result;
	PamacTransactionCliAskCommitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static gboolean
pamac_transaction_cli_real_ask_commit_co (PamacTransactionCliAskCommitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->summary_shown) {
		_data_->result = _data_->self->priv->commit_transaction_answer;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		pamac_transaction_cli_show_summary (_data_->self, _data_->summary);
	}
	_data_->_tmp0_ = pamac_transaction_get_dry_run ((PamacTransaction*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_no_confirm;
	if (_data_->_tmp2_) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = pamac_transaction_cli_ask_user (_data_->self, g_dgettext (NULL, "Apply transaction"));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
pamac_transaction_cli_ask_view_diff (PamacTransactionCli* self,
                                     const gchar* pkgname)
{
	gchar* diff_path = NULL;
	PamacDatabase* _tmp0_;
	PamacDatabase* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* diff_file = NULL;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgname != NULL);
	_tmp0_ = pamac_transaction_get_database ((PamacTransaction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = pamac_database_get_real_aur_build_dir (_tmp1_);
	_tmp3_ = g_build_filename (_tmp2_, pkgname, "diff", NULL);
	diff_path = _tmp3_;
	_tmp4_ = diff_path;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	diff_file = _tmp5_;
	_tmp6_ = diff_file;
	if (g_file_query_exists (_tmp6_, NULL)) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = g_strdup_printf (g_dgettext (NULL, "View %s build files diff"), pkgname);
		_tmp8_ = _tmp7_;
		_tmp9_ = pamac_transaction_cli_ask_user (self, _tmp8_);
		_g_free0 (_tmp8_);
		if (_tmp9_) {
			gchar** cmds = NULL;
			gchar** _tmp10_;
			gint cmds_length1;
			gint _cmds_size_;
			const gchar* editor = NULL;
			const gchar* _tmp11_;
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp13_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp10_ = g_new0 (gchar*, 0 + 1);
			cmds = _tmp10_;
			cmds_length1 = 0;
			_cmds_size_ = cmds_length1;
			_tmp11_ = g_getenv ("EDITOR");
			editor = _tmp11_;
			_tmp13_ = editor;
			if (_tmp13_ == NULL) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp14_;
				_tmp14_ = editor;
				_tmp12_ = g_strcmp0 (_tmp14_, "nano") == 0;
			}
			if (_tmp12_) {
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = g_strdup ("nano");
				_vala_array_add3 (&cmds, &cmds_length1, &_cmds_size_, _tmp15_);
				_tmp16_ = g_strdup ("-v");
				_vala_array_add4 (&cmds, &cmds_length1, &_cmds_size_, _tmp16_);
			} else {
				const gchar* _tmp17_;
				gchar** _tmp18_;
				gchar** _tmp19_;
				_tmp17_ = editor;
				_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, " ", 0);
				{
					gchar** str_collection = NULL;
					gint str_collection_length1 = 0;
					gint _str_collection_size_ = 0;
					gint str_it = 0;
					str_collection = _tmp19_;
					str_collection_length1 = _vala_array_length (_tmp18_);
					for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
						const gchar* str = NULL;
						str = str_collection[str_it];
						{
							const gchar* _tmp20_;
							gchar* _tmp21_;
							_tmp20_ = str;
							_tmp21_ = g_strdup (_tmp20_);
							_vala_array_add5 (&cmds, &cmds_length1, &_cmds_size_, _tmp21_);
						}
					}
					str_collection = (_vala_array_free (str_collection, str_collection_length1, (GDestroyNotify) g_free), NULL);
				}
			}
			_tmp22_ = diff_path;
			_tmp23_ = g_strdup (_tmp22_);
			_vala_array_add6 (&cmds, &cmds_length1, &_cmds_size_, _tmp23_);
			{
				GSubprocess* process = NULL;
				gchar** _tmp24_;
				gint _tmp24__length1;
				GSubprocess* _tmp25_;
				GSubprocess* _tmp26_;
				_tmp24_ = cmds;
				_tmp24__length1 = cmds_length1;
				_tmp25_ = g_subprocess_newv (_tmp24_, G_SUBPROCESS_FLAGS_STDIN_INHERIT, &_inner_error0_);
				process = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp26_ = process;
				g_subprocess_wait (_tmp26_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (process);
					goto __catch0_g_error;
				}
				_g_object_unref0 (process);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp27_;
				const gchar* _tmp28_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp27_ = e;
				_tmp28_ = _tmp27_->message;
				g_warning ("transaction-cli.vala:884: %s", _tmp28_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (diff_file);
				_g_free0 (diff_path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			cmds = (_vala_array_free (cmds, cmds_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	_g_object_unref0 (diff_file);
	_g_free0 (diff_path);
}

static void
pamac_transaction_cli_edit_single_build_files_data_free (gpointer _data)
{
	PamacTransactionCliEditSingleBuildFilesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->pkgname);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacTransactionCliEditSingleBuildFilesData, _data_);
}

static void
pamac_transaction_cli_edit_single_build_files (PamacTransactionCli* self,
                                               const gchar* pkgname,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	PamacTransactionCliEditSingleBuildFilesData* _data_;
	PamacTransactionCli* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgname != NULL);
	_data_ = g_slice_new0 (PamacTransactionCliEditSingleBuildFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_transaction_cli_edit_single_build_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (pkgname);
	_g_free0 (_data_->pkgname);
	_data_->pkgname = _tmp1_;
	pamac_transaction_cli_edit_single_build_files_co (_data_);
}

static void
pamac_transaction_cli_edit_single_build_files_finish (PamacTransactionCli* self,
                                                      GAsyncResult* _res_)
{
	PamacTransactionCliEditSingleBuildFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
pamac_transaction_cli_edit_single_build_files_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	PamacTransactionCliEditSingleBuildFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pamac_transaction_cli_edit_single_build_files_co (_data_);
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
pamac_transaction_cli_edit_single_build_files_co (PamacTransactionCliEditSingleBuildFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	pamac_transaction_get_build_files_async ((PamacTransaction*) _data_->self, _data_->pkgname, pamac_transaction_cli_edit_single_build_files_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = pamac_transaction_get_build_files_finish ((PamacTransaction*) _data_->self, _data_->_res_);
	_data_->files = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->files;
	_data_->_tmp2_ = vala_g_ptr_array_get_length (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ > 0) {
		_data_->_tmp4_ = g_new0 (gchar*, 0 + 1);
		_data_->cmds = _data_->_tmp4_;
		_data_->cmds_length1 = 0;
		_data_->_cmds_size_ = _data_->cmds_length1;
		_data_->_tmp5_ = g_getenv ("EDITOR");
		_data_->editor = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->editor;
		if (_data_->_tmp7_ == NULL) {
			_data_->_tmp6_ = TRUE;
		} else {
			_data_->_tmp8_ = _data_->editor;
			_data_->_tmp6_ = g_strcmp0 (_data_->_tmp8_, "nano") == 0;
		}
		if (_data_->_tmp6_) {
			_data_->_tmp9_ = g_strdup ("nano");
			_vala_array_add7 (&_data_->cmds, &_data_->cmds_length1, &_data_->_cmds_size_, _data_->_tmp9_);
			_data_->_tmp10_ = g_strdup ("-i");
			_vala_array_add8 (&_data_->cmds, &_data_->cmds_length1, &_data_->_cmds_size_, _data_->_tmp10_);
		} else {
			_data_->_tmp11_ = _data_->editor;
			_data_->_tmp13_ = _data_->_tmp12_ = g_strsplit (_data_->_tmp11_, " ", 0);
			{
				_data_->str_collection_length1 = 0;
				_data_->_str_collection_size_ = 0;
				_data_->str_collection = _data_->_tmp13_;
				_data_->str_collection_length1 = _vala_array_length (_data_->_tmp12_);
				for (_data_->str_it = 0; _data_->str_it < _data_->str_collection_length1; _data_->str_it = _data_->str_it + 1) {
					_data_->str = _data_->str_collection[_data_->str_it];
					{
						_data_->_tmp14_ = _data_->str;
						_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
						_vala_array_add9 (&_data_->cmds, &_data_->cmds_length1, &_data_->_cmds_size_, _data_->_tmp15_);
					}
				}
				_data_->str_collection = (_vala_array_free (_data_->str_collection, _data_->str_collection_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_data_->_tmp16_ = _data_->files;
		{
			_data_->file_collection = _data_->_tmp16_;
			for (_data_->file_index = 0; _data_->file_index < _data_->file_collection->len; _data_->file_index = _data_->file_index + 1) {
				_data_->file = (const gchar*) g_ptr_array_index (_data_->file_collection, _data_->file_index);
				{
					_data_->_tmp17_ = _data_->file;
					_data_->_tmp18_ = g_strdup (_data_->_tmp17_);
					_vala_array_add10 (&_data_->cmds, &_data_->cmds_length1, &_data_->_cmds_size_, _data_->_tmp18_);
				}
			}
		}
		{
			_data_->_tmp19_ = _data_->cmds;
			_data_->_tmp19__length1 = _data_->cmds_length1;
			_data_->_tmp20_ = g_subprocess_newv (_data_->_tmp19_, G_SUBPROCESS_FLAGS_STDIN_INHERIT, &_data_->_inner_error0_);
			_data_->process = _data_->_tmp20_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp21_ = _data_->process;
			_data_->_state_ = 2;
			g_subprocess_wait_async (_data_->_tmp21_, NULL, pamac_transaction_cli_edit_single_build_files_ready, _data_);
			return FALSE;
			_state_2:
			g_subprocess_wait_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->process);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_data_->process);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp22_ = _data_->e;
			_data_->_tmp23_ = _data_->_tmp22_->message;
			g_warning ("transaction-cli.vala:911: %s", _data_->_tmp23_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->cmds = (_vala_array_free (_data_->cmds, _data_->cmds_length1, (GDestroyNotify) g_free), NULL);
			_g_ptr_array_unref0 (_data_->files);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->cmds = (_vala_array_free (_data_->cmds, _data_->cmds_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_ptr_array_unref0 (_data_->files);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pamac_transaction_cli_real_edit_build_files_data_free (gpointer _data)
{
	PamacTransactionCliEditBuildFilesData* _data_;
	_data_ = _data;
	_g_ptr_array_unref0 (_data_->pkgnames);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacTransactionCliEditBuildFilesData, _data_);
}

static void
pamac_transaction_cli_real_edit_build_files (PamacTransaction* base,
                                             GPtrArray* pkgnames,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	PamacTransactionCli * self;
	PamacTransactionCliEditBuildFilesData* _data_;
	PamacTransactionCli* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (pkgnames != NULL);
	self = (PamacTransactionCli*) base;
	_data_ = g_slice_new0 (PamacTransactionCliEditBuildFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_transaction_cli_real_edit_build_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_ptr_array_ref0 (pkgnames);
	_g_ptr_array_unref0 (_data_->pkgnames);
	_data_->pkgnames = _tmp1_;
	pamac_transaction_cli_real_edit_build_files_co (_data_);
}

static void
pamac_transaction_cli_edit_build_files_finish (PamacTransaction* base,
                                               GAsyncResult* _res_)
{
	PamacTransactionCliEditBuildFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
pamac_transaction_cli_edit_build_files_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	PamacTransactionCliEditBuildFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pamac_transaction_cli_real_edit_build_files_co (_data_);
}

static gboolean
pamac_transaction_cli_real_edit_build_files_co (PamacTransactionCliEditBuildFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = vala_g_ptr_array_get_length (_data_->pkgnames);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ == 1) {
		_data_->_tmp2_ = g_ptr_array_index (_data_->pkgnames, (guint) 0);
		pamac_transaction_cli_ask_view_diff (_data_->self, (const gchar*) _data_->_tmp2_);
		_data_->_tmp3_ = g_ptr_array_index (_data_->pkgnames, (guint) 0);
		_data_->_state_ = 1;
		pamac_transaction_cli_edit_single_build_files (_data_->self, (const gchar*) _data_->_tmp3_, pamac_transaction_cli_edit_build_files_ready, _data_);
		return FALSE;
		_state_1:
		pamac_transaction_cli_edit_single_build_files_finish (_data_->self, _data_->_res_);
	} else {
		{
			_data_->pkgname_collection = _data_->pkgnames;
			for (_data_->pkgname_index = 0; _data_->pkgname_index < _data_->pkgname_collection->len; _data_->pkgname_index = _data_->pkgname_index + 1) {
				_data_->pkgname = (const gchar*) g_ptr_array_index (_data_->pkgname_collection, _data_->pkgname_index);
				{
					_data_->_tmp4_ = _data_->pkgname;
					pamac_transaction_cli_ask_view_diff (_data_->self, _data_->_tmp4_);
					_data_->_tmp5_ = _data_->pkgname;
					_data_->_tmp6_ = g_strdup_printf ("Edit %s build files", _data_->_tmp5_);
					_data_->_tmp7_ = _data_->_tmp6_;
					_data_->_tmp8_ = pamac_transaction_cli_ask_user (_data_->self, g_dgettext (NULL, _data_->_tmp7_));
					_g_free0 (_data_->_tmp7_);
					if (_data_->_tmp8_) {
						_data_->_tmp9_ = _data_->pkgname;
						_data_->_state_ = 2;
						pamac_transaction_cli_edit_single_build_files (_data_->self, _data_->_tmp9_, pamac_transaction_cli_edit_build_files_ready, _data_);
						return FALSE;
						_state_2:
						pamac_transaction_cli_edit_single_build_files_finish (_data_->self, _data_->_res_);
					}
				}
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
pamac_transaction_cli_get_no_confirm (PamacTransactionCli* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_confirm;
	return result;
}

void
pamac_transaction_cli_set_no_confirm (PamacTransactionCli* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pamac_transaction_cli_get_no_confirm (self);
	if (old_value != value) {
		self->priv->_no_confirm = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_transaction_cli_properties[PAMAC_TRANSACTION_CLI_NO_CONFIRM_PROPERTY]);
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PamacTransactionCli* self;
		self = _data1_->self;
		_g_main_loop_unref0 (_data1_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_pamac_transaction_cli_print_action_pamac_transaction_emit_action (PamacTransaction* _sender,
                                                                   const gchar* action,
                                                                   gpointer self)
{
	pamac_transaction_cli_print_action ((PamacTransactionCli*) self, action);
}

static void
_pamac_transaction_cli_print_action_progress_pamac_transaction_emit_action_progress (PamacTransaction* _sender,
                                                                                     const gchar* action,
                                                                                     const gchar* status,
                                                                                     gdouble progress,
                                                                                     gpointer self)
{
	pamac_transaction_cli_print_action_progress ((PamacTransactionCli*) self, action, status, progress);
}

static void
_pamac_transaction_cli_print_download_progress_pamac_transaction_emit_download_progress (PamacTransaction* _sender,
                                                                                         const gchar* action,
                                                                                         const gchar* status,
                                                                                         gdouble progress,
                                                                                         gpointer self)
{
	pamac_transaction_cli_print_download_progress ((PamacTransactionCli*) self, action, status, progress);
}

static void
_pamac_transaction_cli_print_hook_progress_pamac_transaction_emit_hook_progress (PamacTransaction* _sender,
                                                                                 const gchar* action,
                                                                                 const gchar* details,
                                                                                 const gchar* status,
                                                                                 gdouble progress,
                                                                                 gpointer self)
{
	pamac_transaction_cli_print_hook_progress ((PamacTransactionCli*) self, action, details, status, progress);
}

static void
_pamac_transaction_cli_on_emit_script_output_pamac_transaction_emit_script_output (PamacTransaction* _sender,
                                                                                   const gchar* message,
                                                                                   gpointer self)
{
	pamac_transaction_cli_on_emit_script_output ((PamacTransactionCli*) self, message);
}

static void
_pamac_transaction_cli_print_warning_pamac_transaction_emit_warning (PamacTransaction* _sender,
                                                                     const gchar* message,
                                                                     gpointer self)
{
	pamac_transaction_cli_print_warning ((PamacTransactionCli*) self, message);
}

static void
_pamac_transaction_cli_print_error_pamac_transaction_emit_error (PamacTransaction* _sender,
                                                                 const gchar* message,
                                                                 GPtrArray* details,
                                                                 gpointer self)
{
	pamac_transaction_cli_print_error ((PamacTransactionCli*) self, message, details);
}

static void
_pamac_transaction_cli___lambda4_ (Block1Data* _data1_,
                                   GObject* obj,
                                   GAsyncResult* res)
{
	PamacTransactionCli* self;
	GMainLoop* _tmp0_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
__pamac_transaction_cli___lambda4__gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self)
{
	_pamac_transaction_cli___lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

static GObject *
pamac_transaction_cli_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PamacTransactionCli * self;
	Block1Data* _data1_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GMainLoop* _tmp2_;
	GMainLoop* _tmp3_;
	parent_class = G_OBJECT_CLASS (pamac_transaction_cli_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCli);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->current_line);
	self->priv->current_line = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->current_action);
	self->priv->current_action = _tmp1_;
	self->priv->summary_shown = FALSE;
	pamac_transaction_cli_set_no_confirm (self, FALSE);
	self->priv->commit_transaction_answer = FALSE;
	g_signal_connect_object ((PamacTransaction*) self, "emit-action", (GCallback) _pamac_transaction_cli_print_action_pamac_transaction_emit_action, self, 0);
	g_signal_connect_object ((PamacTransaction*) self, "emit-action-progress", (GCallback) _pamac_transaction_cli_print_action_progress_pamac_transaction_emit_action_progress, self, 0);
	g_signal_connect_object ((PamacTransaction*) self, "emit-download-progress", (GCallback) _pamac_transaction_cli_print_download_progress_pamac_transaction_emit_download_progress, self, 0);
	g_signal_connect_object ((PamacTransaction*) self, "emit-hook-progress", (GCallback) _pamac_transaction_cli_print_hook_progress_pamac_transaction_emit_hook_progress, self, 0);
	g_signal_connect_object ((PamacTransaction*) self, "emit-script-output", (GCallback) _pamac_transaction_cli_on_emit_script_output_pamac_transaction_emit_script_output, self, 0);
	g_signal_connect_object ((PamacTransaction*) self, "emit-warning", (GCallback) _pamac_transaction_cli_print_warning_pamac_transaction_emit_warning, self, 0);
	g_signal_connect_object ((PamacTransaction*) self, "emit-error", (GCallback) _pamac_transaction_cli_print_error_pamac_transaction_emit_error, self, 0);
	_tmp2_ = g_main_loop_new (NULL, FALSE);
	_data1_->loop = _tmp2_;
	pamac_transaction_check_dbs ((PamacTransaction*) self, __pamac_transaction_cli___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp3_ = _data1_->loop;
	g_main_loop_run (_tmp3_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
pamac_transaction_cli_class_init (PamacTransactionCliClass * klass,
                                  gpointer klass_data)
{
	pamac_transaction_cli_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacTransactionCli_private_offset);
	((PamacTransactionClass *) klass)->run_cmd_line_async = (void (*) (PamacTransaction*, GPtrArray*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) pamac_transaction_cli_real_run_cmd_line_async;
	((PamacTransactionClass *) klass)->run_cmd_line_finish = (gint (*) (PamacTransaction*, GAsyncResult*)) pamac_transaction_cli_run_cmd_line_finish;
	((PamacTransactionClass *) klass)->choose_optdeps = (void (*) (PamacTransaction*, const gchar*, GPtrArray*, GAsyncReadyCallback, gpointer)) pamac_transaction_cli_real_choose_optdeps;
	((PamacTransactionClass *) klass)->choose_optdeps_finish = (GPtrArray* (*) (PamacTransaction*, GAsyncResult*)) pamac_transaction_cli_choose_optdeps_finish;
	((PamacTransactionClass *) klass)->choose_provider = (void (*) (PamacTransaction*, const gchar*, GPtrArray*, GAsyncReadyCallback, gpointer)) pamac_transaction_cli_real_choose_provider;
	((PamacTransactionClass *) klass)->choose_provider_finish = (gint (*) (PamacTransaction*, GAsyncResult*)) pamac_transaction_cli_choose_provider_finish;
	((PamacTransactionClass *) klass)->ask_import_key = (void (*) (PamacTransaction*, const gchar*, const gchar*, const gchar*, GAsyncReadyCallback, gpointer)) pamac_transaction_cli_real_ask_import_key;
	((PamacTransactionClass *) klass)->ask_import_key_finish = (gboolean (*) (PamacTransaction*, GAsyncResult*)) pamac_transaction_cli_ask_import_key_finish;
	((PamacTransactionClass *) klass)->ask_edit_build_files = (void (*) (PamacTransaction*, PamacTransactionSummary*, GAsyncReadyCallback, gpointer)) pamac_transaction_cli_real_ask_edit_build_files;
	((PamacTransactionClass *) klass)->ask_edit_build_files_finish = (gboolean (*) (PamacTransaction*, GAsyncResult*)) pamac_transaction_cli_ask_edit_build_files_finish;
	((PamacTransactionClass *) klass)->ask_commit = (void (*) (PamacTransaction*, PamacTransactionSummary*, GAsyncReadyCallback, gpointer)) pamac_transaction_cli_real_ask_commit;
	((PamacTransactionClass *) klass)->ask_commit_finish = (gboolean (*) (PamacTransaction*, GAsyncResult*)) pamac_transaction_cli_ask_commit_finish;
	((PamacTransactionClass *) klass)->edit_build_files = (void (*) (PamacTransaction*, GPtrArray*, GAsyncReadyCallback, gpointer)) pamac_transaction_cli_real_edit_build_files;
	((PamacTransactionClass *) klass)->edit_build_files_finish = (void (*) (PamacTransaction*, GAsyncResult*)) pamac_transaction_cli_edit_build_files_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_pamac_transaction_cli_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pamac_transaction_cli_set_property;
	G_OBJECT_CLASS (klass)->constructor = pamac_transaction_cli_constructor;
	G_OBJECT_CLASS (klass)->finalize = pamac_transaction_cli_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_TRANSACTION_CLI_NO_CONFIRM_PROPERTY, pamac_transaction_cli_properties[PAMAC_TRANSACTION_CLI_NO_CONFIRM_PROPERTY] = g_param_spec_boolean ("no-confirm", "no-confirm", "no-confirm", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pamac_transaction_cli_instance_init (PamacTransactionCli * self,
                                     gpointer klass)
{
	self->priv = pamac_transaction_cli_get_instance_private (self);
}

static void
pamac_transaction_cli_finalize (GObject * obj)
{
	PamacTransactionCli * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCli);
	_g_free0 (self->priv->current_line);
	_g_free0 (self->priv->current_action);
	G_OBJECT_CLASS (pamac_transaction_cli_parent_class)->finalize (obj);
}

static GType
pamac_transaction_cli_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacTransactionCliClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_transaction_cli_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacTransactionCli), 0, (GInstanceInitFunc) pamac_transaction_cli_instance_init, NULL };
	GType pamac_transaction_cli_type_id;
	pamac_transaction_cli_type_id = g_type_register_static (PAMAC_TYPE_TRANSACTION, "PamacTransactionCli", &g_define_type_info, 0);
	PamacTransactionCli_private_offset = g_type_add_instance_private (pamac_transaction_cli_type_id, sizeof (PamacTransactionCliPrivate));
	return pamac_transaction_cli_type_id;
}

GType
pamac_transaction_cli_get_type (void)
{
	static volatile gsize pamac_transaction_cli_type_id__once = 0;
	if (g_once_init_enter (&pamac_transaction_cli_type_id__once)) {
		GType pamac_transaction_cli_type_id;
		pamac_transaction_cli_type_id = pamac_transaction_cli_get_type_once ();
		g_once_init_leave (&pamac_transaction_cli_type_id__once, pamac_transaction_cli_type_id);
	}
	return pamac_transaction_cli_type_id__once;
}

static void
_vala_pamac_transaction_cli_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PamacTransactionCli * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCli);
	switch (property_id) {
		case PAMAC_TRANSACTION_CLI_NO_CONFIRM_PROPERTY:
		g_value_set_boolean (value, pamac_transaction_cli_get_no_confirm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pamac_transaction_cli_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	PamacTransactionCli * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCli);
	switch (property_id) {
		case PAMAC_TRANSACTION_CLI_NO_CONFIRM_PROPERTY:
		pamac_transaction_cli_set_no_confirm (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

