
use builtin;
use str;

set edit:completion:arg-completer[rage] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'rage'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'rage'= {
            cand --max-work-factor 'Maximum work factor to allow for passphrase decryption.'
            cand -r 'Encrypt to the specified RECIPIENT. May be repeated.'
            cand --recipient 'Encrypt to the specified RECIPIENT. May be repeated.'
            cand -R 'Encrypt to the recipients listed at PATH. May be repeated.'
            cand --recipients-file 'Encrypt to the recipients listed at PATH. May be repeated.'
            cand -i 'Use the identity file at IDENTITY. May be repeated.'
            cand --identity 'Use the identity file at IDENTITY. May be repeated.'
            cand -j 'Use age-plugin-PLUGIN-NAME in its default mode as an identity.'
            cand -o 'Write the result to the file at path OUTPUT.'
            cand --output 'Write the result to the file at path OUTPUT.'
            cand -h 'Print this help message and exit.'
            cand --help 'Print this help message and exit.'
            cand -V 'Print version info and exit.'
            cand --version 'Print version info and exit.'
            cand -e 'Encrypt the input (the default).'
            cand --encrypt 'Encrypt the input (the default).'
            cand -d 'Decrypt the input.'
            cand --decrypt 'Decrypt the input.'
            cand -p 'Encrypt with a passphrase instead of recipients.'
            cand --passphrase 'Encrypt with a passphrase instead of recipients.'
            cand -a 'Encrypt to a PEM encoded format.'
            cand --armor 'Encrypt to a PEM encoded format.'
        }
    ]
    $completions[$command]
}
