/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.NoSuchElementException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.javafx.filterpanel.CommonViewSettingsPane;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.jetbrains.annotations.NotNull;

public class OldSwingJavaFxFilterDialog
extends JDialog {
    private final JFXPanel fxPanel = new JFXPanel();
    private final JToggleButton filterToggleButton;

    public OldSwingJavaFxFilterDialog(Frame owner, CommonViewSettingsPane content, @NotNull JToggleButton filterToggleButton) {
        super(owner);
        this.filterToggleButton = filterToggleButton;
        ToggleVisibilityKeyHandler handler = new ToggleVisibilityKeyHandler(this);
        handler.installHandler(filterToggleButton.getAction());
        this.setDefaultCloseOperation(1);
        this.setTitle("Filter");
        this.setType(Window.Type.UTILITY);
        this.setContentPane(this.fxPanel);
        Platform.runLater(() -> {
            this.fxPanel.setScene(new Scene(content));
            SwingUtilities.invokeLater(() -> {
                this.pack();
                this.restoreWindowSizeFromConfig();
                this.restoreDialogVisibility();
                this.addComponentListener(new FilterDialogComponentListener());
            });
        });
        MessageBus.getMessageBus().subscribe(this);
        Daten.getInstance().getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                boolean enabled = false;
                OldSwingJavaFxFilterDialog.this.setEnabled(false);
                OldSwingJavaFxFilterDialog.this.fxPanel.setEnabled(false);
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                boolean enabled = true;
                OldSwingJavaFxFilterDialog.this.setEnabled(true);
                OldSwingJavaFxFilterDialog.this.fxPanel.setEnabled(true);
            }
        });
    }

    @Handler
    private void handleTableModelChangeEvent(TableModelChangeEvent e) {
        SwingUtilities.invokeLater(() -> this.setEnabled(!e.active));
    }

    private void restoreDialogVisibility() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        boolean visible = config.getBoolean("application.ui.filter_dialog.visible", false);
        this.setVisible(visible);
    }

    private void storeDialogVisibility() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        config.setProperty("application.ui.filter_dialog.visible", this.isVisible());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreWindowSizeFromConfig() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int width = config.getInt("application.ui.filter_dialog.width");
            int height = config.getInt("application.ui.filter_dialog.height");
            int x = config.getInt("application.ui.filter_dialog.location.x");
            int y = config.getInt("application.ui.filter_dialog.location.y");
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    static class ToggleVisibilityKeyHandler {
        private static final String TOGGLE_FILTER_VISIBILITY = "toggle_dialog_visibility";
        private final JRootPane rootPane;

        public ToggleVisibilityKeyHandler(JDialog dlg) {
            this.rootPane = dlg.getRootPane();
        }

        public void installHandler(Action action) {
            InputMap inputMap = this.rootPane.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(123, 0), TOGGLE_FILTER_VISIBILITY);
            this.rootPane.getActionMap().put(TOGGLE_FILTER_VISIBILITY, action);
        }
    }

    public class FilterDialogComponentListener
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent e) {
            this.storeWindowPosition(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.storeWindowPosition(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            OldSwingJavaFxFilterDialog.this.storeDialogVisibility();
            OldSwingJavaFxFilterDialog.this.filterToggleButton.setSelected(true);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.storeWindowPosition(e);
            OldSwingJavaFxFilterDialog.this.storeDialogVisibility();
            OldSwingJavaFxFilterDialog.this.filterToggleButton.setSelected(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeWindowPosition(ComponentEvent e) {
            Configuration config = ApplicationConfiguration.getConfiguration();
            Component component = e.getComponent();
            Dimension dims = component.getSize();
            Point loc = component.getLocation();
            try {
                config.lock(LockMode.WRITE);
                config.setProperty("application.ui.filter_dialog.width", dims.width);
                config.setProperty("application.ui.filter_dialog.height", dims.height);
                config.setProperty("application.ui.filter_dialog.location.x", loc.x);
                config.setProperty("application.ui.filter_dialog.location.y", loc.y);
            }
            finally {
                config.unlock(LockMode.WRITE);
            }
        }
    }
}

