/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import mediathek.Main;
import mediathek.config.Konstanten;
import mediathek.tool.TimerPool;
import mediathek.tool.UIProgressState;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lmediathek/SplashScreen;", "Ljavax/swing/JWindow;", "()V", "appTitleLabel", "Ljavax/swing/JLabel;", "curSteps", "", "imageLabel", "osName", "", "getOsName", "()Ljava/lang/String;", "progressBar", "Ljavax/swing/JProgressBar;", "statusLabel", "versionLabel", "close", "", "initComponents", "update", "state", "Lmediathek/tool/UIProgressState;", "updateStatus", "statusText", "percentComplete", "", "Companion", "MediathekView"})
public final class SplashScreen
extends JWindow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private JLabel versionLabel;
    private double curSteps;
    @Nullable
    private JLabel appTitleLabel;
    @Nullable
    private JLabel imageLabel;
    @Nullable
    private JProgressBar progressBar;
    @Nullable
    private JLabel statusLabel;
    private static final double MAXIMUM_STEPS = (double)EnumSet.allOf(UIProgressState.class).size() - 1.0;

    public SplashScreen() {
        this.initComponents();
        this.getContentPane().setBackground(Color.BLACK);
        String string = "Version: %s (%s %s)";
        Object[] objectArray = new Object[]{Konstanten.MVVERSION, this.getOsName(), SystemUtils.OS_ARCH};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        String res = string2;
        JLabel jLabel = this.versionLabel;
        Intrinsics.checkNotNull(jLabel);
        jLabel.setText(res);
        JProgressBar jProgressBar = this.progressBar;
        Intrinsics.checkNotNull(jProgressBar);
        jProgressBar.setValue(0);
        this.setLocationRelativeTo(null);
        if (SystemUtils.IS_OS_WINDOWS && this.isAlwaysOnTopSupported()) {
            this.setAlwaysOnTop(true);
        }
    }

    public final void update(@NotNull UIProgressState state) {
        Intrinsics.checkNotNullParameter((Object)state, "state");
        double d = this.curSteps;
        this.curSteps = d + 1.0;
        int pct = MathKt.roundToInt((double)100 * (this.curSteps / MAXIMUM_STEPS));
        this.updateStatus(state.toString(), pct);
    }

    public final void close() {
        TimerPool.getTimerPool().schedule(() -> SplashScreen.close$lambda$1(this), 2L, TimeUnit.SECONDS);
        Main.splashScreen = Optional.empty();
    }

    private final String getOsName() {
        String string;
        if (SystemUtils.IS_OS_MAC_OSX) {
            string = "macOS";
        } else {
            String string2 = SystemUtils.OS_NAME;
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "OS_NAME");
        }
        return string;
    }

    private final void updateStatus(String statusText, int percentComplete) {
        JLabel jLabel = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel);
        JLabel jLabel2 = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel2);
        int n = jLabel2.getWidth();
        JLabel jLabel3 = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel3);
        jLabel.paintImmediately(0, 0, n, jLabel3.getHeight());
        JLabel jLabel4 = this.imageLabel;
        Intrinsics.checkNotNull(jLabel4);
        JLabel jLabel5 = this.imageLabel;
        Intrinsics.checkNotNull(jLabel5);
        int n2 = jLabel5.getWidth();
        JLabel jLabel6 = this.imageLabel;
        Intrinsics.checkNotNull(jLabel6);
        jLabel4.paintImmediately(0, 0, n2, jLabel6.getHeight());
        JLabel jLabel7 = this.versionLabel;
        Intrinsics.checkNotNull(jLabel7);
        JLabel jLabel8 = this.versionLabel;
        Intrinsics.checkNotNull(jLabel8);
        int n3 = jLabel8.getWidth();
        JLabel jLabel9 = this.versionLabel;
        Intrinsics.checkNotNull(jLabel9);
        jLabel7.paintImmediately(0, 0, n3, jLabel9.getHeight());
        JLabel jLabel10 = this.statusLabel;
        Intrinsics.checkNotNull(jLabel10);
        jLabel10.setText(statusText);
        JLabel jLabel11 = this.statusLabel;
        Intrinsics.checkNotNull(jLabel11);
        JLabel jLabel12 = this.statusLabel;
        Intrinsics.checkNotNull(jLabel12);
        int n4 = jLabel12.getWidth();
        JLabel jLabel13 = this.statusLabel;
        Intrinsics.checkNotNull(jLabel13);
        jLabel11.paintImmediately(0, 0, n4, jLabel13.getHeight());
        JProgressBar jProgressBar = this.progressBar;
        Intrinsics.checkNotNull(jProgressBar);
        jProgressBar.setValue(percentComplete);
        JProgressBar jProgressBar2 = this.progressBar;
        Intrinsics.checkNotNull(jProgressBar2);
        JProgressBar jProgressBar3 = this.progressBar;
        Intrinsics.checkNotNull(jProgressBar3);
        int n5 = jProgressBar3.getWidth();
        JProgressBar jProgressBar4 = this.progressBar;
        Intrinsics.checkNotNull(jProgressBar4);
        jProgressBar2.paintImmediately(0, 0, n5, jProgressBar4.getHeight());
    }

    private final void initComponents() {
        this.appTitleLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.imageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.statusLabel = new JLabel();
        this.setMinimumSize(new Dimension(640, 480));
        this.setBackground(Color.black);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setAutoRequestFocus(false);
        this.setForeground(Color.black);
        Container contentPane = this.getContentPane();
        JLabel jLabel = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel);
        jLabel.setText("MediathekView");
        JLabel jLabel2 = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel2);
        JLabel jLabel3 = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel3);
        Font font = jLabel3.getFont();
        JLabel jLabel4 = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel4);
        int n = jLabel4.getFont().getStyle() | 1;
        JLabel jLabel5 = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel5);
        jLabel2.setFont(font.deriveFont(n, (float)jLabel5.getFont().getSize() + 45.0f));
        JLabel jLabel6 = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel6);
        jLabel6.setForeground(Color.white);
        JLabel jLabel7 = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel7);
        jLabel7.setBackground(Color.black);
        JLabel jLabel8 = this.appTitleLabel;
        Intrinsics.checkNotNull(jLabel8);
        jLabel8.setOpaque(true);
        JLabel jLabel9 = this.versionLabel;
        Intrinsics.checkNotNull(jLabel9);
        jLabel9.setText("Version");
        JLabel jLabel10 = this.versionLabel;
        Intrinsics.checkNotNull(jLabel10);
        jLabel10.setOpaque(true);
        JLabel jLabel11 = this.versionLabel;
        Intrinsics.checkNotNull(jLabel11);
        jLabel11.setForeground(Color.white);
        JLabel jLabel12 = this.versionLabel;
        Intrinsics.checkNotNull(jLabel12);
        jLabel12.setBackground(Color.black);
        JLabel jLabel13 = this.imageLabel;
        Intrinsics.checkNotNull(jLabel13);
        jLabel13.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/MediathekView.png")));
        JLabel jLabel14 = this.imageLabel;
        Intrinsics.checkNotNull(jLabel14);
        jLabel14.setBackground(Color.black);
        JLabel jLabel15 = this.imageLabel;
        Intrinsics.checkNotNull(jLabel15);
        jLabel15.setOpaque(true);
        JProgressBar jProgressBar = this.progressBar;
        Intrinsics.checkNotNull(jProgressBar);
        jProgressBar.setValue(50);
        JProgressBar jProgressBar2 = this.progressBar;
        Intrinsics.checkNotNull(jProgressBar2);
        jProgressBar2.setPreferredSize(new Dimension(146, 10));
        JLabel jLabel16 = this.statusLabel;
        Intrinsics.checkNotNull(jLabel16);
        jLabel16.setText("Status Text Message is here");
        JLabel jLabel17 = this.statusLabel;
        Intrinsics.checkNotNull(jLabel17);
        jLabel17.setForeground(Color.white);
        JLabel jLabel18 = this.statusLabel;
        Intrinsics.checkNotNull(jLabel18);
        jLabel18.setBackground(Color.black);
        JLabel jLabel19 = this.statusLabel;
        Intrinsics.checkNotNull(jLabel19);
        jLabel19.setOpaque(true);
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup().addComponent(this.versionLabel, -1, 628, Short.MAX_VALUE).addComponent(this.progressBar, -1, 628, Short.MAX_VALUE).addGroup(contentPaneLayout.createSequentialGroup().addComponent(this.appTitleLabel).addGap(0, 257, Short.MAX_VALUE)).addComponent(this.statusLabel, -1, 628, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addGap(0, 372, Short.MAX_VALUE).addComponent(this.imageLabel))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.appTitleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 94, Integer.MAX_VALUE).addComponent(this.imageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private static final void close$lambda$1$lambda$0(SplashScreen this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.setVisible(false);
    }

    private static final void close$lambda$1(SplashScreen this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        SwingUtilities.invokeLater(() -> SplashScreen.close$lambda$1$lambda$0(this$0));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmediathek/SplashScreen$Companion;", "", "()V", "MAXIMUM_STEPS", "", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

