/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.tools.plugin.edit;

import java.awt.Color;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TextProperties;
import org.gephi.graph.api.TimeFormat;
import org.gephi.ui.tools.plugin.edit.EditWindowUtils;
import org.gephi.ui.tools.plugin.edit.MultipleRowsAttributeValueWrapper;
import org.gephi.ui.tools.plugin.edit.SingleRowAttributeValueWrapper;
import org.joda.time.DateTimeZone;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EditNodes
extends AbstractNode {
    private final Node[] nodes;
    private final boolean multipleNodes;
    private final TimeFormat currentTimeFormat;
    private final DateTimeZone dateTimeZone;
    private Node.PropertySet[] propertySets;

    public EditNodes(Node node) {
        super(Children.LEAF);
        this.nodes = new Node[]{node};
        this.setName(node.getLabel());
        this.multipleNodes = false;
        GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.currentTimeFormat = gc.getGraphModel().getTimeFormat();
        this.dateTimeZone = gc.getGraphModel().getTimeZone();
    }

    public EditNodes(Node[] nodes) {
        super(Children.LEAF);
        this.nodes = nodes;
        boolean bl = this.multipleNodes = nodes.length > 1;
        if (this.multipleNodes) {
            this.setName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.multiple.elements"));
        } else {
            this.setName(nodes[0].getLabel());
        }
        GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.currentTimeFormat = gc.getGraphModel().getTimeFormat();
        this.dateTimeZone = gc.getGraphModel().getTimeZone();
    }

    public Node.PropertySet[] getPropertySets() {
        this.propertySets = new Node.PropertySet[]{this.prepareNodesProperties(), this.prepareNodesAttributes()};
        return this.propertySets;
    }

    private Sheet.Set prepareNodesAttributes() {
        try {
            AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
            Sheet.Set set = new Sheet.Set();
            set.setName("attributes");
            if (this.nodes.length > 1) {
                set.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.attributes.text.multiple"));
            } else {
                set.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.attributes.text", (Object)this.nodes[0].getLabel()));
            }
            Node row = this.nodes[0];
            for (Column column : row.getAttributeColumns()) {
                EditWindowUtils.AttributeValueWrapper wrap = this.multipleNodes ? new MultipleRowsAttributeValueWrapper((Element[])this.nodes, column, this.currentTimeFormat, this.dateTimeZone) : new SingleRowAttributeValueWrapper((Element)this.nodes[0], column, this.currentTimeFormat, this.dateTimeZone);
                Class type = column.getTypeClass();
                PropertyEditor propEditor = PropertyEditorManager.findEditor(type);
                PropertySupport.Reflection p = ac.canChangeColumnData(column) ? (propEditor != null && !type.isArray() ? new PropertySupport.Reflection((Object)wrap, type, "getValue" + type.getSimpleName(), "setValue" + type.getSimpleName()) : new PropertySupport.Reflection((Object)wrap, String.class, "getValueAsString", "setValueAsString")) : (propEditor != null ? new PropertySupport.Reflection((Object)wrap, type, "getValue" + type.getSimpleName(), null) : new PropertySupport.Reflection((Object)wrap, String.class, "getValueAsString", null));
                p.setDisplayName(column.getTitle());
                p.setName(column.getId());
                set.put((Node.Property)p);
            }
            return set;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private Sheet.Set prepareNodesProperties() {
        try {
            if (this.multipleNodes) {
                MultipleNodesPropertiesWrapper nodesWrapper = new MultipleNodesPropertiesWrapper(this.nodes);
                Sheet.Set set = new Sheet.Set();
                set.setName("properties");
                set.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.properties.text.multiple"));
                PropertySupport.Reflection p = new PropertySupport.Reflection((Object)nodesWrapper, Float.class, "getNodesSize", "setNodesSize");
                p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.size.text"));
                p.setName("size");
                set.put((Node.Property)p);
                set.put(this.buildMultipleNodesGeneralPositionProperty(nodesWrapper, "x"));
                set.put(this.buildMultipleNodesGeneralPositionProperty(nodesWrapper, "y"));
                set.put(this.buildMultipleNodesGeneralPositionProperty(nodesWrapper, "z"));
                p = new PropertySupport.Reflection((Object)nodesWrapper, Color.class, "getNodesColor", "setNodesColor");
                p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.color.text"));
                p.setName("color");
                set.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)nodesWrapper, Color.class, "getLabelsColor", "setLabelsColor");
                p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.label.color.text"));
                p.setName("labelcolor");
                set.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)nodesWrapper, Float.class, "getLabelsSize", "setLabelsSize");
                p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.label.size.text"));
                p.setName("labelsize");
                set.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)nodesWrapper, Boolean.class, "getLabelsVisible", "setLabelsVisible");
                p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.label.visible.text"));
                p.setName("labelvisible");
                set.put((Node.Property)p);
                return set;
            }
            Node node = this.nodes[0];
            Sheet.Set set = new Sheet.Set();
            set.setName("properties");
            set.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.properties.text", (Object)node.getLabel()));
            PropertySupport.Reflection p = new PropertySupport.Reflection((Object)node, Float.TYPE, "size", "setSize");
            p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.size.text"));
            p.setName("size");
            set.put((Node.Property)p);
            set.put(this.buildGeneralPositionProperty(node, "x"));
            set.put(this.buildGeneralPositionProperty(node, "y"));
            set.put(this.buildGeneralPositionProperty(node, "z"));
            SingleNodePropertiesWrapper nodeWrapper = new SingleNodePropertiesWrapper(node);
            p = new PropertySupport.Reflection((Object)nodeWrapper, Color.class, "getNodeColor", "setNodeColor");
            p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.color.text"));
            p.setName("color");
            set.put((Node.Property)p);
            TextProperties textProperties = node.getTextProperties();
            p = new PropertySupport.Reflection((Object)textProperties, Float.TYPE, "getSize", "setSize");
            p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.label.size.text"));
            p.setName("labelsize");
            set.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)nodeWrapper, Color.class, "getLabelColor", "setLabelColor");
            p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.label.color.text"));
            p.setName("labelcolor");
            set.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)textProperties, Boolean.TYPE, "isVisible", "setVisible");
            p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.label.visible.text"));
            p.setName("labelvisible");
            set.put((Node.Property)p);
            return set;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private Node.Property buildGeneralPositionProperty(Node node, String coordinate) throws NoSuchMethodException {
        PropertySupport.Reflection p = new PropertySupport.Reflection((Object)node, Float.TYPE, coordinate, "set" + coordinate.toUpperCase());
        p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.position.text", (Object)coordinate));
        p.setName(coordinate);
        return p;
    }

    private Node.Property buildMultipleNodesGeneralPositionProperty(MultipleNodesPropertiesWrapper nodesWrapper, String coordinate) throws NoSuchMethodException {
        PropertySupport.Reflection p = new PropertySupport.Reflection((Object)nodesWrapper, Float.class, "getNodes" + coordinate.toUpperCase(), "setNodes" + coordinate.toUpperCase());
        p.setDisplayName(NbBundle.getMessage(EditNodes.class, (String)"EditNodes.position.text", (Object)coordinate));
        p.setName(coordinate);
        return p;
    }

    public class MultipleNodesPropertiesWrapper {
        private final Node[] nodes;
        private Float nodesX = null;
        private Float nodesY = null;
        private Float nodesZ = null;
        private Float nodesSize = null;
        private Color nodesColor = null;
        private Color labelsColor = null;
        private Float labelsSize = null;
        private Boolean labelsVisible = null;

        public MultipleNodesPropertiesWrapper(Node[] nodes) {
            this.nodes = nodes;
        }

        public Float getNodesX() {
            return this.nodesX;
        }

        public void setNodesX(Float x) {
            this.nodesX = x;
            for (Node node : this.nodes) {
                node.setX(x.floatValue());
            }
        }

        public Float getNodesY() {
            return this.nodesY;
        }

        public void setNodesY(Float y) {
            this.nodesY = y;
            for (Node node : this.nodes) {
                node.setY(y.floatValue());
            }
        }

        public Float getNodesZ() {
            return this.nodesZ;
        }

        public void setNodesZ(Float z) {
            this.nodesZ = z;
            for (Node node : this.nodes) {
                node.setZ(z.floatValue());
            }
        }

        public Color getNodesColor() {
            return this.nodesColor;
        }

        public void setNodesColor(Color c) {
            if (c != null) {
                this.nodesColor = c;
                for (Node node : this.nodes) {
                    node.setR((float)c.getRed() / 255.0f);
                    node.setG((float)c.getGreen() / 255.0f);
                    node.setB((float)c.getBlue() / 255.0f);
                    node.setAlpha((float)c.getAlpha() / 255.0f);
                }
            }
        }

        public Float getNodesSize() {
            return this.nodesSize;
        }

        public void setNodesSize(Float size) {
            this.nodesSize = size;
            for (Node node : this.nodes) {
                node.setSize(size.floatValue());
            }
        }

        public Color getLabelsColor() {
            return this.labelsColor;
        }

        public void setLabelsColor(Color c) {
            if (c != null) {
                this.labelsColor = c;
                for (Node node : this.nodes) {
                    TextProperties textProps = node.getTextProperties();
                    textProps.setR((float)c.getRed() / 255.0f);
                    textProps.setG((float)c.getGreen() / 255.0f);
                    textProps.setB((float)c.getBlue() / 255.0f);
                    textProps.setAlpha((float)c.getAlpha() / 255.0f);
                }
            }
        }

        public Float getLabelsSize() {
            return this.labelsSize;
        }

        public void setLabelsSize(Float size) {
            this.labelsSize = size;
            for (Node node : this.nodes) {
                TextProperties textProps = node.getTextProperties();
                textProps.setSize(size.floatValue());
            }
        }

        public Boolean getLabelsVisible() {
            return this.labelsVisible;
        }

        public void setLabelsVisible(Boolean visible) {
            this.labelsVisible = visible;
            for (Node node : this.nodes) {
                TextProperties textProps = node.getTextProperties();
                textProps.setVisible(visible.booleanValue());
            }
        }
    }

    public class SingleNodePropertiesWrapper {
        private final Node node;

        public SingleNodePropertiesWrapper(Node node) {
            this.node = node;
        }

        public Color getNodeColor() {
            return new Color(this.node.r(), this.node.g(), this.node.b(), this.node.alpha());
        }

        public void setNodeColor(Color c) {
            if (c != null) {
                this.node.setR((float)c.getRed() / 255.0f);
                this.node.setG((float)c.getGreen() / 255.0f);
                this.node.setB((float)c.getBlue() / 255.0f);
                this.node.setAlpha((float)c.getAlpha() / 255.0f);
            }
        }

        public Color getLabelColor() {
            TextProperties textProps = this.node.getTextProperties();
            if (textProps.getAlpha() == 0.0f) {
                return null;
            }
            return textProps.getColor();
        }

        public void setLabelColor(Color c) {
            if (c != null) {
                TextProperties textProps = this.node.getTextProperties();
                textProps.setColor(c);
            }
        }
    }
}

