"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createService = createService;
const binder_js_1 = require("../binder.js");
const checker_js_1 = require("../checker.js");
const index_js_1 = require("../index.js");
const codeAction_js_1 = require("./codeAction.js");
const colorProvider_js_1 = require("./colorProvider.js");
const completion_js_1 = require("./completion.js");
const hover_js_1 = require("./hover.js");
const reference_js_1 = require("./reference.js");
const rename_js_1 = require("./rename.js");
const validation_js_1 = require("./validation.js");
function parseDocument(doc) {
    const parser = new index_js_1.Parser();
    const content = typeof doc === "string" ? doc : doc.getText();
    const sourceFile = parser.parse(content);
    (0, binder_js_1.bindSourceFile)(sourceFile);
    (0, checker_js_1.checkSourceFile)(sourceFile);
    return sourceFile;
}
function createService() {
    return {
        parseDocument,
        validateDocument: validation_js_1.validateDocument,
        hover: hover_js_1.hover,
        findReferences: reference_js_1.findReferences,
        findDefinition: reference_js_1.findDefinition,
        renameSymbol: rename_js_1.renameSymbol,
        getCompletions: completion_js_1.getCompletions,
        getDocumentColors: colorProvider_js_1.getDocumentColors,
        getColorRepresentations: colorProvider_js_1.getColorRepresentations,
        getCodeActions: codeAction_js_1.getCodeActions,
        executeCommand: codeAction_js_1.executeCommand,
        getAvailableCommands: codeAction_js_1.getAvailableCommands,
    };
}
//# sourceMappingURL=service.js.map