/*
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Spicebird code.
#
# The Initial Developer of the Original Code is
#   Prasad Sunkari <prasad@synovel.com>
# Portions created by the Initial Developer are Copyright (C) 2007-2008
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
#
# Alternatively, the contents of this file may be used under the terms of
# either of the GNU General Public License Version 2 or later (the "GPL"),
# or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK ***** 
*/

const gContactsAppName = "contacts";

var contactsAppObserver = {
   observe: function (aSubject, aTopic, aCurrentApp) {
      if (aTopic == "csApplicationSwitched" && aCurrentApp == gContactsAppName)
         this.switchToContacts();
   },
   
   switchToContacts: function() {
       // Restore the previously focused element if any.
       var focusElement = gFocusElements[gContactsAppName];
       if (!focusElement)
           focusElement = document.getElementById("abResultsTree");
       focusElement.focus();

       CommandUpdate_AddressBook();
   },
}

// Enable app status in appInfo component
var contactsAppInfoClass = Components.classes["@synovel.com/collab/contacts-appinfo;1"];
if (contactsAppInfoClass) {
    var contactsAppInfo = contactsAppInfoClass.getService(Components.interfaces.csIAppInfo);
    if (contactsAppInfo)
        contactsAppInfo.enabled = true;
}

function OnLoadCollabAddressBook () {
    var tabcollab = document.getElementById ("tabcollab");
    var newTab = tabcollab.addTab (30);
    var StringBundle = document.getElementById("bundle_collab");
    newTab.setAttribute ("label", StringBundle.getString("contactsTitle"));

    newTab.setAttribute ("onselect", "setCurrentApp('" + gContactsAppName + "')");
    newTab.setAttribute ("image", "chrome://messenger/skin/addressbook/16x16/x-office-address-book.png");
    newTab.setAttribute ("type", "contacts");
    newTab.setAttribute ("id", "tab-contacts");
    newTab.setAttribute ("linkedpanel", "tabpanel-contacts");

    var controllers = getLinkedTabPanel(newTab).controllers;
    controllers.appendController(AddressBookController);
    controllers.appendController(imController);

    gObserverService.addObserver(contactsAppObserver, "csApplicationSwitched", false)
    OnLoadAddressBook ();
}

addEventListener("load", OnLoadCollabAddressBook, true);
