#! /bin/bash
# Copyright 2020 Yann MRN
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.


######################### CHECK INTERNET CONNECTION ####################
check_internet_connection() {
[[ "$DISABLEWEBCHECK" ]] || [[ "$(ping -c1 google.com)" ]] && INTERNET=connected || INTERNET=no-internet
#[[ "$(wget -T $WGETTIM -q -O - checkip.dyndns.org)" =~ "Current IP Address:" ]]
[[ "$DEBBUG" ]] && echo "[debug]internet: $INTERNET"
}

ask_internet_connection() {
if [[ "$INTERNET" != connected ]];then
    if [[ ! "$FORCEYES" ]];then
        if [[ "$GUI" ]];then
            end_pulse
            zenity --width=400 --info --title="$APPNAME2" --text="$Please_connect_internet $Then_close_this_window" 2>/dev/null
            start_pulse
        else
            read -r -p "$Please_connect_internet [Enter]"
        fi
    fi
	check_internet_connection
fi
}

exit_as_packagelist_is_missing() {
end_pulse
update_translations
echo "$please_install_PACKAGELIST"
[[ "$TMP_FOLDER_TO_BE_CLEARED" ]] && rm -r $TMP_FOLDER_TO_BE_CLEARED
choice=exit; [[ "$GUI" ]] && echo 'EXIT@@' || exit 0
}

################################# CRYPT ##################################
#propose_decrypt() {
#BLKID=$(blkid)
#FUNCTION=LUKS PACKAGELIST=ecryptfs-utils FILETOTEST=ecryptfsd
#if [[ "$(echo "$BLKID" | grep -i crypt | grep -vi swap )" ]];then
#	update_translations
#	text="$Encryption_detected $You_may_want_to_retry_after_installing_PACKAGELIST"
#	echo "$text"
#	end_pulse
#	zenity --width=400 --info --title="$APPNAME2" --text="$text" 2>/dev/null
#	[[ ! "$(type -p $FILETOTEST)" ]] && installpackagelist
#	start_pulse
#	text="$You_may_want_decrypt ($Decrypt_links)"
#fi
	
#apt-get install lvm2 cryptsetup; sudo modprobe dm-crypt; sudo cryptsetup luksOpen /dev/sda5 crypt1 ;sudo vgscan --mknodes; sudo vgscan --mknodes
#http://ubuntuforums.org/showthread.php?p=4530641



################################# LVM ##################################
activate_lvm_if_needed() {
#works: http://paste.ubuntu.com/1004461
local FUNCTION=LVM PACKAGELIST=lvm2 FILETOTEST=vgchange
BLKID=$(blkid)
ECHO_LVM_RAID_PREPAR=""
if [[ "$DISTRIB_DESCRIPTION" =~ Unknown ]] || [[ "$(lsb_release -cs)" =~ squeeze ]] && [[ "$BLKID" =~ LVM ]];then
	FUNCTION=LVM; FUNCTION44=LVM; DISK44="Boot-Repair-Disk (www.sourceforge.net/p/boot-repair-cd/home)"; update_translations
	end_pulse
    echo "$FUNCTION_detected $Please_use_DISK44_which_is_FUNCTION44_ok"
	[[ "$GUI" ]] && zenity --width=400 --info --title="$APPNAME2" --text="$FUNCTION_detected $Please_use_DISK44_which_is_FUNCTION44_ok" 2>/dev/null
	choice=exit
elif [[ "$BLKID" =~ LVM ]];then
	BEFLVMBLKID="$BLKID"
	[[ ! "$(type -p $FILETOTEST)" ]] && installpackagelist
	if [[ ! "$(type -p $FILETOTEST)" ]];then
        choice=exit
    else
        if [[ "$DEBBUG" ]];then
            title_gen "blkid (filtered) before lvm activation"
            while read line; do
                [[ "$line" ]] && [[ ! "$line" =~ squashfs ]] && [[ "$DEBBUG" ]] && echo "$line"
            done < <(blkid)
        fi
        # Not sure if modprobe and vgscan are necessary
        ECHO_LVM_RAID_PREPAR="$(title_gen "LVM activation")

modprobe dm-mod  $(modprobe dm-mod)
vgscan --mknodes
$(vgscan --mknodes)
vgchange -ay
$(vgchange -ay)
lvscan
$(LANGUAGE=C LC_ALL=C lvscan)
blkid -g
$(blkid -g)"
        BLKID=$(blkid)
        [[ "$BEFLVMBLKID" != "$BLKID" ]] && ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
Successfully activated LVM."
    fi
fi
}

################################# RAID #################################
activate_raid_if_needed() {
raiduser=no
if [[ "$DISTRIB_DESCRIPTION" =~ Unknown ]] || [[ "$(lsb_release -cs)" =~ squeeze ]] && [[ "$BLKID" =~ raid ]];then #|| [[ "$DISTRIB_DESCRIPTION" =~ Boot-Repair-Disk ]]
	FUNCTION=RAID; FUNCTION44=RAID; DISK44="Boot-Repair-Disk (www.sourceforge.net/p/boot-repair-cd/home)"; update_translations
	end_pulse
    echo "$FUNCTION_detected $Please_use_DISK44_which_is_FUNCTION44_ok"
	[[ "$GUI" ]] && zenity --width=400 --info --title="$APPNAME2" --text="$FUNCTION_detected $Please_use_DISK44_which_is_FUNCTION44_ok" 2>/dev/null
	choice=exit
elif [[ "$BLKID" =~ raid ]] || [[ "$(echo "$BLKID" | grep /dev/mapper/ | grep -v swap  | grep -vi LVM)" ]];then
	raiduser=yes
	if [[ ! "$BLKID" =~ raid ]];then
        if [[ ! "$FORCEYES" ]];then
            if [[ "$GUI" ]];then
                end_pulse
                zenity --width=400 --question --title="$APPNAME2" --text="$Is_there_RAID_on_this_pc" 2>/dev/null || raiduser=no
            else
                read -r -p "$Is_there_RAID_on_this_pc [yes/no] " response
                [[ ! "$response" =~ y ]] && raiduser=no
            fi
        fi
        [[ "$DEBBUG" ]] && echo "$Is_there_RAID_on_this_pc $raiduser"
        USERCHOICES="$USERCHOICES
Is there RAID on this computer? $raiduser"
		[[ "$raiduser" = yes ]] && ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
Unusual RAID (no raid in blkid)." #zenity --width=400 --warning --title="$APPNAME2" --text="Unusual RAID. $PLEASECONTACT" 2>/dev/null
		start_pulse
	fi
	if [[ "$raiduser" = yes ]];then
		local FUNCTION=RAID PACKAGELIST=mdadm; FILETOTEST=mdadm removedmraid=yes
		DMRAID=""
		MD_ARRAY=""
		BEFRAIDBLKID="$BLKID"
        ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
$(title_gen "blkid (filtered) before raid activation:")"
        while read line; do
            [[ "$line" ]] && [[ ! "$line" =~ squashfs ]] && ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
$line"
        done < <(blkid)
		[[ "$(type -p dmraid)" ]] && INIT_DMR=y || INIT_DMR=""
		if [[ "$INIT_DMR" ]];then
			assemble_dmraid
			[[ ! "$DMRAID" ]] && propose_remove_dmraid #mdadm & dmraid interfere: https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=534274
		fi
		[[ ! "$(type -p mdadm)" ]] && installpackagelist
		assemble_mdadm #software raid
		if [[ ! "$INIT_DMR" ]] && [[ ! "$MD_ARRAY" ]];then
			[[ "$(type -p mdadm)" ]] && PACKAGELIST=dmraid || PACKAGELIST="dmraid/mdadm"
			update_translations
			text="$FUNCTION_detected $You_may_want_to_retry_after_installing_PACKAGELIST"
			ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
$text"
			end_pulse
			[[ "$GUI" ]] && zenity --width=400 --info --title="$APPNAME2" --text="$text" 2>/dev/null
			start_pulse
		fi
		[[ ! "$INIT_DMR" ]] && assemble_dmraid
		
		[[ "$DEBBUG" ]] && echo "[debug]$(type -p dmraid) , MDADM $(type -p mdadm)"
		[[ "$BLKID" =~ raid ]] || [[ ! "$BLKID" =~ LVM ]] && [[ ! "$(type -p dmraid)" ]] && [[ ! "$(type -p mdadm)" ]] && choice=exit
		if [[ ! "$DMRAID" ]] && [[ ! "$MD_ARRAY" ]] && [[ "$choice" != exit ]];then
			ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
Warning: no active raid (DMRAID nor MD_ARRAY)."
			[[ ! "$BLKID" =~ LVM ]] && ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
No active RAID." && [[ "$GUI" ]] && zenity --width=400 --warning --text="No active RAID." 2>/dev/null
		fi
		BLKID=$(blkid)
		[[ "$BEFRAIDBLKID" != "$BLKID" ]] && ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
Successfully activated RAID."
	fi
fi
}

propose_remove_dmraid() {
if [[ "$(type -p dmraid)" ]] && [[ "$APPNAME" =~ re ]];then	#http://ubuntuforums.org/showthread.php?t=1551087
    if [[ ! "$FORCEYES" ]];then
        if [[ "$GUI" ]];then
            end_pulse
            zenity --width=400 --question --title="$APPNAME2" --text="$dmraid_may_interfere_MDraid_remove" 2>/dev/null || removedmraid=no
            start_pulse
        else
            read -r -p "$dmraid_may_interfere_MDraid_remove [yes/no] " response
            [[ ! "$response" =~ y ]] && removedmraid=no
        fi
    fi
	[[ "$DEBBUG" ]] && echo "$dmraid_may_interfere_MDraid_remove $removedmraid"
    USERCHOICES="$USERCHOICES
[dmraid] packages may interfere with MDraid. Do you want to remove them? $removedmraid"
	if [[ "$removedmraid" = no ]];then
		ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
User chose to keep dmraid. It may interfere with mdadm."
	else
		ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
$PACKMAN remove $PACKYES dmraid
$($PACKMAN remove $PACKYES dmraid)"
		if [[ "$(type -p mdadm)" ]];then
			text="It is now recommended to reinstall mdadm. Please continue when done."
            if [[ ! "$FORCEYES" ]];then
                if [[ "$GUI" ]];then
                    echo "$text"
                    end_pulse
                    zenity --width=400 --info --title="$APPNAME2" --text="$text" 2>/dev/null
                    start_pulse
                else
                    read -r -p "$text [Enter]"
                fi
            else
                ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
It is recommended to reinstall mdadm after removing dmraid. You can check in interactive mode."
            fi
		fi
	fi
fi
}

assemble_dmraid() {
if [[ "$(type -p dmraid)" ]];then
	#end_pulse
	#zenity --width=400 --question --title="$APPNAME2" --text="${FUNCTION_detected} ${activate_dmraid} (dmraid -ay; dmraid -sa -c)" 2>/dev/null || dmraidenable="no"
	#start_pulse
	#if [[ ! "$dmraidenable" ]]; then
		DMRAID="$(dmraid -si -c)"
		ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
dmraid -si -c
$DMRAID"
		if [[ "$DMRAID" =~ "no raid disk" ]];then
			DMRAID=""
			ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
No DMRAID disk."
		else
			ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
dmraid -ay:
$(dmraid -ay)"	#Activate RAID
			DMRAID="$(dmraid -sa -c)"
			ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
dmraid -sa -c:
$DMRAID"	#e.g. isw_bcbggbcebj_ARRAY (http://paste.ubuntu.com/1055404)
		fi
	#fi
fi
}	

assemble_mdadm() {
if [[ "$(type -p mdadm)" ]];then
    #Assemble all arrays
	ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
mdadm --assemble --scan
$(mdadm --assemble --scan)"
	# All arrays.
	MD_ARRAY=$(mdadm --detail --scan) #TODO  | ${AWK} '{ print $2 }')
	ECHO_LVM_RAID_PREPAR="$ECHO_LVM_RAID_PREPAR
mdadm --detail --scan
$MD_ARRAY"
	#for MD in ${MD_ARRAY}; do
	#	MD_SIZE=$(fdisks ${MD})     # size in blocks
	#	MD_SIZE=$((2*${MD_SIZE}))   # size in sectors
	#	MDNAME=${MD:5}
	#	MDMOUNTNAME="MDRaid/${name}"
	#	echo "MD${MD}: ${MDNAME}, ${MDMOUNTNAME}, ${MD_SIZE}"
	#done
fi
}
