function test10_compare (op, C1, C2, tol)
%TEST10_COMPARE check results for test10
%
% Compare results for test10, results from unary operators.
% Usage: test10_compare (op, C1, C2, tol) ;
%
% acos, asin, and other a* trig functions can return different but valid
% results.

% SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2020, All Rights Reserved.
% http://suitesparse.com   See GraphBLAS/Doc/License.txt for license.

C1 = GB_spec_matrix (C1, 0) ;
C2 = GB_spec_matrix (C2, 0) ;
assert (isequal (C1.pattern, C2.pattern)) ;

[i,j,x] = find (C2.matrix) ;
[m,n] = size (C2.matrix) ;
x = ones (size (x)) ;
S = sparse (i,j,x,m,n) ;

C1.matrix = double (C1.matrix) ;
if (isequal (C1.class, 'single complex'))
    C1.class = 'double complex' ;
else
    C1.class = 'double' ;
end

C2.matrix = double (C2.matrix) ;
if (isequal (C2.class, 'single complex'))
    C2.class = 'double complex' ;
else
    C2.class = 'double' ;
end

switch (op.opname)

    case { 'acos' }
        C1.matrix = cos (C1.matrix) .* S ;
        C2.matrix = cos (C2.matrix) .* S ;
        GB_spec_compare (C1, C2, 0, tol) ;

    case { 'asin' }
        C1.matrix = sin (C1.matrix) .* S ;
        C2.matrix = sin (C2.matrix) .* S ;
        GB_spec_compare (C1, C2, 0, tol) ;

    case { 'atan' }
        C1.matrix = tan (C1.matrix) .* S ;
        C2.matrix = tan (C2.matrix) .* S ;
        GB_spec_compare (C1, C2, 0, tol) ;

    case { 'acosh' }
        C1.matrix = cosh (C1.matrix) .* S ;
        C2.matrix = cosh (C2.matrix) .* S ;
        GB_spec_compare (C1, C2, 0, tol) ;

    case { 'asinh' }
        C1.matrix = sinh (C1.matrix) .* S ;
        C2.matrix = sinh (C2.matrix) .* S ;
        GB_spec_compare (C1, C2, 0, tol) ;

    case { 'atanh' }
        C1.matrix = tanh (C1.matrix) .* S ;
        C2.matrix = tanh (C2.matrix) .* S ;
        GB_spec_compare (C1, C2, 0, tol) ;

    otherwise
        GB_spec_compare (C1, C2, 0, tol) ;
end

