% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-build.R
\name{ggplot_build}
\alias{ggplot_build}
\alias{get_layer_data}
\alias{layer_data}
\alias{get_panel_scales}
\alias{layer_scales}
\alias{get_layer_grob}
\alias{layer_grob}
\title{Build ggplot for rendering.}
\usage{
ggplot_build(plot, ...)

get_layer_data(plot = get_last_plot(), i = 1L)

layer_data(plot = get_last_plot(), i = 1L)

get_panel_scales(plot = get_last_plot(), i = 1L, j = 1L)

layer_scales(plot = get_last_plot(), i = 1L, j = 1L)

get_layer_grob(plot = get_last_plot(), i = 1L)

layer_grob(plot = get_last_plot(), i = 1L)
}
\arguments{
\item{plot}{ggplot object}

\item{...}{Not currently in use.}

\item{i}{An integer. In \code{get_layer_data()}, the data to return (in the order added to the
plot). In \code{get_layer_grob()}, the grob to return (in the order added to the
plot). In \code{get_panel_scales()}, the row of a facet to return scales for.}

\item{j}{An integer. In \code{get_panel_scales()}, the column of a facet to return
scales for.}
}
\description{
\code{build_ggplot()} takes the plot object, and performs all steps necessary
to produce an object that can be rendered.  This function outputs two pieces:
a list of data frames (one for each layer), and a panel object, which
contain all information about axis limits, breaks etc. The \code{ggplot_build()}
function is vestigial and \code{build_ggplot()} should be used instead.
}
\details{
\code{get_layer_data()}, \code{get_layer_grob()}, and \code{get_panel_scales()} are helper
functions that return the data, grob, or scales associated with a given
layer. These are useful for tests.
}
\seealso{
\code{\link[=print.ggplot]{print.ggplot()}} and \code{\link[=benchplot]{benchplot()}} for
functions that contain the complete set of steps for generating
a ggplot2 plot.

The \href{https://ggplot2-book.org/internals#sec-ggplotbuild}{build step section} of the online ggplot2 book.
}
\keyword{internal}
