% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rule}
\alias{rule}
\title{Make a rule with one or two text labels}
\usage{
rule(
  left = "",
  center = "",
  right = "",
  line = 1,
  col = NULL,
  line_col = col,
  background_col = NULL,
  width = console_width()
)
}
\arguments{
\item{left}{Label to show on the left. It interferes with the \code{center}
label, only at most one of them can be present.}

\item{center}{Label to show at the center. It interferes  with the
\code{left} and \code{right} labels.}

\item{right}{Label to show on the right. It interferes with the \code{center}
label, only at most one of them can be present.}

\item{line}{The character or string that is used to draw the line.
It can also \code{1} or \code{2}, to request a single line (Unicode, if
available), or a double line. Some strings are interpreted specially,
see \emph{Line styles} below.}

\item{col}{Color of text, and default line color. Either an ANSI style
function (see \link[=ansi-styles]{ANSI styles}), or a color name that is
passed to \code{\link[=make_ansi_style]{make_ansi_style()}}.}

\item{line_col, background_col}{Either a color name (used in
\code{\link[=make_ansi_style]{make_ansi_style()}}), or a style function (see
\link[=ansi-styles]{ANSI styles}), to color the line and background.}

\item{width}{Width of the rule. Defaults to the \code{width} option, see
\code{\link[base:options]{base::options()}}.}
}
\value{
Character scalar, the rule.
}
\description{
The rule can include either a centered text label, or labels on the
left and right side.

To color the labels, use the functions \verb{col_*}, \verb{bg_*} and \verb{style_*}
functions, see \link[=ansi-styles]{ANSI styles}, and the examples below.
To color the line, either these functions directly, or the \code{line_col}
option.
}
\details{
\subsection{Simple rule}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ──────────────────────────────────────────────────────────────────────          
</pre></div>
}}

}

\subsection{Line styles}{

Some strings for the \code{line} argument are interpreted specially:
\itemize{
\item \code{"single"}: (same as \code{1}), a single line,
\item \code{"double"}: (same as \code{2}), a double line,
\item \code{"bar1"}, \code{"bar2"}, \code{"bar3"}, etc., \code{"bar8"} uses varying height bars.
}
\subsection{Double rule}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule(line = 2)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ══════════════════════════════════════════════════════════════════════          
</pre></div>
}}

}

\subsection{Bars}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule(line = "bar2")
rule(line = "bar5")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂          
#> ▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅▅          
</pre></div>
}}

}

\subsection{Custom lines}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule(center = "TITLE", line = "~")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ TITLE ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~          
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule(center = "TITLE", line = col_blue("~-"))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #268BD2;">~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-</span> TITLE <span style="color: #268BD2;">~-~-~-~-~-~-~-~-~-~-~-~-~-~-~-~</span>          
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule(center = bg_red(" ", symbol$star, "TITLE",
  symbol$star, " "),
  line = "\\u2582",
  line_col = "orange")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #ff9900;">▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂</span> <span style="background-color: #DC322F;"> ★TITLE★ </span> <span style="color: #ff9900;">▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂▂</span>          
</pre></div>
}}

}

}

\subsection{Left label}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule(left = "Results")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ── Results ───────────────────────────────────────────────────────────          
</pre></div>
}}

}

\subsection{Centered label}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule(center = " * RESULTS * ")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ────────────────────────────  * RESULTS *  ───────────────────────────          
</pre></div>
}}

}

\subsection{Colored labels}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule(center = col_red(" * RESULTS * "))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ──────────────────────────── <span style="color: #DC322F;"> * RESULTS * </span> ───────────────────────────          
</pre></div>
}}

}

\subsection{Colored line}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rule(center = col_red(" * RESULTS * "), line_col = "red")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #DC322F;">────────────────────────────</span> <span style="color: #DC322F;"> * RESULTS * </span> <span style="color: #DC322F;">───────────────────────────</span>          
</pre></div>
}}

}
}
