/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
 
package org.apache.jdo.tck.pc.fieldtypes;

import java.io.Serializable;

public class FieldsOfPrimitivedouble { 
  public int identifier;
  private double double0;
  private double double1;
  private double double2;
  private double double3;
  private double double4;
  private double double5;
  private double double6;
  private double double7;
  private static double double8;
  private transient double double9;
  private transient double double10;
  private transient double double11;
  private transient double double12;
  private transient double double13;
  private transient double double14;
  private final double double15 = 5;
  private volatile double double16;
  private volatile double double17;
  private volatile double double18;
  private volatile double double19;
  private volatile double double20;
  private volatile double double21;
  private volatile double double22;
  private volatile double double23;
  private static transient double double24;
  private static final double double25 = 5;
  private static volatile double double26;
  private transient final double double27 = 5;
  private transient volatile double double28;
  private transient volatile double double29;
  private transient volatile double double30;
  private transient volatile double double31;
  private transient volatile double double32;
  private transient volatile double double33;
  private static transient final double double34 = 5;
  private static transient volatile double double35;
  public double double36;
  public double double37;
  public double double38;
  public double double39;
  public double double40;
  public double double41;
  public double double42;
  public double double43;
  public static double double44;
  public transient double double45;
  public transient double double46;
  public transient double double47;
  public transient double double48;
  public transient double double49;
  public transient double double50;
  public final double double51 = 5;
  public volatile double double52;
  public volatile double double53;
  public volatile double double54;
  public volatile double double55;
  public volatile double double56;
  public volatile double double57;
  public volatile double double58;
  public volatile double double59;
  public static transient double double60;
  public static final double double61 = 5;
  public static volatile double double62;
  public transient final double double63 = 5;
  public transient volatile double double64;
  public transient volatile double double65;
  public transient volatile double double66;
  public transient volatile double double67;
  public transient volatile double double68;
  public transient volatile double double69;
  public static transient final double double70 = 5;
  public static transient volatile double double71;
  protected double double72;
  protected double double73;
  protected double double74;
  protected double double75;
  protected double double76;
  protected double double77;
  protected double double78;
  protected double double79;
  protected static double double80;
  protected transient double double81;
  protected transient double double82;
  protected transient double double83;
  protected transient double double84;
  protected transient double double85;
  protected transient double double86;
  protected final double double87 = 5;
  protected volatile double double88;
  protected volatile double double89;
  protected volatile double double90;
  protected volatile double double91;
  protected volatile double double92;
  protected volatile double double93;
  protected volatile double double94;
  protected volatile double double95;
  protected static transient double double96;
  protected static final double double97 = 5;
  protected static volatile double double98;
  protected transient final double double99 = 5;
  protected transient volatile double double100;
  protected transient volatile double double101;
  protected transient volatile double double102;
  protected transient volatile double double103;
  protected transient volatile double double104;
  protected transient volatile double double105;
  protected static transient final double double106 = 5;
  protected static transient volatile double double107;
  double double108;
  double double109;
  double double110;
  double double111;
  double double112;
  double double113;
  double double114;
  double double115;
  static double double116;
  transient double double117;
  transient double double118;
  transient double double119;
  transient double double120;
  transient double double121;
  transient double double122;
  final double double123 = 5;
  volatile double double124;
  volatile double double125;
  volatile double double126;
  volatile double double127;
  volatile double double128;
  volatile double double129;
  volatile double double130;
  volatile double double131;
  static transient double double132;
  static final double double133 = 5;
  static volatile double double134;
  transient final double double135 = 5;
  transient volatile double double136;
  transient volatile double double137;
  transient volatile double double138;
  transient volatile double double139;
  transient volatile double double140;
  transient volatile double double141;
  static transient final double double142 = 5;
  static transient volatile double double143;

public static final boolean [] isPersistent = { 
true,true,true,false,true,true,true,false,false,false,
false,true,true,true,false,false,true,true,true,false,
true,true,true,false,false,false,false,false,false,false,
true,true,true,false,false,false,true,true,true,false,
true,true,true,false,false,false,false,true,true,true,
false,false,true,true,true,false,true,true,true,false,
false,false,false,false,false,false,true,true,true,false,
false,false,true,true,true,false,true,true,true,false,
false,false,false,true,true,true,false,false,true,true,
true,false,true,true,true,false,false,false,false,false,
false,false,true,true,true,false,false,false,true,true,
true,false,true,true,true,false,false,false,false,true,
true,true,false,false,true,true,true,false,true,true,
true,false,false,false,false,false,false,false,true,true,
true,false,false,false
 };

public static final boolean [] isStatic = { 
false,false,false,false,false,false,false,false,true,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,true,true,true,false,false,false,
false,false,false,false,true,true,false,false,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
true,true,true,false,false,false,false,false,false,false,
true,true,false,false,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,true,true,true,false,
false,false,false,false,false,false,true,true,false,false,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,true,true,true,false,false,false,false,false,
false,false,true,true
 };

public static final boolean [] isFinal = { 
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,true,false,false,false,false,
false,false,false,false,false,true,false,true,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,true,false,false,false,false,false,false,false,false,
false,true,false,true,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,false,true,false,false,
false,false,false,false,false,false,false,true,false,true,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,true,false,false,false,false,false,false,
false,false,false,true,false,true,false,false,false,false,
false,false,true,false
 };

  public static final String [] fieldSpecs = { 
  "private double double0",
  "embedded= true   private double double1",
  "embedded= false   private double double2",
  "persistence-modifier= none    private double double3",
  "persistence-modifier= persistent    private double double4",
  "persistence-modifier= persistent  embedded= true   private double double5",
  "persistence-modifier= persistent  embedded= false   private double double6",
  "persistence-modifier= transactional    private double double7",
  "private static double double8",
  "private transient double double9",
  "persistence-modifier= none    private transient double double10",
  "persistence-modifier= persistent    private transient double double11",
  "persistence-modifier= persistent  embedded= true   private transient double double12",
  "persistence-modifier= persistent  embedded= false   private transient double double13",
  "persistence-modifier= transactional    private transient double double14",
  "private final double double15",
  "private volatile double double16",
  "embedded= true   private volatile double double17",
  "embedded= false   private volatile double double18",
  "persistence-modifier= none    private volatile double double19",
  "persistence-modifier= persistent    private volatile double double20",
  "persistence-modifier= persistent  embedded= true   private volatile double double21",
  "persistence-modifier= persistent  embedded= false   private volatile double double22",
  "persistence-modifier= transactional    private volatile double double23",
  "private static transient double double24",
  "private static final double double25",
  "private static volatile double double26",
  "private transient final double double27",
  "private transient volatile double double28",
  "persistence-modifier= none    private transient volatile double double29",
  "persistence-modifier= persistent    private transient volatile double double30",
  "persistence-modifier= persistent  embedded= true   private transient volatile double double31",
  "persistence-modifier= persistent  embedded= false   private transient volatile double double32",
  "persistence-modifier= transactional    private transient volatile double double33",
  "private static transient final double double34",
  "private static transient volatile double double35",
  "public double double36",
  "embedded= true   public double double37",
  "embedded= false   public double double38",
  "persistence-modifier= none    public double double39",
  "persistence-modifier= persistent    public double double40",
  "persistence-modifier= persistent  embedded= true   public double double41",
  "persistence-modifier= persistent  embedded= false   public double double42",
  "persistence-modifier= transactional    public double double43",
  "public static double double44",
  "public transient double double45",
  "persistence-modifier= none    public transient double double46",
  "persistence-modifier= persistent    public transient double double47",
  "persistence-modifier= persistent  embedded= true   public transient double double48",
  "persistence-modifier= persistent  embedded= false   public transient double double49",
  "persistence-modifier= transactional    public transient double double50",
  "public final double double51",
  "public volatile double double52",
  "embedded= true   public volatile double double53",
  "embedded= false   public volatile double double54",
  "persistence-modifier= none    public volatile double double55",
  "persistence-modifier= persistent    public volatile double double56",
  "persistence-modifier= persistent  embedded= true   public volatile double double57",
  "persistence-modifier= persistent  embedded= false   public volatile double double58",
  "persistence-modifier= transactional    public volatile double double59",
  "public static transient double double60",
  "public static final double double61",
  "public static volatile double double62",
  "public transient final double double63",
  "public transient volatile double double64",
  "persistence-modifier= none    public transient volatile double double65",
  "persistence-modifier= persistent    public transient volatile double double66",
  "persistence-modifier= persistent  embedded= true   public transient volatile double double67",
  "persistence-modifier= persistent  embedded= false   public transient volatile double double68",
  "persistence-modifier= transactional    public transient volatile double double69",
  "public static transient final double double70",
  "public static transient volatile double double71",
  "protected double double72",
  "embedded= true   protected double double73",
  "embedded= false   protected double double74",
  "persistence-modifier= none    protected double double75",
  "persistence-modifier= persistent    protected double double76",
  "persistence-modifier= persistent  embedded= true   protected double double77",
  "persistence-modifier= persistent  embedded= false   protected double double78",
  "persistence-modifier= transactional    protected double double79",
  "protected static double double80",
  "protected transient double double81",
  "persistence-modifier= none    protected transient double double82",
  "persistence-modifier= persistent    protected transient double double83",
  "persistence-modifier= persistent  embedded= true   protected transient double double84",
  "persistence-modifier= persistent  embedded= false   protected transient double double85",
  "persistence-modifier= transactional    protected transient double double86",
  "protected final double double87",
  "protected volatile double double88",
  "embedded= true   protected volatile double double89",
  "embedded= false   protected volatile double double90",
  "persistence-modifier= none    protected volatile double double91",
  "persistence-modifier= persistent    protected volatile double double92",
  "persistence-modifier= persistent  embedded= true   protected volatile double double93",
  "persistence-modifier= persistent  embedded= false   protected volatile double double94",
  "persistence-modifier= transactional    protected volatile double double95",
  "protected static transient double double96",
  "protected static final double double97",
  "protected static volatile double double98",
  "protected transient final double double99",
  "protected transient volatile double double100",
  "persistence-modifier= none    protected transient volatile double double101",
  "persistence-modifier= persistent    protected transient volatile double double102",
  "persistence-modifier= persistent  embedded= true   protected transient volatile double double103",
  "persistence-modifier= persistent  embedded= false   protected transient volatile double double104",
  "persistence-modifier= transactional    protected transient volatile double double105",
  "protected static transient final double double106",
  "protected static transient volatile double double107",
  "double double108",
  "embedded= true   double double109",
  "embedded= false   double double110",
  "persistence-modifier= none    double double111",
  "persistence-modifier= persistent    double double112",
  "persistence-modifier= persistent  embedded= true   double double113",
  "persistence-modifier= persistent  embedded= false   double double114",
  "persistence-modifier= transactional    double double115",
  "static double double116",
  "transient double double117",
  "persistence-modifier= none    transient double double118",
  "persistence-modifier= persistent    transient double double119",
  "persistence-modifier= persistent  embedded= true   transient double double120",
  "persistence-modifier= persistent  embedded= false   transient double double121",
  "persistence-modifier= transactional    transient double double122",
  "final double double123",
  "volatile double double124",
  "embedded= true   volatile double double125",
  "embedded= false   volatile double double126",
  "persistence-modifier= none    volatile double double127",
  "persistence-modifier= persistent    volatile double double128",
  "persistence-modifier= persistent  embedded= true   volatile double double129",
  "persistence-modifier= persistent  embedded= false   volatile double double130",
  "persistence-modifier= transactional    volatile double double131",
  "static transient double double132",
  "static final double double133",
  "static volatile double double134",
  "transient final double double135",
  "transient volatile double double136",
  "persistence-modifier= none    transient volatile double double137",
  "persistence-modifier= persistent    transient volatile double double138",
  "persistence-modifier= persistent  embedded= true   transient volatile double double139",
  "persistence-modifier= persistent  embedded= false   transient volatile double double140",
  "persistence-modifier= transactional    transient volatile double double141",
  "static transient final double double142",
  "static transient volatile double double143"
  };
  public int getLength()
  {
    return fieldSpecs.length;
  }
  public double get(int index)
  {
    switch (index)
    {
      case(0):
        return double0;
      case(1):
        return double1;
      case(2):
        return double2;
      case(3):
        return double3;
      case(4):
        return double4;
      case(5):
        return double5;
      case(6):
        return double6;
      case(7):
        return double7;
      case(8):
        return double8;
      case(9):
        return double9;
      case(10):
        return double10;
      case(11):
        return double11;
      case(12):
        return double12;
      case(13):
        return double13;
      case(14):
        return double14;
      case(15):
        return double15;
      case(16):
        return double16;
      case(17):
        return double17;
      case(18):
        return double18;
      case(19):
        return double19;
      case(20):
        return double20;
      case(21):
        return double21;
      case(22):
        return double22;
      case(23):
        return double23;
      case(24):
        return double24;
      case(25):
        return double25;
      case(26):
        return double26;
      case(27):
        return double27;
      case(28):
        return double28;
      case(29):
        return double29;
      case(30):
        return double30;
      case(31):
        return double31;
      case(32):
        return double32;
      case(33):
        return double33;
      case(34):
        return double34;
      case(35):
        return double35;
      case(36):
        return double36;
      case(37):
        return double37;
      case(38):
        return double38;
      case(39):
        return double39;
      case(40):
        return double40;
      case(41):
        return double41;
      case(42):
        return double42;
      case(43):
        return double43;
      case(44):
        return double44;
      case(45):
        return double45;
      case(46):
        return double46;
      case(47):
        return double47;
      case(48):
        return double48;
      case(49):
        return double49;
      case(50):
        return double50;
      case(51):
        return double51;
      case(52):
        return double52;
      case(53):
        return double53;
      case(54):
        return double54;
      case(55):
        return double55;
      case(56):
        return double56;
      case(57):
        return double57;
      case(58):
        return double58;
      case(59):
        return double59;
      case(60):
        return double60;
      case(61):
        return double61;
      case(62):
        return double62;
      case(63):
        return double63;
      case(64):
        return double64;
      case(65):
        return double65;
      case(66):
        return double66;
      case(67):
        return double67;
      case(68):
        return double68;
      case(69):
        return double69;
      case(70):
        return double70;
      case(71):
        return double71;
      case(72):
        return double72;
      case(73):
        return double73;
      case(74):
        return double74;
      case(75):
        return double75;
      case(76):
        return double76;
      case(77):
        return double77;
      case(78):
        return double78;
      case(79):
        return double79;
      case(80):
        return double80;
      case(81):
        return double81;
      case(82):
        return double82;
      case(83):
        return double83;
      case(84):
        return double84;
      case(85):
        return double85;
      case(86):
        return double86;
      case(87):
        return double87;
      case(88):
        return double88;
      case(89):
        return double89;
      case(90):
        return double90;
      case(91):
        return double91;
      case(92):
        return double92;
      case(93):
        return double93;
      case(94):
        return double94;
      case(95):
        return double95;
      case(96):
        return double96;
      case(97):
        return double97;
      case(98):
        return double98;
      case(99):
        return double99;
      case(100):
        return double100;
      case(101):
        return double101;
      case(102):
        return double102;
      case(103):
        return double103;
      case(104):
        return double104;
      case(105):
        return double105;
      case(106):
        return double106;
      case(107):
        return double107;
      case(108):
        return double108;
      case(109):
        return double109;
      case(110):
        return double110;
      case(111):
        return double111;
      case(112):
        return double112;
      case(113):
        return double113;
      case(114):
        return double114;
      case(115):
        return double115;
      case(116):
        return double116;
      case(117):
        return double117;
      case(118):
        return double118;
      case(119):
        return double119;
      case(120):
        return double120;
      case(121):
        return double121;
      case(122):
        return double122;
      case(123):
        return double123;
      case(124):
        return double124;
      case(125):
        return double125;
      case(126):
        return double126;
      case(127):
        return double127;
      case(128):
        return double128;
      case(129):
        return double129;
      case(130):
        return double130;
      case(131):
        return double131;
      case(132):
        return double132;
      case(133):
        return double133;
      case(134):
        return double134;
      case(135):
        return double135;
      case(136):
        return double136;
      case(137):
        return double137;
      case(138):
        return double138;
      case(139):
        return double139;
      case(140):
        return double140;
      case(141):
        return double141;
      case(142):
        return double142;
      case(143):
        return double143;
      default:
        throw new IndexOutOfBoundsException();
    }
  }
  public boolean set(int index,double value)
  {
    if(fieldSpecs[index].indexOf("final") != -1)
      return false;
    switch (index)
    {
      case(0):
        double0= value;
         break;
      case(1):
        double1= value;
         break;
      case(2):
        double2= value;
         break;
      case(3):
        double3= value;
         break;
      case(4):
        double4= value;
         break;
      case(5):
        double5= value;
         break;
      case(6):
        double6= value;
         break;
      case(7):
        double7= value;
         break;
      case(8):
        double8= value;
         break;
      case(9):
        double9= value;
         break;
      case(10):
        double10= value;
         break;
      case(11):
        double11= value;
         break;
      case(12):
        double12= value;
         break;
      case(13):
        double13= value;
         break;
      case(14):
        double14= value;
         break;
      case(16):
        double16= value;
         break;
      case(17):
        double17= value;
         break;
      case(18):
        double18= value;
         break;
      case(19):
        double19= value;
         break;
      case(20):
        double20= value;
         break;
      case(21):
        double21= value;
         break;
      case(22):
        double22= value;
         break;
      case(23):
        double23= value;
         break;
      case(24):
        double24= value;
         break;
      case(26):
        double26= value;
         break;
      case(28):
        double28= value;
         break;
      case(29):
        double29= value;
         break;
      case(30):
        double30= value;
         break;
      case(31):
        double31= value;
         break;
      case(32):
        double32= value;
         break;
      case(33):
        double33= value;
         break;
      case(35):
        double35= value;
         break;
      case(36):
        double36= value;
         break;
      case(37):
        double37= value;
         break;
      case(38):
        double38= value;
         break;
      case(39):
        double39= value;
         break;
      case(40):
        double40= value;
         break;
      case(41):
        double41= value;
         break;
      case(42):
        double42= value;
         break;
      case(43):
        double43= value;
         break;
      case(44):
        double44= value;
         break;
      case(45):
        double45= value;
         break;
      case(46):
        double46= value;
         break;
      case(47):
        double47= value;
         break;
      case(48):
        double48= value;
         break;
      case(49):
        double49= value;
         break;
      case(50):
        double50= value;
         break;
      case(52):
        double52= value;
         break;
      case(53):
        double53= value;
         break;
      case(54):
        double54= value;
         break;
      case(55):
        double55= value;
         break;
      case(56):
        double56= value;
         break;
      case(57):
        double57= value;
         break;
      case(58):
        double58= value;
         break;
      case(59):
        double59= value;
         break;
      case(60):
        double60= value;
         break;
      case(62):
        double62= value;
         break;
      case(64):
        double64= value;
         break;
      case(65):
        double65= value;
         break;
      case(66):
        double66= value;
         break;
      case(67):
        double67= value;
         break;
      case(68):
        double68= value;
         break;
      case(69):
        double69= value;
         break;
      case(71):
        double71= value;
         break;
      case(72):
        double72= value;
         break;
      case(73):
        double73= value;
         break;
      case(74):
        double74= value;
         break;
      case(75):
        double75= value;
         break;
      case(76):
        double76= value;
         break;
      case(77):
        double77= value;
         break;
      case(78):
        double78= value;
         break;
      case(79):
        double79= value;
         break;
      case(80):
        double80= value;
         break;
      case(81):
        double81= value;
         break;
      case(82):
        double82= value;
         break;
      case(83):
        double83= value;
         break;
      case(84):
        double84= value;
         break;
      case(85):
        double85= value;
         break;
      case(86):
        double86= value;
         break;
      case(88):
        double88= value;
         break;
      case(89):
        double89= value;
         break;
      case(90):
        double90= value;
         break;
      case(91):
        double91= value;
         break;
      case(92):
        double92= value;
         break;
      case(93):
        double93= value;
         break;
      case(94):
        double94= value;
         break;
      case(95):
        double95= value;
         break;
      case(96):
        double96= value;
         break;
      case(98):
        double98= value;
         break;
      case(100):
        double100= value;
         break;
      case(101):
        double101= value;
         break;
      case(102):
        double102= value;
         break;
      case(103):
        double103= value;
         break;
      case(104):
        double104= value;
         break;
      case(105):
        double105= value;
         break;
      case(107):
        double107= value;
         break;
      case(108):
        double108= value;
         break;
      case(109):
        double109= value;
         break;
      case(110):
        double110= value;
         break;
      case(111):
        double111= value;
         break;
      case(112):
        double112= value;
         break;
      case(113):
        double113= value;
         break;
      case(114):
        double114= value;
         break;
      case(115):
        double115= value;
         break;
      case(116):
        double116= value;
         break;
      case(117):
        double117= value;
         break;
      case(118):
        double118= value;
         break;
      case(119):
        double119= value;
         break;
      case(120):
        double120= value;
         break;
      case(121):
        double121= value;
         break;
      case(122):
        double122= value;
         break;
      case(124):
        double124= value;
         break;
      case(125):
        double125= value;
         break;
      case(126):
        double126= value;
         break;
      case(127):
        double127= value;
         break;
      case(128):
        double128= value;
         break;
      case(129):
        double129= value;
         break;
      case(130):
        double130= value;
         break;
      case(131):
        double131= value;
         break;
      case(132):
        double132= value;
         break;
      case(134):
        double134= value;
         break;
      case(136):
        double136= value;
         break;
      case(137):
        double137= value;
         break;
      case(138):
        double138= value;
         break;
      case(139):
        double139= value;
         break;
      case(140):
        double140= value;
         break;
      case(141):
        double141= value;
         break;
      case(143):
        double143= value;
         break;
      default:
        throw new IndexOutOfBoundsException();
    }
    return true;
  }

    public static class Oid implements Serializable {
        public int identifier;

        public Oid() {
        }

        public Oid(String s) { identifier = Integer.parseInt(justTheId(s)); }

        public String toString() { return this.getClass().getName() + ": "  + identifier;}

        public int hashCode() { return (int)identifier ; }

        public boolean equals(Object other) {
            if (other != null && (other instanceof Oid)) {
                Oid k = (Oid)other;
                return k.identifier == this.identifier;
            }
            return false;
        }
        
        protected static String justTheId(String str) {
            return str.substring(str.indexOf(':') + 1);
        }
    }   
}
