/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <cairo.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpcolor/gimpcolor.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpimage-color-profile.h"
#include "core/gimpimage.h"
#include "core/gimpparamspecs.h"

#include "gimppdb.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
image_get_color_profile_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gint32 num_bytes = 0;
  guint8 *profile_data = NULL;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      GimpColorProfile *profile;

      profile = gimp_image_get_color_profile (image);

      if (profile)
        {
          const guint8 *data;
          gsize         length;

          data = gimp_color_profile_get_icc_profile (profile, &length);

          profile_data = g_memdup (data, length);
          num_bytes = length;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), num_bytes);
      gimp_value_take_int8array (gimp_value_array_index (return_vals, 2), profile_data, num_bytes);
    }

  return return_vals;
}

static GimpValueArray *
image_get_effective_color_profile_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  gint32 num_bytes = 0;
  guint8 *profile_data = NULL;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);

  if (success)
    {
      GimpColorProfile *profile;

      profile = gimp_color_managed_get_color_profile (GIMP_COLOR_MANAGED (image));

      if (profile)
        {
          const guint8 *data;
          gsize         length;

          data = gimp_color_profile_get_icc_profile (profile, &length);

          profile_data = g_memdup (data, length);
          num_bytes = length;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), num_bytes);
      gimp_value_take_int8array (gimp_value_array_index (return_vals, 2), profile_data, num_bytes);
    }

  return return_vals;
}

static GimpValueArray *
image_set_color_profile_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 num_bytes;
  const guint8 *color_profile;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  num_bytes = g_value_get_int (gimp_value_array_index (args, 1));
  color_profile = gimp_value_get_int8array (gimp_value_array_index (args, 2));

  if (success)
    {
      if (color_profile)
        {
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_icc_profile (color_profile,
                                                             num_bytes,
                                                             error);

          if (profile)
            {
              success = gimp_image_set_color_profile (image, profile, error);
              g_object_unref (profile);
            }
          else
            success = FALSE;
        }
      else
        {
          success = gimp_image_set_color_profile (image, NULL, error);
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_set_color_profile_from_file_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *uri;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  uri = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      if (uri)
        {
          GFile            *file = g_file_new_for_uri (uri);
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_file (file, error);

          if (profile)
            {
              success = gimp_image_set_color_profile (image, profile, error);
              g_object_unref (profile);
            }
          else
            success = FALSE;

          g_object_unref (file);
        }
      else
        {
          success = gimp_image_set_color_profile (image, NULL, error);
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_convert_color_profile_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 num_bytes;
  const guint8 *color_profile;
  gint32 intent;
  gboolean bpc;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  num_bytes = g_value_get_int (gimp_value_array_index (args, 1));
  color_profile = gimp_value_get_int8array (gimp_value_array_index (args, 2));
  intent = g_value_get_enum (gimp_value_array_index (args, 3));
  bpc = g_value_get_boolean (gimp_value_array_index (args, 4));

  if (success)
    {
      if (color_profile)
        {
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_icc_profile (color_profile,
                                                             num_bytes,
                                                             error);

          if (profile)
            {
              success = gimp_image_convert_color_profile (image, profile,
                                                          intent, bpc,
                                                          progress, error);
              g_object_unref (profile);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_convert_color_profile_from_file_invoker (GimpProcedure         *procedure,
                                               Gimp                  *gimp,
                                               GimpContext           *context,
                                               GimpProgress          *progress,
                                               const GimpValueArray  *args,
                                               GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *uri;
  gint32 intent;
  gboolean bpc;

  image = gimp_value_get_image (gimp_value_array_index (args, 0), gimp);
  uri = g_value_get_string (gimp_value_array_index (args, 1));
  intent = g_value_get_enum (gimp_value_array_index (args, 2));
  bpc = g_value_get_boolean (gimp_value_array_index (args, 3));

  if (success)
    {
      if (uri)
        {
          GFile            *file = g_file_new_for_uri (uri);
          GimpColorProfile *profile;

          profile = gimp_color_profile_new_from_file (file, error);

          if (profile)
            {
              success = gimp_image_convert_color_profile (image, profile,
                                                          intent, bpc,
                                                          progress, error);
              g_object_unref (profile);
            }
          else
            success = FALSE;

          g_object_unref (file);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_image_color_profile_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-image-get-color-profile
   */
  procedure = gimp_procedure_new (image_get_color_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-get-color-profile");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-get-color-profile",
                                     "Returns the image's color profile",
                                     "This procedure returns the image's color profile, or NULL if the image has no color profile assigned.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-bytes",
                                                          "num bytes",
                                                          "Number of bytes in the color_profile array",
                                                          0, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int8_array ("profile-data",
                                                               "profile data",
                                                               "The image's serialized color profile. The returned value must be freed with g_free()",
                                                               GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-get-effective-color-profile
   */
  procedure = gimp_procedure_new (image_get_effective_color_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-get-effective-color-profile");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-get-effective-color-profile",
                                     "Returns the color profile that is used for the image",
                                     "This procedure returns the color profile that is actually used for this image, which is the profile returned by 'gimp-image-get-color-profile' if the image has a profile assigned, or a generated default RGB or grayscale profile, according to the image's type.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-bytes",
                                                          "num bytes",
                                                          "Number of bytes in the color_profile array",
                                                          0, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int8_array ("profile-data",
                                                               "profile data",
                                                               "The image's serialized color profile. The returned value must be freed with g_free()",
                                                               GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-set-color-profile
   */
  procedure = gimp_procedure_new (image_set_color_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-set-color-profile");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-set-color-profile",
                                     "Sets the image's color profile",
                                     "This procedure sets the image's color profile, or unsets it if NULL is passed as 'color_profile'. This procedure does no color conversion.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-bytes",
                                                      "num bytes",
                                                      "Number of bytes in the color_profile array",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int8_array ("color-profile",
                                                           "color profile",
                                                           "The new serialized color profile",
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-set-color-profile-from-file
   */
  procedure = gimp_procedure_new (image_set_color_profile_from_file_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-set-color-profile-from-file");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-set-color-profile-from-file",
                                     "Sets the image's color profile from an ICC file",
                                     "This procedure sets the image's color profile from a file containing an ICC profile, or unsets it if NULL is passed as 'uri'. This procedure does no color conversion.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("uri",
                                                       "uri",
                                                       "The URI of the file containing the new color profile",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-convert-color-profile
   */
  procedure = gimp_procedure_new (image_convert_color_profile_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-convert-color-profile");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-convert-color-profile",
                                     "Convert the image's layers to a color profile",
                                     "This procedure converts from the image's color profile (or the default RGB or grayscale profile if none is set) to the given color profile. Only RGB and grayscale color profiles are accepted, according to the image's type.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-bytes",
                                                      "num bytes",
                                                      "Number of bytes in the color_profile array",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int8_array ("color-profile",
                                                           "color profile",
                                                           "The serialized color profile",
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("intent",
                                                  "intent",
                                                  "Rendering intent",
                                                  GIMP_TYPE_COLOR_RENDERING_INTENT,
                                                  GIMP_COLOR_RENDERING_INTENT_PERCEPTUAL,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("bpc",
                                                     "bpc",
                                                     "Black point compensation",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-convert-color-profile-from-file
   */
  procedure = gimp_procedure_new (image_convert_color_profile_from_file_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-convert-color-profile-from-file");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-image-convert-color-profile-from-file",
                                     "Convert the image's layers to a color profile",
                                     "This procedure converts from the image's color profile (or the default RGB or grayscale profile if none is set) to an ICC profile specified by 'uri'. Only RGB and grayscale color profiles are accepted, according to the image's type.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2015",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("uri",
                                                       "uri",
                                                       "The URI of the file containing the new color profile",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("intent",
                                                  "intent",
                                                  "Rendering intent",
                                                  GIMP_TYPE_COLOR_RENDERING_INTENT,
                                                  GIMP_COLOR_RENDERING_INTENT_PERCEPTUAL,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("bpc",
                                                     "bpc",
                                                     "Black point compensation",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
