/*
 * fspy - Linux filesystem activity monitor
 *
 * Copyright (C) 2007  Richard Sammet (e-axe) <richard.sammet@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <regex.h>

#include "fspy.h"

regex_t re;
regex_t ire;

int reg_comp(char *pattern)
{

	if(regcomp(&re, pattern, REG_EXTENDED|REG_NOSUB|REG_EESCAPE) != 0) {
		perror("reg_comp()");
		return FALSE;
	}

	return TRUE;
}

int ireg_comp(char *pattern)
{

	if(regcomp(&ire, pattern, REG_EXTENDED|REG_NOSUB|REG_EESCAPE) != 0) {
		perror("ireg_comp()");
		return FALSE;
	}

	return TRUE;
}

int reg_match(const char *string)
{

	if(regexec(&re, string, (size_t) 0, NULL, 0) != 0) {
		return FALSE;
	}

	return TRUE;
}

int ireg_match(const char *string)
{

	if(!(regexec(&ire, string, (size_t) 0, NULL, 0) != 0)) {
		return FALSE;
	}

	return TRUE;
}

void reg_dest(void)
{

	(void) regfree(&re);
}
