/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

class ColorMenu
extends JMenu {
    protected Border unselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
    protected Border selectedBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
    protected Border activeBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
    protected Hashtable panes;
    protected ColorPane selected;

    public ColorMenu(String name) {
        super(name);
        JPanel p = new JPanel();
        p.setBorder(new EmptyBorder(5, 5, 5, 5));
        p.setLayout(new GridLayout(8, 8));
        this.panes = new Hashtable();
        int[] values = new int[]{0, 128, 192, 255};
        for (int r = 0; r < values.length; ++r) {
            for (int g = 0; g < values.length; ++g) {
                for (int b = 0; b < values.length; ++b) {
                    Color c = new Color(values[r], values[g], values[b]);
                    ColorPane pn = new ColorPane(c);
                    p.add(pn);
                    this.panes.put(c, pn);
                }
            }
        }
        this.add(p);
    }

    public void setColor(Color c) {
        Object obj = this.panes.get(c);
        if (obj == null) {
            return;
        }
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = (ColorPane)obj;
        this.selected.setSelected(true);
    }

    public Color getColor() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.getColor();
    }

    public void doSelection() {
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    class ColorPane
    extends JPanel
    implements MouseListener {
        protected Color col;
        protected boolean selected;

        public ColorPane(Color c) {
            this.col = c;
            this.setBackground(c);
            this.setBorder(ColorMenu.this.unselectedBorder);
            String msg = "R " + c.getRed() + ", G " + c.getGreen() + ", B " + c.getBlue();
            this.setToolTipText(msg);
            this.addMouseListener(this);
        }

        public Color getColor() {
            return this.col;
        }

        public Dimension getPreferredSize() {
            return new Dimension(15, 15);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setSelected(boolean select) {
            this.selected = select;
            if (this.selected) {
                this.setBorder(ColorMenu.this.selectedBorder);
            } else {
                this.setBorder(ColorMenu.this.unselectedBorder);
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            ColorMenu.this.setColor(this.col);
            MenuSelectionManager.defaultManager().clearSelectedPath();
            ColorMenu.this.doSelection();
        }

        public void mouseEntered(MouseEvent e) {
            this.setBorder(ColorMenu.this.activeBorder);
        }

        public void mouseExited(MouseEvent e) {
            this.setBorder(this.selected ? ColorMenu.this.selectedBorder : ColorMenu.this.unselectedBorder);
        }
    }
}

