package Language::INTERCAL::Server::IPv6;

# Determine if this system can at least look up IPv6 addresses
# Only something ancient could fail this, but we do check anyway

# This file is part of CLC-INTERCAL

# Copyright (c) 2023 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

use strict;
use vars qw($VERSION $PERVERSION @EXPORT_OK);
($VERSION) = ($PERVERSION = "CLC-INTERCAL/INET INTERCAL/Server/IPv6.pm 1.-94.-2.4") =~ /\s(\S+)$/;

use Socket ();
use Language::INTERCAL::Exporter '1.-94.-2.4';

my $has_ipv6;
BEGIN {
    $has_ipv6 = 0;
    eval {
	$ENV{CLCINTERCAL_TEST_OLD_CODE} and die;
	require IO::Socket::IP;
	# make sure all constants we might be using are available
	import Socket qw(
	    inet_ntop inet_pton pack_sockaddr_in6 unpack_sockaddr_in6
	    AF_INET6 PF_INET6
	    IPPROTO_IPV6 IPV6_JOIN_GROUP
	    IPV6_MULTICAST_IF IPV6_MULTICAST_LOOP IPV6_MULTICAST_HOPS
	);
	my $a6 = '2001:db8:1::1';
	my $p = inet_pton(&AF_INET6, $a6) or die;
	my $u6 = inet_ntop(&AF_INET6, $p) or die;
	my $c = inet_pton(&AF_INET6, $u6) or die;
	$c eq $p or die;
	# it does look like we have at least working inet_ntop and inet_pton
	$has_ipv6 = 1;
    };
}

@EXPORT_OK = qw(has_ipv6);
sub has_ipv6 { $has_ipv6 }

1;

