*NOTE: The [BLIS](https://github.com/flame/blis) project is not affiliated with [Discord Inc.](https://discord.com/company) in any way, and we use the Discord logo with their permission.*


## Contents

* **[Welcome](Discord.md#welcome)**
* **[Introduction to Discord](Discord.md#introduction-to-discord)**
* **[Creating an account](Discord.md#creating-an-account)**
* **[Obtaining the invite link](Discord.md#obtaining-the-invite-link)**
* **[Joining the BLIS server](Discord.md#joining-the-blis-server)**
* **[Additional resources](Discord.md#additional-resources)**

## Welcome

In 2021, we soft-launched our Discord server by privately inviting current and former collaborators, attendees of our BLIS Retreat, as well as other participants within the BLIS ecosystem. We've been thrilled by the results thus far, and are happy to announce that our new community is now open to the broader public!

If you'd like to hang out with other BLIS users and developers, ask a question, discuss future features, or just say hello, please feel free to join us! Joining our server is also a great way to get announcements for new versions, workshop events, video chat parties, and other infrequent updates.

**If you already use Discord** and want to skip straight to the invite link, you can find it [here](#obtaining-the-invite-link). Just be sure to manually remove the dashes (`-`) and equal signs (`=`) before using it!

## Introduction to Discord

The remaining sections of this file walk the reader through basic instructions for joining the BLIS community on [Discord](https://discord.com).

Discord is free to use for everyone. You can optionally pay for premium features via their [Nitro](https://discord.com/nitro) subscription, but Nitro is not necessary for most casual users.

Discord offers several kinds of clients. Users may use Discord via:

- the official Android and iOS apps on mobile devices
- a [web browser](https://discord.com/login)
- the standalone desktop application, available from their [Download](https://discord.com/download) page.

You can even stay logged in on multiple devices! Each one will automatically sync itself to newly sent/received messages.

In this document, we'll walk you through each step necessary to join the BLIS Discord community. First, we'll talk about how to [create a Discord account](#creating-an-account) (if you don't already have one). Then, we'll explain how to [obtain the invite link](#obtaining-the-invite-link). And finally, we'll tell you how to use that invite link to [join the BLIS Discord server](#joining-the-blis-server).


## Creating an account

If you don't already have a Discord account, you'll need to first create one.

As of this writing, you may follow these steps to create your account:

*NOTE: We recommend executing these steps using a desktop web browser. Once you've created your account and joined the BLIS server, you can proceed to use your client(s) of choice (mobile app, desktop app, or web browser).*

1. Go to [https://discord.com](https://discord.com) and click on "Login" at the top-right.
2. At the bottom of the dialog, click the "Register" link.
3. Enter the prompted information, such as username and email, then click "Continue".
4. Perform the Captcha verification.
5. This should take you into the web browser version of Discord. You will be asked if you want to create your own server. Close the dialog without making any selection.
6. At this point, you need to verify your email address. Check your email account for a message from Discord. Click the link in the email. This should bring up a dialog confirming your email has been verified. You may now close the web browser tab.

Congratulations! You're now a member of Discord and ready to join individual communities, or "servers."


## Obtaining the invite link

Since we do not have access to an official Captcha-like service to confirm that you are not a software bot, we have instead obfuscated our invite link in a way that should be easy for a human to unmangle.

Here's an example invite link (for reference purposes only): `https://discord.gg/abC2jUVeip`

Notice that the link consists of `https://discord.gg/` followed by a 10-character string consisting of lower- and upper-case letters, and (typically) one numerical digit.

**The BLIS Discord invite link is: https://discord.gg/e-Zx=p-z9=p-Ks=x**

*Note that you **must** remove the dashes (`-`) and equal signs (`=`) before using the link!*

Once you decipher the invite link, copy it to your clipboard so it's ready to use in the appropriate step within the next section, [Joining the BLIS server](#joining-the-blis-server).


## Joining the BLIS server

Once you have the invite link copied to your clipboard, follow these steps in order to join the BLIS server:

*NOTE: We recommend executing these steps using a desktop web browser. Once you've joined the BLIS server, you can proceed to use your client(s) of choice (mobile app, desktop app, or web browser).*

1. Log in to the [Discord website](https://discord.com).
2. Once logged in, on the left-hand side of the UI, click on the button with the "+" symbol. This will bring up a dialog asking if you want to create a server.
3. At the bottom of the dialog, there will be a section asking, "Have an invite already?" Click the button below it labeled "Join a Server".
4. Paste the invite link into the prompt and click "Join Server".
5. This should bring up a dialog stating that you've been invited to join the BLIS server. Click on "Accept Invite". This will trigger a new dialog informing you that your account has been updated with the invitation.

That's it! Now that you've joined our server, please consider introducing yourself in `#general`! We love hearing about how application developers and end-users are using BLIS.

If you had any difficulty joining or with the invite link, please reach out to [field@cs.utexas.edu](field@cs.utexas.edu).


## Additional resources

Are you new to Discord? Not sure how to work this newfangled technology? Don't worry; once you learn the basics, you'll feel much more at home!

While a tutorial on Discord is beyond the scope of this document, there are countless articles and YouTube videos that introduce newcomers to Discord's UI. Here are a few articles on the basics:

- **tom's guide**. [Discord: Everything You Need to Know](https://www.tomsguide.com/us/what-is-discord,review-5203.html)
- **WIRED.** [How to Use Discord: A Beginner's Guide](https://www.wired.com/story/how-to-use-discord/)
- **Discord Support.** [Beginner's Guide to Discord](https://support.discord.com/hc/en-us/articles/360045138571-Beginner-s-Guide-to-Discord)

And some YouTube videos:

- **Tech Audit TV.** [How to Use Discord in 2022: The Ultimate Beginner Walkthrough](https://www.youtube.com/watch?v=nPmdafMo1b8)
- **Howfinity.** [How to Use Discord - Beginner's Guide](https://www.youtube.com/watch?v=rnYGrq95ezA)

Some things I recommend setting up shortly after you create your account:

- Take note of your username's "tag" or disambiguator. This is a randomly-assigned four-digit number that gets implicitly appended to the end of your username (e.g. `bsmith#1234`), which helps when others need to tell you apart from others who have the same username.
- Not happy with your username? You can change it!
- Review your privacy settings, and consider using two-factor authentication.
- Personalize your account with a custom profile image.
- Consider switching to the "dark" theme (if you prefer dark modes on other websites or on mobile devices).
- Tweak other appearence settings such as the font size or UI compactness.
- Set up your notifications.

There are many other settings in Discord! Feel free to explore all of them by clicking the gear icon in the bottom-left area of your screen, just to the right of your username.

We hope you found this short guide useful, and we hope to see you on Discord! Thanks for your interest in BLIS and our community! :)
