Aevol basic example
===================

This is the most basic example for using Aevol. It uses the STANDARD setup in which genomes are binary, hence the _\_2b_ in e.g. `aevol_2b_create`.

You can run the same experiment with 4-BASES genomes simply by replacing _\_2b_ with _\_4b_ in all the aevol commands.

Note that in both the STANDARD and 4-BASES setups, genomes are haploid and circular.

Note
----
It is assumed you have installed Aevol on your computer. If you haven't, you can use the full path to the
Aevol binaries instead of their name. _E.g._ if you have built aevol in `/home/login/aevol/build`,
you can use:
```sh
/home/login/aevol/build/bin/aevol_2b_create --help # beware of the additional bin level
```
instead of
```sh
aevol_2b_create --help
```

Step 1: Create an experiment
---------------------------
Go into the examples/basic directory and `create` an experiment:
```sh
cd examples/basic
aevol_2b_create param.in
```
This will create a checkpoint for generation 0 in the `checkpoint` directory.

A checkpoint consists of 3 files:
  - a setup file containing the setup of your experiment
  - a population file containing the sequences of all the individuals in the population in fasta format
  - a checkpoint file containing internal states of Aevol objects

An additional file named `last_gener.txt` is also generated. It allows to track the latest generation that was computed.


Step 2: Run an experiment
-------------------------
Once you have created an experiment, you can run it (let the population evolve in the specified setup).

The following command will run the first 1000 generations of evolution in several parallel threads (system default):
```sh
# run evolution from generation 0 to 1000 using <system-default> threads
aevol_2b_run --begin 0 --end 1000 --parallel -1
```

Note that you can set a specific number of threads for aevol to run in with option `--parallel` or drop that option
altogether for a single-thread execution.

In addition to a checkpoint being generated at generation 1000 (CHECKPOINT_STEP is set to 1000 in param.in),
stats are written in the `stats` directory:
  - file `stats/stats_best.csv` contains stats about the best individual of its generation
  - file `stats/stats_means.csv` contains the same stats as `stats/stats_best.csv` (with exceptions) but averaged over the population 


Resume an experiment (from a checkpoint)
----------------------------------------
To resume a simulation from a checkpoint, simply set the `--begin` (or `-b`) option to the corresponding generation:
```sh
# run evolution from generation 1000 to 5000 using <system-default> threads
aevol_2b_run --begin 1000 --end 5000 --parallel -1
```

Note that when it produces a checkpoint, aevol writes the corresponding generation number in the file `last_gener.txt`.
The content of this file is in turn used as the generation at which to resume the simulation if the `--begin` (or `-b`) option is not present.
This means that, by default, `aevol_run` resumes the simulation where it stopped.
