#ifndef GOP_H_
#define GOP_H_
/*****************************************************************************
* This file is part of Kvazaar HEVC encoder.
*
* Copyright (C) 2018 Tampere University of Technology and others (see
* COPYING file).
*
* Kvazaar is free software: you can redistribute it and/or modify it under
* the terms of the GNU Lesser General Public License as published by the
* Free Software Foundation; either version 2.1 of the License, or (at your
* option) any later version.
*
* Kvazaar is distributed in the hope that it will be useful, but WITHOUT ANY
* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
* FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
* more details.
*
* You should have received a copy of the GNU General Public License along
* with Kvazaar.  If not, see <http://www.gnu.org/licenses/>.
****************************************************************************/

#include <kvazaar.h>


static const kvz_gop_config kvz_gop_lowdelay4[4] = {
  {
    .poc_offset = 1,
    .layer      = 1,
    .qp_offset  = 5,
    .qp_factor  = 1.0,
    .qp_model_offset = -6.5,
    .qp_model_scale  = 0.2590,
    .is_ref     = 1,
    .ref_neg_count = 4,
    .ref_neg = { 1, 5, 9, 13 },
    .ref_pos_count = 0,
    .ref_pos = { 0 },
  },
  {
    .poc_offset = 2,
    .layer      = 1,
    .qp_offset  = 4,
    .qp_factor  = 1.0,
    .qp_model_offset = -6.5,
    .qp_model_scale  = 0.2590,
    .is_ref     = 1,
    .ref_neg_count = 3,
    .ref_neg = { 1, 2, 6, 10 },
    .ref_pos_count = 0,
    .ref_pos = { 0 },
  },
  {
    .poc_offset = 3,
    .layer      = 1,
    .qp_offset  = 5,
    .qp_factor  = 1.0,
    .qp_model_offset = -6.5,
    .qp_model_scale  = 0.2590,
    .is_ref     = 1,
    .ref_neg_count = 3,
    .ref_neg = { 1, 3, 7, 11 },
    .ref_pos_count = 0,
    .ref_pos = { 0 },
  },
  {
    .poc_offset = 4,
    .layer      = 1,
    .qp_offset  = 1,
    .qp_factor  = 1.0,
    .qp_model_offset = 0.0,
    .qp_model_scale  = 0.0,
    .is_ref     = 1,
    .ref_neg_count = 3,
    .ref_neg = { 1, 4, 8, 12 },
    .ref_pos_count = 0,
    .ref_pos = { 0 },
  },
};


static const kvz_gop_config kvz_gop_ra8[8] = {
  {
    .poc_offset = 8,
    .layer      = 1,
    .qp_offset  = 0,
    .qp_factor  = 1.0,
    .qp_model_offset = 0.0,
    .qp_model_scale  = 0.0,
    .is_ref     = 1,
    .ref_neg_count = 3,
    .ref_neg = { 8, 12, 16 },
    .ref_pos_count = 0,
    .ref_pos = { 0 },
  },
  {
    .poc_offset = 4,
    .layer      = 2,
    .qp_offset  = 3,
    .qp_factor  = 1.0,
    .qp_model_offset = -6.25,
    .qp_model_scale  = 0.25,
    .is_ref     = 1,
    .ref_neg_count = 2,
    .ref_neg = { 4, 8 },
    .ref_pos_count = 1,
    .ref_pos = { 4 },
  },
  {
    .poc_offset = 2,
    .layer      = 3,
    .qp_offset  = 4,
    .qp_factor  = 1.0,
    .qp_model_offset = -6.25,
    .qp_model_scale  = 0.25,
    .is_ref     = 1,
    .ref_neg_count = 2,
    .ref_neg = { 2, 6 },
    .ref_pos_count = 2,
    .ref_pos = { 2, 6 },
  },
  {
    .poc_offset = 1,
    .layer      = 4,
    .qp_offset  = 8,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.0,
    .qp_model_scale  = 0.245,
    .is_ref     = 0,
    .ref_neg_count = 1,
    .ref_neg = { 1 },
    .ref_pos_count = 3,
    .ref_pos = { 1, 3, 7 },
  },
  {
    .poc_offset = 3,
    .layer      = 4,
    .qp_offset  = 8,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.0,
    .qp_model_scale  = 0.245,
    .is_ref     = 0,
    .ref_neg_count = 2,
    .ref_neg = { 1, 3 },
    .ref_pos_count = 2,
    .ref_pos = { 1, 5 },
  },
  {
    .poc_offset = 6,
    .layer      = 3,
    .qp_offset  = 4,
    .qp_factor  = 1.0,
    .qp_model_offset = -6.25,
    .qp_model_scale  = 0.25,
    .is_ref     = 1,
    .ref_neg_count = 2,
    .ref_neg = { 2, 6 },
    .ref_pos_count = 1,
    .ref_pos = { 2 },
  },
  {
    .poc_offset = 5,
    .layer      = 4,
    .qp_offset  = 8,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.0,
    .qp_model_scale  = 0.245,
    .is_ref     = 0,
    .ref_neg_count = 2,
    .ref_neg = { 1, 5 },
    .ref_pos_count = 2,
    .ref_pos = { 1, 3 },
  },
  {
    .poc_offset = 7,
    .layer      = 4,
    .qp_offset  = 8,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.0,
    .qp_model_scale  = 0.245,
    .is_ref     = 0,
    .ref_neg_count = 3,
    .ref_neg = { 1, 3, 7 },
    .ref_pos_count = 1,
    .ref_pos = { 1 },
  },
};

static const kvz_gop_config kvz_gop_ra16[16] = {
  {
    .poc_offset = 16,
    .layer      = 1,
    .qp_offset  = 1,
    .qp_factor  = 1.0,
    .qp_model_offset = 0.0,
    .qp_model_scale  = 0.0,
    .is_ref     = 1,
    .ref_neg_count = 3,
    .ref_neg = { 16, 24, 32 },
    .ref_pos_count = 0,
    .ref_pos = { 0 },
  },
  {
    .poc_offset = 8,
    .layer      = 2,
    .qp_offset  = 1,
    .qp_factor  = 1.0,
    .qp_model_offset = -4.8848,
    .qp_model_scale  = 0.2061,
    .is_ref     = 1,
    .ref_neg_count = 2,
    .ref_neg = { 8, 16 },
    .ref_pos_count = 1,
    .ref_pos = { 8 },
  },
  {
    .poc_offset = 4,
    .layer      = 3,
    .qp_offset  = 4,
    .qp_factor  = 1.0,
    .qp_model_offset = -5.7476,
    .qp_model_scale  = 0.2286,
    .is_ref     = 1,
    .ref_neg_count = 2,
    .ref_neg = { 4, 12 },
    .ref_pos_count = 2,
    .ref_pos = { 4, 12 },
  },
  {
    .poc_offset = 2,
    .layer      = 4,
    .qp_offset  = 5,
    .qp_factor  = 1.0,
    .qp_model_offset = -5.90,
    .qp_model_scale  = 0.2333,
    .is_ref     = 1,
    .ref_neg_count = 2,
    .ref_neg = { 2, 10 },
    .ref_pos_count = 3,
    .ref_pos = { 2, 6, 14 },
  },
  {
    .poc_offset = 1,
    .layer      = 5,
    .qp_offset  = 6,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.1444,
    .qp_model_scale  = 0.3,
    .is_ref     = 0,
    .ref_neg_count = 1,
    .ref_neg = { 1 },
    .ref_pos_count = 4,
    .ref_pos = { 1, 3, 7, 15 },
  },
  {
    .poc_offset = 3,
    .layer      = 5,
    .qp_offset  = 6,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.1444,
    .qp_model_scale  = 0.3,
    .is_ref     = 0,
    .ref_neg_count = 2,
    .ref_neg = { 1, 3 },
    .ref_pos_count = 3,
    .ref_pos = { 1, 5, 13 },
  },
  {
    .poc_offset = 6,
    .layer      = 4,
    .qp_offset  = 5,
    .qp_factor  = 1.0,
    .qp_model_offset = -5.90,
    .qp_model_scale  = 0.2333,
    .is_ref     = 1,
    .ref_neg_count = 2,
    .ref_neg = { 2, 6 },
    .ref_pos_count = 2,
    .ref_pos = { 2, 10 },
  },
  {
    .poc_offset = 5,
    .layer      = 5,
    .qp_offset  = 6,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.1444,
    .qp_model_scale  = 0.3,
    .is_ref     = 0,
    .ref_neg_count = 2,
    .ref_neg = { 1, 5 },
    .ref_pos_count = 3,
    .ref_pos = { 1, 3, 11 },
  },
  {
    .poc_offset = 7,
    .layer      = 5,
    .qp_offset  = 6,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.1444,
    .qp_model_scale  = 0.3,
    .is_ref     = 0,
    .ref_neg_count = 3,
    .ref_neg = { 1, 3, 7 },
    .ref_pos_count = 2,
    .ref_pos = { 1, 9 },
  },
  {
    .poc_offset = 12,
    .layer      = 3,
    .qp_offset  = 4,
    .qp_factor  = 1.0,
    .qp_model_offset = -5.7476,
    .qp_model_scale  = 0.2286,
    .is_ref     = 1,
    .ref_neg_count = 2,
    .ref_neg = { 4, 12 },
    .ref_pos_count = 1,
    .ref_pos = { 4 },
  },
  {
    .poc_offset = 10,
    .layer      = 4,
    .qp_offset  = 5,
    .qp_factor  = 1.0,
    .qp_model_offset = -5.90,
    .qp_model_scale  = 0.2333,
    .is_ref     = 1,
    .ref_neg_count = 2,
    .ref_neg = { 2, 10 },
    .ref_pos_count = 2,
    .ref_pos = { 2, 6 },
  },
  {
    .poc_offset = 9,
    .layer      = 5,
    .qp_offset  = 6,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.1444,
    .qp_model_scale  = 0.3,
    .is_ref     = 0,
    .ref_neg_count = 2,
    .ref_neg = { 1, 9 },
    .ref_pos_count = 3,
    .ref_pos = { 1, 3, 7 },
  },
  {
    .poc_offset = 11,
    .layer      = 5,
    .qp_offset  = 6,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.1444,
    .qp_model_scale  = 0.3,
    .is_ref     = 0,
    .ref_neg_count = 3,
    .ref_neg = { 1, 3, 11 },
    .ref_pos_count = 2,
    .ref_pos = { 1, 5 },
  },
  {
    .poc_offset = 14,
    .layer      = 4,
    .qp_offset  = 5,
    .qp_factor  = 1.0,
    .qp_model_offset = -5.90,
    .qp_model_scale  = 0.2333,
    .is_ref     = 1,
    .ref_neg_count = 3,
    .ref_neg = { 2, 6, 14 },
    .ref_pos_count = 1,
    .ref_pos = { 2 },
  },
  {
    .poc_offset = 13,
    .layer      = 5,
    .qp_offset  = 6,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.1444,
    .qp_model_scale  = 0.3,
    .is_ref     = 0,
    .ref_neg_count = 3,
    .ref_neg = { 1, 5, 13 },
    .ref_pos_count = 2,
    .ref_pos = { 1, 3 },
  },
  {
    .poc_offset = 15,
    .layer      = 5,
    .qp_offset  = 6,
    .qp_factor  = 1.0,
    .qp_model_offset = -7.1444,
    .qp_model_scale  = 0.3,
    .is_ref     = 0,
    .ref_neg_count = 4,
    .ref_neg = { 1, 3, 7, 15 },
    .ref_pos_count = 1,
    .ref_pos = { 1 },
  },
};

#endif // GOP_H_
