/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.Communicator;
import Ice.PluginInitializationException;
import Ice.Properties;
import IceInternal.Network;
import IceSSL.ConnectionInfo;
import IceSSL.RFC2253;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

class TrustManager {
    private Communicator _communicator;
    private int _traceLevel;
    private List _all;
    private List _client;
    private List _allServer;
    private Map _server = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    TrustManager(Communicator communicator) {
        if (!$assertionsDisabled && communicator == null) {
            throw new AssertionError();
        }
        this._communicator = communicator;
        Properties properties = communicator.getProperties();
        this._traceLevel = properties.getPropertyAsInt("IceSSL.Trace.Security");
        String key = null;
        try {
            key = "IceSSL.TrustOnly";
            this._all = this.parse(properties.getProperty(key));
            key = "IceSSL.TrustOnly.Client";
            this._client = this.parse(properties.getProperty(key));
            key = "IceSSL.TrustOnly.Server";
            this._allServer = this.parse(properties.getProperty(key));
            Map dict = properties.getPropertiesForPrefix("IceSSL.TrustOnly.Server.");
            Iterator p = dict.entrySet().iterator();
            while (p.hasNext()) {
                Map.Entry entry = p.next();
                key = (String)entry.getKey();
                String name = key.substring("IceSSL.TrustOnly.Server.".length());
                this._server.put(name, this.parse((String)entry.getValue()));
            }
        }
        catch (RFC2253.ParseException e) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: invalid property " + key + ":\n" + e.reason;
            throw ex;
        }
    }

    boolean verify(ConnectionInfo info) {
        LinkedList<List> trustset = new LinkedList<List>();
        if (!this._all.isEmpty()) {
            trustset.add(this._all);
        }
        if (info.incoming) {
            List p;
            if (!this._allServer.isEmpty()) {
                trustset.add(this._allServer);
            }
            if (info.adapterName.length() > 0 && (p = (List)this._server.get(info.adapterName)) != null) {
                trustset.add(p);
            }
        } else if (!this._client.isEmpty()) {
            trustset.add(this._client);
        }
        if (trustset.isEmpty()) {
            return true;
        }
        if (info.certs != null && info.certs.length > 0) {
            X500Principal subjectDN = ((X509Certificate)info.certs[0]).getSubjectX500Principal();
            String subjectName = subjectDN.getName("RFC2253");
            if (!$assertionsDisabled && subjectName == null) {
                throw new AssertionError();
            }
            try {
                if (this._traceLevel > 0) {
                    if (info.incoming) {
                        this._communicator.getLogger().trace("Security", "trust manager evaluating client:\nsubject = " + subjectName + "\n" + "adapter = " + info.adapterName + "\n" + "local addr = " + Network.addrToString(info.localAddr) + "\n" + "remote addr = " + Network.addrToString(info.remoteAddr));
                    } else {
                        this._communicator.getLogger().trace("Security", "trust manager evaluating server:\nsubject = " + subjectName + "\n" + "local addr = " + Network.addrToString(info.localAddr) + "\n" + "remote addr = " + Network.addrToString(info.remoteAddr));
                    }
                }
                List dn = RFC2253.parseStrict(subjectName);
                Iterator p = trustset.iterator();
                while (p.hasNext()) {
                    List matchSet = (List)p.next();
                    if (this._traceLevel > 1) {
                        String s = "trust manager matching PDNs:\n";
                        Iterator q = matchSet.iterator();
                        boolean addSemi = false;
                        while (q.hasNext()) {
                            if (addSemi) {
                                s = s + ';';
                            }
                            addSemi = true;
                            List rdnSet = (List)q.next();
                            Iterator r = rdnSet.iterator();
                            boolean addComma = false;
                            while (r.hasNext()) {
                                if (addComma) {
                                    s = s + ',';
                                }
                                addComma = true;
                                RFC2253.RDNPair rdn = (RFC2253.RDNPair)r.next();
                                s = s + rdn.key;
                                s = s + '=';
                                s = s + rdn.value;
                            }
                        }
                        this._communicator.getLogger().trace("Security", s);
                    }
                    if (!this.match(matchSet, dn)) continue;
                    return true;
                }
            }
            catch (RFC2253.ParseException e) {
                this._communicator.getLogger().warning("IceSSL: unable to parse certificate DN `" + subjectName + "'\nreason: " + e.reason);
            }
        }
        return false;
    }

    private boolean match(List matchSet, List subject) {
        Iterator r = matchSet.iterator();
        while (r.hasNext()) {
            if (!this.matchRDNs((List)r.next(), subject)) continue;
            return true;
        }
        return false;
    }

    private boolean matchRDNs(List match, List subject) {
        Iterator p = match.iterator();
        while (p.hasNext()) {
            RFC2253.RDNPair matchRDN = (RFC2253.RDNPair)p.next();
            boolean found = false;
            Iterator q = subject.iterator();
            while (q.hasNext()) {
                RFC2253.RDNPair subjectRDN = (RFC2253.RDNPair)q.next();
                if (!matchRDN.key.equals(subjectRDN.key)) continue;
                found = true;
                if (matchRDN.value.equals(subjectRDN.value)) continue;
                return false;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    List parse(String value) throws RFC2253.ParseException {
        List l = RFC2253.parse(value);
        LinkedList<List> result = new LinkedList<List>();
        Iterator p = l.iterator();
        while (p.hasNext()) {
            List dn = (List)p.next();
            String v = new String();
            boolean first = true;
            Iterator q = dn.iterator();
            while (q.hasNext()) {
                if (!first) {
                    v = v + ",";
                }
                first = false;
                RFC2253.RDNPair pair = (RFC2253.RDNPair)q.next();
                v = v + pair.key;
                v = v + "=";
                v = v + pair.value;
            }
            X500Principal princ = new X500Principal(v);
            String subjectName = princ.getName("RFC2253");
            result.add(RFC2253.parseStrict(subjectName));
        }
        return result;
    }

    static {
        $assertionsDisabled = !TrustManager.class.desiredAssertionStatus();
    }
}

