/* wconfig.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: wconfig.cc,v 1.54 2002/03/17 01:43:17 ralf Exp $ */

#include "wconfig.h"
#include "worker.h"
#include "filereq.h"
#include "fontreq.h"
#include <string>

#define DEFAULT_TIME_STRING "%H:%M:%S"
#define DEFAULT_DATE_STRING "%d %b %Y"

const char * predefined_dates[] = { "%d %b %Y",
                                    "%m/%d/%y",
                                    "%d.%m.%Y" };
const char * predefined_times[] = { "%H:%M:%S",
                                    "%H:%M" };

WConfig *wconfig;

bool WConfig::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  WConfig *config_bak=duplicate();
  int w,h,ty,i;
  Button *buts[20];

//  for(i=1;i<9;i++) {
//    l1=strlen(catalog.getLocale(i));
//    if(l1>l2) l2=l1;
//  }
//  l1=strlen(catalog.getLocale(91));
//  if(l1>l2) l2=l1;
//  l1=strlen(catalog.getLocale(209));
//  if(l1>l2) l2=l1;
//  l1=strlen(catalog.getLocale(231));
//  if(l1>l2) l2=l1;
//  l1=strlen(catalog.getLocale(232));
//  if(l1>l2) l2=l1;
//  if(l2<26) l2=26;
//  w=l2*aguix->getCharWidth()+20;
//  h=12*(aguix->getCharHeight()+4)+2*aguix->getCharHeight()+4*5+10*2;
  w = h = 10;
  AWindow *cwin=new AWindow(aguix);
  cwin->create(NULL,10,10,w,h,0,catalog.getLocale(0));
  ty=5;
  buts[0]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(1),1,0,1));
  int dh=buts[0]->getHeight()+2;
  ty+=dh;
  buts[1]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(2),1,0,2));
  ty+=dh;
  buts[2]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(3),1,0,3));
  ty+=dh;
  buts[3]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(4),1,0,4));
  ty+=dh;
  buts[4]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(5),1,0,5));
  ty+=dh;
  buts[5]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(6),1,0,6));
  ty+=dh;
  buts[6]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(91),1,0,7));
  ty+=dh;
  buts[7]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(209),1,0,8));
  ty+=dh;
  buts[8]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(368),1,0,13));
  ty+=dh;
  buts[9] = (Button*)cwin->add( new Button( aguix, 5, ty, catalog.getLocale(396),1,0,14));
  ty+=dh+5;
//  b1=(Button*)cwin->add(new Button(aguix,5,ty,w-10,catalog.getLocale(231),1,0,9));
//  ty+=dh;
  buts[10]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(7),1,0,10));
  ty+=dh;
//  b1=(Button*)cwin->add(new Button(aguix,5,ty,w-10,catalog.getLocale(232),1,0,11));
//  ty+=dh;
  buts[11]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(8),1,0,12));
  ty+=dh;
  Text *ttext=(Text*)cwin->add(new Text(aguix,5,ty,"Worker Configuration",1));
  ty+=ttext->getHeight()+5;
  cwin->add(new Text(aguix,5,ty,"Copyright by Ralf Hoffmann",1));
  ty+=ttext->getHeight()+5;
  h=ty;
  cwin->resize(w,h);
  cwin->maximizeX();
  w = cwin->getWidth();
  cwin->setMaxSize(w,h);
  cwin->setMinSize(w,h);
  
  for ( i = 0; i < 12; i++ )
    buts[i]->resize( w - 10, buts[i]->getHeight() );
  
  cwin->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(cwin);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==cwin->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if ( msg->button.button == buts[0] ) {
          cwin->hide();
          changeGlobal();
          cwin->show();
        } else if ( msg->button.button == buts[1] ) {
          cwin->hide();
          changeColorDefs();
          cwin->show();
        } else if ( msg->button.button == buts[2] ) {
          cwin->hide();
          changeStartup();
          cwin->show();
        } else if ( msg->button.button == buts[3] ) {
          cwin->hide();
          changeButtons();
          cwin->show();
        } else if ( msg->button.button == buts[4] ) {
          cwin->hide();
          changePaths();
          cwin->show();
        } else if ( msg->button.button == buts[5] ) {
          cwin->hide();
          changeTypes();
          cwin->show();
        } else if ( msg->button.button == buts[6] ) {
          cwin->hide();
          changeHotkeys();
          cwin->show();
        } else if ( msg->button.button == buts[7] ) {
          cwin->hide();
          changeFont();
          cwin->show();
        } else if ( msg->button.button == buts[8] ) {
          cwin->hide();
          changeClockbarSets();
          cwin->show();
        } else if ( msg->button.button == buts[9] ) {
          cwin->hide();
          im_export();
          cwin->show();
        } else if ( msg->button.button == buts[10] ) {
          save();
          ende=1;
        } else if ( msg->button.button == buts[11] ) {
          ende=-1;
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  cwin->close();
  delete cwin;
  if(ende==-1) {
    setLang(config_bak->getLang());
    setTerminalBin(config_bak->getTerminalBin());
    setRows(config_bak->getRows());
    setColumns(config_bak->getColumns());
    setCacheSize(config_bak->getCacheSize());
    for(i=0;i<2;i++) {
      setHBarTop(i,config_bak->getHBarTop(i));
      setVBarLeft(i,config_bak->getVBarLeft(i));
      setHBarHeight(i,config_bak->getHBarHeight(i));
      setVBarWidth(i,config_bak->getVBarWidth(i));
      setDisplay(i,config_bak->getDisplay(i));
      setStatusbar(i,config_bak->getStatusbar(i));
      setSelLVB(i,config_bak->getSelLVB(i));
      setUnselLVB(i,config_bak->getUnselLVB(i));
      setSelDir(i,config_bak->getSelDir(i));
      setUnselDir(i,config_bak->getUnselDir(i));
      setSelFile(i,config_bak->getSelFile(i));
      setUnselFile(i,config_bak->getUnselFile(i));
      setSelDirAct(i,config_bak->getSelDirAct(i));
      setUnselDirAct(i,config_bak->getUnselDirAct(i));
      setSelFileAct(i,config_bak->getSelFileAct(i));
      setUnselFileAct(i,config_bak->getUnselFileAct(i));
      setClockbar(i,config_bak->getClockbar(i));
      setRequest(i,config_bak->getRequest(i));
      setStartDir(i,config_bak->getStartDir(i));
    }
    for(i=0;i<4;i++) setFont(i,config_bak->getFont(i));
    setPaths(config_bak->getPaths());
    setFiletypes(config_bak->getFiletypes());
    setHotkeys(config_bak->getHotkeys());
    setButtons(config_bak->getButtons());
    setColors(config_bak->getColors());
    setOwnerstringtype(config_bak->getOwnerstringtype());
    applyColorList(getColors());
    setClockbarMode(config_bak->getClockbarMode());
    setClockbarUpdatetime(config_bak->getClockbarUpdatetime());
    setClockbarCommand(config_bak->getClockbarCommand());
    setDontCheckDirs(config_bak->getDontCheckDirs());
    setListerBG(config_bak->getListerBG());
    setShowStringForDirSize(config_bak->getShowStringForDirSize());
    setStringForDirSize(config_bak->getStringForDirSize());
  }
  delete config_bak;
  initFixTypes(filetypes);
  if(ende==1) {
    applyLanguage();
  }
  return (ende==1)?true:false;
}

bool WConfig::changeTypes()
{
  return changeTypes( false );
}

bool WConfig::changeTypes( bool onlyFiletypes )
{
  return changeTypes( onlyFiletypes, false );
}

/*
 * configures the filetypes
 *
 * args:
 *   bool onlyFiletypes
 *     when true only allow configure of the filetypes
 *     not any other option (currently the "dontcheck"-dirs)
 *   bool allowRemoveUnique
 *     when true allow to remove the unique types (dir, notyet,...)
 *     mainly used for export
 *
 * returnvalues:
 *   bool:  true when okay was choosen
 *          false otherwise
 */
bool WConfig::changeTypes( bool onlyFiletypes, bool allowRemoveUnique )
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1, i;
  Button *dcdb, *b2[2], *b[4];

  w=100;
  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(6));
  t1=(strlen(catalog.getLocale(85))+2);
  t1*=aguix->getCharWidth();
  w=t1;
  t1=(strlen(catalog.getLocale(86))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  t1=(strlen(catalog.getLocale(87))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  t1=(strlen(catalog.getLocale(88))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  w+=10;
  
  ty=5;
  ListView *lv=(ListView*)win->add(new ListView(aguix,5,ty,w-10,150,0));
  lv->setHBarState(2);
  lv->setVBarState(2);
  ty+=lv->getHeight()+5;
  t1=(strlen(catalog.getLocale(85))+2);
  t1*=aguix->getCharWidth();
  Button *newb=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(85),1,0,0));
  t1=(strlen(catalog.getLocale(86))+2);
  t1*=aguix->getCharWidth();
  Button *dupb=(Button*)win->add(new Button(aguix,newb->getX()+newb->getWidth(),ty,t1,
                                            catalog.getLocale(86),1,0,0));
  t1=(strlen(catalog.getLocale(87))+2);
  t1*=aguix->getCharWidth();
  Button *delb=(Button*)win->add(new Button(aguix,dupb->getX()+dupb->getWidth(),ty,t1,
                                            catalog.getLocale(87),1,0,0));
  t1=(strlen(catalog.getLocale(88))+2);
  t1*=aguix->getCharWidth();
  Button *editb=(Button*)win->add(new Button(aguix,delb->getX()+delb->getWidth(),ty,t1,
                                            catalog.getLocale(88),1,0,0));
  ty+=newb->getHeight()+5;
  b[0] = newb;
  b[1] = dupb;
  b[2] = delb;
  b[3] = editb;

  if ( onlyFiletypes == false ) {
    // only add this button when in normal mode
    // this way the user can't choose this button and so can't configure other things
    // then the filetypes
    dcdb=(Button*)win->add(new Button(aguix,5,ty,w-10,
                                      catalog.getLocale(144),1,0,0));
    ty+=dcdb->getHeight()+5;
  } else {
    dcdb = NULL;
  }

  b2[0] = (Button*)win->add( new Button( aguix,
                                         0,
                                         ty,
                                         catalog.getLocale( 11 ),
                                         1,
                                         0,
                                         0 ) );
  b2[1] =(Button*)win->add( new Button( aguix,
                                        0,
                                        ty,
                                        catalog.getLocale( 8 ),
                                        1,
                                        0,
                                        0 ) );
  tw = AGUIX::scaleElementsW( w, 5, 10, -1, false, false, (GUIElement**)b2, 2 );
  if ( tw > w ) w = tw;
  h=b2[0]->getY()+b2[0]->getHeight()+5;
  
  int id=filetypes->initEnum();
  WCFiletype *f1=(WCFiletype*)filetypes->getFirstElement(id);
  while(f1!=NULL) {
    lv->add(new ListViewContent(f1->getName(),1,1,2,2,0,0,1,1,0));
    f1=(WCFiletype*)filetypes->getNextElement(id);
  }
  filetypes->closeEnum(id);
  
  win->resize(w,h);
  //win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  ListViewContent *tlvc;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==b2[0]) ende=1;
        else if(msg->button.button==b2[1]) ende=-1;
        else if(msg->button.button==newb) {
          WCFiletype *tf1=new WCFiletype();
          filetypes->addElement(tf1);
          tlvc=(ListViewContent*)lv->add(new ListViewContent(tf1->getName(),1,1,2,2,
                                         0,0,1,1,0));
          tlvc->setActive(true);
          lv->showActive();
          win->hide();
          if(configureFiletype(tf1)==true) {
            tlvc->setText(tf1->getName());
          }
          win->show();
          lv->redraw();
        } else if(msg->button.button==dupb) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            int pos=lv->getPos(tlvc);
            WCFiletype *tf1=(WCFiletype*)filetypes->getElementAt(pos);
            if(tf1!=NULL) {
              WCFiletype *tf2=tf1->duplicate();
              tf2->setinternID(NORMALTYPE);
              filetypes->addElement(tf2);
              tlvc=(ListViewContent*)lv->add(new ListViewContent(tf2->getName(),1,1,2,2,
                                             0,0,1,1,0));
              tlvc->setActive(true);
              lv->showActive();
            }
          }
        } else if(msg->button.button==delb) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            int pos=lv->getPos(tlvc);
            WCFiletype *tf1=(WCFiletype*)filetypes->getElementAt(pos);
            if(tf1!=NULL) {
              if( ( tf1->getinternID() == NORMALTYPE ) ||
                  ( allowRemoveUnique == true ) ) {
                delete tf1;
                filetypes->removeElementAt(pos);
                lv->remove(pos);
                lv->redraw();
              }
            }
          }
        } else if(msg->button.button==editb) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            int pos=lv->getPos(tlvc);
            WCFiletype *tf1=(WCFiletype*)filetypes->getElementAt(pos);
            if(tf1!=NULL) {
              win->hide();
              if(configureFiletype(tf1)==true) {
                tlvc->setText(tf1->getName());
              }
              win->show();
            }
          }
        } else if(msg->button.button==dcdb) {
          configureDCD(dontcheckdirs);
        }
      } else if ( msg->type == AG_SIZECHANGED ) {
        AGUIX::scaleElementsW( msg->size.neww, 5, 10, -1, false, false, (GUIElement**)b2, 2 );
        AGUIX::scaleElementsW( msg->size.neww, 5, 0, 0, true, true, (GUIElement**)b, 4 );
        if ( dcdb != NULL )
          AGUIX::scaleElementsW( msg->size.neww, 5, 0, 0, true, true, (GUIElement**)&dcdb, 1 );
        
        for ( i = 0; i < 2; i++ ) {
          b2[i]->move( b2[i]->getX(), msg->size.newh - 5 - b2[i]->getHeight() );
        }
        ty = b2[0]->getY();
        if ( dcdb != NULL ) {
          dcdb->move( dcdb->getX(), ty - 5 - dcdb->getHeight() );
          ty = dcdb->getY();
        }
        for ( i = 0; i < 4; i++ ) {
          b[i]->move( b[i]->getX(), ty - 5 - b[i]->getHeight() );
        }
        ty = b[0]->getY();
        lv->resize( msg->size.neww - 10, ty - 5 - lv->getY() );
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setFiletypes(twconfig->getFiletypes());
    setDontCheckDirs(twconfig->getDontCheckDirs());
  } else  {
    recalcMaxFiletypeLen();
  }
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

bool WConfig::changeHotkeys()
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1, i;
  Button *b2[2], *b[4];

  w=150;
  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(91));
  t1=(strlen(catalog.getLocale(154))+2);
  t1*=aguix->getCharWidth();
  w=t1;
  t1=(strlen(catalog.getLocale(155))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  t1=(strlen(catalog.getLocale(156))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  t1=(strlen(catalog.getLocale(157))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  w+=10;
  
  ty=5;
  ListView *lv=(ListView*)win->add(new ListView(aguix,5,ty,w-10,150,0));
  lv->setHBarState(2);
  lv->setVBarState(2);
  ty+=lv->getHeight()+5;
  t1=(strlen(catalog.getLocale(154))+2);
  t1*=aguix->getCharWidth();
  Button *newb=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(154),1,0,0));
  t1=(strlen(catalog.getLocale(155))+2);
  t1*=aguix->getCharWidth();
  Button *dupb=(Button*)win->add(new Button(aguix,newb->getX()+newb->getWidth(),ty,t1,
                                            catalog.getLocale(155),1,0,0));
  t1=(strlen(catalog.getLocale(156))+2);
  t1*=aguix->getCharWidth();
  Button *delb=(Button*)win->add(new Button(aguix,dupb->getX()+dupb->getWidth(),ty,t1,
                                            catalog.getLocale(156),1,0,0));
  t1=(strlen(catalog.getLocale(157))+2);
  t1*=aguix->getCharWidth();
  Button *editb=(Button*)win->add(new Button(aguix,delb->getX()+delb->getWidth(),ty,t1,
                                            catalog.getLocale(157),1,0,0));
  ty+=newb->getHeight()+5;
  
  b[0] = newb;
  b[1] = dupb;
  b[2] = delb;
  b[3] = editb;

  b2[0] = (Button*)win->add( new Button( aguix,
                                         0,
                                         ty,
                                         catalog.getLocale( 11 ),
                                         1,
                                         0,
                                         0 ) );
  b2[1] = (Button*)win->add( new Button( aguix,
                                         0,
                                         ty,
                                         catalog.getLocale( 8 ),
                                         1,
                                         0,
                                         0 ) );
  tw = AGUIX::scaleElementsW( w, 5, 10, -1, false, false, (GUIElement**)b2, 2 );
  if ( tw > w ) w = tw;
  h = b2[0]->getY() + b2[0]->getHeight() + 5;
  
  int id=hotkeys->initEnum();
  WCHotkey *h1=(WCHotkey*)hotkeys->getFirstElement(id);
  while(h1!=NULL) {
    lv->add(new ListViewContent(h1->getName(),1,1,2,2,0,0,1,1,0));
    h1=(WCHotkey*)hotkeys->getNextElement(id);
  }
  hotkeys->closeEnum(id);
  
  win->resize(w,h);
  //win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  ListViewContent *tlvc;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==b2[0]) ende=1;
        else if(msg->button.button==b2[1]) ende=-1;
        else if(msg->button.button==newb) {
          WCHotkey *th1=new WCHotkey();
          hotkeys->addElement(th1);
          tlvc=(ListViewContent*)lv->add(new ListViewContent(th1->getName(),1,1,2,2,
                                         0,0,1,1,0));
          tlvc->setActive(true);
          lv->showActive();
          win->hide();
          if(configureHotkey(th1)==true) {
            tlvc->setText(th1->getName());
            lv->redraw();
          }
          win->show();
        } else if(msg->button.button==dupb) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            int pos=lv->getPos(tlvc);
            WCHotkey *th1=(WCHotkey*)hotkeys->getElementAt(pos);
            if(th1!=NULL) {
              WCHotkey *th2=th1->duplicate();
              // reset shortkey to avoid duplicates
              th2->setKey( NULL );
              hotkeys->addElement(th2);
              tlvc=(ListViewContent*)lv->add(new ListViewContent(th2->getName(),1,1,2,2,
                                             0,0,1,1,0));
              tlvc->setActive(true);
              lv->showActive();
            }
          }
        } else if(msg->button.button==delb) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            int pos=lv->getPos(tlvc);
            WCHotkey *th1=(WCHotkey*)hotkeys->getElementAt(pos);
            if(th1!=NULL) {
              delete th1;
              hotkeys->removeElementAt(pos);
              lv->remove(pos);
              lv->redraw();
            }
          }
        } else if(msg->button.button==editb) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            int pos=lv->getPos(tlvc);
            WCHotkey *th1=(WCHotkey*)hotkeys->getElementAt(pos);
            if(th1!=NULL) {
              win->hide();
              if(configureHotkey(th1)==true) {
                tlvc->setText(th1->getName());
                lv->redraw();
              }
              win->show();
            }
          }
        }
      } else if ( msg->type == AG_SIZECHANGED ) {
        AGUIX::scaleElementsW( msg->size.neww, 5, 10, -1, false, false, (GUIElement**)b2, 2 );
        AGUIX::scaleElementsW( msg->size.neww, 5, 0, 0, true, true, (GUIElement**)b, 4 );
        
        for ( i = 0; i < 2; i++ ) {
          b2[i]->move( b2[i]->getX(), msg->size.newh - 5 - b2[i]->getHeight() );
        }
        ty = b2[0]->getY();
        for ( i = 0; i < 4; i++ ) {
          b[i]->move( b[i]->getX(), ty - 5 - b[i]->getHeight() );
        }
        ty = b[0]->getY();
        lv->resize( msg->size.neww - 10, ty - 5 - lv->getY() );
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setHotkeys(twconfig->getHotkeys());
    // also restore buttons and paths (for the case the user entered a shortkey from one of this
    setButtons(twconfig->getButtons());
    setPaths(twconfig->getPaths());
  }
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

bool WConfig::changeFont()
{
//  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2;
  int erg,i,j;
  char *tstr;
  Requester *req=new Requester(aguix);
  FontRequester *freq=new FontRequester(aguix);
  
  w=100;
  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(209));
  Text *ts[4];
  Button *bs[4];
  t1=(strlen(catalog.getLocale(241))+2);
  t1*=aguix->getCharWidth();
  bs[0]=(Button*)win->add(new Button(aguix,5,5,t1,catalog.getLocale(241),1,0,0));
  ty=bs[0]->getY()+bs[0]->getHeight()+5;
  ts[0]=(Text*)win->add(new Text(aguix,10,ty,fonts[0],1));
  ts[0]->setFont(fonts[0]);
  ty=ts[0]->getY()+ts[0]->getHeight()+5;
  t1=(strlen(catalog.getLocale(242))+2);
  t1*=aguix->getCharWidth();
  bs[1]=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(242),1,0,0));
  ty=bs[1]->getY()+bs[1]->getHeight()+5;
  ts[1]=(Text*)win->add(new Text(aguix,10,ty,fonts[1],1));
  ts[1]->setFont(fonts[1]);
  ty=ts[1]->getY()+ts[1]->getHeight()+5;
  t1=(strlen(catalog.getLocale(243))+2);
  t1*=aguix->getCharWidth();
  bs[2]=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(243),1,0,0));
  ty=bs[2]->getY()+bs[2]->getHeight()+5;
  ts[2]=(Text*)win->add(new Text(aguix,10,ty,fonts[2],1));
  ts[2]->setFont(fonts[2]);
  ty=ts[2]->getY()+ts[2]->getHeight()+5;
  t1=(strlen(catalog.getLocale(244))+2);
  t1*=aguix->getCharWidth();
  bs[3]=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(244),1,0,0));
  ty=bs[3]->getY()+bs[3]->getHeight()+5;
  ts[3]=(Text*)win->add(new Text(aguix,10,ty,fonts[3],1));
  ts[3]->setFont(fonts[3]);
  ty=ts[3]->getY()+ts[3]->getHeight()+5;

  for(i=0;i<4;i++) {
    tw=ts[i]->getX()+ts[i]->getWidth()+10;
    if(tw>w) w=tw;
    tw=bs[i]->getX()+bs[i]->getWidth()+10;
    if(tw>w) w=tw;
  }

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else {
          for(i=0;i<4;i++) {
            if(msg->button.button==bs[i]) {
              tstr=NULL;
              erg=freq->request(fonts[i],&tstr);
              if(erg==0) {
                if(aguix->getFont(tstr)!=NULL) {
                  ts[i]->setText(tstr);
                  ts[i]->setFont(tstr);
                  for(j=0;j<4;j++) {
                    tw=ts[j]->getX()+ts[j]->getWidth()+10;
                    if(tw>w) w=tw;
                  }
                  for(j=1;j<4;j++) {
                    bs[j]->move(bs[j]->getX(),ts[j-1]->getY()+ts[j-1]->getHeight()+5);
                    ts[j]->move(ts[j]->getX(),bs[j]->getY()+bs[j]->getHeight()+5);
                  }
                  okb->move(okb->getX(),ts[3]->getY()+ts[3]->getHeight()+5);
                  cancelb->move(w-5-cancelb->getWidth(),okb->getY());
                  h=okb->getY()+okb->getHeight()+5;
                  win->setMinSize(w,h);
                  win->setMaxSize(w,h);
                  win->resize(w,h);
                } else {
                  req->request(catalog.getLocale(124),catalog.getLocale(365),catalog.getLocale(11));
                }
                _freesafe(tstr);
              }
            }
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
/*  if(ende==-1) {
    // Wiederherstellen
    setFont(0,twconfig->getFont(0));
    setFont(1,twconfig->getFont(1));
    setFont(2,twconfig->getFont(2));
    setFont(3,twconfig->getFont(3));
  }*/
  if(ende==1) {
    setFont(0,ts[0]->getText());
    setFont(1,ts[1]->getText());
    setFont(2,ts[2]->getText());
    setFont(3,ts[3]->getText());
    req->request(catalog.getLocale(124),catalog.getLocale(234),catalog.getLocale(11));
  }
  delete req;
  delete freq;
  win->close();
  delete win;
//  delete twconfig;
  return (ende==-1)?false:true;
}

bool WConfig::changeGlobal()
{
  WConfig *wconfig_bak=duplicate();
  // Aktuelle Daten aendern, bei Cancel Daten aus twconfig wiederherstellen
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ttx,tty;
  w=50;
  h=10;
  Text *ttext;
  CycleButton *cyb;
  AWindow *glwin=new AWindow(aguix);
  glwin->create(NULL,10,10,w,h,0,catalog.getLocale(1));
  char *textstr,*buttonstr;
  int erg;
  Requester *req=new Requester(aguix);

  Text *label1=(Text*)glwin->add(new Text(aguix,5,6,catalog.getLocale(9),1));
  int t1=label1->getWidth()+5,t2;
  char *tstr;
  if((strcmp(lang,"builtin")==0)||(strlen(lang)<1)) tstr=catalog.getLocale(10);
  else tstr=lang;
  t2=strlen(tstr)+2;
  t2*=aguix->getCharWidth();
  Button *langb=(Button*)glwin->add(new Button(aguix,5+t1,5,t2,tstr,1,0,1));
  langb->getPos(&ttx,&tty);
  tw=ttx+langb->getWidth()+5;
  if(tw>w) w=tw;
  int dh=langb->getHeight(),dy=5+dh+5;

  Text *label2=(Text*)glwin->add(new Text(aguix,10,dy+5+2,catalog.getLocale(14),1));
  tstr=(char*)_allocsafe(16);
  sprintf(tstr,"%d",colors->size());
  StringGadget *ccsg=(StringGadget*)glwin->add(new StringGadget(aguix,10+label2->getWidth()+5,dy+5,5*aguix->getCharWidth(),tstr,1));
  _freesafe(tstr);
  tw=label2->getWidth()+5+ccsg->getWidth();
  Button *palb=(Button*)glwin->add(new Button(aguix,10,dy+5+ccsg->getHeight()+5,tw,catalog.getLocale(15),1,0,1));
  BevelBox *bb=(BevelBox*)glwin->add(new BevelBox(aguix,5,dy,tw+10,5+ccsg->getHeight()+5+dh+5,1));
  bb->toBack();
  bb->getPos(&ttx,&tty);
  tw=ttx+bb->getWidth()+5;
  if(tw>w) w=tw;
  dy+=bb->getHeight()+5;

  Button *fileselb=(Button*)glwin->add(new Button(aguix,5,dy,(strlen(catalog.getLocale(16))+2)*aguix->getCharWidth(),catalog.getLocale(16),1,0,1));
  dy+=dh+5;
  t1=strlen(catalog.getLocale(17));
  t2=strlen(catalog.getLocale(18));
  if(t2>t1) t1=t2;
  t1*=aguix->getCharWidth();
  label2=(Text*)glwin->add(new Text(aguix,10,dy+5+2,catalog.getLocale(17),1));
  tstr=(char*)_allocsafe(16);
  sprintf(tstr,"%d",rows);
  StringGadget *rowsg=(StringGadget*)glwin->add(new StringGadget(aguix,10+t1+5,dy+5,5*aguix->getCharWidth(),tstr,1));
  _freesafe(tstr);
  label2=(Text*)glwin->add(new Text(aguix,10,dy+5+2+rowsg->getHeight()+5,catalog.getLocale(18),1));
  tstr=(char*)_allocsafe(16);
  sprintf(tstr,"%d",columns);
  StringGadget *colsg=(StringGadget*)glwin->add(new StringGadget(aguix,10+t1+5,dy+5+rowsg->getHeight()+5,5*aguix->getCharWidth(),tstr,1));
  _freesafe(tstr);
  BevelBox *bb2=(BevelBox*)glwin->add(new BevelBox(aguix,5,dy,5+t1+5+colsg->getWidth()+5,2*colsg->getHeight()+3*5,1));
  bb2->toBack();
  bb2->getPos(&ttx,&tty);
  tw=ttx+bb2->getWidth()+5;
  if(tw>w) w=tw;
  dy+=bb2->getHeight()+5;

  label2=(Text*)glwin->add(new Text(aguix,5,dy+2,catalog.getLocale(233),1));
  tstr=(char*)_allocsafe(128);
  sprintf(tstr,"%d",cachesize);
  StringGadget *cachesg=(StringGadget*)glwin->add(new StringGadget(aguix,
                                                                   5+label2->getWidth()+5,
                                                                   dy,
                                                                   7*aguix->getCharWidth(),
                                                                   tstr,
                                                                   1));
  _freesafe(tstr);
  cachesg->getPos(&ttx,&tty);
  tw=ttx+cachesg->getWidth()+5;
  if(tw>w) w=tw;
  dy+=cachesg->getHeight()+5;

  ttx=5;
  ttext=(Text*)glwin->add(new Text(aguix,ttx,dy,catalog.getLocale(130),1));
  ttx+=ttext->getWidth()+5;
  cyb=(CycleButton*)glwin->add(new CycleButton(aguix,ttx,dy,100,1,0,0));
  cyb->addOption(catalog.getLocale(131));
  cyb->addOption(catalog.getLocale(132));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  if(ownerstringtype==1) cyb->setOption(1);
  else cyb->setOption(0);

  dy+=cyb->getHeight()+5;
  tw=ttx+cyb->getWidth()+5;
  if(tw>w) w=tw;
  ttx=5;

  label2=(Text*)glwin->add(new Text(aguix,ttx,dy,catalog.getLocale(134),1));
  dy+=label2->getHeight()+5;
  tw=ttx+label2->getWidth()+5;
  if(tw>w) w=tw;
  ttx=10;
  StringGadget *termsg=(StringGadget*)glwin->add(new StringGadget(aguix,ttx,dy,30*aguix->getCharWidth(),terminalbin,1));
  dy+=termsg->getHeight()+5;
  tw=ttx+termsg->getWidth()+5;
  if(tw>w) w=tw;
  ttx=5;
  
  ChooseButton *sfds_cb=(ChooseButton*)glwin->add(new ChooseButton(aguix,
                                                                   ttx,
                                                                   dy,
                                                                   20,
                                                                   20,
                                                                   (showStringForDirSize==true)?1:0,
                                                                   catalog.getLocale(386),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0));
  tw=sfds_cb->getX()+sfds_cb->getWidth()+10;
  if(tw>w) w=tw;
  dy+=sfds_cb->getHeight()+5;

  Button *dtb = (Button*)glwin->add( new Button( aguix,
                                                 5,
                                                 dy,
                                                 catalog.getLocale( 439 ),
                                                 1,
                                                 0,
                                                 0 ) );
  tw = dtb->getWidth() + 10;
  if ( tw > w ) w = tw;
  dy += dtb->getHeight() + 5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)glwin->add(new Button(aguix,
                                             5,
                                             dy,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)glwin->add(new Button(aguix,
                                                 w-5-t2,
                                                 dy,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  dy+=dh+5;
  
  h=dy;
  glwin->resize(w,h);
  glwin->setMaxSize(w,h);
  glwin->setMinSize(w,h);
  glwin->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(glwin);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==glwin->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) {
          if(isCorrectTerminalBin(termsg->getText())==false) {
            // show requester
            textstr=catalog.getLocale(195);
            buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                        strlen(catalog.getLocale(196))+1);
            sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                      catalog.getLocale(196));
            erg=req->request(catalog.getLocale(125),textstr,buttonstr);
            _freesafe(buttonstr);
            if(erg==0) {
              termsg->activate();
            } else {
              termsg->setText(TERMINAL_BIN);
            }
          } else ende=1;
        } else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==langb) {
          glwin->hide();
          if(changeLanguage()==true) {
            if((strcmp(lang,"builtin")==0)||(strlen(lang)<1)) langb->setText(0,catalog.getLocale(10));
            else langb->setText(0,lang);
          }
          glwin->show();
        } else if(msg->button.button==palb) {
          glwin->hide();
          changePalette();
          glwin->show();
        } else if(msg->button.button==fileselb) {
          glwin->hide();
          changeFileSets();
          glwin->show();
        } else if ( msg->button.button == dtb ) {
          glwin->hide();
          configureDateTime();
          glwin->show();
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        if(msg->stringgadget.sg==ccsg) {
          int val=0;
          sscanf(ccsg->getText(),"%d",&val);
          if((val<8)||(val>256)) {
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",colors->size());
            ccsg->setText(tstr);
            _freesafe(tstr);
          } else {
            if(colors->size()<val)
              while(colors->size()!=val) colors->addElement(new WC_Color());
            else if(colors->size()>val)
              while(colors->size()!=val) colors->removeLastElement();
            applyColorList(colors);
          }
        } else if(msg->stringgadget.sg==rowsg) {
          int val=0;
          sscanf(rowsg->getText(),"%d",&val);
          if((val<1)||(val>10)) {
            tstr=(char*)_allocsafe(128);
            sprintf(tstr,"%d",rows);
            rowsg->setText(tstr);
            _freesafe(tstr);
          } else setRows(val);
        } else if(msg->stringgadget.sg==colsg) {
          int val=0;
          sscanf(colsg->getText(),"%d",&val);
          if((val<1)||(val>20)) {
            tstr=(char*)_allocsafe(128);
            sprintf(tstr,"%d",columns);
            colsg->setText(tstr);
            _freesafe(tstr);
          } else setColumns(val);
        } else if(msg->stringgadget.sg==cachesg) {
          int val=0;
          sscanf(cachesg->getText(),"%d",&val);
          if(val<1) {
            tstr=(char*)_allocsafe(128);
            sprintf(tstr,"%d",cachesize);
            cachesg->setText(tstr);
            _freesafe(tstr);
          } else setCacheSize(val);
        } else if(msg->stringgadget.sg==termsg) {
#if 0
          if(isCorrectTerminalBin(termsg->getText())==false) {
            // show requester
            textstr=catalog.getLocale(195);
            buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                        strlen(catalog.getLocale(196))+1);
            sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                      catalog.getLocale(196));
            erg=req->request(catalog.getLocale(125),textstr,buttonstr);
            _freesafe(buttonstr);
            if(erg==0) {
              termsg->activate();
            } else {
              termsg->setText(TERMINAL_BIN);
            }
          }
#endif
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setLang(wconfig_bak->getLang());
    setTerminalBin(wconfig_bak->getTerminalBin());
    setRows(wconfig_bak->getRows());
    setColumns(wconfig_bak->getColumns());
    setCacheSize(wconfig_bak->getCacheSize());
    setHBarTop(0,wconfig_bak->getHBarTop(0));
    setVBarLeft(0,wconfig_bak->getVBarLeft(0));
    setHBarHeight(0,wconfig_bak->getHBarHeight(0));
    setVBarWidth(0,wconfig_bak->getVBarWidth(0));
    setDisplay(0,wconfig_bak->getDisplay(0));
    setHBarTop(1,wconfig_bak->getHBarTop(1));
    setVBarLeft(1,wconfig_bak->getVBarLeft(1));
    setHBarHeight(1,wconfig_bak->getHBarHeight(1));
    setVBarWidth(1,wconfig_bak->getVBarWidth(1));
    setDisplay(1,wconfig_bak->getDisplay(1));
    setColors(wconfig_bak->getColors());
    applyColorList(colors);
    setOwnerstringtype(wconfig_bak->getOwnerstringtype());
    setShowStringForDirSize(wconfig_bak->getShowStringForDirSize());
    setDateFormat( wconfig_bak->getDateFormat() );
    setDateFormatString( wconfig_bak->getDateFormatString() );
    setDateSubst( wconfig_bak->getDateSubst() );
    setTimeFormat( wconfig_bak->getTimeFormat() );
    setTimeFormatString( wconfig_bak->getTimeFormatString() );
    setDateBeforeTime( wconfig_bak->getDateBeforeTime() );
  } else {
    setOwnerstringtype(cyb->getSelectedOption());
    setTerminalBin(termsg->getText());
    setShowStringForDirSize((sfds_cb->getState()==1)?true:false);
  }
  delete wconfig_bak;
  glwin->close();
  delete glwin;
  delete req;
  return (ende==-1)?false:true;
}

bool WConfig::changeColorDefs()
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ttw,ty;
  int vw,hw,t1,t2,i;
  vw=strlen(catalog.getLocale(32))+2;
  vw*=aguix->getCharWidth();
  hw=strlen(catalog.getLocale(33))+2;
  hw*=aguix->getCharWidth();
  w=100;
  h=100;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(2));

  tw=strlen(catalog.getLocale(31))+2;
  tw*=aguix->getCharWidth();
  SolidButton *sbsb=(SolidButton*)win->add(new SolidButton(aguix,5,5,tw,catalog.getLocale(31),
                                           statusbar[0],statusbar[1],false));
  Button *sbvb=(Button*)win->add(new Button(aguix,sbsb->getX()+sbsb->getWidth()+5,5,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *sbhb=(Button*)win->add(new Button(aguix,sbvb->getX()+sbvb->getWidth()+5,5,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=sbhb->getX()+sbhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=sbsb->getY()+sbsb->getHeight()+5;
  BevelBox *bb1=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb1->getY()+bb1->getHeight()+5;
  tw=strlen(catalog.getLocale(34))+2;
  tw*=aguix->getCharWidth();
  SolidButton *slvbsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,tw,catalog.getLocale(34),
                                           sel_lvb[0],sel_lvb[1],false));
  Button *slvbvb=(Button*)win->add(new Button(aguix,slvbsb->getX()+slvbsb->getWidth()+5,ty,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *slvbhb=(Button*)win->add(new Button(aguix,slvbvb->getX()+slvbvb->getWidth()+5,ty,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=slvbhb->getX()+slvbhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=slvbsb->getY()+slvbsb->getHeight()+5;
  tw=strlen(catalog.getLocale(35))+2;
  tw*=aguix->getCharWidth();
  SolidButton *ulvbsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,tw,catalog.getLocale(35),
                                           unsel_lvb[0],unsel_lvb[1],false));
  Button *ulvbvb=(Button*)win->add(new Button(aguix,ulvbsb->getX()+ulvbsb->getWidth()+5,ty,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *ulvbhb=(Button*)win->add(new Button(aguix,ulvbvb->getX()+ulvbvb->getWidth()+5,ty,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=ulvbhb->getX()+ulvbhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=ulvbsb->getY()+ulvbsb->getHeight()+5;
  BevelBox *bb2=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb2->getY()+bb2->getHeight()+5;
  tw=strlen(catalog.getLocale(36))+2;
  for(i=37;i<40;i++) {
    ttw=strlen(catalog.getLocale(i))+2;
    if(ttw>tw) tw=ttw;
  }
  for(i=375;i<379;i++) {
    ttw=strlen(catalog.getLocale(i))+2;
    if(ttw>tw) tw=ttw;
  }
  tw*=aguix->getCharWidth();
  ListView *lv=(ListView*)win->add(new ListView(aguix,5,ty,tw,8*ulvbvb->getHeight(),0));
  lv->setHBarState(0);
  lv->setVBarState(0);
  lv->resize(lv->getWidth(),9*lv->getLVCHeight()+5);
  ListViewContent *lvcs[9];
  int fg,bg;
  fg=unsel_dir[0];
  bg=unsel_dir[1];
  lvcs[0]=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(36),fg,fg,fg,fg,
                                                        bg,bg,bg,bg,0));
  fg=sel_dir[0];
  bg=sel_dir[1];
  lvcs[1]=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(37),fg,fg,fg,fg,
                                                        bg,bg,bg,bg,0));
  fg=unsel_file[0];
  bg=unsel_file[1];
  lvcs[2]=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(38),fg,fg,fg,fg,
                                                        bg,bg,bg,bg,0));
  fg=sel_file[0];
  bg=sel_file[1];
  lvcs[3]=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(39),fg,fg,fg,fg,
                                                        bg,bg,bg,bg,0));
  fg=unsel_dir_act[0];
  bg=unsel_dir_act[1];
  lvcs[4]=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(375),fg,fg,fg,fg,
                                                        bg,bg,bg,bg,0));
  fg=sel_dir_act[0];
  bg=sel_dir_act[1];
  lvcs[5]=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(376),fg,fg,fg,fg,
                                                        bg,bg,bg,bg,0));
  fg=unsel_file_act[0];
  bg=unsel_file_act[1];
  lvcs[6]=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(377),fg,fg,fg,fg,
                                                        bg,bg,bg,bg,0));
  fg=sel_file_act[0];
  bg=sel_file_act[1];
  lvcs[7]=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(378),fg,fg,fg,fg,
                                                        bg,bg,bg,bg,0));
  fg=1;
  bg=listerbg;
  lvcs[8]=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(379),fg,fg,fg,fg,
                                                        bg,bg,bg,bg,0));
  Button *b[9][2];
  b[0][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,lv->getLVCHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[0][1]=(Button*)win->add(new Button(aguix,b[0][0]->getX()+b[0][0]->getWidth(),ty,hw,lv->getLVCHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[0][0]->getHeight();
  b[1][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,lv->getLVCHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[1][1]=(Button*)win->add(new Button(aguix,b[1][0]->getX()+b[1][0]->getWidth(),ty,hw,lv->getLVCHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[1][0]->getHeight();
  b[2][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,lv->getLVCHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[2][1]=(Button*)win->add(new Button(aguix,b[2][0]->getX()+b[1][0]->getWidth(),ty,hw,lv->getLVCHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[2][0]->getHeight();
  b[3][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,lv->getLVCHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[3][1]=(Button*)win->add(new Button(aguix,b[1][0]->getX()+b[3][0]->getWidth(),ty,hw,lv->getLVCHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[3][0]->getHeight();
  b[4][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,lv->getLVCHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[4][1]=(Button*)win->add(new Button(aguix,b[4][0]->getX()+b[4][0]->getWidth(),ty,hw,lv->getLVCHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[4][0]->getHeight();
  b[5][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,lv->getLVCHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[5][1]=(Button*)win->add(new Button(aguix,b[5][0]->getX()+b[5][0]->getWidth(),ty,hw,lv->getLVCHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[5][0]->getHeight();
  b[6][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,lv->getLVCHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[6][1]=(Button*)win->add(new Button(aguix,b[6][0]->getX()+b[6][0]->getWidth(),ty,hw,lv->getLVCHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[6][0]->getHeight();
  b[7][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,lv->getLVCHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[7][1]=(Button*)win->add(new Button(aguix,b[7][0]->getX()+b[7][0]->getWidth(),ty,hw,lv->getLVCHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[7][0]->getHeight();
  b[8][0]=NULL;
  b[8][1]=(Button*)win->add(new Button(aguix,b[7][0]->getX()+b[7][0]->getWidth(),ty,hw,lv->getLVCHeight(),
                                       catalog.getLocale(33),1,0,0));
  tw=b[7][1]->getX()+b[7][1]->getWidth()+5;
  if(tw>w) w=tw;
  ty=lv->getY()+lv->getHeight()+5;
  BevelBox *bb3=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb3->getY()+bb3->getHeight()+5;
  tw=strlen(catalog.getLocale(43))+2;
  tw*=aguix->getCharWidth();
  SolidButton *cbsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,tw,catalog.getLocale(43),
                                           clockbar[0],clockbar[1],false));
  Button *cbvb=(Button*)win->add(new Button(aguix,cbsb->getX()+cbsb->getWidth()+5,ty,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *cbhb=(Button*)win->add(new Button(aguix,cbvb->getX()+cbvb->getWidth()+5,ty,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=cbhb->getX()+cbhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=cbsb->getY()+cbsb->getHeight()+5;
  BevelBox *bb4=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb4->getY()+bb4->getHeight()+5;
  tw=strlen(catalog.getLocale(44))+2;
  tw*=aguix->getCharWidth();
  SolidButton *rsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,tw,catalog.getLocale(44),
                                           request[0],request[1],false));
  Button *rvb=(Button*)win->add(new Button(aguix,rsb->getX()+rsb->getWidth()+5,ty,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *rhb=(Button*)win->add(new Button(aguix,rvb->getX()+rvb->getWidth()+5,ty,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=rhb->getX()+rhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=rsb->getY()+rsb->getHeight()+5;
  BevelBox *bb5=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb5->getY()+bb5->getHeight()+5;  
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  bb1->resize(w-10,2);
  bb2->resize(w-10,2);
  bb3->resize(w-10,2);
  bb4->resize(w-10,2);
  bb5->resize(w-10,2);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0,col;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==sbvb) {
          col=palette(statusbar[0]);
          if(col>=0) {
            statusbar[0]=col;
            sbsb->setFG(col);
          }
        } else if(msg->button.button==sbhb) {
          col=palette(statusbar[1]);
          if(col>=0) {
            statusbar[1]=col;
            sbsb->setBG(col);
          }
        } else if(msg->button.button==slvbvb) {
          col=palette(sel_lvb[0]);
          if(col>=0) {
            sel_lvb[0]=col;
            slvbsb->setFG(col);
          }
        } else if(msg->button.button==slvbhb) {
          col=palette(sel_lvb[1]);
          if(col>=0) {
            sel_lvb[1]=col;
            slvbsb->setBG(col);
          }
        } else if(msg->button.button==ulvbvb) {
          col=palette(unsel_lvb[0]);
          if(col>=0) {
            unsel_lvb[0]=col;
            ulvbsb->setFG(col);
          }
        } else if(msg->button.button==ulvbhb) {
          col=palette(unsel_lvb[1]);
          if(col>=0) {
            unsel_lvb[1]=col;
            ulvbsb->setBG(col);
          }
        } else if(msg->button.button==cbvb) {
          col=palette(clockbar[0]);
          if(col>=0) {
            clockbar[0]=col;
            cbsb->setFG(col);
          }
        } else if(msg->button.button==cbhb) {
          col=palette(clockbar[1]);
          if(col>=0) {
            clockbar[1]=col;
            cbsb->setBG(col);
          }
        } else if(msg->button.button==rvb) {
          col=palette(request[0]);
          if(col>=0) {
            request[0]=col;
            rsb->setFG(col);
          }
        } else if(msg->button.button==rhb) {
          col=palette(request[1]);
          if(col>=0) {
            request[1]=col;
            rsb->setBG(col);
          }
        } else {
          for(i=0;i<9;i++) {
            if(msg->button.button==b[i][0]) {
              switch(i) {
                case 0:
                  col=palette(unsel_dir[0]);
                  if(col>=0) {
                    unsel_dir[0]=col;
                    lvcs[i]->setFG(0,col);
                    lvcs[i]->setFG(1,col);
                    lvcs[i]->setFG(2,col);
                    lvcs[i]->setFG(3,col);
                  }
                  break;
                case 1:
                  col=palette(sel_dir[0]);
                  if(col>=0) {
                    sel_dir[0]=col;
                    lvcs[i]->setFG(0,col);
                    lvcs[i]->setFG(1,col);
                    lvcs[i]->setFG(2,col);
                    lvcs[i]->setFG(3,col);
                  }
                  break;
                case 2:
                  col=palette(unsel_file[0]);
                  if(col>=0) {
                    unsel_file[0]=col;
                    lvcs[i]->setFG(0,col);
                    lvcs[i]->setFG(1,col);
                    lvcs[i]->setFG(2,col);
                    lvcs[i]->setFG(3,col);
                  }
                  break;
                case 3:
                  col=palette(sel_file[0]);
                  if(col>=0) {
                    sel_file[0]=col;
                    lvcs[i]->setFG(0,col);
                    lvcs[i]->setFG(1,col);
                    lvcs[i]->setFG(2,col);
                    lvcs[i]->setFG(3,col);
                  }
                  break;
                case 4:
                  col=palette(unsel_dir_act[0]);
                  if(col>=0) {
                    unsel_dir_act[0]=col;
                    lvcs[i]->setFG(0,col);
                    lvcs[i]->setFG(1,col);
                    lvcs[i]->setFG(2,col);
                    lvcs[i]->setFG(3,col);
                  }
                  break;
                case 5:
                  col=palette(sel_dir_act[0]);
                  if(col>=0) {
                    sel_dir_act[0]=col;
                    lvcs[i]->setFG(0,col);
                    lvcs[i]->setFG(1,col);
                    lvcs[i]->setFG(2,col);
                    lvcs[i]->setFG(3,col);
                  }
                  break;
                case 6:
                  col=palette(unsel_file_act[0]);
                  if(col>=0) {
                    unsel_file_act[0]=col;
                    lvcs[i]->setFG(0,col);
                    lvcs[i]->setFG(1,col);
                    lvcs[i]->setFG(2,col);
                    lvcs[i]->setFG(3,col);
                  }
                  break;
                default:
                  col=palette(sel_file_act[0]);
                  if(col>=0) {
                    sel_file_act[0]=col;
                    lvcs[i]->setFG(0,col);
                    lvcs[i]->setFG(1,col);
                    lvcs[i]->setFG(2,col);
                    lvcs[i]->setFG(3,col);
                  }
              }
            } else if(msg->button.button==b[i][1]) {
              switch(i) {
                case 0:
                  col=palette(unsel_dir[1]);
                  if(col>=0) {
                    unsel_dir[1]=col;
                    lvcs[i]->setBG(0,col);
                    lvcs[i]->setBG(1,col);
                    lvcs[i]->setBG(2,col);
                    lvcs[i]->setBG(3,col);
                  }
                  break;
                case 1:
                  col=palette(sel_dir[1]);
                  if(col>=0) {
                    sel_dir[1]=col;
                    lvcs[i]->setBG(0,col);
                    lvcs[i]->setBG(1,col);
                    lvcs[i]->setBG(2,col);
                    lvcs[i]->setBG(3,col);
                  }
                  break;
                case 2:
                  col=palette(unsel_file[1]);
                  if(col>=0) {
                    unsel_file[1]=col;
                    lvcs[i]->setBG(0,col);
                    lvcs[i]->setBG(1,col);
                    lvcs[i]->setBG(2,col);
                    lvcs[i]->setBG(3,col);
                  }
                  break;
                case 3:
                  col=palette(sel_file[1]);
                  if(col>=0) {
                    sel_file[1]=col;
                    lvcs[i]->setBG(0,col);
                    lvcs[i]->setBG(1,col);
                    lvcs[i]->setBG(2,col);
                    lvcs[i]->setBG(3,col);
                  }
                  break;
                case 4:
                  col=palette(unsel_dir_act[1]);
                  if(col>=0) {
                    unsel_dir_act[1]=col;
                    lvcs[i]->setBG(0,col);
                    lvcs[i]->setBG(1,col);
                    lvcs[i]->setBG(2,col);
                    lvcs[i]->setBG(3,col);
                  }
                  break;
                case 5:
                  col=palette(sel_dir_act[1]);
                  if(col>=0) {
                    sel_dir_act[1]=col;
                    lvcs[i]->setBG(0,col);
                    lvcs[i]->setBG(1,col);
                    lvcs[i]->setBG(2,col);
                    lvcs[i]->setBG(3,col);
                  }
                  break;
                case 6:
                  col=palette(unsel_file_act[1]);
                  if(col>=0) {
                    unsel_file_act[1]=col;
                    lvcs[i]->setBG(0,col);
                    lvcs[i]->setBG(1,col);
                    lvcs[i]->setBG(2,col);
                    lvcs[i]->setBG(3,col);
                  }
                  break;
                case 7:
                  col=palette(sel_file_act[1]);
                  if(col>=0) {
                    sel_file_act[1]=col;
                    lvcs[i]->setBG(0,col);
                    lvcs[i]->setBG(1,col);
                    lvcs[i]->setBG(2,col);
                    lvcs[i]->setBG(3,col);
                  }
                  break;
                default:
                  col=palette(listerbg);
                  if(col>=0) {
                    listerbg=col;
                    lvcs[i]->setBG(0,col);
                    lvcs[i]->setBG(1,col);
                    lvcs[i]->setBG(2,col);
                    lvcs[i]->setBG(3,col);
                  }
              }
            }
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    statusbar[0]=twconfig->getStatusbar(0);
    statusbar[1]=twconfig->getStatusbar(1);
    sel_lvb[0]=twconfig->getSelLVB(0);
    sel_lvb[1]=twconfig->getSelLVB(1);
    unsel_lvb[0]=twconfig->getUnselLVB(0);
    unsel_lvb[1]=twconfig->getUnselLVB(1);
    sel_dir[0]=twconfig->getSelDir(0);
    sel_dir[1]=twconfig->getSelDir(1);
    unsel_dir[0]=twconfig->getUnselDir(0);
    unsel_dir[1]=twconfig->getUnselDir(1);
    sel_file[0]=twconfig->getSelFile(0);
    sel_file[1]=twconfig->getSelFile(1);
    unsel_file[0]=twconfig->getUnselFile(0);
    unsel_file[1]=twconfig->getUnselFile(1);
    sel_dir_act[0]=twconfig->getSelDirAct(0);
    sel_dir_act[1]=twconfig->getSelDirAct(1);
    unsel_dir_act[0]=twconfig->getUnselDirAct(0);
    unsel_dir_act[1]=twconfig->getUnselDirAct(1);
    sel_file_act[0]=twconfig->getSelFileAct(0);
    sel_file_act[1]=twconfig->getSelFileAct(1);
    unsel_file_act[0]=twconfig->getUnselFileAct(0);
    unsel_file_act[1]=twconfig->getUnselFileAct(1);
    clockbar[0]=twconfig->getClockbar(0);
    clockbar[1]=twconfig->getClockbar(1);
    request[0]=twconfig->getRequest(0);
    request[1]=twconfig->getRequest(1);
    listerbg=twconfig->getListerBG();
  }
  delete twconfig;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

bool WConfig::changeStartup()
{
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2;
  w=100;
  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(3));
  Text *tt1=(Text*)win->add(new Text(aguix,5,5,catalog.getLocale(46),1));
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,10,
                                            tt1->getY()+tt1->getHeight()+5,tt1->getWidth(),
                                            dir[0],0));
  ty=sg1->getY()+sg1->getHeight()+5;
  tw=sg1->getX()+sg1->getWidth()+15;
  if(tw>w) w=tw;
  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(47),1));
  StringGadget *sg2=(StringGadget*)win->add(new StringGadget(aguix,10,
                                            tt1->getY()+tt1->getHeight()+5,tt1->getWidth(),
                                            dir[1],0));
  ty=sg2->getY()+sg2->getHeight()+5;
  tw=sg2->getX()+sg2->getWidth()+15;
  if(tw>w) w=tw;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  sg1->resize(w-15,sg1->getHeight());
  sg2->resize(w-15,sg2->getHeight());
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    setStartDir(0,sg1->getText());
    setStartDir(1,sg2->getText());
  }
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

bool WConfig::changeButtons()
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty,tx;
  int t1,t2,t3,t4,t5,tt;
  char bankstr[64];
  int banknr=0,i;
  unsigned int i2;
  bool extmode=false;
  CycleButton *cyb;
  Text *mtext;
  
  t1=strlen(catalog.getLocale(68))+1+3+1;
  t1*=aguix->getCharWidth();
  for(i=69;i<73;i++) {
    t2=(strlen(catalog.getLocale(i))+2);
    t2*=aguix->getCharWidth();
    t1+=t2;
  }
  w=t1;
  for(i=53;i<59;i++) {
    t1=(strlen(catalog.getLocale(i))+2);
    t1*=aguix->getCharWidth();
    if(t1>w) w=t1;
  }
  t1=(strlen(catalog.getLocale(48))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(49))+2);
  t2*=aguix->getCharWidth();
  t1+=t2;
  t2=(strlen(catalog.getLocale(50))+2);
  t2*=aguix->getCharWidth();
  t1+=t2;
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  t1+=t2;
  t2=(strlen(catalog.getLocale(11))+2);
  t2*=aguix->getCharWidth();
  t1+=t2;
  t1+=20;
  if(t1>w) w=t1;
  if(t1>t2) t2=t1;
  t1+=150+10;
  if(t1>w) w=t1;
  w+=10;

  mtext=new Text(aguix,0,0,catalog.getLocale(227),1);
  cyb=new CycleButton(aguix,0,0,100,1,0,0);
  cyb->addOption(catalog.getLocale(228));
  cyb->addOption(catalog.getLocale(229));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  t1=5+mtext->getWidth()+5+cyb->getWidth()+5;
  if(t1>w) w=t1;

  if(w<600) w=600;

  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(4));
  ty=5;

  sprintf(bankstr,"%d",banknr);
  Button *bbs[rows*columns][2];
  BevelBox *bevelb[2];
  Text *tt1;
  for(int k=0;k<2;k++) {
    bevelb[k]=(BevelBox*)win->add(new BevelBox(aguix,5,ty,w-10,10,true));
    ty+=5;
    tt1=(Text*)win->add(new Text(aguix,10,ty,catalog.getLocale(51+k),1));
    ty+=tt1->getHeight()+5;
    for(i2=0;i2<rows;i2++) {
      tw=w-20;
      for(unsigned int j=0;j<columns;j++) {
        t1=tw/(columns-j);
        if(j<1) t2=10;
        else t2=bbs[i2*columns+j-1][k]->getX()+bbs[i2*columns+j-1][k]->getWidth();
        bbs[i2*columns+j][k]=(Button*)win->add(new Button(aguix,t2,ty,t1,"",1,0,2*(i2*columns+j)+k));
        tw-=bbs[i2*columns+j][k]->getWidth();
      }
      ty+=bbs[i2*columns][k]->getHeight();
    }
    ty+=5;
    bevelb[k]->resize(bevelb[k]->getWidth(),ty-bevelb[k]->getY());
    ty+=5;
  }
  tx=5;
  tt1=(Text*)win->add(new Text(aguix,tx,ty,catalog.getLocale(68),1));
  tx+=tt1->getWidth()+5;
  Text *bnrt=(Text*)win->add(new Text(aguix,tx,ty,"   ",1));
  tx+=bnrt->getWidth()+5;
  tw=strlen(catalog.getLocale(69))+2;
  tw*=aguix->getCharWidth();
  Button *nextbb=(Button*)win->add(new Button(aguix,tx,ty,tw,
                                              catalog.getLocale(69),1,0,0));
  tx+=nextbb->getWidth()+5;
  tw=strlen(catalog.getLocale(70))+2;
  tw*=aguix->getCharWidth();
  Button *prevbb=(Button*)win->add(new Button(aguix,tx,ty,tw,
                                              catalog.getLocale(70),1,0,0));
  tx+=prevbb->getWidth()+5;
  tw=strlen(catalog.getLocale(71))+2;
  tw*=aguix->getCharWidth();
  Button *newbb=(Button*)win->add(new Button(aguix,tx,ty,tw,
                                             catalog.getLocale(71),1,0,0));
  tx+=newbb->getWidth()+5;
  tw=strlen(catalog.getLocale(72))+2;
  tw*=aguix->getCharWidth();
  Button *delbb=(Button*)win->add(new Button(aguix,tx,ty,tw,
                                             catalog.getLocale(72),1,0,0));
  ty+=delbb->getHeight()+5;
  SolidButton *sbsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,w-10,"",2,3,false));
  ty+=sbsb->getHeight()+5;

  tx=5;
  mtext->move(5,ty);
  win->add(mtext);
  tx+=mtext->getWidth()+5;
  cyb->move(tx,ty);
  win->add(cyb);
  if(extmode==true) cyb->setOption(1);
  else cyb->setOption(0);

  ty+=cyb->getHeight()+5;
  tw=tx+cyb->getWidth()+5;
  if(tw>w) w=tw;
  tx=5;

  t1=(strlen(catalog.getLocale(48))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(49))+2);
  t2*=aguix->getCharWidth();
  t3=(strlen(catalog.getLocale(50))+2);
  t3*=aguix->getCharWidth();
  t4=(strlen(catalog.getLocale(8))+2);
  t4*=aguix->getCharWidth();
  t5=(strlen(catalog.getLocale(11))+2);
  t5*=aguix->getCharWidth();
  double d1=w-10;
  d1/=5;
  tt=w-10-t2-t3-t4-t5;
  if(tt>d1) t1=(int)d1; else t1=tt;
  tt=w-10-t1-t3-t4-t5;
  if(tt>d1) t2=(int)d1; else t2=tt;
  tt=w-10-t1-t2-t4-t5;
  if(tt>d1) t3=(int)d1; else t3=tt;
  tt=w-10-t1-t2-t3-t5;
  if(tt>d1) t4=(int)d1; else t4=tt;
  tt=w-10-t1-t2-t3-t4;
  if(tt>d1) t5=(int)d1; else t5=tt;
  
  Button *copyb=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(48),1,0,0));
  Button *swapb=(Button*)win->add(new Button(aguix,copyb->getX()+copyb->getWidth(),
                                             ty,t2,catalog.getLocale(49),1,0,0));
  Button *delb=(Button*)win->add(new Button(aguix,swapb->getX()+swapb->getWidth(),
                                            ty,t3,catalog.getLocale(50),1,0,0));
  Button *okb=(Button*)win->add(new Button(aguix,
                                             delb->getX()+delb->getWidth(),
                                             ty,
                                             t4,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 okb->getX()+okb->getWidth(),
                                                 ty,
                                                 t5,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  int banksize=rows*columns*2;
  int maxbank=buttons->size()/banksize;
  int mode=0;
  int selindex=-1;
  bnrt->setText(bankstr);
  sbsb->setText(catalog.getLocale(53));
  showButtonBank(banknr,bbs);
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==nextbb) {
          if((banknr+1)<maxbank) {
            banknr++;
            showButtonBank(banknr,bbs);
            sprintf(bankstr,"%d",banknr);
            bnrt->setText(bankstr);
          }
        } else if(msg->button.button==prevbb) {
          if(banknr>0) {
            banknr--;
            showButtonBank(banknr,bbs);
            sprintf(bankstr,"%d",banknr);
            bnrt->setText(bankstr);
          }
        } else if(msg->button.button==newbb) {
          int s2=(banknr+1)*banksize;
          for(i=0;i<banksize;i++) {
            buttons->addElementAt(s2,new WCButton());
          }
          maxbank++;
          banknr++;
          showButtonBank(banknr,bbs);
          sprintf(bankstr,"%d",banknr);
          bnrt->setText(bankstr);
        } else if(msg->button.button==delbb) {
          if(maxbank>1) {
            int s2=banknr*banksize;
            WCButton *b1;
            for(i=0;i<banksize;i++) {
              b1=(WCButton*)buttons->getElementAt(s2);
              delete b1;
              buttons->removeElementAt(s2);
            }
            maxbank--;
            if(banknr>=maxbank) {
              banknr--;
              sprintf(bankstr,"%d",banknr);
              bnrt->setText(bankstr);
            }
            showButtonBank(banknr,bbs);
          }
        } else if(msg->button.button==copyb) {
          if((mode==1)||(mode==2)) {
            sbsb->setText(catalog.getLocale(53));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(54));
            mode=1;
          }
        } else if(msg->button.button==swapb) {
          if((mode==3)||(mode==4)) {
            sbsb->setText(catalog.getLocale(53));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(56));
            mode=3;
          }
        } else if(msg->button.button==delb) {
          if(mode==5) {
            sbsb->setText(catalog.getLocale(53));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(58));
            mode=5;
          }
        } else {
          t1=msg->button.button->getData();
          if(t1>=0) {
            t2=t1&1;
            t3=t1/2;
            if(bbs[t3][t2]==msg->button.button) {
              int s1=t1+banknr*banksize;
              WCButton *b1,*b2;
              switch(mode) {
                case 1:
                  selindex=s1;
                  sbsb->setText(catalog.getLocale(55));
                  mode=2;
                  break;
                case 2:
                  // copy selindex -> s1
                  b1=(WCButton*)buttons->getElementAt(selindex);
                  b2=b1->duplicate();
                  // reset shortkey to avoid duplicates
                  b2->setKey( NULL );
                  
                  b1=(WCButton*)buttons->exchangeElement(s1,b2);
                  if(b1!=NULL) delete b1;
                  showButtonBank(banknr,bbs);
                  if(extmode==true) {
                    sbsb->setText(catalog.getLocale(54));
                    mode=1;
                  } else {
                    sbsb->setText(catalog.getLocale(53));
                    mode=0;
                  }
                  break;
                case 3:
                  selindex=s1;
                  sbsb->setText(catalog.getLocale(57));
                  mode=4;
                  break;
                case 4:
                  // swap s1 <-> selindex
                  b1=(WCButton*)buttons->getElementAt(selindex);
                  b2=(WCButton*)buttons->exchangeElement(s1,b1);
                  buttons->exchangeElement(selindex,b2);
                  showButtonBank(banknr,bbs);
                  if(extmode==true) {
                    sbsb->setText(catalog.getLocale(56));
                    mode=3;
                  } else {
                    sbsb->setText(catalog.getLocale(53));
                    mode=0;
                  }
                  break;
                case 5:
                  // del s1
                  b1=new WCButton();
                  b2=(WCButton*)buttons->exchangeElement(s1,b1);
                  if(b2!=NULL) delete b2;
                  showButtonBank(banknr,bbs);
                  if(extmode==false) {
                    sbsb->setText(catalog.getLocale(53));
                    mode=0;
                  }
                  break;
                default:
                  // configure s1
                  b1=(WCButton*)buttons->getElementAt(s1);
                  if(b1!=NULL) {
                    win->hide();
                    if(configureButton(b1)==true) {
                      msg->button.button->setText(0,b1->getText());
                      msg->button.button->setFG(0,b1->getFG());
                      msg->button.button->setBG(0,b1->getBG());
                    }
                    win->show();
                  }
              }
            }
          }
        }
      } else if(msg->type==AG_CYCLEBUTTONCLICKED) {
        if(msg->cyclebutton.cyclebutton==cyb) {
          if(msg->cyclebutton.option==1) extmode=true;
          else extmode=false;
        }
      } else if(msg->type==AG_KEYRELEASED) {
        if(msg->key.key==XK_Escape) {
          sbsb->setText(catalog.getLocale(53));
          mode=0;
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setButtons(twconfig->getButtons());
    // also restore paths and hotkeys (for the case the user entered a shortkey from one of this
    setPaths(twconfig->getPaths());
    setHotkeys(twconfig->getHotkeys());
  } else cleanUpButtons();
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

bool WConfig::changePaths()
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2,t3,tt,tx;
  char bankstr[64];
  int banknr=0,i;
  unsigned int i2;
  bool extmode=false;
  CycleButton *cyb;
  Text *mtext; 

  t1=(strlen(catalog.getLocale(73))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(74))+2);
  t2*=aguix->getCharWidth();
  t1+=t2;
  t2=(strlen(catalog.getLocale(75))+2);
  t2*=aguix->getCharWidth();
  t1+=t2;
  w=t1;
  for(i=76;i<82;i++) {
    t1=(strlen(catalog.getLocale(i))+2);
    t1*=aguix->getCharWidth();
    if(t1>w) w=t1;
  }
  t2=0;
  for(i=69;i<73;i++) {
    t1=(strlen(catalog.getLocale(i))+2);
    t1*=aguix->getCharWidth();
    if(t1>t2) t2=t1;
    t1+=150+10;
    if(t1>w) w=t1;
  }
  t1=(strlen(catalog.getLocale(68))+5);
  t1*=aguix->getCharWidth();
  if(t1>t2) t2=t1;
  t1+=150+10;
  if(t1>w) w=t1;
  w+=10;

  mtext=new Text(aguix,0,0,catalog.getLocale(227),1);
  cyb=new CycleButton(aguix,0,0,100,1,0,0);
  cyb->addOption(catalog.getLocale(228));
  cyb->addOption(catalog.getLocale(229));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  t1=5+mtext->getWidth()+5+cyb->getWidth()+5;
  if(t1>w) w=t1;

  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(5));
  ty=5;

  sprintf(bankstr,"%d",banknr);
  Button *pbs[rows];
  for(i2=0;i2<rows;i2++) {
    pbs[i2]=(Button*)win->add(new Button(aguix,5,ty+((i2==0)?0:(pbs[i2-1]->getHeight()*i2)),
                                        w-5-t2-5-5,"",1,0,0));
  }
  Text *tt1=(Text*)win->add(new Text(aguix,w-5-t2,ty,catalog.getLocale(68),1));
  Text *bnrt=(Text*)win->add(new Text(aguix,tt1->getX()+tt1->getWidth()+5,ty,
                                      bankstr,1));
  ty+=pbs[0]->getHeight();
  Button *nextbb=(Button*)win->add(new Button(aguix,w-5-t2,ty,t2,
                                              catalog.getLocale(69),1,0,0));
  ty+=nextbb->getHeight();
  Button *prevbb=(Button*)win->add(new Button(aguix,w-5-t2,ty,t2,
                                              catalog.getLocale(70),1,0,0));
  ty+=prevbb->getHeight();
  Button *newbb=(Button*)win->add(new Button(aguix,w-5-t2,ty,t2,
                                             catalog.getLocale(71),1,0,0));
  ty+=newbb->getHeight();
  Button *delbb=(Button*)win->add(new Button(aguix,w-5-t2,ty,t2,
                                             catalog.getLocale(72),1,0,0));
  ty=delbb->getY()+delbb->getHeight()+5;
  t2=pbs[rows-1]->getY()+pbs[rows-1]->getHeight()+5;
  if(t2>ty) ty=t2;

  t1=(strlen(catalog.getLocale(73))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(74))+2);
  t2*=aguix->getCharWidth();
  t3=(strlen(catalog.getLocale(75))+2);
  t3*=aguix->getCharWidth();
  double d1=w-10;
  d1/=3;
  tt=w-10-t2-t3;
  if(tt>d1) t1=(int)d1; else t1=tt;
  tt=w-10-t1-t3;
  if(tt>d1) t2=(int)d1; else t2=tt;
  tt=w-10-t1-t2;
  if(tt>d1) t3=(int)d1; else t3=tt;
  
  Button *copyb=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(73),1,0,0));
  Button *swapb=(Button*)win->add(new Button(aguix,copyb->getX()+copyb->getWidth(),
                                             ty,t2,catalog.getLocale(74),1,0,0));
  Button *delb=(Button*)win->add(new Button(aguix,swapb->getX()+swapb->getWidth(),
                                            ty,t3,catalog.getLocale(75),1,0,0));
  ty+=delb->getHeight()+5;
  SolidButton *sbsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,w-10,"",2,3,false));
  ty+=sbsb->getHeight()+5;

  tx=5;
  mtext->move(5,ty);
  win->add(mtext);
  tx+=mtext->getWidth()+5;
  cyb->move(tx,ty);
  win->add(cyb);
  if(extmode==true) cyb->setOption(1);
  else cyb->setOption(0);

  ty+=cyb->getHeight()+5;
  tw=tx+cyb->getWidth()+5;
  if(tw>w) w=tw;
  tx=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  int maxbank=paths->size()/rows;
  int mode=0;
  int selindex=-1;
  sbsb->setText(catalog.getLocale(76));
  showPathBank(banknr,pbs);
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==nextbb) {
          if((banknr+1)<maxbank) {
            banknr++;
            showPathBank(banknr,pbs);
            sprintf(bankstr,"%d",banknr);
            bnrt->setText(bankstr);
          }
        } else if(msg->button.button==prevbb) {
          if(banknr>0) {
            banknr--;
            showPathBank(banknr,pbs);
            sprintf(bankstr,"%d",banknr);
            bnrt->setText(bankstr);
          }
        } else if(msg->button.button==newbb) {
          int s2=(banknr+1)*rows;
          for(i2=0;i2<rows;i2++) {
            paths->addElementAt(s2,new WCPath());
          }
          maxbank++;
          banknr++;
          showPathBank(banknr,pbs);
          sprintf(bankstr,"%d",banknr);
          bnrt->setText(bankstr);
        } else if(msg->button.button==delbb) {
          if(maxbank>1) {
            int s2=banknr*rows;
            WCPath *p1;
            for(i2=0;i2<rows;i2++) {
              p1=(WCPath*)paths->getElementAt(s2);
              delete p1;
              paths->removeElementAt(s2);
            }
            maxbank--;
            if(banknr>=maxbank) {
              banknr--;
              sprintf(bankstr,"%d",banknr);
              bnrt->setText(bankstr);
            }
            showPathBank(banknr,pbs);
          }
        } else if(msg->button.button==copyb) {
          if((mode==1)||(mode==2)) {
            sbsb->setText(catalog.getLocale(76));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(77));
            mode=1;
          }
        } else if(msg->button.button==swapb) {
          if((mode==3)||(mode==4)) {
            sbsb->setText(catalog.getLocale(76));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(79));
            mode=3;
          }
        } else if(msg->button.button==delb) {
          if(mode==5) {
            sbsb->setText(catalog.getLocale(76));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(81));
            mode=5;
          }
        } else {
          for(i2=0;i2<rows;i2++) {
            if(msg->button.button==pbs[i2]) {
              int s1=i2+banknr*rows;
              WCPath *p1,*p2;
              switch(mode) {
                case 1:
                  selindex=s1;
                  sbsb->setText(catalog.getLocale(78));
                  mode=2;
                  break;
                case 2:
                  // copy selindex -> s1
                  p1=(WCPath*)paths->getElementAt(selindex);
                  p2=p1->duplicate();
                  // reset shortkey to avoid duplicates
                  p2->setKey( NULL );
                  
                  p1=(WCPath*)paths->exchangeElement(s1,p2);
                  if(p1!=NULL) delete p1;
                  showPathBank(banknr,pbs);
                  if(extmode==true) {
                    sbsb->setText(catalog.getLocale(77));
                    mode=1;
                  } else {
                    sbsb->setText(catalog.getLocale(76));
                    mode=0;
                  }
                  break;
                case 3:
                  selindex=s1;
                  sbsb->setText(catalog.getLocale(80));
                  mode=4;
                  break;
                case 4:
                  // swap s1 <-> selindex
                  p1=(WCPath*)paths->getElementAt(selindex);
                  p2=(WCPath*)paths->exchangeElement(s1,p1);
                  paths->exchangeElement(selindex,p2);
                  showPathBank(banknr,pbs);
                  if(extmode==true) {
                    sbsb->setText(catalog.getLocale(79));
                    mode=3;
                  } else {
                    sbsb->setText(catalog.getLocale(76));
                    mode=0;
                  }
                  break;
                case 5:
                  // del s1
                  p1=new WCPath();
                  p2=(WCPath*)paths->exchangeElement(s1,p1);
                  if(p2!=NULL) delete p2;
                  showPathBank(banknr,pbs);
                  if(extmode==false) {
                    sbsb->setText(catalog.getLocale(76));
                    mode=0;
                  }
                  break;
                default:
                  // configure s1
                  p1=(WCPath*)paths->getElementAt(s1);
                  if(p1!=NULL) {
                    win->hide();
                    if(configurePath(p1)==true) {
                      showPathBank(banknr,pbs);
                    }
                    win->show();
                  }
              }
              break;
            }
          }
        }
      } else if(msg->type==AG_CYCLEBUTTONCLICKED) {
        if(msg->cyclebutton.cyclebutton==cyb) {
          if(msg->cyclebutton.option==1) extmode=true;
          else extmode=false;
        }
      } else if(msg->type==AG_KEYRELEASED) {
        if(msg->key.key==XK_Escape) {
          sbsb->setText(catalog.getLocale(76));
          mode=0;
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // restore paths
    setPaths(twconfig->getPaths());
    // also restore buttons and hotkeys (for the case the user entered a shortkey from one of this
    setButtons(twconfig->getButtons());
    setHotkeys(twconfig->getHotkeys());
  } else cleanUpPaths();
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

void WConfig::showPathBank(int nr,Button **pbs)
{
  WCPath *p1;
  int id=paths->initEnum();
  if((nr>=0)&&(nr<(paths->size()/(int)rows))) {
    for(unsigned int i=0;i<rows;i++) {
      p1=(WCPath*)paths->getElementAt(id,i+nr*rows);
      if((p1!=NULL)&&(p1->getCheck()==true)) {
        pbs[i]->setText(0,p1->getName());
        pbs[i]->setFG(0,p1->getFG());
        pbs[i]->setBG(0,p1->getBG());
      } else {
        pbs[i]->setText(0,"");
        pbs[i]->setFG(0,1);
        pbs[i]->setBG(0,0);
      }
    }
  }
  paths->closeEnum(id);
}

void WConfig::showButtonBank(int nr,Button *bbs[][2])
{
  WCButton *b1;
  int id=buttons->initEnum();
  int banksize=rows*columns;
  if((nr>=0)&&(nr<(buttons->size()/(banksize*2)))) {
    for(unsigned int i=0;i<rows;i++) {
      for(unsigned int j=0;j<columns;j++) {
        b1=(WCButton*)buttons->getElementAt(id,nr*banksize*2+i*columns*2+j*2);
        if((b1!=NULL)&&(b1->getCheck()==true)) {
          bbs[i*columns+j][0]->setText(0,b1->getText());
          bbs[i*columns+j][0]->setFG(0,b1->getFG());
          bbs[i*columns+j][0]->setBG(0,b1->getBG());
        } else {
          bbs[i*columns+j][0]->setText(0,"");
          bbs[i*columns+j][0]->setFG(0,1);
          bbs[i*columns+j][0]->setBG(0,0);
        }
        b1=(WCButton*)buttons->getNextElement(id);
        if((b1!=NULL)&&(b1->getCheck()==true)) {
          bbs[i*columns+j][1]->setText(0,b1->getText());
          bbs[i*columns+j][1]->setFG(0,b1->getFG());
          bbs[i*columns+j][1]->setBG(0,b1->getBG());
        } else {
          bbs[i*columns+j][1]->setText(0,"");
          bbs[i*columns+j][1]->setFG(0,1);
          bbs[i*columns+j][1]->setBG(0,0);
        }
      }
    }
  }
  buttons->closeEnum(id);
}

WC_Color::WC_Color()
{
  red=0;
  green=0;
  blue=0;
}

WC_Color::WC_Color(int r,int g,int b)
{
  red=r;
  green=g;
  blue=b;
}

WC_Color *WC_Color::duplicate()
{
  return (new WC_Color(red,green,blue));
}

void WC_Color::save(Datei *fh)
{
  if(fh==NULL) return;
  fh->putString("CLOR");
  fh->putULong(3*5);
  fh->putInt(red);
  fh->putInt(green);
  fh->putInt(blue);
}

bool WC_Color::load(Datei *fh)
{
  if(fh==NULL) return false;
  char *str=fh->getString(4);
  if(strncmp(str,"CLOR",4)!=0) {
    _freesafe(str);
    fh->seek(-4,SEEK_CUR);
    return false;
  } else {
    int chunksize=fh->getULong();
    if(chunksize>=3*5) {
      red=fh->getInt();
      green=fh->getInt();
      blue=fh->getInt();
      if(red<0) red=0;
      if(green<0) green=0;
      if(blue<0) blue=0;
      if(red>255) red=255;
      if(green>255) green=255;
      if(blue>255) blue=255;
      chunksize-=3*5;
    }
    while(chunksize>0) {
      fh->getUChar();
      chunksize--;
    }
  }
  _freesafe(str);
  return true;
}

bool WConfig::changePalette()
{
  WConfig *twconfig=duplicate();
  Button *colbs[256];
  AGUIX *aguix=worker->getAGUIX();
  int w,h;
  w=5+256+10+5;
  h=5+256+10+5+aguix->getCharHeight()+4+5;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(15));
  int sx=(int)sqrt(colors->size());
  if((sx*sx)<colors->size()) sx++;
  int tw=w-10-10;
  int th=256/sx;
  for(int i=0;i<colors->size();i++) {
    colbs[i]=(Button*)win->add(new Button(aguix,
                        10+(i%sx)*th,
                        10+(i/sx)*th,
                        th,
                        th,
                        "",
                        0,
                        i,
                        i+1));
  }
  ((BevelBox*)win->add(new BevelBox(aguix,
                                    5,
                                    5,
                                    256+10,
                                    256+10,
                                    1)))->toBack();
  int dy=5;
  Text *label1=(Text*)win->add(new Text(aguix,
                                        256+20,
                                        5,
                                        catalog.getLocale(27),
                                        1));
  Text *palentryt=(Text*)win->add(new Text(aguix,
                                           256+20+label1->getWidth()+5,
                                           5,
                                           "   ",
                                           1));
  int labelindex=-1;
  int ttx,tty,tx,ty;
  palentryt->getPos(&ttx,&tty);
  tw=ttx+palentryt->getWidth()+5;
  if(tw>w) w=tw;
  dy+=label1->getHeight()+5;

  int t1=strlen(catalog.getLocale(28));
  int t2=strlen(catalog.getLocale(29));
  if(t2>t1) t1=t2;
  t2=strlen(catalog.getLocale(30));
  if(t2>t1) t1=t2;
  t1++;
  t1*=aguix->getCharWidth();
  label1=(Text*)win->add(new Text(aguix,
                                  256+20,
                                  dy+2,
                                  catalog.getLocale(28),
                                  1));
  ttx=3*aguix->getCharWidth();
  StringGadget *redsg=(StringGadget*)win->add(new StringGadget(aguix,
                                                               256+20+t1+ttx+5,
                                                               dy,
                                                               6*aguix->getCharWidth(),
                                                               "",
                                                               1));
  tty=redsg->getHeight();
  redsg->getPos(&tx,&ty);
  Button *redl=(Button*)win->add(new Button(aguix,
                                            256+20+t1,
                                            dy,
                                            ttx,
                                            tty,
                                            "<",
                                            1,
                                            0,
                                            0));
  Button *redr=(Button*)win->add(new Button(aguix,
                                            tx+redsg->getWidth()+5,
                                            dy,
                                            ttx,
                                            tty,
                                            ">",
                                            1,
                                            0,
                                            0));
  tw=tx+redsg->getWidth()+5+ttx+5;
  if(tw>w) w=tw;
  dy+=tty+5;
  label1=(Text*)win->add(new Text(aguix,
                                  256+20,
                                  dy+2,
                                  catalog.getLocale(29),
                                  1));
  StringGadget *greensg=(StringGadget*)win->add(new StringGadget(aguix,
                                                               256+20+t1+ttx+5,
                                                               dy,
                                                               6*aguix->getCharWidth(),
                                                               "",
                                                               1));
  Button *greenl=(Button*)win->add(new Button(aguix,
                                            256+20+t1,
                                            dy,
                                            ttx,
                                            tty,
                                            "<",
                                            1,
                                            0,
                                            0));
  Button *greenr=(Button*)win->add(new Button(aguix,
                                            tx+redsg->getWidth()+5,
                                            dy,
                                            ttx,
                                            tty,
                                            ">",
                                            1,
                                            0,
                                            0));
  dy+=tty+5;
  label1=(Text*)win->add(new Text(aguix,
                                  256+20,
                                  dy+2,
                                  catalog.getLocale(30),
                                  1));
  StringGadget *bluesg=(StringGadget*)win->add(new StringGadget(aguix,
                                                               256+20+t1+ttx+5,
                                                               dy,
                                                               6*aguix->getCharWidth(),
                                                               "",
                                                               1));
  Button *bluel=(Button*)win->add(new Button(aguix,
                                            256+20+t1,
                                            dy,
                                            ttx,
                                            tty,
                                            "<",
                                            1,
                                            0,
                                            0));
  Button *bluer=(Button*)win->add(new Button(aguix,
                                            tx+redsg->getWidth()+5,
                                            dy,
                                            ttx,
                                            tty,
                                            ">",
                                            1,
                                            0,
                                            0));
  dy+=tty+5;
  SolidButton *editcolsb=(SolidButton*)win->add(new SolidButton(aguix,
                                                256+20,
                                                dy,
                                                32,
                                                32,
                                                "",
                                                0,
                                                0,
                                                false));
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,
                                           5,
                                           h-5-aguix->getCharHeight()-2,
                                           t1,
                                           catalog.getLocale(11),
                                           1,
                                           0,
                                           0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               w-5-t2,
                                               h-5-aguix->getCharHeight()-2,
                                               t2,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));  
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  char *tstr;
  WC_Color *tc1;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button->getData()>0) {
          // ein Eintrag wurde ausgewhlt
          labelindex=msg->button.button->getData()-1;
          editcolsb->setBG(labelindex);
          tc1=(WC_Color*)colors->getElementAt(labelindex);
          tstr=(char*)_allocsafe(16);
          sprintf(tstr,"%d",tc1->red);
          redsg->setText(tstr);
          sprintf(tstr,"%d",tc1->green);
          greensg->setText(tstr);
          sprintf(tstr,"%d",tc1->blue);
          bluesg->setText(tstr);
          sprintf(tstr,"%d",labelindex);
          palentryt->setText(tstr);
          _freesafe(tstr);
        } else if(msg->button.button==redl) {
          if(labelindex>=0) {
            int val=0;
            sscanf(redsg->getText(),"%d",&val);
            if(val>0) val--;
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",val);
            redsg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->red=val;
            aguix->changeColor(labelindex,tc1->red,tc1->green,tc1->blue);
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==redr) {
          if(labelindex>=0) {
            int val=0;
            sscanf(redsg->getText(),"%d",&val);
            if(val<255) val++;
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",val);
            redsg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->red=val;
            aguix->changeColor(labelindex,tc1->red,tc1->green,tc1->blue);
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==greenl) {
          if(labelindex>=0) {
            int val=0;
            sscanf(greensg->getText(),"%d",&val);
            if(val>0) val--;
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",val);
            greensg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->green=val;
            aguix->changeColor(labelindex,tc1->red,tc1->green,tc1->blue);
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==greenr) {
          if(labelindex>=0) {
            int val=0;
            sscanf(greensg->getText(),"%d",&val);
            if(val<255) val++;
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",val);
            greensg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->green=val;
            aguix->changeColor(labelindex,tc1->red,tc1->green,tc1->blue);
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==bluel) {
          if(labelindex>=0) {
            int val=0;
            sscanf(bluesg->getText(),"%d",&val);
            if(val>0) val--;
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",val);
            bluesg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->blue=val;
            aguix->changeColor(labelindex,tc1->red,tc1->green,tc1->blue);
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==bluer) {
          if(labelindex>=0) {
            int val=0;
            sscanf(bluesg->getText(),"%d",&val);
            if(val<255) val++;
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",val);
            bluesg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->blue=val;
            aguix->changeColor(labelindex,tc1->red,tc1->green,tc1->blue);
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        if(labelindex>=0) {
          if(msg->stringgadget.sg==redsg) {
            int val=0;
            sscanf(redsg->getText(),"%d",&val);
            if(val<0) val=0;
            if(val>255) val=255;
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",val);
            redsg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->red=val;
            aguix->changeColor(labelindex,tc1->red,tc1->green,tc1->blue);
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          } else if(msg->stringgadget.sg==greensg) {
            int val=0;
            sscanf(greensg->getText(),"%d",&val);
            if(val<0) val=0;
            if(val>255) val=255;
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",val);
            greensg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->green=val;
            aguix->changeColor(labelindex,tc1->red,tc1->green,tc1->blue);
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          } else if(msg->stringgadget.sg==bluesg) {
            int val=0;
            sscanf(bluesg->getText(),"%d",&val);
            if(val<0) val=0;
            if(val>255) val=255;
            tstr=(char*)_allocsafe(16);
            sprintf(tstr,"%d",val);
            bluesg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->blue=val;
            aguix->changeColor(labelindex,tc1->red,tc1->green,tc1->blue);
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else {
          if(msg->stringgadget.sg==redsg) {
            redsg->setText("");
          } else if(msg->stringgadget.sg==greensg) {
            greensg->setText("");
          } else if(msg->stringgadget.sg==bluesg) {
            bluesg->setText("");
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setColors(twconfig->getColors());
    applyColorList(colors);
  }
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

int WConfig::palette()
{
  return palette(-1);
}

int WConfig::palette(int startcol)
{
  Button *colbs[256];
  AGUIX *aguix=worker->getAGUIX();
  int w,h;
  w=5+256+10+5;
  h=5+256+10+5+aguix->getCharHeight()+4+5;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(45));
  int sx=(int)sqrt(colors->size());
  if((sx*sx)<colors->size()) sx++;
  int th=256/sx;
  for(int i=0;i<colors->size();i++) {
    colbs[i]=(Button*)win->add(new Button(aguix,
                        10+(i%sx)*th,
                        10+(i/sx)*th,
                        th,
                        th,
                        "",
                        0,
                        i,
                        i+1));
  }
  ((BevelBox*)win->add(new BevelBox(aguix,
                                    5,
                                    5,
                                    256+10,
                                    256+10,
                                    1)))->toBack();
  int t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  int t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,
                                           5,
                                           256+20,
                                           t1,
                                           catalog.getLocale(11),
                                           1,
                                           0,
                                           0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               w-5-t2,
                                               256+20,
                                               t2,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));  
  SolidButton *editcolsb=(SolidButton*)win->add(new SolidButton(aguix,
                                                5+t1+5,
                                                256+20,
                                                w-5-5-10-t1-t2,
                                                "",
                                                0,
                                                (startcol>=0)?startcol:0,
                                                false));
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0,selcol=(startcol>=0)?startcol:-1;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button->getData()>0) {
          // ein Eintrag wurde ausgewhlt
          selcol=msg->button.button->getData()-1;
          editcolsb->setBG(selcol);
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  win->close();
  delete win;
  return (ende==-1)?-1:selcol;
}

bool WConfig::changeLanguage()
{
  struct dirent *namelist;
  DIR *dir2;
  bool ok;
  AGUIX *aguix=worker->getAGUIX();
  char *catdir,*tstr;
  int w,h;
  w=300;
  h=200;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(9));
  ListView *lv=(ListView*)win->add(new ListView(aguix,
                                                5,
                                                5,
                                                w-10,
                                                h-5-aguix->getCharHeight()-2-10,
                                                0));
  lv->setHBarState(2);
  lv->setVBarState(2);
  ListViewContent *lvc1=(ListViewContent*)lv->add(new ListViewContent(catalog.getLocale(10),1,1,2,2,0,0,1,1,0));
  int x=1;
  if((strcmp(lang,"builtin")==0)||(strlen(lang)<1)) lvc1->setActive(true);
#ifdef GLOBALDATADIR
  catdir=(char*)_allocsafe(strlen(GLOBALDATADIR)+strlen("/catalogs")+1);
  strcpy(catdir,GLOBALDATADIR);
  strcat(catdir,"/catalogs");
  dir2=opendir(catdir);
  if(dir2!=NULL) {
    while((namelist=readdir(dir2))!=NULL) {
      if(strlen(namelist->d_name)>8) {
        if(strcmp(".catalog",(namelist->d_name)+strlen(namelist->d_name)-8)==0) {
          // Dies ist ein Katalog
          tstr=namelist->d_name;
          tstr[strlen(tstr)-8]=0;
          lvc1=(ListViewContent*)lv->add(new ListViewContent(tstr,1,1,2,2,0,0,1,1,x++));
          if(strcmp(lang,tstr)==0) lvc1->setActive(true);
        }
      }
    }
    closedir(dir2);
  }
  _freesafe(catdir);
#endif
  catdir=(char*)_allocsafe(strlen(home)+strlen("/catalogs")+1);
  strcpy(catdir,home);
  strcat(catdir,"/catalogs");
  dir2=opendir(catdir);
  if(dir2!=NULL) {
    while((namelist=readdir(dir2))!=NULL) {
      if(strlen(namelist->d_name)>8) {
        if(strcmp(".catalog",(namelist->d_name)+strlen(namelist->d_name)-8)==0) {
          // Dies ist ein Katalog
          tstr=namelist->d_name;
          tstr[strlen(tstr)-8]=0;
          lvc1=lv->get(1);
          while(lvc1!=NULL) {
            if(strcmp(lvc1->getText(),tstr)==0) break;
            lvc1=lv->getNext();
          }
          if(lvc1==NULL) {
            // only add if it doesn't have already is inserted
            lvc1=(ListViewContent*)lv->add(new ListViewContent(tstr,1,1,2,2,0,0,1,1,x++));
            if(strcmp(lang,tstr)==0) lvc1->setActive(true);
          }
        }
      }
    }
    closedir(dir2);
  }
  _freesafe(catdir);

  int t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  int t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,
                                           5,
                                           h-5-aguix->getCharHeight()-2,
                                           t1,
                                           catalog.getLocale(11),
                                           1,
                                           0,
                                           0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               w-5-t2,
                                               h-5-aguix->getCharHeight()-2,
                                               t2,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  ok=false;
  if(ende==1) {
    lvc1=lv->getActiveLVC();
    if(lvc1!=NULL) {
      if(strcmp(lvc1->getText(),catalog.getLocale(10))==0) setLang("builtin");
      else setLang((char*)lvc1->getText());
      Requester *req=new Requester(aguix);
      req->request(catalog.getLocale(124),catalog.getLocale(234),catalog.getLocale(11));
      delete req;
      ok=true;
    }
  }
  win->close();
  delete win;
  return ok;
}

void WConfig::applyColorList(List *cols)
{
  AGUIX *aguix=worker->getAGUIX();
  while(aguix->getMaxCols()>0) aguix->removeLastColor();
  int id=cols->initEnum();
  WC_Color *tc1=(WC_Color*)cols->getFirstElement();
  while(tc1!=NULL) {
    if(aguix->AddColor(tc1->red,tc1->green,tc1->blue)<0) {
      fprintf(stderr,"Worker: Can't allocate color %d,%d,%d!\n",tc1->red,tc1->green,tc1->blue);
    }
    tc1=(WC_Color*)cols->getNextElement();
  }
  cols->closeEnum(id);
}

bool WConfig::changeFileSets()
{
  WConfig *twconfig=duplicate();
  char tstr[128];
  AGUIX *aguix=worker->getAGUIX();
  int w,h,tx,ty,tw,by;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,100,100,0,catalog.getLocale(16)); // Groesse wird spaeter angepasst
  w=0;
  h=0;
  Text *t1=(Text*)win->add(new Text(aguix,5,5,catalog.getLocale(19),1));
  ty=t1->getY()+t1->getHeight()+5+5;
  by=ty-5;
  tx=10;
  ListView *lv1=(ListView*)win->add(new ListView(aguix,
                                                 tx,
                                                 ty,
                                                 100,
                                                 80,
                                                 0));
  lv1->setHBarState((hbar_top[0]==true)?1:2);
  lv1->setVBarState((vbar_left[0]==true)?1:2);
  lv1->setHBarHeight(hbar_height[0]);
  lv1->setVBarWidth(vbar_width[0]);
  ty=lv1->getY()+lv1->getHeight()+5;
  tw=lv1->getX()+lv1->getWidth()+10;
  if(tw>w) w=tw;
  t1=(Text*)win->add(new Text(aguix,tx,ty,catalog.getLocale(21),1));
  tw=t1->getX()+t1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=t1->getHeight()+5;
  ChooseButton *cb1=(ChooseButton*)win->add(new ChooseButton(aguix,
                                                             tx+5,
                                                             ty,
                                                             20,
                                                             20,
                                                             (hbar_top[0]==true)?1:0,
                                                             catalog.getLocale(22),
                                                             LABEL_LEFT,
                                                             1,
                                                             0));
  tw=cb1->getX()+cb1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=cb1->getHeight()+5;
  t1=(Text*)win->add(new Text(aguix,tx+5,ty,catalog.getLocale(23),1));
  sprintf(tstr,"%d",hbar_height[0]);
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,t1->getX()+t1->getWidth()+5,
                                                             ty,50,tstr,0));
  // Text noch in Y anpassen
  double b=sg1->getY()+sg1->getHeight()/2-t1->getHeight()/2;
  t1->move(t1->getX(),(int)b);
  tw=sg1->getX()+sg1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=sg1->getHeight()+5;
  ty+=5;

  t1=(Text*)win->add(new Text(aguix,tx,ty,catalog.getLocale(24),1));
  tw=t1->getX()+t1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=t1->getHeight()+5;
  ChooseButton *cb2=(ChooseButton*)win->add(new ChooseButton(aguix,
                                                             tx+5,
                                                             ty,
                                                             20,
                                                             20,
                                                             (vbar_left[0]==true)?1:0,
                                                             catalog.getLocale(25),
                                                             LABEL_LEFT,
                                                             1,
                                                             0));
  tw=cb2->getX()+cb2->getWidth()+10;
  if(tw>w) w=tw;
  ty+=cb2->getHeight()+5;
  t1=(Text*)win->add(new Text(aguix,tx+5,ty,catalog.getLocale(26),1));
  sprintf(tstr,"%d",vbar_width[0]);
  StringGadget *sg2=(StringGadget*)win->add(new StringGadget(aguix,t1->getX()+t1->getWidth()+5,
                                                             ty,50,tstr,0));
  // Text noch in Y anpassen
  b=sg2->getY()+sg2->getHeight()/2-t1->getHeight()/2;
  t1->move(t1->getX(),(int)b);
  tw=sg2->getX()+sg2->getWidth()+10;
  if(tw>w) w=tw;
  ty+=sg2->getHeight()+5;
  ty+=5;
  Button *dis1=(Button*)win->add(new Button(aguix,
                                            tx,
                                            ty,
                                            aguix->getCharWidth()*(2+strlen(catalog.getLocale(235))),
                                            catalog.getLocale(235),
                                            1,
                                            0,
                                            0));
  tw=dis1->getX()+dis1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=dis1->getHeight()+5;
  BevelBox *bb1=(BevelBox*)win->add(new BevelBox(aguix,
                                                tx-5,
                                                by,
                                                w-10,
                                                ty-by,
                                                1));
  bb1->toBack();
  tx=w;

  t1=(Text*)win->add(new Text(aguix,tx,5,catalog.getLocale(20),1));
  ty=t1->getY()+t1->getHeight()+5+5;
  by=ty-5;
  tx+=5;
  ListView *lv2=(ListView*)win->add(new ListView(aguix,
                                                 tx,
                                                 ty,
                                                 100,
                                                 80,
                                                 0));
  lv2->setHBarState((hbar_top[1]==true)?1:2);
  lv2->setVBarState((vbar_left[1]==true)?1:2);
  lv2->setHBarHeight(hbar_height[1]);
  lv2->setVBarWidth(vbar_width[1]);
  ty=lv2->getY()+lv2->getHeight()+5;
  tw=lv2->getX()+lv2->getWidth()+10;
  if(tw>w) w=tw;
  t1=(Text*)win->add(new Text(aguix,tx,ty,catalog.getLocale(21),1));
  tw=t1->getX()+t1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=t1->getHeight()+5;
  ChooseButton *cb3=(ChooseButton*)win->add(new ChooseButton(aguix,
                                                             tx+5,
                                                             ty,
                                                             20,
                                                             20,
                                                             (hbar_top[1]==true)?1:0,
                                                             catalog.getLocale(22),
                                                             LABEL_LEFT,
                                                             1,
                                                             0));
  tw=cb3->getX()+cb3->getWidth()+10;
  if(tw>w) w=tw;
  ty+=cb3->getHeight()+5;
  t1=(Text*)win->add(new Text(aguix,tx+5,ty,catalog.getLocale(23),1));
  sprintf(tstr,"%d",hbar_height[1]);
  StringGadget *sg3=(StringGadget*)win->add(new StringGadget(aguix,t1->getX()+t1->getWidth()+5,
                                                             ty,50,tstr,0));
  // Text noch in Y anpassen
  b=sg3->getY()+sg3->getHeight()/2-t1->getHeight()/2;
  t1->move(t1->getX(),(int)b);
  tw=sg3->getX()+sg3->getWidth()+10;
  if(tw>w) w=tw;
  ty+=sg3->getHeight()+5;
  ty+=5;

  t1=(Text*)win->add(new Text(aguix,tx,ty,catalog.getLocale(24),1));
  tw=t1->getX()+t1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=t1->getHeight()+5;
  ChooseButton *cb4=(ChooseButton*)win->add(new ChooseButton(aguix,
                                                             tx+5,
                                                             ty,
                                                             20,
                                                             20,
                                                             (vbar_left[1]==true)?1:0,
                                                             catalog.getLocale(25),
                                                             LABEL_LEFT,
                                                             1,
                                                             0));
  tw=cb4->getX()+cb4->getWidth()+10;
  if(tw>w) w=tw;
  ty+=cb4->getHeight()+5;
  t1=(Text*)win->add(new Text(aguix,tx+5,ty,catalog.getLocale(26),1));
  sprintf(tstr,"%d",vbar_width[1]);
  StringGadget *sg4=(StringGadget*)win->add(new StringGadget(aguix,t1->getX()+t1->getWidth()+5,
                                                             ty,50,tstr,0));
  // Text noch in Y anpassen
  b=sg4->getY()+sg4->getHeight()/2-t1->getHeight()/2;
  t1->move(t1->getX(),(int)b);
  tw=sg4->getX()+sg4->getWidth()+10;
  if(tw>w) w=tw;
  ty+=sg4->getHeight()+5;
  ty+=5;
  Button *dis2=(Button*)win->add(new Button(aguix,
                                            tx,
                                            ty,
                                            aguix->getCharWidth()*(2+strlen(catalog.getLocale(235))),
                                            catalog.getLocale(235),
                                            1,
                                            0,
                                            0));
  tw=dis2->getX()+dis2->getWidth()+10;
  if(tw>w) w=tw;
  ty+=dis2->getHeight()+5;
  bb1=(BevelBox*)win->add(new BevelBox(aguix,
                                       tx-5,
                                       by,
                                       w-tx,
                                       ty-by,
                                       1));
  bb1->toBack();
  ty=bb1->getY()+bb1->getHeight()+5;
  int i1=(strlen(catalog.getLocale(11))+2);
  i1*=aguix->getCharWidth();
  int i2=(strlen(catalog.getLocale(8))+2);
  i2*=aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,
                                           5,
                                           ty,
                                           i1,
                                           catalog.getLocale(11),
                                           1,
                                           0,
                                           0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               w-5-i2,
                                               ty,
                                               i2,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==dis1) {
          win->hide();
          changeDisplaySets(0);
          win->show();
        } else if(msg->button.button==dis2) {
          win->hide();
          changeDisplaySets(1);
          win->show();
        }
      } else if(msg->type==AG_CHOOSECLICKED) {
        if(msg->choose.button==cb1) {
          if(msg->choose.state==true) lv1->setHBarState(1);
          else lv1->setHBarState(2);
        } else if(msg->choose.button==cb2) {
          if(msg->choose.state==true) lv1->setVBarState(1);
          else lv1->setVBarState(2);
        } else if(msg->choose.button==cb3) {
          if(msg->choose.state==true) lv2->setHBarState(1);
          else lv2->setHBarState(2);
        } else if(msg->choose.button==cb4) {
          if(msg->choose.state==true) lv2->setVBarState(1);
          else lv2->setVBarState(2);
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        int i=0;
        if(msg->stringgadget.sg==sg1) {
          sscanf(sg1->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg1->setText(tstr);
          }
          lv1->setHBarHeight(i);
        } else if(msg->stringgadget.sg==sg2) {
          sscanf(sg2->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg2->setText(tstr);
          }
          lv1->setVBarWidth(i);
        } else if(msg->stringgadget.sg==sg3) {
          sscanf(sg3->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg3->setText(tstr);
          }
          lv2->setHBarHeight(i);
        } else if(msg->stringgadget.sg==sg4) {
          sscanf(sg4->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg4->setText(tstr);
          }
          lv2->setVBarWidth(i);
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setDisplay(0,twconfig->getDisplay(0));
    setDisplay(1,twconfig->getDisplay(1));
  } else {
    // Werte bernehmen
    setHBarTop(0,cb1->getState());
    setVBarLeft(0,cb2->getState());
    setHBarTop(1,cb3->getState());
    setVBarLeft(1,cb4->getState());
    int i=0;
    sscanf(sg1->getText(),"%d",&i);
    if(i<5) i=5;
    setHBarHeight(0,i);
    sscanf(sg2->getText(),"%d",&i);
    if(i<5) i=5;
    setVBarWidth(0,i);
    sscanf(sg3->getText(),"%d",&i);
    if(i<5) i=5;
    setHBarHeight(1,i);
    sscanf(sg4->getText(),"%d",&i);
    if(i<5) i=5;
    setVBarWidth(1,i);
  }
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

bool WConfig::changeDisplaySets(int side)
{
  bool sels[9];
  char *strs[9];
  strs[0]=catalog.getLocale(176);
  strs[1]=catalog.getLocale(177);
  strs[2]=catalog.getLocale(178);
  strs[3]=catalog.getLocale(180);  // nicht ganz richtig
  strs[4]=catalog.getLocale(184);
  strs[5]=catalog.getLocale(179);
  strs[6]=catalog.getLocale(163);
  strs[7]=catalog.getLocale(162);
  strs[8]=catalog.getLocale(164);
  AGUIX *aguix=worker->getAGUIX();
  int w,h,tx,ty;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,100,100,0,catalog.getLocale(235));
  w=0;
  h=0;
  tx=5;
  ty=5;
  Text *t1=(Text*)win->add(new Text(aguix,tx,ty,catalog.getLocale(238),1));
  ty=t1->getY()+t1->getHeight()+5;
  int i1=(strlen(catalog.getLocale(236))+2);
  i1*=aguix->getCharWidth();
  int i2=(strlen(catalog.getLocale(237))+2);
  i2*=aguix->getCharWidth();
  if((i1+i2)<100) {
    int x=100-i1-i2;
    i1+=x/2;
    i2+=x/2;
  }
  Button *upb=(Button*)win->add(new Button(aguix,
                                           tx,
                                           ty+100,
                                           i1,
                                           catalog.getLocale(236),
                                           1,
                                           0,
                                           0));
  Button *downb=(Button*)win->add(new Button(aguix,
                                             tx+i1,
                                             ty+100,
                                             i2,
                                             catalog.getLocale(237),
                                             1,
                                             0,
                                             0));
  ListView *lv1=(ListView*)win->add(new ListView(aguix,
                                                 tx,
                                                 ty,
                                                 i1+i2,
                                                 upb->getY()-ty,
                                                 0));
  lv1->setHBarState(2);
  lv1->setVBarState(2);
  tx=lv1->getX()+lv1->getWidth()+5;

  i1=(strlen(catalog.getLocale(239))+2);
  i1*=aguix->getCharWidth();
  i2=(strlen(catalog.getLocale(240))+2);
  i2*=aguix->getCharWidth();
  int i=(i1>i2)?i1:i2;
  double b=lv1->getHeight()-upb->getHeight();
  b/=3;
  Button *delb=(Button*)win->add(new Button(aguix,
                                            tx,
                                            ty+(int)b,
                                            i,
                                            catalog.getLocale(239),
                                            1,
                                            0,
                                            0));
  Button *insb=(Button*)win->add(new Button(aguix,
                                            tx,
                                            ty+(int)b+delb->getHeight()+(int)b,
                                            i,
                                            catalog.getLocale(240),
                                            1,
                                            0,
                                            0));
  tx+=i+5;
  ListView *lv2=(ListView*)win->add(new ListView(aguix,
                                                 tx,
                                                 ty,
                                                 lv1->getWidth(),
                                                 lv1->getHeight()+upb->getHeight(),
                                                 0));
  lv2->setHBarState(2);
  lv2->setVBarState(2);
  w=lv2->getX()+lv2->getWidth()+5;
  ty=upb->getY()+upb->getHeight()+5;

  i1=(strlen(catalog.getLocale(11))+2);
  i1*=aguix->getCharWidth();
  i2=(strlen(catalog.getLocale(8))+2);
  i2*=aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,
                                           5,
                                           ty,
                                           i1,
                                           catalog.getLocale(11),
                                           1,
                                           0,
                                           0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               w-5-i2,
                                               ty,
                                               i2,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  for(i=0;i<9;i++) {
    sels[i]=false;
  }
  for(i=0;i<9;i++) {
    if(display[side][i]>=0) {
      lv1->add(new ListViewContent(strs[display[side][i]],1,1,2,2,0,0,1,1,0));
      sels[display[side][i]]=true;
    }
  }
  for(i=0;i<9;i++) {
    if(sels[i]==false) {
      lv2->add(new ListViewContent(strs[i],1,1,2,2,0,0,1,1,0));
    }
  }
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==upb) {
          ListViewContent *lvc=lv1->getActiveLVC(),*lvc2;
          if(lvc!=NULL) {
            int pos=lv1->getPos(lvc);
            if(pos>0) {
              lvc2=lv1->add(new ListViewContent(lvc->getText(),1,1,2,2,0,0,1,1,0),pos-1);
              lv1->remove(lvc);
              lvc2->setActive(true);
              lv1->redraw();
              lv1->showActive();
            }
          }
        } else if(msg->button.button==downb) {
          ListViewContent *lvc=lv1->getActiveLVC(),*lvc2;
          if(lvc!=NULL) {
            int pos=lv1->getPos(lvc);
            if(pos<(lv1->getElements()-1)) {
              lvc2=lv1->add(new ListViewContent(lvc->getText(),1,1,2,2,0,0,1,1,0),pos+2);
              lv1->remove(lvc);
              lvc2->setActive(true);
              lv1->redraw();
              lv1->showActive();
            }
          }
        } else if(msg->button.button==delb) {
          ListViewContent *lvc=lv1->getActiveLVC(),*lvc2;
          if(lvc!=NULL) {
            for(i=0,i1=-1;i<9;i++) {
              if(strcmp(strs[i],lvc->getText())==0) i1=i;
            }
            lvc2=lv2->get(0);
            i2=0;
            int i3;
            while(lvc2!=NULL) {
              for(i=0,i3=-1;i<9;i++) {
                if(strcmp(strs[i],lvc2->getText())==0) i3=i;
              }
              if(i3<i1) i2++;
              lvc2=lv2->getNext();
            }
            lv2->add(new ListViewContent(lvc->getText(),1,1,2,2,0,0,1,1,0),i2);
            lv1->remove(lvc);
            lv1->redraw();
            lv2->redraw();
          }
        } else if(msg->button.button==insb) {
          ListViewContent *lvc=lv2->getActiveLVC();
          if(lvc!=NULL) {
            lv1->add(new ListViewContent(lvc->getText(),1,1,2,2,0,0,1,1,0));
            lv2->remove(lvc);
            lv1->redraw();
            lv2->redraw();
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    ListViewContent *lvc2;
    lvc2=lv1->get(0);
    i2=0;
    int i3;
    while(lvc2!=NULL) {
      for(i=0,i3=-1;i<9;i++) {
        if(strcmp(strs[i],lvc2->getText())==0) i3=i;
      }
      display[side][i2]=i3;
      lvc2=lv1->getNext();
      i2++;
    }
    for(i=i2;i<9;i++) {
      display[side][i]=-1;
    }
  }
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

void WConfig::setLang(char *nlang)
{
  if(lang!=NULL) _freesafe(lang);
  if(nlang==NULL) lang=dupstring("builtin");
  else lang=dupstring(nlang);
}

void WConfig::setTerminalBin(const char *ntb)
{
  if(isCorrectTerminalBin(ntb)==true) {
    if(terminalbin!=NULL) _freesafe(terminalbin);
    if(ntb==NULL) terminalbin=dupstring(TERMINAL_BIN);
    else terminalbin=dupstring(ntb);
  }
}

void WConfig::setRows(unsigned int nrows)
{
  if((nrows<1)||(nrows>10)) return;
  rows=nrows;
  cleanUpPaths();
  cleanUpButtons();
}

void WConfig::setColumns(unsigned int ncols)
{
  if((ncols<1)||(ncols>20)) return;
  columns=ncols;
  cleanUpPaths();
  cleanUpButtons();
}

void WConfig::setCacheSize(unsigned int ncs)
{
  if(ncs<1) return;
  cachesize=ncs;
}

void WConfig::setHBarTop(int index2,bool val)
{
  if((index2<0)||(index2>1)) return;
  hbar_top[index2]=val;
}

void WConfig::setVBarLeft(int index2,bool val)
{
  if((index2<0)||(index2>1)) return;
  vbar_left[index2]=val;
}

void WConfig::setHBarHeight(int index2,unsigned int nh)
{
  if((index2<0)||(index2>1)) return;
  if(nh<5) return;
  hbar_height[index2]=nh;
}

void WConfig::setVBarWidth(int index2,unsigned int nw)
{
  if((index2<0)||(index2>1)) return;
  if(nw<5) return;
  vbar_width[index2]=nw;
}

void WConfig::setDisplay(int index2,int *val)
{
  if((index2<0)||(index2>1)) return;
  for(int i=0;i<9;i++) {
    display[index2][i]=val[i];
  }
}

char *WConfig::getLang()
{
  return lang;
}

char *WConfig::getTerminalBin()
{
  return terminalbin;
}

unsigned int WConfig::getRows()
{
  return rows;
}

unsigned int WConfig::getColumns()
{
  return columns;
}

unsigned int WConfig::getCacheSize()
{
  return cachesize;
}

bool WConfig::getHBarTop(int index2)
{
  if((index2<0)||(index2>1)) return false;
  return hbar_top[index2];
}

bool WConfig::getVBarLeft(int index2)
{
  if((index2<0)||(index2>1)) return false;
  return vbar_left[index2];
}

unsigned int WConfig::getHBarHeight(int index2)
{
  if((index2<0)||(index2>1)) return 10;
  return hbar_height[index2];
}

unsigned int WConfig::getVBarWidth(int index2)
{
  if((index2<0)||(index2>1)) return 10;
  return vbar_width[index2];
}

int *WConfig::getDisplay(int index2)
{
  if((index2<0)||(index2>1)) return NULL;
  return display[index2];
}

void WConfig::setStatusbar(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  statusbar[index2]=col;
}

void WConfig::setSelLVB(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_lvb[index2]=col;
}

void WConfig::setUnselLVB(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_lvb[index2]=col;
}

void WConfig::setSelDir(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_dir[index2]=col;
}

void WConfig::setUnselDir(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_dir[index2]=col;
}

void WConfig::setSelFile(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_file[index2]=col;
}

void WConfig::setUnselFile(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_file[index2]=col;
}

void WConfig::setSelDirAct(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_dir_act[index2]=col;
}

void WConfig::setUnselDirAct(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_dir_act[index2]=col;
}

void WConfig::setSelFileAct(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_file_act[index2]=col;
}

void WConfig::setUnselFileAct(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_file_act[index2]=col;
}

void WConfig::setClockbar(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  clockbar[index2]=col;
}

void WConfig::setRequest(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  request[index2]=col;
}

int WConfig::getStatusbar(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return statusbar[index2];
}

int WConfig::getSelLVB(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return sel_lvb[index2];
}

int WConfig::getUnselLVB(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_lvb[index2];
}

int WConfig::getSelDir(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return sel_dir[index2];
}

int WConfig::getUnselDir(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_dir[index2];
}

int WConfig::getSelFile(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return sel_file[index2];
}

int WConfig::getUnselFile(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_file[index2];
}

int WConfig::getSelDirAct(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return sel_dir_act[index2];
}

int WConfig::getUnselDirAct(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_dir_act[index2];
}

int WConfig::getSelFileAct(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return sel_file_act[index2];
}

int WConfig::getUnselFileAct(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_file_act[index2];
}

int WConfig::getClockbar(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return clockbar[index2];
}

int WConfig::getRequest(int index2)
{
  if((index2<0)||(index2>1)) return 0;
  return request[index2];
}

void WConfig::setStartDir(int index2,const char *ndir)
{
  if((index2<0)||(index2>1)) return;
  if(dir[index2]!=NULL) _freesafe(dir[index2]);
  if(ndir==NULL) dir[index2]=dupstring("");
  else dir[index2]=dupstring(ndir);
}

char *WConfig::getStartDir(int index2)
{
  if((index2<0)||(index2>1)) return NULL;
  return dir[index2];
}

void WConfig::setFont(int index2,const char *nfont)
{
  if((index2<0)||(index2>3)) return;
  if(fonts[index2]!=NULL) _freesafe(fonts[index2]);
  if(nfont==NULL) fonts[index2]=dupstring("");
  else fonts[index2]=dupstring(nfont);
}

char *WConfig::getFont(int index2)
{
  if((index2<0)||(index2>3)) return NULL;
  return fonts[index2];
}

void WConfig::setPaths(List *npaths)
{
  WCPath *tp;
  int id=paths->initEnum();
  tp=(WCPath*)paths->getFirstElement(id);
  while(tp!=NULL) {
    delete tp;
    tp=(WCPath*)paths->getNextElement(id);
  }
  paths->closeEnum(id);
  paths->removeAllElements();
  id=npaths->initEnum();
  tp=(WCPath*)npaths->getFirstElement(id);
  while(tp!=NULL) {
    paths->addElement(tp->duplicate());
    tp=(WCPath*)npaths->getNextElement(id);
  }
  npaths->closeEnum(id);
  cleanUpPaths();
}

List *WConfig::getPaths()
{
  return paths;
}

void WConfig::setFiletypes(List *nfts)
{
  WCFiletype *tft;
  int id=filetypes->initEnum();
  tft=(WCFiletype*)filetypes->getFirstElement(id);
  while(tft!=NULL) {
    delete tft;
    tft=(WCFiletype*)filetypes->getNextElement(id);
  }
  filetypes->closeEnum(id);
  filetypes->removeAllElements();
  id=nfts->initEnum();
  tft=(WCFiletype*)nfts->getFirstElement(id);
  while(tft!=NULL) {
    filetypes->addElement(tft->duplicate());
    tft=(WCFiletype*)nfts->getNextElement(id);
  }
  nfts->closeEnum(id);
}

List *WConfig::getFiletypes()
{
  return filetypes;
}

void WConfig::setHotkeys(List *nhks)
{
  WCHotkey *thk;
  int id=hotkeys->initEnum();
  thk=(WCHotkey*)hotkeys->getFirstElement(id);
  while(thk!=NULL) {
    delete thk;
    thk=(WCHotkey*)hotkeys->getNextElement(id);
  }
  hotkeys->closeEnum(id);
  hotkeys->removeAllElements();
  id=nhks->initEnum();
  thk=(WCHotkey*)nhks->getFirstElement(id);
  while(thk!=NULL) {
    hotkeys->addElement(thk->duplicate());
    thk=(WCHotkey*)nhks->getNextElement(id);
  }
  nhks->closeEnum(id);
}

List *WConfig::getHotkeys()
{
  return hotkeys;
}

void WConfig::setButtons(List *nbs)
{
  WCButton *tb;
  int id=buttons->initEnum();
  tb=(WCButton*)buttons->getFirstElement(id);
  while(tb!=NULL) {
    delete tb;
    tb=(WCButton*)buttons->getNextElement(id);
  }
  buttons->closeEnum(id);
  buttons->removeAllElements();
  id=nbs->initEnum();
  tb=(WCButton*)nbs->getFirstElement(id);
  while(tb!=NULL) {
    buttons->addElement(tb->duplicate());
    tb=(WCButton*)nbs->getNextElement(id);
  }
  nbs->closeEnum(id);
  cleanUpButtons();
}

List *WConfig::getButtons()
{
  return buttons;
}

void WConfig::cleanUpPaths()
{
  int id=paths->initEnum();
  WCPath *tp=(WCPath*)paths->getLastElement(id);
  while(tp!=NULL) {
    // Alle leeren am Ende entfernen
    if(tp->getCheck()==false) {
      delete tp;
      paths->removeLastElement();
    } else break;
    tp=(WCPath*)paths->getLastElement(id);
  }
  // Und nun noch auf Bankgroesse auffuellen
  paths->closeEnum(id);
  while((((paths->size())%rows)!=0)||(paths->size()==0)) {
    paths->addElement(new WCPath());
  }
}

void WConfig::cleanUpButtons()
{
  int banksize=rows*columns*2;
  int id=buttons->initEnum();
  WCButton *tb=(WCButton*)buttons->getLastElement(id);
  while(tb!=NULL) {
    // Alle leeren am Ende entfernen
    if(tb->getCheck()==false) {
      delete tb;
      buttons->removeLastElement();
    } else break;
    tb=(WCButton*)buttons->getLastElement(id);
  }
  // Und nun noch auf Bankgroesse auffuellen
  buttons->closeEnum(id);
  while((((buttons->size())%banksize)!=0)||(buttons->size()==0)) {
    buttons->addElement(new WCButton());
  }
}

WConfig::WConfig(Worker *tworker)
{
  unsigned int i;
  this->worker=tworker;
  lang=dupstring("");
  terminalbin=dupstring(TERMINAL_BIN);
  rows=1;
  columns=1;
  cachesize=10;
  colors=new List();
  colors->addElement(new WC_Color(160,160,160));
  colors->addElement(new WC_Color(0,0,0));
  colors->addElement(new WC_Color(255,255,255));
  colors->addElement(new WC_Color(0,85,187));
  colors->addElement(new WC_Color(204,34,0));
  colors->addElement(new WC_Color(50,180,20));
  colors->addElement(new WC_Color(119,0,119));
  colors->addElement(new WC_Color(238,170,68));
  hbar_top[0]=false;
  hbar_top[1]=false;
  vbar_left[0]=false;
  vbar_left[1]=true;
  hbar_height[0]=10;
  hbar_height[1]=10;
  vbar_width[0]=10;
  vbar_width[1]=10;
  display[0][0]=3;
  display[0][1]=1;
  display[0][2]=0;
  display[0][3]=2;
  display[0][4]=-1;
  display[0][5]=-1;
  display[0][6]=-1;
  display[0][7]=-1;
  display[0][8]=-1;
  display[1][0]=3;
  display[1][1]=1;
  display[1][2]=0;
  display[1][3]=2;
  display[1][4]=-1;
  display[1][5]=-1;
  display[1][6]=-1;
  display[1][7]=-1;
  display[1][8]=-1;
  statusbar[0]=2;
  statusbar[1]=3;
  sel_lvb[0]=2;
  sel_lvb[1]=4;
  unsel_lvb[0]=1;
  unsel_lvb[1]=0;
  sel_dir[0]=2;
  sel_dir[1]=3;
  unsel_dir[0]=3;
  unsel_dir[1]=0;
  sel_file[0]=2;
  sel_file[1]=1;
  unsel_file[0]=1;
  unsel_file[1]=0;
  sel_dir_act[0]=2;
  sel_dir_act[1]=7;
  unsel_dir_act[0]=1;
  unsel_dir_act[1]=7;
  sel_file_act[0]=2;
  sel_file_act[1]=7;
  unsel_file_act[0]=1;
  unsel_file_act[1]=7;
  clockbar[0]=2;
  clockbar[1]=6;
  request[0]=1;
  request[1]=0;
  dir[0]=dupstring("");
  dir[1]=dupstring("");
  fonts[0]=dupstring("fixed");
  fonts[1]=dupstring("fixed");
  fonts[2]=dupstring("fixed");
  fonts[3]=dupstring("fixed");
  paths=new List();
  for(i=0;i<rows;i++) {
    paths->addElement(new WCPath());
  }
  filetypes=new List();
  hotkeys=new List();
  buttons=new List();
  for(i=0;i<(rows*columns);i++) {
    buttons->addElement(new WCButton());
    buttons->addElement(new WCButton());
  }
  notyettype=NULL;
  dirtype=NULL;
  initFixTypes(filetypes);
  char *file=(char*)getenv("HOME");
  if(file==NULL) {
    printf("There is no HOME-Variable, please set it to your home-directory!\n");
  } else {
    home=(char*)_allocsafe(strlen(file)+1+8);
    strcpy(home,file);
    strcat(home,"/.worker");
  }
  maxfiletypelen=0;
  ownerstringtype=0;

  clockbar_mode=CLOCKBAR_MODE_TIMERAM;
  clockbar_updatetime=1;
  clockbar_command=dupstring("");
  dontcheckdirs=new List();
  
  listerbg=0;
  
  showStringForDirSize=false;
  stringForDirSize=dupstring("<DIR>");
  stringForDirSizeLen=strlen(stringForDirSize);
  
  setDateFormat( 0 );
  date_formatstring = dupstring( "" );
  setDateFormatString( NULL );
  setDateSubst( true );
  
  setTimeFormat( 0 );
  time_formatstring = dupstring( "" );
  setTimeFormatString( NULL );
  
  setDateBeforeTime( false );

  setDefaultConfig();
}

WConfig::~WConfig()
{
  if(lang!=NULL) _freesafe(lang);
  if(terminalbin!=NULL) _freesafe(terminalbin);
  int id=colors->initEnum();
  WC_Color *tcol=(WC_Color*)colors->getFirstElement(id);
  while(tcol!=NULL) {
    delete tcol;
    tcol=(WC_Color*)colors->getNextElement(id);
  }
  colors->closeEnum(id);
  delete colors;
  if(dir[0]!=NULL) _freesafe(dir[0]);
  if(dir[1]!=NULL) _freesafe(dir[1]);
  if(fonts[0]!=NULL) _freesafe(fonts[0]);
  if(fonts[1]!=NULL) _freesafe(fonts[1]);
  if(fonts[2]!=NULL) _freesafe(fonts[2]);
  if(fonts[3]!=NULL) _freesafe(fonts[3]);
  id=paths->initEnum();
  WCPath *tp=(WCPath*)paths->getFirstElement(id);
  while(tp!=NULL) {
    delete tp;
    tp=(WCPath*)paths->getNextElement(id);
  }
  paths->closeEnum(id);
  delete paths;
  id=filetypes->initEnum();
  WCFiletype *tft=(WCFiletype*)filetypes->getFirstElement(id);
  while(tft!=NULL) {
    delete tft;
    tft=(WCFiletype*)filetypes->getNextElement(id);
  }
  filetypes->closeEnum(id);
  delete filetypes;
  id=hotkeys->initEnum();
  WCHotkey *thk=(WCHotkey*)hotkeys->getFirstElement(id);
  while(thk!=NULL) {
    delete thk;
    thk=(WCHotkey*)hotkeys->getNextElement(id);
  }
  hotkeys->closeEnum(id);
  delete hotkeys;
  id=buttons->initEnum();
  WCButton *tb=(WCButton*)buttons->getFirstElement(id);
  while(tb!=NULL) {
    delete tb;
    tb=(WCButton*)buttons->getNextElement(id);
  }
  buttons->closeEnum(id);
  delete buttons;

  if(home!=NULL) _freesafe(home);
  
  _freesafe(clockbar_command);
  id=dontcheckdirs->initEnum();
  char *tstr=(char*)dontcheckdirs->getFirstElement(id);
  while(tstr!=NULL) {
    _freesafe(tstr);
    tstr=(char*)dontcheckdirs->getNextElement(id);
  }
  dontcheckdirs->closeEnum(id);
  delete dontcheckdirs;
  _freesafe(stringForDirSize);
  
  _freesafe( date_formatstring );
  _freesafe( time_formatstring );
}

WConfig *WConfig::duplicate()
{
  WConfig *twc=new WConfig(worker);
  twc->setLang(lang);
  twc->setTerminalBin(terminalbin);
  twc->setRows(rows);
  twc->setColumns(columns);
  twc->setCacheSize(cachesize);
  twc->setHBarTop(0,hbar_top[0]);
  twc->setHBarTop(1,hbar_top[1]);
  twc->setVBarLeft(0,vbar_left[0]);
  twc->setVBarLeft(1,vbar_left[1]);
  twc->setHBarHeight(0,hbar_height[0]);
  twc->setHBarHeight(1,hbar_height[1]);
  twc->setVBarWidth(0,vbar_width[0]);
  twc->setVBarWidth(1,vbar_width[1]);
  twc->setDisplay(0,display[0]);
  twc->setDisplay(1,display[1]);
  twc->setStatusbar(0,statusbar[0]);
  twc->setStatusbar(1,statusbar[1]);
  twc->setSelLVB(0,sel_lvb[0]);
  twc->setSelLVB(1,sel_lvb[1]);
  twc->setUnselLVB(0,unsel_lvb[0]);
  twc->setUnselLVB(1,unsel_lvb[1]);
  twc->setSelDir(0,sel_dir[0]);
  twc->setSelDir(1,sel_dir[1]);
  twc->setUnselDir(0,unsel_dir[0]);
  twc->setUnselDir(1,unsel_dir[1]);
  twc->setSelFile(0,sel_file[0]);
  twc->setSelFile(1,sel_file[1]);
  twc->setUnselFile(0,unsel_file[0]);
  twc->setUnselFile(1,unsel_file[1]);
  twc->setSelDirAct(0,sel_dir_act[0]);
  twc->setSelDirAct(1,sel_dir_act[1]);
  twc->setUnselDirAct(0,unsel_dir_act[0]);
  twc->setUnselDirAct(1,unsel_dir_act[1]);
  twc->setSelFileAct(0,sel_file_act[0]);
  twc->setSelFileAct(1,sel_file_act[1]);
  twc->setUnselFileAct(0,unsel_file_act[0]);
  twc->setUnselFileAct(1,unsel_file_act[1]);
  twc->setClockbar(0,clockbar[0]);
  twc->setClockbar(1,clockbar[1]);
  twc->setRequest(0,request[0]);
  twc->setRequest(1,request[1]);
  twc->setStartDir(0,dir[0]);
  twc->setStartDir(1,dir[1]);
  twc->setFont(0,fonts[0]);
  twc->setFont(1,fonts[1]);
  twc->setFont(2,fonts[2]);
  twc->setFont(3,fonts[3]);
  twc->setPaths(paths);
  twc->setFiletypes(filetypes);
  twc->setHotkeys(hotkeys);
  twc->setButtons(buttons);
  twc->setColors(colors);
  twc->setOwnerstringtype(ownerstringtype);
  twc->setClockbarMode(clockbar_mode);
  twc->setClockbarUpdatetime(clockbar_updatetime);
  twc->setClockbarCommand(clockbar_command);
  twc->setDontCheckDirs(dontcheckdirs);
  twc->setListerBG(listerbg);
  twc->setShowStringForDirSize(showStringForDirSize);
  twc->setStringForDirSize(stringForDirSize);
  
  twc->setDateFormat( date_format );
  twc->setDateFormatString( date_formatstring );
  twc->setDateSubst( date_subst );
  twc->setTimeFormat( time_format );
  twc->setTimeFormatString( time_formatstring );
  twc->setDateBeforeTime( date_before_time );
  
  return twc;
}

void WConfig::setColors(List *ncolors)
{
  WC_Color *tc;
  int id=colors->initEnum();
  tc=(WC_Color*)colors->getFirstElement(id);
  while(tc!=NULL) {
    delete tc;
    tc=(WC_Color*)colors->getNextElement(id);
  }
  colors->closeEnum(id);
  colors->removeAllElements();
  id=ncolors->initEnum();
  tc=(WC_Color*)ncolors->getFirstElement(id);
  while(tc!=NULL) {
    colors->addElement(tc->duplicate());
    tc=(WC_Color*)ncolors->getNextElement(id);
  }
  ncolors->closeEnum(id);
}

List *WConfig::getColors()
{
  return colors;
}

/**************************************
 Definition WCButton
**************************************/

WCButton::WCButton()
{
  text=dupstring("");
  fg=1;
  bg=0;
  key=new WCShortkey();
  com=new List();
  check=false;
  flags=new WCGlobalFlags();
}

WCButton::~WCButton()
{
  if(text!=NULL) _freesafe(text);
  delete key;
  freecoms(com);
  delete com;
  delete flags;
}

WCButton *WCButton::duplicate()
{
  WCButton *tbut=new WCButton();
  tbut->setText(text);
  tbut->setFG(fg);
  tbut->setBG(bg);
  tbut->setKey(key);
  tbut->setComs(com);
  tbut->setCheck(check);
  tbut->setComsGF(flags);
  return tbut;
}

void WCButton::setText(const char *ntext)
{
  if(text!=NULL) _freesafe(text);
  if(ntext==NULL) {
    text=dupstring("");
  } else {
    text=dupstring(ntext);
  }
}

void WCButton::setFG(int nfg)
{
  fg=nfg;
}

void WCButton::setBG(int nbg)
{
  bg=nbg;
}

char *WCButton::getText()
{
  return text;
}

int WCButton::getFG()
{
  return fg;
}

int WCButton::getBG()
{
  return bg;
}

WCShortkey *WCButton::getKey()
{
  return key;
}

List *WCButton::getComs()
{
  return com;
}

void WCButton::setKey(WCShortkey *nkey)
{
  if(key!=NULL) delete key;
  if(nkey==NULL) {
    key=new WCShortkey();
  } else {
    key=nkey->duplicate();
  }
}

void WCButton::setComs(List *ncom)
{
  freecoms(com);
  FunctionProto *fp;
  int id=ncom->initEnum();
  fp=(FunctionProto*)ncom->getFirstElement(id);
  while(fp!=NULL) {
    com->addElement(fp->duplicate());
    fp=(FunctionProto*)ncom->getNextElement(id);
  }
  com->closeEnum(id);  
}

void WCButton::setCheck(bool ncheck)
{
  check=ncheck;
}

bool WCButton::getCheck()
{
  return check;
}

WCGlobalFlags *WCButton::getComsGF()
{
  return flags;
}

void WCButton::setComsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) flags->setFlags(0);
  else flags->setFlags(nf->getFlags());
}

/**************************************
 Ende Definition WCButton
**************************************/

void freecoms(List *com)
{
  FunctionProto *fp;
  int id=com->initEnum();
  fp=(FunctionProto*)com->getFirstElement(id);
  while(fp!=NULL) {
    delete fp;
    fp=(FunctionProto*)com->getNextElement(id);
  }
  com->removeAllElements();
  com->closeEnum(id);
}

/**************************************
 Definition WCHotkey
**************************************/

WCHotkey::WCHotkey()
{
  name=dupstring("");
  key=new WCShortkey();
  com=new List();
  flags=new WCGlobalFlags();
}

WCHotkey::~WCHotkey()
{
  if(name!=NULL) _freesafe(name);
  delete key;
  freecoms(com);
  delete com;
  delete flags;
}

WCHotkey *WCHotkey::duplicate()
{
  WCHotkey *thot=new WCHotkey();
  thot->setName(name);
  thot->setKey(key);
  thot->setComs(com);
  thot->setComsGF(flags);
  return thot;
}

void WCHotkey::setName(const char *nname)
{
  if(name!=NULL) _freesafe(name);
  if(nname==NULL) {
    name=dupstring("");
  } else {
    name=dupstring(nname);
  }
}

char *WCHotkey::getName()
{
  return name;
}

WCShortkey *WCHotkey::getKey()
{
  return key;
}

List *WCHotkey::getComs()
{
  return com;
}

void WCHotkey::setKey(WCShortkey *nkey)
{
  if(key!=NULL) delete key;
  if(nkey==NULL) {
    key=new WCShortkey();
  } else {
    key=nkey->duplicate();
  }
}

void WCHotkey::setComs(List *ncom)
{
  freecoms(com);
  FunctionProto *fp;
  int id=ncom->initEnum();
  fp=(FunctionProto*)ncom->getFirstElement(id);
  while(fp!=NULL) {
    com->addElement(fp->duplicate());
    fp=(FunctionProto*)ncom->getNextElement(id);
  }
  com->closeEnum(id);  
}

WCGlobalFlags *WCHotkey::getComsGF()
{
  return flags;
}

void WCHotkey::setComsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) flags->setFlags(0);
  else flags->setFlags(nf->getFlags());
}

/**************************************
 Ende Definition WCHotkey
**************************************/

/**************************************
 Definition WCPath
**************************************/

WCPath::WCPath()
{
  name=dupstring("");
  path=dupstring("");
  fg=1;
  bg=0;
  key=new WCShortkey();
  check=false;
}

WCPath::~WCPath()
{
  if(name!=NULL) _freesafe(name);
  if(path!=NULL) _freesafe(path);
  delete key;
}

WCPath *WCPath::duplicate()
{
  WCPath *tpath=new WCPath();
  tpath->setName(name);
  tpath->setPath(path);
  tpath->setFG(fg);
  tpath->setBG(bg);
  tpath->setKey(key);
  tpath->setCheck(check);
  return tpath;
}

void WCPath::setName(const char *nname)
{
  if(name!=NULL) _freesafe(name);
  if(nname==NULL) {
    name=dupstring("");
  } else {
    name=dupstring(nname);
  }
}

void WCPath::setPath(const char *npath)
{
  if(path!=NULL) _freesafe(path);
  if(npath==NULL) {
    path=dupstring("");
  } else {
    path=dupstring(npath);
  }
}

void WCPath::setFG(int nfg)
{
  fg=nfg;
}

void WCPath::setBG(int nbg)
{
  bg=nbg;
}

char *WCPath::getName()
{
  return name;
}

char *WCPath::getPath()
{
  return path;
}

int WCPath::getFG()
{
  return fg;
}

int WCPath::getBG()
{
  return bg;
}

WCShortkey *WCPath::getKey()
{
  return key;
}

void WCPath::setKey(WCShortkey *nkey)
{
  if(key!=NULL) delete key;
  if(nkey==NULL) {
    key=new WCShortkey();
  } else {
    key=nkey->duplicate();
  }
}

void WCPath::setCheck(bool ncheck)
{
  check=ncheck;
}

bool WCPath::getCheck()
{
  return check;
}

bool WCPath::configure(AGUIX *aguix)
{
  return false;
}

/**************************************
 Ende Definition WCPath
**************************************/

/**************************************
 Definition WCFiletype
**************************************/

WCFiletype::WCFiletype()
{
  int i;
  name=dupstring("");
  namelen=0;
  pattern=dupstring("");
  usepattern=false;
  usefiledesc=false;
  for(i=1;i<64;i++) filedesc[i]=-1;
  filedesc[0]=-2;
  dndaction=new List();
  doubleclickaction=new List();
  showaction=new List();
  rawshowaction=new List();
  for(i=0;i<10;i++) useraction[i]=new List();
  dndactiongf=new WCGlobalFlags();
  doubleclickactiongf=new WCGlobalFlags();
  showactiongf=new WCGlobalFlags();
  rawshowactiongf=new WCGlobalFlags();
  for(i=0;i<10;i++) useractiongf[i]=new WCGlobalFlags();
  internID=0;

  usefileexp = false;
  fileexp = dupstring( "" );
#if 0  // for filetype checking with file
  regex_compiled = false;
#endif
}

int WCFiletype::getinternID()
{
  return internID;
}

void WCFiletype::setinternID(int newid)
{
  if((newid<NORMALTYPE)||(newid>DIRTYPE)) return;
  internID=newid;
}

WCFiletype::~WCFiletype()
{
  int i;
  if(name!=NULL) _freesafe(name);
  if(pattern!=NULL) _freesafe(pattern);
  freecoms(dndaction);
  freecoms(doubleclickaction);
  freecoms(showaction);
  freecoms(rawshowaction);
  for(i=0;i<10;i++) freecoms(useraction[i]);
  delete dndaction;
  delete doubleclickaction;
  delete showaction;
  delete rawshowaction;
  for(i=0;i<10;i++) delete useraction[i];
  delete dndactiongf;
  delete doubleclickactiongf;
  delete showactiongf;
  delete rawshowactiongf;
  for(i=0;i<10;i++) delete useractiongf[i];

#if 0  // for filetype checking with file
  free_compexp();
#endif
  _freesafe( fileexp );
}

WCFiletype *WCFiletype::duplicate()
{
  int i;
  WCFiletype *tft=new WCFiletype();
  tft->setName(name);
  tft->setPattern(pattern);
  tft->setUsePattern(usepattern);
  tft->setFiledesc(filedesc);
  tft->setUseFiledesc(usefiledesc);
  tft->setDNDActions(dndaction);
  tft->setDoubleClickActions(doubleclickaction);
  tft->setShowActions(showaction);
  tft->setRawShowActions(rawshowaction);
  for(i=0;i<10;i++) tft->setUserActions(i,useraction[i]);
  tft->setDNDActionsGF(dndactiongf);
  tft->setDoubleClickActionsGF(doubleclickactiongf);
  tft->setShowActionsGF(showactiongf);
  tft->setRawShowActionsGF(rawshowactiongf);
  for(i=0;i<10;i++) tft->setUserActionsGF(i,useractiongf[i]);
  tft->setinternID(internID);
  tft->setUseFileExp( usefileexp );
  tft->setFileExp( fileexp );
  
  return tft;
}

void WCFiletype::setName(const char *nname)
{
  if(name!=NULL) _freesafe(name);
  if(nname==NULL) {
    name=dupstring("");
    namelen=0;
  } else {
    name=dupstring(nname);
    namelen=strlen(name);
  }
}

void WCFiletype::setPattern(const char *npattern)
{
  if(pattern!=NULL) _freesafe(pattern);
  if(npattern==NULL) {
    pattern=dupstring("");
  } else {
    pattern=dupstring(npattern);
  }
}

char *WCFiletype::getName()
{
  return name;
}

char *WCFiletype::getPattern()
{
  return pattern;
}

void WCFiletype::setUsePattern(bool nup)
{
  usepattern=nup;
}

bool WCFiletype::getUsePattern()
{
  return usepattern;
}

void WCFiletype::setUseFiledesc(bool nufd)
{
  usefiledesc=nufd;
}

bool WCFiletype::getUseFiledesc()
{
  return usefiledesc;
}

void WCFiletype::setFiledesc(short *nfd)
{
  for(int i=0;i<64;i++) filedesc[i]=nfd[i];
}

short *WCFiletype::getFiledesc()
{
  return filedesc;
}

List *WCFiletype::getDNDActions()
{
  return dndaction;
}

List *WCFiletype::getDoubleClickActions()
{
  return doubleclickaction;
}

List *WCFiletype::getShowActions()
{
  return showaction;
}

List *WCFiletype::getRawShowActions()
{
  return rawshowaction;
}

List *WCFiletype::getUserActions(int id)
{
  if((id<0)||(id>9)) return NULL;
  return useraction[id];
}

void WCFiletype::setDNDActions(List *ndnda)
{
  freecoms(dndaction);
  FunctionProto *fp;
  int id=ndnda->initEnum();
  fp=(FunctionProto*)ndnda->getFirstElement(id);
  while(fp!=NULL) {
    dndaction->addElement(fp->duplicate());
    fp=(FunctionProto*)ndnda->getNextElement(id);
  }
  ndnda->closeEnum(id);
}

void WCFiletype::setDoubleClickActions(List *ndca)
{
  freecoms(doubleclickaction);
  FunctionProto *fp;
  int id=ndca->initEnum();
  fp=(FunctionProto*)ndca->getFirstElement(id);
  while(fp!=NULL) {
    doubleclickaction->addElement(fp->duplicate());
    fp=(FunctionProto*)ndca->getNextElement(id);
  }
  ndca->closeEnum(id);
}

void WCFiletype::setShowActions(List *nsa)
{
  freecoms(showaction);
  FunctionProto *fp;
  int id=nsa->initEnum();
  fp=(FunctionProto*)nsa->getFirstElement(id);
  while(fp!=NULL) {
    showaction->addElement(fp->duplicate());
    fp=(FunctionProto*)nsa->getNextElement(id);
  }
  nsa->closeEnum(id);
}

void WCFiletype::setRawShowActions(List *nrsa)
{
  freecoms(rawshowaction);
  FunctionProto *fp;
  int id=nrsa->initEnum();
  fp=(FunctionProto*)nrsa->getFirstElement(id);
  while(fp!=NULL) {
    rawshowaction->addElement(fp->duplicate());
    fp=(FunctionProto*)nrsa->getNextElement(id);
  }
  nrsa->closeEnum(id);
}

void WCFiletype::setUserActions(int uid,List *nua)
{
  if((uid<0)||(uid>9)) return;
  freecoms(useraction[uid]);
  FunctionProto *fp;
  int id=nua->initEnum();
  fp=(FunctionProto*)nua->getFirstElement(id);
  while(fp!=NULL) {
    useraction[uid]->addElement(fp->duplicate());
    fp=(FunctionProto*)nua->getNextElement(id);
  }
  nua->closeEnum(id);
}

WCGlobalFlags *WCFiletype::getDNDActionsGF()
{
  return dndactiongf;
}

WCGlobalFlags *WCFiletype::getDoubleClickActionsGF()
{
  return doubleclickactiongf;
}

WCGlobalFlags *WCFiletype::getShowActionsGF()
{
  return showactiongf;
}

WCGlobalFlags *WCFiletype::getRawShowActionsGF()
{
  return rawshowactiongf;
}

WCGlobalFlags *WCFiletype::getUserActionsGF(int index2)
{
  if((index2<0)||(index2>9)) return NULL;
  return useractiongf[index2];
}

void WCFiletype::setDNDActionsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) dndactiongf->setFlags(0);
  else dndactiongf->setFlags(nf->getFlags());
}

void WCFiletype::setDoubleClickActionsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) doubleclickactiongf->setFlags(0);
  else doubleclickactiongf->setFlags(nf->getFlags());
}

void WCFiletype::setShowActionsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) showactiongf->setFlags(0);
  else showactiongf->setFlags(nf->getFlags());
}

void WCFiletype::setRawShowActionsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) rawshowactiongf->setFlags(0);
  else rawshowactiongf->setFlags(nf->getFlags());
}

void WCFiletype::setUserActionsGF(int index2,WCGlobalFlags *nf)
{
  if((index2<0)||(index2>9)) return;
  if(nf==NULL) useractiongf[index2]->setFlags(0);
  else useractiongf[index2]->setFlags(nf->getFlags());
}

/**************************************
 Ende Definition WCFiletype
**************************************/

/**************************************
 Definition WCShortkey
**************************************/

WCShortkey::WCShortkey()
{
  shortkey=0;
  mod=0;
}

WCShortkey::~WCShortkey()
{
}

WCShortkey *WCShortkey::duplicate()
{
  WCShortkey *tsh=new WCShortkey();
  tsh->setMod(mod);
  tsh->setShortkey(shortkey);
  return tsh;
}

void WCShortkey::setShortkey(KeySym nkey)
{
  shortkey=nkey;
}

void WCShortkey::setMod(unsigned int nmod)
{
  mod=nmod;
}

KeySym WCShortkey::getShortkey()
{
  return shortkey;
}

unsigned int WCShortkey::getMod()
{
  return mod;
}

bool WCShortkey::isShortkey(KeySym tkey,unsigned int tmod)
{
  if((tkey==shortkey)&&(tmod==mod)) return true;
  return false;
}

bool WCShortkey::isReal()
{
  if ( shortkey != 0 ) return true;
  return false;
}

/**************************************
 Ende Definition WCShortkey
**************************************/

/**************************************
 Definition WCGlobalFlags
**************************************/

WCGlobalFlags::WCGlobalFlags()
{
  flags=0;
}

WCGlobalFlags::~WCGlobalFlags()
{
}

WCGlobalFlags *WCGlobalFlags::duplicate()
{
  WCGlobalFlags *tf=new WCGlobalFlags();
  tf->setFlags(flags);
  return tf;
}

unsigned long WCGlobalFlags::getFlags()
{
  return flags;
}

void WCGlobalFlags::setFlags(unsigned long nf)
{
  flags=nf;
}

/**************************************
 Ende Definition WCGlobalFlags
**************************************/

bool WConfig::configurePath(WCPath *p1)
{
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty,tx;
  int t1,t2;
  AWindow *win=new AWindow(aguix);
  w=10;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(82));
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(83),1));
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,5+tt1->getWidth()+5,
                                                             ty,100,p1->getName(),0));
  w=sg1->getX()+sg1->getWidth()+5;
  ty+=sg1->getHeight()+5;
  
  t1=5*aguix->getCharWidth();
  SolidButton *sb1=(SolidButton*)win->add(new SolidButton(aguix,5,ty,t1,"Test",
                                                          p1->getFG(),p1->getBG(),false));
  tx=sb1->getX()+sb1->getWidth()+5;
  t1=strlen(catalog.getLocale(32))+2;
  t1*=aguix->getCharWidth();
  Button *b1=(Button*)win->add(new Button(aguix,tx,ty,t1,catalog.getLocale(32),1,0,0));
  tx+=b1->getWidth()+5;
  t1=strlen(catalog.getLocale(33))+2;
  t1*=aguix->getCharWidth();
  Button *b2=(Button*)win->add(new Button(aguix,tx,ty,t1,catalog.getLocale(33),1,0,0));
  tw=tx+b2->getWidth()+5;
  if(tw>w) w=tw;
  ty+=b2->getHeight()+5;
  t1=strlen(catalog.getLocale(61))+2;
  t1*=aguix->getCharWidth();
  t2=strlen(catalog.getLocale(62))+2;
  t2*=aguix->getCharWidth();
  tw=(t1>t2)?t1:t2;
  Button *b3=(Button*)win->add(new Button(aguix,5,ty,tw,catalog.getLocale(61),
                                          catalog.getLocale(62),1,1,0,0,0));
  Text *skt=(Text*)win->add(new Text(aguix,5+b3->getWidth()+5,ty,"",1));
  tw=30*aguix->getCharWidth()+5+b3->getWidth()+10;
  if(tw>w) w=tw;
  ty+=b3->getHeight()+5;
  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(84),1));
  StringGadget *sg2=(StringGadget*)win->add(new StringGadget(aguix,5+tt1->getWidth()+5,ty,100,
                                                             p1->getPath(),0));
  tw=sg2->getX()+sg2->getWidth()+5;
  if(tw>w) w=tw;
  ty+=sg2->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  sg1->resize(w-5-sg1->getX(),sg1->getHeight());
  sg2->resize(w-5-sg2->getX(),sg2->getHeight());
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  WCShortkey *sk=p1->getKey()->duplicate();
  char *tstr=aguix->getNameOfKey(sk->getShortkey(),sk->getMod());
  if(tstr!=NULL) {
    skt->setText(tstr);
    _freesafe(tstr);
  }
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b1) {
          int col=palette(sb1->getFG());
          if(col>=0) sb1->setFG(col);
        } else if(msg->button.button==b2) {
          int col=palette(sb1->getBG());
          if(col>=0) sb1->setBG(col);
        } else if(msg->button.button==b3) {
          if(msg->button.state==1) {
            WCShortkey *tsk;
            getShortkey(p1->getKey(),&tsk);
            if(tsk!=NULL) {
              delete sk;
              sk=tsk;
              tstr=aguix->getNameOfKey(sk->getShortkey(),sk->getMod());
              skt->setText(tstr);
              _freesafe(tstr);
            }
          } else {
            delete sk;
            sk=NULL;
            skt->setText("");
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // Ubernehmen
    p1->setName(sg1->getText());
    p1->setPath(sg2->getText());
    if(sk!=NULL) {
      WCButton *twcb;
      WCHotkey *twch;
      WCPath *twcp;
      // search for existing shortkey and remove it
      if(findShortkey(sk,&twcb,&twcp,&twch)!=0) {
        if(twcb!=NULL) {
          twcb->setKey(NULL);
        } else if(twcp!=NULL) {
          twcp->setKey(NULL);
        } else if(twch!=NULL) {
          twch->setKey(NULL);
        }
      }
      p1->setKey(sk);
    } else {
      sk=new WCShortkey();
      p1->setKey(sk);
    }
    p1->setCheck(true);
    p1->setFG(sb1->getFG());
    p1->setBG(sb1->getBG());
  }
  if(sk!=NULL) delete sk;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

/*
 * getShortkey
 * Returnvalue:
 * -1 Cancel, null in return_sk
 * 0 Okay, no collision, Shortkey in return_sk
 * 1 Okay, collision with ignore_sk, null in return_sk
 * 2 Okay, collision with some other sk, Shortkey in return_sk
 */
int WConfig::getShortkey(const WCShortkey *ignore_sk, WCShortkey **return_sk)
{
  WCShortkey *tsk=NULL;
  AGUIX *aguix=worker->getAGUIX();
  int w,h;
  WCButton *b1;
  WCPath *p1;
  WCHotkey *h1;
  char *textstr,*buttonstr;
  Requester *req=new Requester(aguix);
  int erg;
  int returnvalue=-1;
  
  AWindow *win=new AWindow(aguix);
  w=10;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(61));
  Text *tt1=(Text*)win->add(new Text(aguix,5,5,catalog.getLocale(66),1));
  w=10+tt1->getWidth();
  h=10+tt1->getHeight();
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_KEYRELEASED) {
        if(tsk!=NULL) {
          delete tsk;
        }
        tsk=new WCShortkey();
        tsk->setShortkey(msg->key.key);
        tsk->setMod(KEYSTATEMASK(msg->key.keystate));
        if(findShortkey(tsk,&b1,&p1,&h1)!=0) {
          if(b1!=NULL) {
            if(b1->getKey()==ignore_sk) {
              returnvalue=1;
              ende=1;
            } else {
              textstr=(char*)_allocsafe(strlen(catalog.getLocale(42))+strlen(b1->getText())+1);
              sprintf(textstr,catalog.getLocale(42),b1->getText());
              buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(41))+1+
                                          strlen(catalog.getLocale(11))+1+
                                          strlen(catalog.getLocale(8))+1);
              sprintf(buttonstr,"%s|%s|%s",catalog.getLocale(41),
                                           catalog.getLocale(11),
                                           catalog.getLocale(8));
              erg=req->request(catalog.getLocale(125),textstr,buttonstr);
              _freesafe(textstr);
              _freesafe(buttonstr);
              if(erg==2) ende=-1;
              else if(erg==1) {
                returnvalue=2;
                ende=1;
              }
            }
          } else if(p1!=NULL) {
            if(p1->getKey()==ignore_sk) {
              returnvalue=1;
              ende=1;
            } else {
              textstr=(char*)_allocsafe(strlen(catalog.getLocale(63))+strlen(p1->getName())+1);
              sprintf(textstr,catalog.getLocale(63),p1->getName());
              buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(41))+1+
                                          strlen(catalog.getLocale(11))+1+
                                          strlen(catalog.getLocale(8))+1);
              sprintf(buttonstr,"%s|%s|%s",catalog.getLocale(41),
                                           catalog.getLocale(11),
                                           catalog.getLocale(8));
              erg=req->request(catalog.getLocale(125),textstr,buttonstr);
              _freesafe(textstr);
              _freesafe(buttonstr);
              if(erg==2) ende=-1;
              else if(erg==1) {
                returnvalue=2;
                ende=1;
              }
            }
          } else if(h1!=NULL) {
            if(h1->getKey()==ignore_sk) {
              returnvalue=1;
              ende=1;
            } else {
              textstr=(char*)_allocsafe(strlen(catalog.getLocale(65))+strlen(h1->getName())+1);
              sprintf(textstr,catalog.getLocale(65),h1->getName());
              buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(41))+1+
                                          strlen(catalog.getLocale(11))+1+
                                          strlen(catalog.getLocale(8))+1);
              sprintf(buttonstr,"%s|%s|%s",catalog.getLocale(41),
                                           catalog.getLocale(11),
                                           catalog.getLocale(8));
              erg=req->request(catalog.getLocale(125),textstr,buttonstr);
              _freesafe(textstr);
              _freesafe(buttonstr);
              if(erg==2) ende=-1;
              else if(erg==1) {
                returnvalue=2;
                ende=1;
              }
            }
          }
        } else {
          returnvalue=0;
          ende=1;
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  win->close();
  delete win;
  delete req;

  if(ende<0) returnvalue=-1;  
  if( ((returnvalue==2)||(returnvalue==0)) && (return_sk!=NULL) ) {
    *return_sk=tsk;
  } else {
    if(return_sk!=NULL)
      *return_sk=NULL;
    if(tsk!=NULL)
      delete tsk;
  }
  return returnvalue;
}

bool WConfig::configureHotkey(WCHotkey *h1)
{
  WCHotkey *h1_bak=h1->duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2,t3;
  AWindow *win=new AWindow(aguix);
  w=10;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(91));
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(92),1));
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,5+tt1->getWidth()+5,
                                                             ty,100,h1->getName(),0));
  w=sg1->getX()+sg1->getWidth()+5;
  ty+=sg1->getHeight()+5;
  
  t1=strlen(catalog.getLocale(61))+2;
  t1*=aguix->getCharWidth();
  t2=strlen(catalog.getLocale(62))+2;
  t2*=aguix->getCharWidth();
  tw=(t1>t2)?t1:t2;
  Button *b1=(Button*)win->add(new Button(aguix,5,ty,tw,catalog.getLocale(61),
                                          catalog.getLocale(62),1,1,0,0,0));
  Text *skt=(Text*)win->add(new Text(aguix,5+b1->getWidth()+5,ty,"",1));
  tw=30*aguix->getCharWidth()+5+b1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=b1->getHeight()+5;

  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(245),1));
  ty+=tt1->getHeight()+5;

  t1=strlen(catalog.getLocale(246))+2;
  t1*=aguix->getCharWidth();
  Button *b2=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(246),1,0,0));
  t2=b2->getWidth();
  ty+=b2->getHeight();
  t1=strlen(catalog.getLocale(247))+2;
  t1*=aguix->getCharWidth();
  Button *b3=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(247),1,0,0));
  t3=b3->getWidth();
  if(t3>t2) t2=t3;
  ty+=b3->getHeight();
  t1=strlen(catalog.getLocale(248))+2;
  t1*=aguix->getCharWidth();
  Button *b4=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(248),2,3,0));
  t3=b4->getWidth();
  if(t3>t2) t2=t3;
  ty+=b4->getHeight();
  t1=strlen(catalog.getLocale(236))+2;
  t1*=aguix->getCharWidth();
  Button *b5=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(236),1,0,0));
  t3=b5->getWidth();
  if(t3>t2) t2=t3;
  ty+=b5->getHeight();
  t1=strlen(catalog.getLocale(237))+2;
  t1*=aguix->getCharWidth();
  Button *b6=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(237),1,0,0));
  t3=b6->getWidth();
  if(t3>t2) t2=t3;
  ty+=b6->getHeight()+5;
  b2->resize(t2,b2->getHeight());
  b3->resize(t2,b3->getHeight());
  b4->resize(t2,b4->getHeight());
  b5->resize(t2,b5->getHeight());
  b6->resize(t2,b6->getHeight());
  ListView *lv=(ListView*)win->add(new ListView(aguix,b2->getX()+b2->getWidth(),
                                                b2->getY(),
                                                w-5-b2->getX()-b2->getWidth(),
                                                b6->getY()+b6->getHeight()-b2->getY(),
                                                0));
  lv->setHBarState(2);
  lv->setVBarState(2);
  List *coms=h1->getComs();
  int id=coms->initEnum();
  FunctionProto *fpr=(FunctionProto*)coms->getFirstElement(id);
  while(fpr!=NULL) {
    lv->add(new ListViewContent(fpr->getDescription(),1,1,2,2,0,0,1,1,0));
    fpr=(FunctionProto*)coms->getNextElement(id);
  }
  coms->closeEnum(id);
  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(64),1));
  ty+=tt1->getHeight()+5;
  ListView *lv2=(ListView*)win->add(new ListView(aguix,5,ty,w-10,75,0));
  lv2->setHBarState(2);
  lv2->setVBarState(2);
  ty+=lv2->getHeight()+5;
  List *fns=WCGlobalFlags::getNameOfFlags();
  unsigned long flags=h1->getComsGF()->getFlags(),tp;
  char *str=(char*)fns->getFirstElement();
  t1=0;
  ListViewContent *tlvc;
  while(str!=NULL) {
    tlvc=(ListViewContent*)lv2->add(new ListViewContent(str,1,2,1,2,0,1,0,1,0));
    tp=(unsigned long)pow(2,t1);
    if((flags&tp)==tp) {
      tlvc->setSelect(true);
    }
    str=(char*)fns->getNextElement();
    t1++;
  }

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  sg1->resize(w-5-sg1->getX(),sg1->getHeight());
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  WCShortkey *sk=h1->getKey()->duplicate();
  char *tstr=aguix->getNameOfKey(sk->getShortkey(),sk->getMod());
  if(tstr!=NULL) {
    skt->setText(tstr);
    _freesafe(tstr);
  }
  FunctionProto *fpr2;
  ListViewContent *tlvc2;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b1) {
          if(msg->button.state==1) {
            WCShortkey *tsk;
            getShortkey(h1->getKey(),&tsk);
            if(tsk!=NULL) {
              delete sk;
              sk=tsk;
              tstr=aguix->getNameOfKey(sk->getShortkey(),sk->getMod());
              skt->setText(tstr);
              _freesafe(tstr);
            }
          } else {
            delete sk;
            sk=NULL;
            skt->setText("");
          }
        } else if(msg->button.button==b2) {
          fpr=requestCommand();
          if(fpr!=NULL) {
            coms->addElement(fpr);
            tlvc=lv->add(new ListViewContent(fpr->getDescription(),1,1,2,2,0,0,1,1,0));
            tlvc->setActive(true);
            lv->showActive();
          }
        } else if(msg->button.button==b3) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            fpr=(FunctionProto*)coms->getElementAt(t1);
            delete fpr;
            coms->removeElementAt(t1);
            lv->remove(tlvc);
            lv->showActive();
          }
        } else if(msg->button.button==b4) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            fpr=(FunctionProto*)coms->getElementAt(t1);
            fpr->configure();
          }
        } else if(msg->button.button==b5) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            if(t1>0) {
              fpr=(FunctionProto*)coms->getElementAt(t1);
              fpr2=(FunctionProto*)coms->exchangeElement(t1-1,fpr);
              coms->exchangeElement(t1,fpr2);
              tlvc2=lv->add(new ListViewContent(tlvc->getText(),1,1,2,2,0,0,1,1,0),t1-1);
              lv->remove(tlvc);
              tlvc2->setActive(true);
              lv->showActive();
            }
          }
        } else if(msg->button.button==b6) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            if(t1<(lv->getElements()-1)) {
              fpr=(FunctionProto*)coms->getElementAt(t1);
              fpr2=(FunctionProto*)coms->exchangeElement(t1+1,fpr);
              coms->exchangeElement(t1,fpr2);
              tlvc2=lv->add(new ListViewContent(tlvc->getText(),1,1,2,2,0,0,1,1,0),t1+2);
              lv->remove(tlvc);
              tlvc2->setActive(true);
              lv->showActive();
            }
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // Ubernehmen
    h1->setName(sg1->getText());
    if(sk!=NULL) {
      WCButton *twcb;
      WCHotkey *twch;
      WCPath *twcp;
      // search for existing shortkey and remove it
      if(findShortkey(sk,&twcb,&twcp,&twch)!=0) {
        if(twcb!=NULL) {
          twcb->setKey(NULL);
        } else if(twcp!=NULL) {
          twcp->setKey(NULL);
        } else if(twch!=NULL) {
          twch->setKey(NULL);
        }
      }
      h1->setKey(sk);
    } else {
      sk=new WCShortkey();
      h1->setKey(sk);
    }
    for(t1=0,flags=0;t1<fns->size();t1++) {
      tlvc=lv2->get(0);
      if(tlvc->getSelect()==true) {
        tp=(unsigned long)pow(2,t1);
        flags+=tp;
      }
    }
    h1->getComsGF()->setFlags(flags);
  } else {
    h1->setComs(h1_bak->getComs());
  }
  WCGlobalFlags::freeNameOfFlags(fns);
  if(sk!=NULL) delete sk;
  delete h1_bak;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

List* WCGlobalFlags::getNameOfFlags()
{
  List *names=new List();
//  names->addElement(dupstring("All in one shell"));
  return names;
}

void WCGlobalFlags::freeNameOfFlags(List *names)
{
  while(names->size()>0) {
    _freesafe(names->getFirstElement());
    names->removeFirstElement();
  }
  delete names;
}

struct requestCommand_str {
  char *str;
  int id;
};

int WConfig::requestCommand_sf(void *p1,void *p2)
{
  return strcasecmp(((struct requestCommand_str*)p1)->str,((struct requestCommand_str*)p2)->str);
}

FunctionProto *WConfig::requestCommand()
{
  AGUIX *aguix=worker->getAGUIX();
  FunctionProto *fpr=NULL;
  int tw,w,h,ty;
  int t1,t2;
  AWindow *win=new AWindow(aguix);
  List *tlist;
  struct requestCommand_str *ts;
  int id;
  
  w=200;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(249));
  ty=5;
  ListView *lv=(ListView*)win->add(new ListView(aguix,5,
                                                ty,
                                                w-10,
                                                200,
                                                0));
  lv->setHBarState(2);
  lv->setVBarState(2);
  
  tlist=new List();
  FunctionProto *tfpr;
  for(int i=0;i<worker->getNrOfCommands();i++) {
    tfpr=worker->getCommand4ID(i);
    ts=(struct requestCommand_str*)_allocsafe(sizeof(struct requestCommand_str));
    ts->id=i;
    ts->str=dupstring(tfpr->getDescription());
    tlist->addElement(ts);
    delete tfpr;
  }
  tlist->sort(requestCommand_sf);

  id=tlist->initEnum();
  ts=(struct requestCommand_str*)tlist->getFirstElement(id);
  while(ts!=NULL) {
    lv->add(new ListViewContent(ts->str,1,1,2,2,0,0,1,1,0));
    ts=(struct requestCommand_str*)tlist->getNextElement(id);
  }

  ty+=lv->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
//  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      } else if(msg->type==AG_SIZECHANGED) {
        if(msg->size.window==win->getWindow()) {
          w=msg->size.neww;
          h=msg->size.newh;
          okb->move(okb->getX(),h-5-okb->getHeight());
          cancelb->move(w-5-cancelb->getWidth(),h-5-cancelb->getHeight());
          lv->resize(w-10,okb->getY()-10);
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    ListViewContent *tlvc=lv->getActiveLVC();
    if(tlvc!=NULL) {
      t1=lv->getPos(tlvc);
      if(t1>=0) {
        ts=(struct requestCommand_str*)tlist->getElementAt(t1);
        fpr=worker->getCommand4ID(ts->id);
      }
    }
  }
  win->close();
  delete win;

  ts=(struct requestCommand_str*)tlist->getFirstElement(id);
  while(ts!=NULL) {
    _freesafe(ts->str);
    _freesafe(ts);
    ts=(struct requestCommand_str*)tlist->getNextElement(id);
  }
  tlist->closeEnum(id);
  delete tlist;

  return fpr;
}

bool WConfig::configureButton(WCButton *wcb1)
{
  WCButton *wcb1_bak=wcb1->duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2,t3;
  AWindow *win=new AWindow(aguix);
  w=10;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(59));
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(60),1));
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,5+tt1->getWidth()+5,
                                                             ty,100,wcb1->getText(),0));
  w=sg1->getX()+sg1->getWidth()+5;
  ty+=sg1->getHeight()+5;
  t1=6*aguix->getCharWidth();
  t2=strlen(catalog.getLocale(32))+2;
  t2*=aguix->getCharWidth();
  t3=strlen(catalog.getLocale(33))+2;
  t3*=aguix->getCharWidth();
  SolidButton *tsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,t1,"Test",wcb1->getFG(),
                                                          wcb1->getBG(),false));
  Button *fgb=(Button*)win->add(new Button(aguix,5+t1+5,ty,t2,catalog.getLocale(32),1,0,0));
  Button *bgb=(Button*)win->add(new Button(aguix,5+t1+5+t2+5,ty,t3,catalog.getLocale(33),1,0,0));
  tw=bgb->getX()+bgb->getWidth()+5;
  if(tw>w) w=tw;
  ty+=fgb->getHeight()+5;
  
  t1=strlen(catalog.getLocale(61))+2;
  t1*=aguix->getCharWidth();
  t2=strlen(catalog.getLocale(62))+2;
  t2*=aguix->getCharWidth();
  tw=(t1>t2)?t1:t2;
  Button *b1=(Button*)win->add(new Button(aguix,5,ty,tw,catalog.getLocale(61),
                                          catalog.getLocale(62),1,1,0,0,0));
  Text *skt=(Text*)win->add(new Text(aguix,5+b1->getWidth()+5,ty,"",1));
  tw=30*aguix->getCharWidth()+5+b1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=b1->getHeight()+5;

  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(245),1));
  ty+=tt1->getHeight()+5;

  t1=strlen(catalog.getLocale(246))+2;
  t1*=aguix->getCharWidth();
  Button *b2=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(246),1,0,0));
  t2=b2->getWidth();
  ty+=b2->getHeight();
  t1=strlen(catalog.getLocale(247))+2;
  t1*=aguix->getCharWidth();
  Button *b3=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(247),1,0,0));
  t3=b3->getWidth();
  if(t3>t2) t2=t3;
  ty+=b3->getHeight();
  t1=strlen(catalog.getLocale(248))+2;
  t1*=aguix->getCharWidth();
  Button *b4=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(248),2,3,0));
  t3=b4->getWidth();
  if(t3>t2) t2=t3;
  ty+=b4->getHeight();
  t1=strlen(catalog.getLocale(236))+2;
  t1*=aguix->getCharWidth();
  Button *b5=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(236),1,0,0));
  t3=b5->getWidth();
  if(t3>t2) t2=t3;
  ty+=b5->getHeight();
  t1=strlen(catalog.getLocale(237))+2;
  t1*=aguix->getCharWidth();
  Button *b6=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(237),1,0,0));
  t3=b6->getWidth();
  if(t3>t2) t2=t3;
  ty+=b6->getHeight()+5;
  b2->resize(t2,b2->getHeight());
  b3->resize(t2,b3->getHeight());
  b4->resize(t2,b4->getHeight());
  b5->resize(t2,b5->getHeight());
  b6->resize(t2,b6->getHeight());
  ListView *lv=(ListView*)win->add(new ListView(aguix,b2->getX()+b2->getWidth(),
                                                b2->getY(),
                                                w-5-b2->getX()-b2->getWidth(),
                                                b6->getY()+b6->getHeight()-b2->getY(),
                                                0));
  lv->setHBarState(2);
  lv->setVBarState(2);
  List *coms=wcb1->getComs();
  int id=coms->initEnum();
  FunctionProto *fpr=(FunctionProto*)coms->getFirstElement(id);
  while(fpr!=NULL) {
    lv->add(new ListViewContent(fpr->getDescription(),1,1,2,2,0,0,1,1,0));
    fpr=(FunctionProto*)coms->getNextElement(id);
  }
  coms->closeEnum(id);
  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(64),1));
  ty+=tt1->getHeight()+5;
  ListView *lv2=(ListView*)win->add(new ListView(aguix,5,ty,w-10,75,0));
  lv2->setHBarState(2);
  lv2->setVBarState(2);
  ty+=lv2->getHeight()+5;
  List *fns=WCGlobalFlags::getNameOfFlags();
  unsigned long flags=wcb1->getComsGF()->getFlags(),tp;
  char *str=(char*)fns->getFirstElement();
  t1=0;
  ListViewContent *tlvc;
  while(str!=NULL) {
    tlvc=(ListViewContent*)lv2->add(new ListViewContent(str,1,2,1,2,0,1,0,1,0));
    tp=(unsigned long)pow(2,t1);
    if((flags&tp)==tp) {
      tlvc->setSelect(true);
    }
    str=(char*)fns->getNextElement();
    t1++;
  }

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  sg1->resize(w-5-sg1->getX(),sg1->getHeight());
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  WCShortkey *sk=wcb1->getKey()->duplicate();
  char *tstr=aguix->getNameOfKey(sk->getShortkey(),sk->getMod());
  if(tstr!=NULL) {
    skt->setText(tstr);
    _freesafe(tstr);
  }
  FunctionProto *fpr2;
  ListViewContent *tlvc2;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b1) {
          if(msg->button.state==1) {
            WCShortkey *tsk;
            getShortkey(wcb1->getKey(),&tsk);
            if(tsk!=NULL) {
              delete sk;
              sk=tsk;
              tstr=aguix->getNameOfKey(sk->getShortkey(),sk->getMod());
              skt->setText(tstr);
              _freesafe(tstr);
            }
          } else {
            delete sk;
            sk=NULL;
            skt->setText("");
          }
        } else if(msg->button.button==b2) {
          fpr=requestCommand();
          if(fpr!=NULL) {
            coms->addElement(fpr);
            tlvc=lv->add(new ListViewContent(fpr->getDescription(),1,1,2,2,0,0,1,1,0));
            tlvc->setActive(true);
            lv->showActive();
          }
        } else if(msg->button.button==b3) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            fpr=(FunctionProto*)coms->getElementAt(t1);
            delete fpr;
            coms->removeElementAt(t1);
            lv->remove(tlvc);
            lv->showActive();
          }
        } else if(msg->button.button==b4) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            fpr=(FunctionProto*)coms->getElementAt(t1);
            fpr->configure();
          }
        } else if(msg->button.button==b5) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            if(t1>0) {
              fpr=(FunctionProto*)coms->getElementAt(t1);
              fpr2=(FunctionProto*)coms->exchangeElement(t1-1,fpr);
              coms->exchangeElement(t1,fpr2);
              tlvc2=lv->add(new ListViewContent(tlvc->getText(),1,1,2,2,0,0,1,1,0),t1-1);
              lv->remove(tlvc);
              tlvc2->setActive(true);
              lv->showActive();
            }
          }
        } else if(msg->button.button==b6) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            if(t1<(lv->getElements()-1)) {
              fpr=(FunctionProto*)coms->getElementAt(t1);
              fpr2=(FunctionProto*)coms->exchangeElement(t1+1,fpr);
              coms->exchangeElement(t1,fpr2);
              tlvc2=lv->add(new ListViewContent(tlvc->getText(),1,1,2,2,0,0,1,1,0),t1+2);
              lv->remove(tlvc);
              tlvc2->setActive(true);
              lv->showActive();
            }
          }
        } else if(msg->button.button==fgb) {
          t1=palette(tsb->getFG());
          if(t1>=0) {
            tsb->setFG(t1);
          }
        } else if(msg->button.button==bgb) {
          t1=palette(tsb->getBG());
          if(t1>=0) {
            tsb->setBG(t1);
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // Ubernehmen
    wcb1->setText(sg1->getText());
    wcb1->setFG(tsb->getFG());
    wcb1->setBG(tsb->getBG());
    wcb1->setCheck(true);
    if(sk!=NULL) {
      WCButton *twcb;
      WCHotkey *twch;
      WCPath *twcp;
      // search for existing shortkey and remove it
      if(findShortkey(sk,&twcb,&twcp,&twch)!=0) {
        if(twcb!=NULL) {
          twcb->setKey(NULL);
        } else if(twcp!=NULL) {
          twcp->setKey(NULL);
        } else if(twch!=NULL) {
          twch->setKey(NULL);
        }
      }
      wcb1->setKey(sk);
    } else {
      sk=new WCShortkey();
      wcb1->setKey(sk);
    }
    for(t1=0,flags=0;t1<fns->size();t1++) {
      tlvc=lv2->get(0);
      if(tlvc->getSelect()==true) {
        tp=(unsigned long)pow(2,t1);
        flags+=tp;
      }
    }
    wcb1->getComsGF()->setFlags(flags);
  } else {
    wcb1->setComs(wcb1_bak->getComs());
  }
  WCGlobalFlags::freeNameOfFlags(fns);
  if(sk!=NULL) delete sk;
  delete wcb1_bak;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

bool WConfig::configureFiletype(WCFiletype *ft1)
{
  WCFiletype *ft1_bak=ft1->duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2,t3;
  AWindow *win=new AWindow(aguix);
  w=10;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(88));
  ty=5;

  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(89),1));
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,5+tt1->getWidth()+5,
                                                             ty,100,ft1->getName(),0));
  w=sg1->getX()+sg1->getWidth()+5;
  ty+=sg1->getHeight()+5;
  AGUIX::centerElementsY( tt1, sg1 );

  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(250),1));
  ty+=tt1->getHeight()+5;
  ListView *lv0=(ListView*)win->add(new ListView(aguix,5,ty,w-10,80,0));
  lv0->setHBarState(2);
  lv0->setVBarState(2);
  for(t1=0;t1<14;t1++) lv0->add(new ListViewContent(catalog.getLocale(251+t1),1,1,2,2,0,0,1,1,0));
  lv0->get(1)->setActive(true);
  ty+=lv0->getHeight()+5;
  
  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(245),1));
  ty+=tt1->getHeight()+5;

  t1=strlen(catalog.getLocale(246))+2;
  t1*=aguix->getCharWidth();
  Button *b2=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(246),1,0,0));
  t2=b2->getWidth();
  ty+=b2->getHeight();
  t1=strlen(catalog.getLocale(247))+2;
  t1*=aguix->getCharWidth();
  Button *b3=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(247),1,0,0));
  t3=b3->getWidth();
  if(t3>t2) t2=t3;
  ty+=b3->getHeight();
  t1=strlen(catalog.getLocale(248))+2;
  t1*=aguix->getCharWidth();
  Button *b4=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(248),2,3,0));
  t3=b4->getWidth();
  if(t3>t2) t2=t3;
  ty+=b4->getHeight();
  t1=strlen(catalog.getLocale(236))+2;
  t1*=aguix->getCharWidth();
  Button *b5=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(236),1,0,0));
  t3=b5->getWidth();
  if(t3>t2) t2=t3;
  ty+=b5->getHeight();
  t1=strlen(catalog.getLocale(237))+2;
  t1*=aguix->getCharWidth();
  Button *b6=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(237),1,0,0));
  t3=b6->getWidth();
  if(t3>t2) t2=t3;
  ty+=b6->getHeight()+5;
  b2->resize(t2,b2->getHeight());
  b3->resize(t2,b3->getHeight());
  b4->resize(t2,b4->getHeight());
  b5->resize(t2,b5->getHeight());
  b6->resize(t2,b6->getHeight());
  ListView *lv=(ListView*)win->add(new ListView(aguix,b2->getX()+b2->getWidth(),
                                                b2->getY(),
                                                w-5-b2->getX()-b2->getWidth(),
                                                b6->getY()+b6->getHeight()-b2->getY(),
                                                0));
  lv->setHBarState(2);
  lv->setVBarState(2);
  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(64),1));
  ty+=tt1->getHeight()+5;
  ListView *lv2=(ListView*)win->add(new ListView(aguix,5,ty,w-10,75,0));
  lv2->setHBarState(2);
  lv2->setVBarState(2);

  List *fns=WCGlobalFlags::getNameOfFlags();
  char *str=(char*)fns->getFirstElement();
  while(str!=NULL) {
    lv2->add(new ListViewContent(str,1,2,1,2,0,1,0,1,0));
    str=(char*)fns->getNextElement();
  }
  WCGlobalFlags::freeNameOfFlags(fns);

  ty+=lv2->getHeight()+5;
  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(93),1));
  StringGadget *sg2=(StringGadget*)win->add(new StringGadget(aguix,tt1->getX()+tt1->getWidth()+5,
                                                             ty,
                                                             100,
                                                             ft1->getPattern(),0));
  ChooseButton *cb1=(ChooseButton*)win->add(new ChooseButton(aguix,sg2->getX()+sg2->getWidth()+5,
                                                             ty,ft1->getUsePattern(),
                                                             catalog.getLocale(94),LABEL_LEFT,1,1));
  tw=cb1->getX()+cb1->getWidth()+5;
  if(tw>w) w=tw;
  ty+=sg2->getHeight()+5;
  AGUIX::centerElementsY( tt1, sg2 );
  
  t1=strlen(catalog.getLocale(95))+2;
  t1*=aguix->getCharWidth();
  Button *b7=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(95),1,0,0));
  ChooseButton *cb2=(ChooseButton*)win->add(new ChooseButton(aguix,b7->getX()+b7->getWidth()+5,
                                                             ty,ft1->getUseFiledesc(),
                                                             catalog.getLocale(96),LABEL_LEFT,1,1));
  tw=cb2->getX()+cb2->getWidth()+5;
  if(tw>w) w=tw;
  ty+=((b7->getHeight()>cb2->getHeight())?b7->getHeight():cb2->getHeight())+5;

#if 0  // for filetype checking with file
  //TODO
  tt1 = (Text*)win->add( new Text( aguix,
                                   5,
                                   ty,
                                   /*catalog.getLocale(93)*/"file-output (regular expression or substring):",
                                   1 ) );
  StringGadget *sg3 = (StringGadget*)win->add( new StringGadget( aguix,
                                                                 tt1->getX() + tt1->getWidth() + 5,
                                                                 ty,
                                                                 100,
                                                                 ft1->getFileExp(),
                                                                 0 ) );
  ChooseButton *cb3 = (ChooseButton*)win->add( new ChooseButton( aguix,
                                                                 sg3->getX() + sg3->getWidth() + 5,
                                                                 ty,
                                                                 ft1->getUseFileExp(),
                                                                 /*catalog.getLocale(94)*/"Use file-output",
                                                                 LABEL_LEFT,
                                                                 1,
                                                                 1 ) );
  tw=cb3->getX()+cb3->getWidth()+5;
  if(tw>w) w=tw;
  ty+=sg3->getHeight()+5;
  AGUIX::centerElementsY( tt1, sg3 );
#endif

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  sg1->resize(w-5-sg1->getX(),sg1->getHeight());
  lv0->resize(w-10,lv0->getHeight());
  lv->resize(w-5-lv->getX(),lv->getHeight());
  lv2->resize(w-10,lv2->getHeight());
  cb1->move(w-5-cb1->getWidth(),cb1->getY());
  cb2->move(w-5-cb2->getWidth(),cb2->getY());
#if 0  // for filetype checking with file
  cb3->move(w-5-cb3->getWidth(),cb3->getY());
#endif
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  FunctionProto *fpr2,*fpr;
  ListViewContent *tlvc2,*tlvc;
  List *coms=NULL;
  WCGlobalFlags *gf=NULL;
  tlvc=lv0->getActiveLVC();
  if(tlvc!=NULL) {
    if(gf!=NULL) {
      applyGlobalFlags(lv2,gf);
    }
    showFTActions((char*)tlvc->getText(),ft1,lv,lv2,&coms,&gf);
  }
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b2) {
          if(coms!=NULL) {
            fpr=requestCommand();
            if(fpr!=NULL) {
              coms->addElement(fpr);
              tlvc=lv->add(new ListViewContent(fpr->getDescription(),1,1,2,2,0,0,1,1,0));
              tlvc->setActive(true);
              lv->showActive();
            }
          }
        } else if(msg->button.button==b3) {
          if(coms!=NULL) {
            tlvc=lv->getActiveLVC();
            if(tlvc!=NULL) {
              t1=lv->getPos(tlvc);
              fpr=(FunctionProto*)coms->getElementAt(t1);
              delete fpr;
              coms->removeElementAt(t1);
              lv->remove(tlvc);
              lv->showActive();
            }
          }
        } else if(msg->button.button==b4) {
          if(coms!=NULL) {
            tlvc=lv->getActiveLVC();
            if(tlvc!=NULL) {
              t1=lv->getPos(tlvc);
              fpr=(FunctionProto*)coms->getElementAt(t1);
              fpr->configure();
            }
          }
        } else if(msg->button.button==b5) {
          if(coms!=NULL) {
            tlvc=lv->getActiveLVC();
            if(tlvc!=NULL) {
              t1=lv->getPos(tlvc);
              if(t1>0) {
                fpr=(FunctionProto*)coms->getElementAt(t1);
                fpr2=(FunctionProto*)coms->exchangeElement(t1-1,fpr);
                coms->exchangeElement(t1,fpr2);
                tlvc2=lv->add(new ListViewContent(tlvc->getText(),1,1,2,2,0,0,1,1,0),t1-1);
                lv->remove(tlvc);
                tlvc2->setActive(true);
                lv->showActive();
              }
            }
          }
        } else if(msg->button.button==b6) {
          if(coms!=NULL) {
            tlvc=lv->getActiveLVC();
            if(tlvc!=NULL) {
              t1=lv->getPos(tlvc);
              if(t1<(lv->getElements()-1)) {
                fpr=(FunctionProto*)coms->getElementAt(t1);
                fpr2=(FunctionProto*)coms->exchangeElement(t1+1,fpr);
                coms->exchangeElement(t1,fpr2);
                tlvc2=lv->add(new ListViewContent(tlvc->getText(),1,1,2,2,0,0,1,1,0),t1+2);
                lv->remove(tlvc);
                tlvc2->setActive(true);
                lv->showActive();
              }
            }
          }
        } else if(msg->button.button==b7) {
          if(changeFiledesc(ft1)==true) {
            cb2->setState(1);
          }
        }
      } else if((msg->type==AG_LISTVIEW_ONESELECT)||(msg->type==AG_LISTVIEW_MULTISELECT)) {
        if(msg->listview.lv==lv0) {
          // Nur das Aktions-LV interessiert
          tlvc=lv0->getActiveLVC();
          if(tlvc!=NULL) {
            if(gf!=NULL) {
              applyGlobalFlags(lv2,gf);
            }
            showFTActions((char*)tlvc->getText(),ft1,lv,lv2,&coms,&gf);
          }
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        if(msg->stringgadget.sg==sg2) cb1->setState(1);
#if 0  // for filetype checking with file
        else if ( msg->stringgadget.sg == sg3 ) cb3->setState( 1 );
#endif
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // Uebernehmen
    if(gf!=NULL) {
      applyGlobalFlags(lv2,gf);
    }
    ft1->setName(sg1->getText());
    ft1->setPattern(sg2->getText());
    ft1->setUsePattern((cb1->getState()==0)?false:true);
    ft1->setUseFiledesc((cb2->getState()==0)?false:true);
#if 0  // for filetype checking with file
    ft1->setUseFileExp( ( cb3->getState() == 0 ) ? false : true );
    ft1->setFileExp( sg3->getText() );
#endif
  } else {
    ft1->setDNDActions(ft1_bak->getDNDActions());
    ft1->setDoubleClickActions(ft1_bak->getDoubleClickActions());
    ft1->setShowActions(ft1_bak->getShowActions());
    ft1->setRawShowActions(ft1_bak->getRawShowActions());
    ft1->setUserActions(0,ft1_bak->getUserActions(0));
    ft1->setUserActions(1,ft1_bak->getUserActions(1));
    ft1->setUserActions(2,ft1_bak->getUserActions(2));
    ft1->setUserActions(3,ft1_bak->getUserActions(3));
    ft1->setUserActions(4,ft1_bak->getUserActions(4));
    ft1->setUserActions(5,ft1_bak->getUserActions(5));
    ft1->setUserActions(6,ft1_bak->getUserActions(6));
    ft1->setUserActions(7,ft1_bak->getUserActions(7));
    ft1->setUserActions(8,ft1_bak->getUserActions(8));
    ft1->setUserActions(9,ft1_bak->getUserActions(9));
    ft1->setFiledesc(ft1_bak->getFiledesc());
  }
  delete ft1_bak;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

void WConfig::showFTActions(char *actionname,
                            WCFiletype *ft,
                            ListView *lv1,
                            ListView *lv2,
                            List **return_list,
                            WCGlobalFlags **return_flags)
{
  List *l1=NULL;
  WCGlobalFlags *gf1=NULL;
  if(strcmp(actionname,catalog.getLocale(251))==0) {
    // DND
    l1=ft->getDNDActions();
    gf1=ft->getDNDActionsGF();
  } else if(strcmp(actionname,catalog.getLocale(252))==0) {
    // DoubleClick
    l1=ft->getDoubleClickActions();
    gf1=ft->getDoubleClickActionsGF();
  } else if(strcmp(actionname,catalog.getLocale(253))==0) {
    // Show
    l1=ft->getShowActions();
    gf1=ft->getShowActionsGF();
  } else if(strcmp(actionname,catalog.getLocale(254))==0) {
    // RawShow
    l1=ft->getRawShowActions();
    gf1=ft->getRawShowActionsGF();
  } else if(strcmp(actionname,catalog.getLocale(255))==0) {
    // User0
    l1=ft->getUserActions(0);
    gf1=ft->getUserActionsGF(0);
  } else if(strcmp(actionname,catalog.getLocale(256))==0) {
    // User1
    l1=ft->getUserActions(1);
    gf1=ft->getUserActionsGF(1);
  } else if(strcmp(actionname,catalog.getLocale(257))==0) {
    // User2
    l1=ft->getUserActions(2);
    gf1=ft->getUserActionsGF(2);
  } else if(strcmp(actionname,catalog.getLocale(258))==0) {
    // User3
    l1=ft->getUserActions(3);
    gf1=ft->getUserActionsGF(3);
  } else if(strcmp(actionname,catalog.getLocale(259))==0) {
    // User4
    l1=ft->getUserActions(4);
    gf1=ft->getUserActionsGF(4);
  } else if(strcmp(actionname,catalog.getLocale(260))==0) {
    // User5
    l1=ft->getUserActions(5);
    gf1=ft->getUserActionsGF(5);
  } else if(strcmp(actionname,catalog.getLocale(261))==0) {
    // User6
    l1=ft->getUserActions(6);
    gf1=ft->getUserActionsGF(6);
  } else if(strcmp(actionname,catalog.getLocale(262))==0) {
    // User7
    l1=ft->getUserActions(7);
    gf1=ft->getUserActionsGF(7);
  } else if(strcmp(actionname,catalog.getLocale(263))==0) {
    // User8
    l1=ft->getUserActions(8);
    gf1=ft->getUserActionsGF(8);
  } else if(strcmp(actionname,catalog.getLocale(264))==0) {
    // User9
    l1=ft->getUserActions(9);
    gf1=ft->getUserActionsGF(9);
  }
  int id=l1->initEnum();
  FunctionProto *fpr=(FunctionProto*)l1->getFirstElement(id);
  lv1->removeAll();
  while(fpr!=NULL) {
    lv1->add(new ListViewContent(fpr->getDescription(),1,1,2,2,0,0,1,1,0));
    fpr=(FunctionProto*)l1->getNextElement(id);
  }
  l1->closeEnum(id);

  unsigned long flags=gf1->getFlags(),tp;
  int t1;
  t1=0;
  ListViewContent *tlvc;
  List *fns=WCGlobalFlags::getNameOfFlags();
  for(t1=0;t1<fns->size();t1++) {
    tlvc=lv2->get(t1);
    tp=(unsigned long)pow(2,t1);
    if((flags&tp)==tp) {
      tlvc->setSelect(true);
    } else tlvc->setSelect(false);
    t1++;
  }
  WCGlobalFlags::freeNameOfFlags(fns);

  if(return_list!=NULL) *return_list=l1;
  if(return_flags!=NULL) *return_flags=gf1;
}

void WConfig::applyGlobalFlags(ListView *lv,WCGlobalFlags *gf)
{
  unsigned long flags=0,tp;
  List *fns=WCGlobalFlags::getNameOfFlags();
  ListViewContent *tlvc;
  for(int t1=0;t1<fns->size();t1++) {
    tlvc=lv->get(0);
    if(tlvc->getSelect()==true) {
      tp=(unsigned long)pow(2,t1);
      flags+=tp;
    }
  }
  gf->setFlags(flags);
  WCGlobalFlags::freeNameOfFlags(fns);
}

bool WConfig::changeFiledesc(WCFiletype *ft)
{
  WCFiletype *ft_bak=ft->duplicate();
  AGUIX *aguix=worker->getAGUIX();
  short *filedesc=ft->getFiledesc();
  int tw,w,h,ty;
  int t1,t2;
  char *str;
  AWindow *win=new AWindow(aguix);
  w=100;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(101));
  ty=5;
  ListView *lv=(ListView*)win->add(new ListView(aguix,5,ty,w-10,150,0));
  lv->setHBarState(2);
  lv->setVBarState(2);
  for(t1=0;t1<64;t1++) {
    str=getStr4Char(t1,filedesc[t1]);
    lv->add(new ListViewContent(str,1,1,2,2,0,0,1,1,0));
    _freesafe(str);
  }
  ty+=lv->getHeight()+5;
  
  t1=strlen(catalog.getLocale(98))+2;
  t1*=aguix->getCharWidth();
  Button *b1=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(98),1,0,0));
  t2=b1->getWidth();
  t1=strlen(catalog.getLocale(99))+2;
  t1*=aguix->getCharWidth();
  Button *b2=(Button*)win->add(new Button(aguix,5+t2+5,ty,t1,catalog.getLocale(99),1,0,0));
  tw=b2->getX()+b2->getWidth()+5;
  if(tw>w) w=tw;
  ty+=b2->getHeight()+5;
  t1=strlen(catalog.getLocale(100))+2;
  t1*=aguix->getCharWidth();
  if((t1+10)<w) t1=w-10;
  Button *b3=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(100),1,0,0));
  tw=b3->getX()+b3->getWidth()+5;
  if(tw>w) w=tw;
  ty+=b3->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  lv->resize(w-10,lv->getHeight());
  b2->move(w-5-b2->getWidth(),b2->getY());
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  ListViewContent *tlvc;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b1) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            t2=WCEditByte(filedesc[t1]);
            if(t2>=0) {
              filedesc[t1]=t2;
              str=getStr4Char(t1,t2);
              tlvc->setText(str);
              _freesafe(str);
              lv->redraw();
            }
          }
        } else if(msg->button.button==b2) {
          tlvc=lv->getActiveLVC();
          if(tlvc!=NULL) {
            t1=lv->getPos(tlvc);
            t2=-1;
            filedesc[t1]=t2;
            str=getStr4Char(t1,t2);
            tlvc->setText(str);
            _freesafe(str);
            lv->redraw();
          }
        } else if(msg->button.button==b3) {
          win->hide();
          if(FTautocreate(ft)==true) {
            for(t1=0;t1<64;t1++) {
              tlvc=lv->get(t1);
              str=getStr4Char(t1,filedesc[t1]);
              tlvc->setText(str);
              _freesafe(str);
            }
          }
          win->show();
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    ft->setFiledesc(ft_bak->getFiledesc());
  } else {
    for(t1=63;t1>=0;t1--) {
      if(filedesc[t1]>=0) {
        if(t1<63) filedesc[t1+1]=-2;
        break;
      }
    }
    if(t1<1) if(filedesc[t1]<0) filedesc[t1]=-2;
  }
  delete ft_bak;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

char *WConfig::getStr4Char(int index2,short ch)
{
  char *str=(char*)_allocsafe(128);
  char buf[32];
  sprintf(str,"%2d.%s: ",index2,catalog.getLocale(97));
  if(ch>=0) {
    sprintf(buf,"%3d %c",ch,ch);
    strcat(str,buf);
  }
  return str;
}

int WConfig::WCEditByte(int ch)
{
  int return_byte;
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2;
  char buf[32];
  AWindow *win=new AWindow(aguix);
  w=100;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(98));
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(102),1));
  ty+=tt1->getHeight()+5;
  tw=tt1->getWidth()+10;
  if(tw>w) w=tw;
  if(ch>=0) sprintf(buf,"%d",ch); else buf[0]=0;
  t1=6*aguix->getCharWidth();
  StringGadget *sg=(StringGadget*)win->add(new StringGadget(aguix,5,ty,t1,buf,0));
  if(ch>=0) sprintf(buf,"%c",ch); else buf[0]=0;
  tt1=(Text*)win->add(new Text(aguix,sg->getX()+sg->getWidth()+5,ty,buf,1));
  tw=tt1->getX()+tt1->getWidth()+5;
  if(tw>w) w=tw;
  ty+=sg->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  return_byte=ch;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        t1=-1;
        sscanf(sg->getText(),"%d",&t1);
        if(t1<0) t1=0;
        else if(t1>255) t1=255;
        sprintf(buf,"%d",t1);
        sg->setText(buf);
        sprintf(buf,"%c",t1);
        tt1->setText(buf);
        return_byte=t1;
      } else if(msg->type==AG_KEYPRESSED) {
        if(sg->isActive()==false) {
          t1=msg->key.key;
          if(t1<=0xff) {
            sprintf(buf,"%d",t1);
            sg->setText(buf);
            sprintf(buf,"%c",t1);
            tt1->setText(buf);
            return_byte=t1;
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  win->close();
  delete win;
  return (ende==-1)?-1:return_byte;
}

bool WConfig::FTautocreate(WCFiletype *ft)
{
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2,i;
  char *str;
  Text *tt[3];
  StringGadget *sg[3];
  Button *fb[3];
  AWindow *win=new AWindow(aguix);
  FileRequester *frq=new FileRequester(aguix);
  bool dirSet = false;

  w=100;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(100));
  ty=5;
  str=(char*)_allocsafe(strlen(catalog.getLocale(103))+4);
  for(i=0;i<3;i++) {
    sprintf(str,"%s %d",catalog.getLocale(103),i+1);
    tt[i]=(Text*)win->add(new Text(aguix,5,ty,str,1));
    sg[i]=(StringGadget*)win->add(new StringGadget(aguix,tt[i]->getX()+tt[i]->getWidth()+5,
                                                   ty,100,"",0));
    fb[i]=(Button*)win->add(new Button(aguix,sg[i]->getX()+sg[i]->getWidth(),ty,
                                       sg[i]->getHeight(),sg[i]->getHeight(),"",1,0,0));
    tw=fb[i]->getX()+fb[i]->getWidth()+5;
    if(tw>w) w=tw;
    ty+=sg[i]->getHeight()+5;
  }
  _freesafe(str);

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->resize(w,h);
  for(i=0;i<3;i++) {
    fb[i]->move(w-5-fb[i]->getWidth(),fb[i]->getY());
    sg[i]->resize(fb[i]->getX()-sg[i]->getX(),sg[i]->getHeight());
  }
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else {
          for(t1=0;t1<3;t1++) {
            if(msg->button.button==fb[t1]) {
              if ( dirSet == false ) {
                str=ParentDir(home,NULL);
                dirSet = true;
              } else {
                str = dupstring("");
              }
              if(frq->request(catalog.getLocale(265),str,catalog.getLocale(11),catalog.getLocale(8),catalog.getLocale(266))!=0) {
                FileEntry *fe=frq->getFirstFE();
                if(fe!=NULL) sg[t1]->setText(fe->fullname);
              }
              _freesafe(str);
            }
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
    if(ende==1) {
      // Pruefen, ob Dateien existieren
      if(Datei::fileExists(sg[0]->getText())==false) ende=0;
      if(Datei::fileExists(sg[1]->getText())==false) ende=0;
      if(Datei::fileExists(sg[2]->getText())==false) ende=0;
      if(ende==0) {
        // Hinweis
        Requester *req=new Requester(aguix);
        req->request(catalog.getLocale(124),catalog.getLocale(267),catalog.getLocale(11));
        delete req;
      }
    }
  }
  if(ende==1) {
    Datei *fh[3];
    for(t1=0,t2=0;t1<3;t1++) {
      fh[t1]=new Datei();
      if(fh[t1]->open(sg[t1]->getText(),"r")==0) t2++;
    }
    if(t2==3) {
      unsigned char buffer[3][64],c1,c2,c3;
      short int filedesc[64];
      for(t1=0;t1<3;t1++) {
        for(t2=0;t2<64;t2++) buffer[t1][t2]=fh[t1]->getUChar();
      }
      for(t1=0;t1<64;t1++) {
        c1=buffer[0][t1];
        c2=buffer[1][t1];
        c3=buffer[2][t1];
        if((c1==c2)&&(c2==c3)&&(c1!=0)) {
          filedesc[t1]=c1;
        } else {
          filedesc[t1]=-1;
        } 
      }
      ft->setFiledesc(filedesc);
    }
    for(t1=0;t1<3;t1++) fh[t1]->close();
  }
  win->close();
  delete win;
  delete frq;
  return (ende==-1)?false:true;
}

bool WConfig::save()
{
  int len=strlen(home);
  bool ret;
  
  if(len<1) return false;
  char *textstr;

  char *str=(char*)_allocsafe((len+1+8+2)*sizeof(char));
  strcpy(str,home);
  if(len>1) if(home[len-1]!='/') strcat(str,"/");
#ifdef USEOWNCONFIGFILES
  strcat(str,"wconfig2");
#else
  strcat(str,"config");
#endif
  if(Datei::lfileExistsExt(home)!=Datei::D_FE_DIR) {
    // no home dir, try to create one
    if(mkdir(home,S_IRWXU|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH)!=0) {
      Requester *req=new Requester(worker->getAGUIX());
      textstr=(char*)_allocsafe(strlen(catalog.getLocale(127))+strlen(home)+1);
      sprintf(textstr,catalog.getLocale(127),home);
      req->request(catalog.getLocale(347),textstr,catalog.getLocale(11));
      _freesafe(textstr);
      delete req;
    }
  }
  ret=saveas(str);
  _freesafe(str);
  return ret;
}

bool WConfig::saveas(char *file)
{
  int id;
  char *tstr;
  unsigned long chunksize;
  Datei *fh=new Datei();
  if(fh->open(file,"w")==0) {
    fh->putString("FORM");
    fh->putULong(0);
    fh->putString("WCFG");
    fh->putString("VERS");
    fh->putULong(3*2);
    fh->putUShort(WORKER_MAJOR);
    fh->putUShort(WORKER_MINOR);
    fh->putUShort(WORKER_PATCH);
    fh->putString("SETS");
    chunksize=4+strlen(lang)+11*2+2*9*5+18*5;
    chunksize+=5+strlen(dir[0])+5+strlen(dir[1]);
    chunksize+=5+strlen(fonts[0])+5+strlen(fonts[1])+5+strlen(fonts[2])+5+strlen(fonts[3]);
    chunksize+=2+4*5;
    chunksize+=1;
    chunksize+=4+strlen(terminalbin);
    chunksize+=Datei::getUCharSize()+2*Datei::getIntSize()+strlen(clockbar_command);
    chunksize+=Datei::getIntSize();

    id=dontcheckdirs->initEnum();
    tstr=(char*)dontcheckdirs->getFirstElement(id);
    while(tstr!=NULL) {
      chunksize+=fh->getIntSize();
      chunksize+=strlen(tstr);
      tstr=(char*)dontcheckdirs->getNextElement(id);
    }
    dontcheckdirs->closeEnum(id);
    
    chunksize+=8*Datei::getIntSize();
    chunksize+=Datei::getIntSize();
    // for showStringForDirSize
    chunksize+=Datei::getUCharSize()+Datei::getIntSize()+strlen(stringForDirSize);
    
    // for time/date config
    chunksize += Datei::getIntSize() +
                 Datei::getIntSize() + strlen( date_formatstring ) + 
                 Datei::getUCharSize() +
                 Datei::getIntSize() +
                 Datei::getIntSize() + strlen( time_formatstring ) +
                 Datei::getUCharSize();

    fh->putULong(chunksize);
    fh->putULong(strlen(lang));
    fh->putString(lang);
    fh->putUShort(rows);
    fh->putUShort(columns);
    fh->putUShort(cachesize);
    fh->putUShort((hbar_top[0]==true)?1:0);
    fh->putUShort((hbar_top[1]==true)?1:0);
    fh->putUShort(hbar_height[0]);
    fh->putUShort(hbar_height[1]);
    fh->putUShort((vbar_left[0]==true)?1:0);
    fh->putUShort((vbar_left[1]==true)?1:0);
    fh->putUShort(vbar_width[0]);
    fh->putUShort(vbar_width[1]);
    for(int i=0;i<2;i++)
      for(int j=0;j<9;j++) {
        fh->putInt(display[i][j]);
      }
    fh->putInt(statusbar[0]);
    fh->putInt(statusbar[1]);
    fh->putInt(sel_lvb[0]);
    fh->putInt(sel_lvb[1]);
    fh->putInt(unsel_lvb[0]);
    fh->putInt(unsel_lvb[1]);
    fh->putInt(sel_dir[0]);
    fh->putInt(sel_dir[1]);
    fh->putInt(unsel_dir[0]);
    fh->putInt(unsel_dir[1]);
    fh->putInt(sel_file[0]);
    fh->putInt(sel_file[1]);
    fh->putInt(unsel_file[0]);
    fh->putInt(unsel_file[1]);
    fh->putInt(clockbar[0]);
    fh->putInt(clockbar[1]);
    fh->putInt(request[0]);
    fh->putInt(request[1]);
    fh->putInt(strlen(dir[0]));
    fh->putString(dir[0]);
    fh->putInt(strlen(dir[1]));
    fh->putString(dir[1]);
    fh->putInt(strlen(fonts[0]));
    fh->putString(fonts[0]);
    fh->putInt(strlen(fonts[1]));
    fh->putString(fonts[1]);
    fh->putInt(strlen(fonts[2]));
    fh->putString(fonts[2]);
    fh->putInt(strlen(fonts[3]));
    fh->putString(fonts[3]);
    fh->putUShort(colors->size());
    fh->putInt(paths->size());
    fh->putInt(filetypes->size());
    fh->putInt(buttons->size());
    fh->putInt(hotkeys->size());
    fh->putUChar(ownerstringtype);
    fh->putULong(strlen(terminalbin));
    fh->putString(terminalbin);
    
    switch(clockbar_mode) {
      case CLOCKBAR_MODE_TIME:
        fh->putUChar(1);
        break;
      case CLOCKBAR_MODE_VERSION:
        fh->putUChar(2);
        break;
      case CLOCKBAR_MODE_EXTERN:
        fh->putUChar(3);
        break;
      default:
        fh->putUChar(0);
        break;
    }
    fh->putInt(clockbar_updatetime);
    fh->putInt(strlen(clockbar_command));
    fh->putString(clockbar_command);
    fh->putInt(dontcheckdirs->size());
    
    id=dontcheckdirs->initEnum();
    tstr=(char*)dontcheckdirs->getFirstElement(id);
    while(tstr!=NULL) {
      fh->putInt(strlen(tstr));
      fh->putString(tstr);
      tstr=(char*)dontcheckdirs->getNextElement(id);
    }
    dontcheckdirs->closeEnum(id);
    
    // new in version 2.2.1
    fh->putInt(sel_dir_act[0]);
    fh->putInt(sel_dir_act[1]);
    fh->putInt(unsel_dir_act[0]);
    fh->putInt(unsel_dir_act[1]);
    fh->putInt(sel_file_act[0]);
    fh->putInt(sel_file_act[1]);
    fh->putInt(unsel_file_act[0]);
    fh->putInt(unsel_file_act[1]);

    // new in version 2.2.2
    fh->putInt(listerbg);
    
    // new in version 2.2.3
    fh->putUChar((showStringForDirSize==true)?1:0);
    fh->putInt(strlen(stringForDirSize));
    fh->putString(stringForDirSize);

    // new in >2.3.1
    fh->putInt( date_format );
    fh->putInt( strlen( date_formatstring ) );
    fh->putString( date_formatstring );
    fh->putUChar( ( date_subst == true ) ? 1 : 0 );
    fh->putInt( time_format );
    fh->putInt( strlen( time_formatstring ) );
    fh->putString( time_formatstring );
    fh->putUChar( ( date_before_time == true ) ? 1 : 0 );


    id=colors->initEnum();
    WC_Color *col=(WC_Color*)colors->getFirstElement(id);
    while(col!=NULL) {
      col->save(fh);
      col=(WC_Color*)colors->getNextElement(id);
    }
    colors->closeEnum(id);
    id=paths->initEnum();
    WCPath *p1=(WCPath*)paths->getFirstElement(id);
    while(p1!=NULL) {
      p1->save(fh);
      p1=(WCPath*)paths->getNextElement(id);
    }
    paths->closeEnum(id);
    id=filetypes->initEnum();
    WCFiletype *f1=(WCFiletype*)filetypes->getFirstElement(id);
    while(f1!=NULL) {
      f1->save(fh);
      f1=(WCFiletype*)filetypes->getNextElement(id);
    }
    filetypes->closeEnum(id);
    id=hotkeys->initEnum();
    WCHotkey *h1=(WCHotkey*)hotkeys->getFirstElement(id);
    while(h1!=NULL) {
      h1->save(fh);
      h1=(WCHotkey*)hotkeys->getNextElement(id);
    }
    hotkeys->closeEnum(id);
    id=buttons->initEnum();
    WCButton *b1=(WCButton*)buttons->getFirstElement(id);
    while(b1!=NULL) {
      b1->save(fh);
      b1=(WCButton*)buttons->getNextElement(id);
    }
    buttons->closeEnum(id);
    
    fh->close();
  } else {
    Requester *req=new Requester(worker->getAGUIX());
    char *textstr;
    textstr=(char*)_allocsafe(strlen(catalog.getLocale(40))+strlen(file)+1);
    sprintf(textstr,catalog.getLocale(40),file);
    req->request(catalog.getLocale(347),textstr,catalog.getLocale(11));
    _freesafe(textstr);
    delete req;
    return false;
  }
  return true;
}

bool WConfig::load()
{
  int len=strlen(home);
  bool ret=false;
  if(len<1) return false;
  
  if(Datei::lfileExistsExt(home)==Datei::D_FE_NOFILE) {
    // no .worker so show an hint for starting "worker.inst"
    char *buttonstr,*textstr;
    Requester *req;
    
    buttonstr=catalog.getLocale(11);
//    textstr=catalog.getLocale(90);  // Macht keine grossen Sinn, eine andere Sprache kann eh noch nicht geladen sein
    textstr="There is no Worker configuration directory.|Worker will continue and use an intern configuration!";
    req=new Requester(worker->getAGUIX());
    req->request(catalog.getLocale(124),textstr,buttonstr);
    delete req;
  } else {
    char *str=(char*)_allocsafe((len+1+8+2)*sizeof(char));
    strcpy(str,home);
    if(len>1) if(home[len-1]!='/') strcat(str,"/");
#ifdef USEOWNCONFIGFILES
    strcat(str,"wconfig2");
#else
    strcat(str,"config");
#endif
    ret=loadfrom(str);
    _freesafe(str);
  }
  return ret;
}

bool WConfig::loadfrom(char *file)
{
  int id;
  unsigned long chunksize;
  unsigned short us1=0,us2=0,us3=0,colorsize=0;
  int pathsize=0,filetypesize=0,buttonsize=0,hotkeysize=0;
  char *str,buf[5],*tstr;
  Requester *req;
  char *textstr;
  Datei *fh=new Datei();
  if(fh->open(file,"r")==0) {
    fh->getString(buf,4);
    if(strcmp(buf,"FORM")==0) {
      fh->getULong();
      fh->getString(buf,4);
      if(strcmp(buf,"WCFG")==0) {
        fh->getString(buf,4);
        if(strcmp(buf,"VERS")==0) {
          chunksize=fh->getULong();
          if(chunksize>=3*2) {
            us1=fh->getUShort();
            chunksize-=2;
            us2=fh->getUShort();
            chunksize-=2;
            us3=fh->getUShort();
            chunksize-=2;
          }
          while(chunksize>0) {
            fh->getUChar();
            chunksize--;
          }
          if( ((us1==WORKER_MAJOR)&&(us2>WORKER_MINOR)) ||
              ((us1==WORKER_MAJOR)&&(us2==WORKER_MINOR)&&(us3>WORKER_PATCH)) ) {
            // Konfig-Datei hat neuere Version => nicht laden
            req=new Requester(worker->getAGUIX());
            textstr=(char*)_allocsafe(strlen(catalog.getLocale(384))+3*sizeof(int)+1);
            sprintf(textstr,catalog.getLocale(384),us1,us2,us3);
            req->request(catalog.getLocale(347),textstr,catalog.getLocale(11));
            _freesafe(textstr);
            delete req;
          } else {
            fh->getString(buf,4);
            if(strcmp(buf,"SETS")==0) {
              chunksize=fh->getULong();
              unsigned long len;
              if(chunksize>=(4+11*2+2*9*5+18*5+5+5+5+5+5+5+2+4*5)) {
                len=fh->getULong();
                chunksize-=4;
                str=fh->getString(len);
                setLang(str);
                _freesafe(str);
                chunksize-=len;
                setRows(fh->getUShort());
                chunksize-=2;
                setColumns(fh->getUShort());
                chunksize-=2;
                setCacheSize(fh->getUShort());
                chunksize-=2;
                setHBarTop(0,(fh->getUShort()==1)?true:false);
                chunksize-=2;
                setHBarTop(1,(fh->getUShort()==1)?true:false);
                chunksize-=2;
                setHBarHeight(0,fh->getUShort());
                chunksize-=2;
                setHBarHeight(1,fh->getUShort());
                chunksize-=2;
                setVBarLeft(0,(fh->getUShort()==1)?true:false);
                chunksize-=2;
                setVBarLeft(1,(fh->getUShort()==1)?true:false);
                chunksize-=2;
                setVBarWidth(0,fh->getUShort());
                chunksize-=2;
                setVBarWidth(1,fh->getUShort());
                chunksize-=2;
                for(int i=0;i<2;i++) {
                  for(int j=0;j<9;j++) {
                    display[i][j]=fh->getInt();
                    chunksize-=5;
                  }
                }
                setStatusbar(0,fh->getInt());
                chunksize-=5;
                setStatusbar(1,fh->getInt());
                chunksize-=5;
                setSelLVB(0,fh->getInt());
                chunksize-=5;
                setSelLVB(1,fh->getInt());
                chunksize-=5;
                setUnselLVB(0,fh->getInt());
                chunksize-=5;
                setUnselLVB(1,fh->getInt());
                chunksize-=5;
                setSelDir(0,fh->getInt());
                chunksize-=5;
                setSelDir(1,fh->getInt());
                chunksize-=5;
                setUnselDir(0,fh->getInt());
                chunksize-=5;
                setUnselDir(1,fh->getInt());
                chunksize-=5;
                setSelFile(0,fh->getInt());
                chunksize-=5;
                setSelFile(1,fh->getInt());
                chunksize-=5;
                setUnselFile(0,fh->getInt());
                chunksize-=5;
                setUnselFile(1,fh->getInt());
                chunksize-=5;
                setClockbar(0,fh->getInt());
                chunksize-=5;
                setClockbar(1,fh->getInt());
                chunksize-=5;
                setRequest(0,fh->getInt());
                chunksize-=5;
                setRequest(1,fh->getInt());
                chunksize-=5;
    
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setStartDir(0,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setStartDir(1,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setFont(0,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setFont(1,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setFont(2,str);
                _freesafe(str);
                chunksize-=len;
                len=fh->getInt();
                chunksize-=5;
                str=fh->getString(len);
                setFont(3,str);
                _freesafe(str);
                chunksize-=len;
                colorsize=fh->getUShort();
                chunksize-=2;
                pathsize=fh->getInt();
                chunksize-=5;
                filetypesize=fh->getInt();
                chunksize-=5;
                buttonsize=fh->getInt();
                chunksize-=5;
                hotkeysize=fh->getInt();
                chunksize-=5;
                
                // this is since version 2.0.2 so do extra check for older configs
                if(chunksize>=1) {
                  setOwnerstringtype(fh->getUChar());
                  chunksize-=1;

                  // new option
                  if(chunksize>=4) {
                    len=fh->getULong();
                    chunksize-=4;
                    str=fh->getString(len);
                    setTerminalBin(str);
                    _freesafe(str);
                    chunksize-=len;
                    
                    // new option from 16.3.2001
                    if(chunksize>=(unsigned long)(Datei::getUCharSize()+2*Datei::getIntSize())) {
                      unsigned char nm=fh->getUChar();
                      chunksize-=Datei::getUCharSize();
                      switch(nm) {
                        case 1:
                          setClockbarMode(CLOCKBAR_MODE_TIME);
                          break;
                        case 2:
                          setClockbarMode(CLOCKBAR_MODE_VERSION);
                          break;
                        case 3:
                          setClockbarMode(CLOCKBAR_MODE_EXTERN);
                          break;
                        default:
                          setClockbarMode(CLOCKBAR_MODE_TIMERAM);
                          break;
                      }
                      setClockbarUpdatetime(fh->getInt());
                      chunksize-=Datei::getIntSize();
                      int ilen=fh->getInt();
                      chunksize-=Datei::getIntSize();
                      str=fh->getString(ilen);
                      setClockbarCommand(str);
                      _freesafe(str);
                      chunksize-=ilen;
                      
                      if(chunksize>=(unsigned int)Datei::getIntSize()) {
                        // load the dontcheckdirs
                        List *ndcd=new List();
                        int dcdsize=fh->getInt();
                        chunksize-=Datei::getIntSize();
                        while(dcdsize>0) {
                          len=fh->getInt();
                          chunksize-=fh->getIntSize();
                          tstr=fh->getString(len);
                          chunksize-=len;
                          ndcd->addElement(tstr);
                          dcdsize--;
                        }
                        setDontCheckDirs(ndcd);
                        id=ndcd->initEnum();
                        tstr=(char*)ndcd->getFirstElement(id);
                        while(tstr!=NULL) {
                          _freesafe(tstr);
                          tstr=(char*)ndcd->getNextElement(id);
                        }
                        ndcd->closeEnum(id);
                        delete ndcd;
                        
                        // new in version 2.2.1
                        if(chunksize>=(unsigned int)(8*Datei::getIntSize())) {
                          setSelDirAct(0,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setSelDirAct(1,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setUnselDirAct(0,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setUnselDirAct(1,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setSelFileAct(0,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setSelFileAct(1,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setUnselFileAct(0,fh->getInt());
                          chunksize-=Datei::getIntSize();
                          setUnselFileAct(1,fh->getInt());
                          chunksize-=Datei::getIntSize();

                          // new in version 2.2.2
                          if(chunksize>=(unsigned int)(Datei::getIntSize())) {
                            setListerBG(fh->getInt());
                            chunksize-=Datei::getIntSize();
                            
                            // new in version 2.2.3
                            if(chunksize>=(unsigned long)(Datei::getUCharSize()+Datei::getIntSize())) {
                              setShowStringForDirSize((fh->getUChar()==1)?true:false);
                              chunksize-=fh->getUCharSize();
                              len=fh->getInt();
                              chunksize-=fh->getIntSize();
                              tstr=fh->getString(len);
                              chunksize-=len;
                              setStringForDirSize(tstr);
                              _freesafe(tstr);
                              
                              // new in >2.3.1
                              if ( chunksize >= (unsigned long)( Datei::getIntSize() +
                                                                 Datei::getIntSize() +
                                                                 Datei::getUCharSize() +
                                                                 Datei::getIntSize() +
                                                                 Datei::getIntSize() +
                                                                 Datei::getUCharSize() ) ) {
                                setDateFormat( fh->getInt() );
                                chunksize -= Datei::getIntSize();
                                
                                len = fh->getInt();
                                chunksize -= Datei::getIntSize();
                                
                                tstr = fh->getString( len );
                                chunksize -= len;
                                setDateFormatString( tstr );
                                _freesafe( tstr );
                                
                                setDateSubst( ( fh->getUChar() == 1 ) ? true : false );
                                chunksize -= Datei::getUCharSize();
                                
                                setTimeFormat( fh->getInt() );
                                chunksize -= Datei::getIntSize();

                                len = fh->getInt();
                                chunksize -= Datei::getIntSize();
                                
                                tstr = fh->getString( len );
                                chunksize -= len;
                                setTimeFormatString( tstr );
                                _freesafe( tstr );
                                
                                setDateBeforeTime( ( fh->getUChar() == 1 ) ? true : false );
                                chunksize -= Datei::getUCharSize();
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
              while(chunksize>0) {
                fh->getUChar();
                chunksize--;
              }
              WC_Color *col;
              List *l1=new List();
              while(colorsize>0) {
                col=new WC_Color();
                col->load(fh);
                l1->addElement(col);
                colorsize--;
              }
              setColors(l1);
              applyColorList(colors);
              id=l1->initEnum();
              while(l1->size()>0) {
                col=(WC_Color*)l1->getFirstElement(id);
                delete col;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              WCPath *p1;
              while(pathsize>0) {
                p1=new WCPath();
                p1->load(worker,fh);
                l1->addElement(p1);
                pathsize--;
              }
              setPaths(l1);
              id=l1->initEnum();
              while(l1->size()>0) {
                p1=(WCPath*)l1->getFirstElement(id);
                delete p1;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              WCFiletype *f1;
              while(filetypesize>0) {
                f1=new WCFiletype();
                f1->load(worker,fh);
                l1->addElement(f1);
                filetypesize--;
              }
              setFiletypes(l1);
              initFixTypes(filetypes);
              id=l1->initEnum();
              while(l1->size()>0) {
                f1=(WCFiletype*)l1->getFirstElement(id);
                delete f1;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              WCHotkey *h1;
              while(hotkeysize>0) {
                h1=new WCHotkey();
                h1->load(worker,fh);
                l1->addElement(h1);
                hotkeysize--;
              }
              setHotkeys(l1);
              id=l1->initEnum();
              while(l1->size()>0) {
                h1=(WCHotkey*)l1->getFirstElement(id);
                delete h1;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              WCButton *b1;
              while(buttonsize>0) {
                b1=new WCButton();
                b1->load(worker,fh);
                l1->addElement(b1);
                buttonsize--;
              }
              setButtons(l1);
              id=l1->initEnum();
              while(l1->size()>0) {
                b1=(WCButton*)l1->getFirstElement(id);
                delete b1;
                l1->removeFirstElement();
              }
              l1->closeEnum(id);
              delete l1;
            }
          }
        } else {
          // Keine 2er-Version
          read1Config(fh);
        }
      } else {
        // kein Config-file
        req=new Requester(worker->getAGUIX());
        textstr=(char*)_allocsafe(strlen(catalog.getLocale(367))+strlen(file)+1);
        sprintf(textstr,catalog.getLocale(367),file);
        req->request(catalog.getLocale(125),textstr,catalog.getLocale(11));
        _freesafe(textstr);
        delete req;
      }
    } else {
      // kein IFF-file
      req=new Requester(worker->getAGUIX());
      textstr=(char*)_allocsafe(strlen(catalog.getLocale(367))+strlen(file)+1);
      sprintf(textstr,catalog.getLocale(367),file);
      req->request(catalog.getLocale(125),textstr,catalog.getLocale(11));
      _freesafe(textstr);
      delete req;
    }
    fh->close();
  } else {
    return false;
  }
  recalcMaxFiletypeLen();
  return true;
}

bool WCPath::save(Datei *fh)
{
  if(fh==NULL) return false;
  fh->putString("PATH");
  fh->putULong(4+strlen(name)+2+2+4+strlen(path)+2);
  fh->putULong(strlen(name));
  fh->putString(name);
  fh->putUShort(fg);
  fh->putUShort(bg);
  fh->putULong(strlen(path));
  fh->putString(path);
  fh->putUShort((check==true)?1:0);
  key->save(fh);
  return true;
}

bool WCPath::load(Worker *w,Datei *fh)
{
  if(fh==NULL) return false;
  char *str=fh->getString(4);
  if(strncmp(str,"PATH",4)!=0) {
    _freesafe(str);
    fh->seek(-4,SEEK_CUR);
    return false;
  } else {
    _freesafe(str);
    int chunksize=fh->getULong();
    if(chunksize>=14) {
      unsigned long len=fh->getULong();
      chunksize-=4;
      str=fh->getString(len);
      chunksize-=len;
      setName(str);
      _freesafe(str);
      setFG(fh->getUShort());
      chunksize-=2;
      setBG(fh->getUShort());
      chunksize-=2;
      len=fh->getULong();
      chunksize-=4;
      str=fh->getString(len);
      chunksize-=len;
      setPath(str);
      _freesafe(str);
      setCheck((fh->getUShort()==1)?true:false);
      chunksize-=2;
    }
    while(chunksize>0) {
      fh->getUChar();
      chunksize--;
    }
    // Hier sollte das Shortkey folgen, aber die Load-Funktion prueft das schon :-)
    key->load(fh);
  }
  return true;
}

bool WCShortkey::save(Datei *fh)
{
  if(fh==NULL) return false;
  fh->putString("WSHK");
  fh->putULong(4+5);
  fh->putULong(shortkey);
  fh->putInt(mod);
  return true;
}

bool WCShortkey::load(Datei *fh)
{
  if(fh==NULL) return false;
  char *str=fh->getString(4);
  if(strncmp(str,"WSHK",4)!=0) {
    _freesafe(str);
    fh->seek(-4,SEEK_CUR);
    return false;
  } else {
    unsigned long chunksize=fh->getULong();
    if(chunksize>=9) {
      setShortkey(fh->getULong());
      chunksize-=4;
      setMod(fh->getInt());
      chunksize-=5;
    }
    while(chunksize>0) {
      fh->getUChar();
      chunksize--;
    }
  }
  _freesafe(str);
  return true;
}

bool WCGlobalFlags::save(Datei *fh)
{
  if(fh==NULL) return false;
  fh->putString("GLFL");
  fh->putULong(4);
  fh->putULong(flags);
  return true;
}

bool WCGlobalFlags::load(Datei *fh)
{
  if(fh==NULL) return false;
  char *str=fh->getString(4);
  if(strncmp(str,"GLFL",4)!=0) {
    _freesafe(str);
    fh->seek(-4,SEEK_CUR);
    return false;
  } else {
    unsigned long chunksize=fh->getULong();
    if(chunksize>=4) {
      flags=fh->getULong();
      chunksize-=4;
    }
    while(chunksize>0) {
      fh->getUChar();
      chunksize--;
    }
  }
  _freesafe(str);
  return true;
}

bool WCFiletype::save(Datei *fh)
{
  int i;
  if(fh==NULL) return false;
  fh->putString("FITY");

  fh->putULong(4+strlen(name)+4+strlen(pattern)+2+64*5+2+14*5+5 +
               Datei::getIntSize() + strlen( fileexp ) + Datei::getUShortSize() );

  fh->putULong(strlen(name));
  fh->putString(name);
  fh->putULong(strlen(pattern));
  fh->putString(pattern);
  fh->putUShort((usepattern==true)?1:0);
  for(i=0;i<64;i++) {
    fh->putInt(filedesc[i]);
  }
  fh->putUShort((usefiledesc==true)?1:0);
  fh->putInt(dndaction->size());
  fh->putInt(doubleclickaction->size());
  fh->putInt(showaction->size());
  fh->putInt(rawshowaction->size());
  for(i=0;i<10;i++) {
    fh->putInt(useraction[i]->size());
  }
  fh->putInt(internID);

  fh->putInt( strlen( fileexp ) );
  fh->putString( fileexp );
  fh->putUShort( ( usefileexp == true ) ? 1 : 0 );

  dndactiongf->save(fh);
  doubleclickactiongf->save(fh);
  showactiongf->save(fh);
  rawshowactiongf->save(fh);
  for(i=0;i<10;i++) {
    useractiongf[i]->save(fh);
  }
  int id=dndaction->initEnum();
  FunctionProto *f1=(FunctionProto*)dndaction->getFirstElement(id);
  while(f1!=NULL) {
    FunctionProto::presave(fh,f1);
    f1=(FunctionProto*)dndaction->getNextElement(id);
  }
  dndaction->closeEnum(id);
  id=doubleclickaction->initEnum();
  f1=(FunctionProto*)doubleclickaction->getFirstElement(id);
  while(f1!=NULL) {
    FunctionProto::presave(fh,f1);
    f1=(FunctionProto*)doubleclickaction->getNextElement(id);
  }
  doubleclickaction->closeEnum(id);
  id=showaction->initEnum();
  f1=(FunctionProto*)showaction->getFirstElement(id);
  while(f1!=NULL) {
    FunctionProto::presave(fh,f1);
    f1=(FunctionProto*)showaction->getNextElement(id);
  }
  showaction->closeEnum(id);
  id=rawshowaction->initEnum();
  f1=(FunctionProto*)rawshowaction->getFirstElement(id);
  while(f1!=NULL) {
    FunctionProto::presave(fh,f1);
    f1=(FunctionProto*)rawshowaction->getNextElement(id);
  }
  rawshowaction->closeEnum(id);
  for(i=0;i<10;i++) {
    id=useraction[i]->initEnum();
    f1=(FunctionProto*)useraction[i]->getFirstElement(id);
    while(f1!=NULL) {
      FunctionProto::presave(fh,f1);
      f1=(FunctionProto*)useraction[i]->getNextElement(id);
    }
    useraction[i]->closeEnum(id);
  }
  return true;
}

bool WCFiletype::load(Worker *w,Datei *fh)
{
  int i;
  if(fh==NULL) return false;
  char *str=fh->getString(4);
  if(strncmp(str,"FITY",4)!=0) {
    _freesafe(str);
    fh->seek(-4,SEEK_CUR);
    return false;
  } else {
    _freesafe(str);
    unsigned long chunksize=fh->getULong();
    int dndsize=0;
    int dcsize=0;
    int showsize=0;
    int rssize=0;
    int usize[10];
    if(chunksize>=(4+4+2+64*5+2+14*5+5)) {
      unsigned long len=fh->getULong();
      chunksize-=4;
      str=fh->getString(len);
      chunksize-=len;
      setName(str);
      _freesafe(str);
      len=fh->getULong();
      chunksize-=4;
      str=fh->getString(len);
      chunksize-=len;
      setPattern(str);
      _freesafe(str);
      unsigned short us=fh->getUShort();
      chunksize-=2;
      setUsePattern((us==1)?true:false);
      for(i=0;i<64;i++) {
        filedesc[i]=fh->getInt();
        chunksize-=5;
      }
      us=fh->getUShort();
      setUseFiledesc((us==1)?true:false);
      chunksize-=2;
      dndsize=fh->getInt();
      chunksize-=5;
      dcsize=fh->getInt();
      chunksize-=5;
      showsize=fh->getInt();
      chunksize-=5;
      rssize=fh->getInt();
      chunksize-=5;
      for(i=0;i<10;i++) {
        usize[i]=fh->getInt();
        chunksize-=5;
      }
      internID=fh->getInt();
      chunksize-=5;
      
      // new in >2.3.1
      if ( chunksize >= (unsigned long)( Datei::getIntSize() + Datei::getUShortSize() ) ) {
        len = fh->getInt();
        chunksize -= Datei::getIntSize();
        
        str = fh->getString( len );
        chunksize -= len;
        setFileExp( str );
        _freesafe(str);
        
        setUseFileExp( ( fh->getUShort() == 1 ) ? true : false );
        chunksize -= Datei::getUShortSize();
      }
    }
    while(chunksize>0) {
      fh->getUChar();
      chunksize--;
    }
    // Jetzt Flags laden
    dndactiongf->load(fh);
    doubleclickactiongf->load(fh);
    showactiongf->load(fh);
    rawshowactiongf->load(fh);
    for(i=0;i<10;i++) {
      useractiongf[i]->load(fh);
    }
    // Und nun die Kommandos
    FunctionProto *f1;
    while(dndsize>0) {
      f1=FunctionProto::preload(w,fh);
      dndaction->addElement(f1);
      dndsize--;
    }
    while(dcsize>0) {
      f1=FunctionProto::preload(w,fh);
      doubleclickaction->addElement(f1);
      dcsize--;
    }
    while(showsize>0) {
      f1=FunctionProto::preload(w,fh);
      showaction->addElement(f1);
      showsize--;
    }
    while(rssize>0) {
      f1=FunctionProto::preload(w,fh);
      rawshowaction->addElement(f1);
      rssize--;
    }
    for(i=0;i<10;i++) {
      while(usize[i]>0) {
        f1=FunctionProto::preload(w,fh);
        useraction[i]->addElement(f1);
        usize[i]--;
      }
    }
  }
  return true;
}

bool WCHotkey::save(Datei *fh)
{
  if(fh==NULL) return false;
  fh->putString("HOTK");
  fh->putULong(4+strlen(name)+4);
  fh->putULong(strlen(name));
  fh->putString(name);
  fh->putULong(com->size());
  key->save(fh);
  flags->save(fh);
  int id=com->initEnum();
  FunctionProto *f1=(FunctionProto*)com->getFirstElement(id);
  while(f1!=NULL) {
    FunctionProto::presave(fh,f1);
    f1=(FunctionProto*)com->getNextElement(id);
  }
  com->closeEnum(id);
  return true;
}

bool WCHotkey::load(Worker *w,Datei *fh)
{
  if(fh==NULL) return false;
  char *str=fh->getString(4);
  if(strncmp(str,"HOTK",4)!=0) {
    _freesafe(str);
    fh->seek(-4,SEEK_CUR);
    return false;
  } else {
    _freesafe(str);
    unsigned long chunksize=fh->getULong();
    unsigned long comsize=0;
    if(chunksize>=8) {
      unsigned long len=fh->getULong();
      chunksize-=4;
      str=fh->getString(len);
      chunksize-=len;
      setName(str);
      _freesafe(str);
      comsize=fh->getULong();
      chunksize-=4;
    }
    while(chunksize>0) {
      fh->getUChar();
      chunksize--;
    }
    key->load(fh);
    flags->load(fh);
    FunctionProto *f1;
    while(comsize>0) {
      f1=FunctionProto::preload(w,fh);
      com->addElement(f1);
      comsize--;
    }
  }
  return true;
}

bool WCButton::save(Datei *fh)
{
  if(fh==NULL) return false;
  fh->putString("BTTN");
  fh->putULong(4+strlen(text)+5+5+4+2);
  fh->putULong(strlen(text));
  fh->putString(text);
  fh->putInt(fg);
  fh->putInt(bg);
  fh->putULong(com->size());
  fh->putUShort((check==true)?1:0);
  key->save(fh);
  flags->save(fh);
  int id=com->initEnum();
  FunctionProto *f1=(FunctionProto*)com->getFirstElement(id);
  while(f1!=NULL) {
    FunctionProto::presave(fh,f1);
    f1=(FunctionProto*)com->getNextElement(id);
  }
  com->closeEnum(id);
  return true;
}

bool WCButton::load(Worker *w,Datei *fh)
{
  if(fh==NULL) return false;
  char *str=fh->getString(4);
  if(strncmp(str,"BTTN",4)!=0) {
    _freesafe(str);
    fh->seek(-4,SEEK_CUR);
    return false;
  } else {
    _freesafe(str);
    unsigned long chunksize=fh->getULong();
    unsigned long comsize=0;
    if(chunksize>=(4+5+5+4+2)) {
      unsigned long len=fh->getULong();
      chunksize-=4;
      str=fh->getString(len);
      chunksize-=len;
      setText(str);
      _freesafe(str);
      setFG(fh->getInt());
      chunksize-=5;
      setBG(fh->getInt());
      chunksize-=5;
      comsize=fh->getULong();
      chunksize-=4;
      unsigned short us=fh->getUShort();
      chunksize-=2;
      setCheck((us==1)?true:false);
    }
    while(chunksize>0) {
      fh->getUChar();
      chunksize--;
    }
    key->load(fh);
    flags->load(fh);
    FunctionProto *f1;
    while(comsize>0) {
      f1=FunctionProto::preload(w,fh);
      com->addElement(f1);
      comsize--;
    }
  }
  return true;
}

int WConfig::getMaxFiletypeLen()
{
  return maxfiletypelen;
}

void WConfig::recalcMaxFiletypeLen()
{
  int m1=0,id,ti;
  WCFiletype *ft;
  id=filetypes->initEnum();
  ft=(WCFiletype*)filetypes->getFirstElement(id);
  while(ft!=NULL) {
    ti=strlen(ft->getName());
    if(ti>m1) m1=ti;
    ft=(WCFiletype*)filetypes->getNextElement(id);
  }
  filetypes->closeEnum(id);
  ti=strlen(catalog.getLocale(109)); // Dir-Name
  if(ti>m1) m1=ti;
  maxfiletypelen=m1;
}

const char *WConfig::getHome()
{
  return home;
}

void WConfig::initFixTypes(List *list)
{
  int ids=0;
  WCFiletype *ft;
  // Pruefen, welche feste Type vorhanden sind (per Bitmaske)
  int e=list->initEnum();
  ft=(WCFiletype*)list->getFirstElement(e);
  while(ft!=NULL) {
    switch(ft->getinternID()) {
      case NOTYETTYPE:
        ids|=1<<(NOTYETTYPE-1);
        notyettype=ft;
        break;
      case UNKNOWNTYPE:
        ids|=1<<(UNKNOWNTYPE-1);
        break;
      case VOIDTYPE:
        ids|=1<<(VOIDTYPE-1);
        break;
      case DIRTYPE:
        ids|=1<<(DIRTYPE-1);
        dirtype=ft;
        break;
    }
    ft=(WCFiletype*)list->getNextElement(e);
  }
  list->closeEnum(e);
  
  if((ids&(1<<(NOTYETTYPE-1)))==0) {
    // NotYet voreinstellen
    debugmsg("Notyet erstellen\n"); //TODO: Diese Zeile entfernen
    ft=new WCFiletype();
    ft->setName(catalog.getLocale(344));
    ft->setinternID(NOTYETTYPE);
    // Reicht vorerst, denn irgendwelche Patterns oder so sind (im jetztigen Stadium des
    // Programms) nicht sinnvoll
    notyettype=ft;
    list->addElementAt(NOTYETTYPE-1,ft);
  }

  if((ids&(1<<(UNKNOWNTYPE-1)))==0) {
    // Unknown voreinstellen
    debugmsg("Unknown erstellen\n"); //TODO: Diese Zeile entfernen
    ft=new WCFiletype();
    ft->setName(catalog.getLocale(345));
    ft->setinternID(UNKNOWNTYPE);
    list->addElementAt(UNKNOWNTYPE-1,ft);
  }
  
  if((ids&(1<<(VOIDTYPE-1)))==0) {
    // Void voreinstellen (der wird nie im Lister angezeigt)
    debugmsg("void erstellen\n"); //TODO: Diese Zeile entfernen
    ft=new WCFiletype();
    ft->setName(catalog.getLocale(346));
    ft->setinternID(VOIDTYPE);
    list->addElementAt(VOIDTYPE-1,ft);
  }
  
  if((ids&(1<<(DIRTYPE-1)))==0) {
    // Dir voreinstellen
    debugmsg("dir erstellen\n"); //TODO: Diese Zeile entfernen
    ft=new WCFiletype();
    ft->setName(catalog.getLocale(109));
    ft->setinternID(DIRTYPE);
    dirtype=ft;
    list->addElementAt(DIRTYPE-1,ft);
  }
}

WCFiletype *WConfig::getnotyettype()
{
  return notyettype;
}

WCFiletype *WConfig::getdirtype()
{
  return dirtype;
}

int WCFiletype::getNameLen()
{
  return namelen;
}

void WConfig::applyLanguage()
{
  if((strcmp(lang,"builtin")==0)||(strlen(lang)<1)) catalog.freeLanguage();
  else catalog.loadLanguage(lang);
}

int WConfig::savesize(int w,int h)
{
  Datei *fp;
  char *file;
  long error;
  
  file=(char*)_allocsafe(strlen(home)+strlen("/lastsize")+1);
  sprintf(file,"%s/lastsize",home);
  fp=new Datei();
  if(fp!=NULL) {
    if(fp->open(file,"w")==0) {
      fp->putUShort(w);
      fp->putUShort(h);
      error=fp->errors();
      fp->close();
    } else error=1;
    delete fp;
  } else error=1;
  _freesafe(file);
  return (int)error;
}

int WConfig::loadsize(int *w,int *h)
{
  Datei *fp;
  char *file;
  long error;
  
  file=(char*)_allocsafe(strlen(home)+strlen("/lastsize")+1);
  sprintf(file,"%s/lastsize",home);
  fp=new Datei();
  if(fp!=NULL) {
    if(fp->open(file,"r")==0) {
      *w=fp->getUShort();
      *h=fp->getUShort();
      error=fp->errors();
      fp->close();
    } else error=1;
    delete fp;
  } else error=1;
  _freesafe(file);
  return (int)error;
}

int WConfig::findShortkey(WCShortkey *sk,
                          WCButton **returnbutton,
                          WCPath **returnpath,
                          WCHotkey **returnhotkey)
{
  int id;
  WCHotkey *h1;
  WCButton *b1;
  WCPath *p1;
  WCShortkey *tsk;
  
  // search for a hotkey
  id=hotkeys->initEnum();
  h1=(WCHotkey*)hotkeys->getFirstElement(id);
  while(h1!=NULL) {
    tsk=h1->getKey();
    if(tsk->isShortkey(sk->getShortkey(),sk->getMod())==true) break;
    h1=(WCHotkey*)hotkeys->getNextElement(id);
  }
  hotkeys->closeEnum(id);
  if(h1!=NULL) {
    *returnbutton=NULL;
    *returnpath=NULL;
    *returnhotkey=h1;
    return 1;
  }
  
  // search for a path
  id=paths->initEnum();
  p1=(WCPath*)paths->getFirstElement(id);
  while(p1!=NULL) {
    tsk=p1->getKey();
    if(tsk->isShortkey(sk->getShortkey(),sk->getMod())==true) break;
    p1=(WCPath*)paths->getNextElement(id);
  }
  paths->closeEnum(id);
  if(p1!=NULL) {
    *returnbutton=NULL;
    *returnpath=p1;
    *returnhotkey=NULL;
    return 2;
  }

  // search for a button
  id=buttons->initEnum();
  b1=(WCButton*)buttons->getFirstElement(id);
  while(b1!=NULL) {
    tsk=b1->getKey();
    if(tsk->isShortkey(sk->getShortkey(),sk->getMod())==true) break;
    b1=(WCButton*)buttons->getNextElement(id);
  }
  buttons->closeEnum(id);
  if(b1!=NULL) {
    *returnbutton=b1;
    *returnpath=NULL;
    *returnhotkey=NULL;
    return 3;
  }
  *returnbutton=NULL;
  *returnpath=NULL;
  *returnhotkey=NULL;
  return 0;
}

void WConfig::setOwnerstringtype(int nv)
{
  ownerstringtype=nv;
  if(ownerstringtype<0) ownerstringtype=0;
  else if(ownerstringtype>1) ownerstringtype=1;
}

int WConfig::getOwnerstringtype()
{
  return ownerstringtype;
}

bool WConfig::isCorrectTerminalBin(const char *tstr)
{
  char *pos;
  if(strlen(tstr)<1) return true;
  pos=strstr(tstr,"%s");
  if(pos!=NULL) return true;
  return false;
}

const char *WConfig::getTerminalStr()
{
  if(strlen(terminalbin)<1) return TERMINAL_BIN;
  else if(isCorrectTerminalBin(terminalbin)==false) return TERMINAL_BIN;
  return terminalbin;
}

void WConfig::setClockbarMode(WConfig::clockbar_mode_t nm)
{
  clockbar_mode=nm;
}

WConfig::clockbar_mode_t WConfig::getClockbarMode()
{
  return clockbar_mode;
}

void WConfig::setClockbarUpdatetime(int nv)
{
  clockbar_updatetime=nv;
  if(clockbar_updatetime<1) clockbar_updatetime=1;
}

int WConfig::getClockbarUpdatetime()
{
  return clockbar_updatetime;
}

void WConfig::setShowStringForDirSize(bool nv)
{
  showStringForDirSize=nv;
}

bool WConfig::getShowStringForDirSize()
{
  return showStringForDirSize;
}

void WConfig::setStringForDirSize(const char *nv)
{
  _freesafe(stringForDirSize);
  if(nv!=NULL) stringForDirSize=dupstring(nv);
  else stringForDirSize=dupstring("<DIR>");
  stringForDirSizeLen=strlen(stringForDirSize);
}

const char *WConfig::getStringForDirSize()
{
  return stringForDirSize;
}

void WConfig::setClockbarCommand(const char *nv)
{
  _freesafe(clockbar_command);
  if(nv!=NULL) clockbar_command=dupstring(nv);
  else clockbar_command=dupstring("");
}

const char *WConfig::getClockbarCommand()
{
  return clockbar_command;
}

bool WConfig::changeClockbarSets()
{
  AGUIX *aguix=worker->getAGUIX();
  StringGadget *ccsg,*cusg;
  CycleButton *cyb;
  Text *cctext,*cutext,*ttext;
  Button *okb,*cb;
  AWindow *cuwin,*ccwin;
  int tw,ttw,tth,ttx,tty;
  int t1,t2;
  char *tstr;

  ttw=200;
  tth=10;
  ttx=tty=5;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,ttw,tth,0,catalog.getLocale(368));

  ttext=(Text*)win->add(new Text(aguix,ttx,tty,catalog.getLocale(369),1));
  ttx+=ttext->getWidth()+5;
  cyb=(CycleButton*)win->add(new CycleButton(aguix,ttx,tty,100,1,0,0));
  cyb->addOption(catalog.getLocale(370));
  cyb->addOption(catalog.getLocale(371));
  cyb->addOption(catalog.getLocale(372));
  cyb->addOption(catalog.getLocale(373));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  switch(clockbar_mode) {
    case CLOCKBAR_MODE_TIME:
      cyb->setOption(1);
      break;
    case CLOCKBAR_MODE_VERSION:
      cyb->setOption(2);
      break;
    case CLOCKBAR_MODE_EXTERN:
      cyb->setOption(3);
      break;
    default:
      cyb->setOption(0);
      break;
  }

  tty+=cyb->getHeight()+5;
  tw=ttx+cyb->getWidth()+5;
  if(tw>ttw) ttw=tw;
  ttx=5;

  cuwin=new AWindow(aguix);
  cuwin->create(win,0,tty,ttw,5,0,"");
  cutext=(Text*)cuwin->add(new Text(aguix,ttx,0,catalog.getLocale(129),1));
  ttx+=cutext->getWidth()+5;
  tstr=(char*)_allocsafe(sizeof(int)*8);
  sprintf(tstr,"%d",clockbar_updatetime);
  cusg=(StringGadget*)cuwin->add(new StringGadget(aguix,ttx,0,ttw-ttx-5,tstr,0));
  _freesafe(tstr);
  tty+=cusg->getHeight()+5;
  ttx=5;

  ccwin=new AWindow(aguix);
  ccwin->create(win,0,tty,ttw,5,0,"");
  cctext=(Text*)ccwin->add(new Text(aguix,ttx,0,catalog.getLocale(374),1));
  ttx+=cctext->getWidth()+5;
  ccsg=(StringGadget*)ccwin->add(new StringGadget(aguix,ttx,0,ttw-ttx-5,clockbar_command,0));
  tty+=ccsg->getHeight()+5;
  ttx=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>ttw) ttw=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   tty,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  ttw-5-t2,
                                  tty,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  tty+=okb->getHeight()+5;
  
  tth=tty;
  
  cusg->resize(ttw-5-cusg->getX(),cusg->getHeight());
  cuwin->resize(ttw,cusg->getHeight()+5);
  cuwin->show();
  ccsg->resize(ttw-5-ccsg->getX(),ccsg->getHeight());
  ccwin->resize(ttw,ccsg->getHeight()+5);
  ccwin->show();

  // now check which extra fields are visible
  if(clockbar_mode!=CLOCKBAR_MODE_EXTERN) {
    ccwin->hide();
  }
  switch(clockbar_mode) {
    case CLOCKBAR_MODE_VERSION:
      cuwin->hide();
      break;
    case CLOCKBAR_MODE_TIME:
    case CLOCKBAR_MODE_EXTERN:
    default:
      break;
  }

  win->resize(ttw,tth);
  win->setMaxSize(ttw,tth);
  win->setMinSize(ttw,tth);
  win->show();

  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cb) ende=-1;
      } else if(msg->type==AG_CYCLEBUTTONCLICKED) {
        if(msg->cyclebutton.cyclebutton==cyb) {
          if(msg->cyclebutton.option==3) ccwin->show();
          else ccwin->hide();
          switch(msg->cyclebutton.option) {
            case CLOCKBAR_MODE_VERSION:
              cuwin->hide();
              break;
            case CLOCKBAR_MODE_TIME:
            case CLOCKBAR_MODE_EXTERN:
            default:
              cuwin->show();
              break;
           }
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        if(msg->stringgadget.sg==cusg) {
          int val=atoi(cusg->getText());
          if(val<1) cusg->setText("1");
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    switch(cyb->getSelectedOption()) {
      case 1:
        setClockbarMode(CLOCKBAR_MODE_TIME);
        break;
      case 2:
        setClockbarMode(CLOCKBAR_MODE_VERSION);
        break;
      case 3:
        setClockbarMode(CLOCKBAR_MODE_EXTERN);
        break;
      default:
        setClockbarMode(CLOCKBAR_MODE_TIMERAM);
        break;
    }
    setClockbarUpdatetime(atoi(cusg->getText()));
    setClockbarCommand(ccsg->getText());
  }
  cuwin->close();
  delete cuwin;
  ccwin->close();
  delete ccwin;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

void WConfig::setDontCheckDirs(List *ndcd)
{
  char *tstr;
  int id=dontcheckdirs->initEnum();
  tstr=(char*)dontcheckdirs->getFirstElement(id);
  while(tstr!=NULL) {
    _freesafe(tstr);
    tstr=(char*)dontcheckdirs->getNextElement(id);
  }
  dontcheckdirs->closeEnum(id);
  dontcheckdirs->removeAllElements();
  id=ndcd->initEnum();
  tstr=(char*)ndcd->getFirstElement(id);
  while(tstr!=NULL) {
    dontcheckdirs->addElement(dupstring(tstr));
    tstr=(char*)ndcd->getNextElement(id);
  }
  ndcd->closeEnum(id);
}

List *WConfig::getDontCheckDirs()
{
  return dontcheckdirs;
}

int WConfig::configureDCD(List *tdcd)
{
  AGUIX *aguix=worker->getAGUIX();
  int tw,ttw,tth,ty;
  int t1,t2;
  ListViewContent *tlvc,*tlvc2;
  int pos;
  int id;
  char *tstr,*buttonstr,*textstr,*tstr2;
  Requester *req;
  bool found;

  ttw=10;
  tth=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,ttw,tth,0,catalog.getLocale(144));

  ty=5;
  ListView *filv=(ListView*)win->add(new ListView(aguix,5,ty,ttw,100,0));
  filv->setHBarState(2);
  filv->setVBarState(2);
  ty+=filv->getHeight()+5;
  t1=(strlen(catalog.getLocale(181))+2);
  t1*=aguix->getCharWidth();
  Button *newb=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(181),1,0,0));
  t1=(strlen(catalog.getLocale(183))+2);
  t1*=aguix->getCharWidth();
  Button *delb=(Button*)win->add(new Button(aguix,newb->getX()+newb->getWidth(),ty,t1,
                                            catalog.getLocale(183),1,0,0));
  t1=(strlen(catalog.getLocale(182))+2);
  t1*=aguix->getCharWidth();
  Button *editb=(Button*)win->add(new Button(aguix,delb->getX()+delb->getWidth(),ty,t1,
                                            catalog.getLocale(182),1,0,0));
  ty+=newb->getHeight()+5;
  ttw=editb->getX()+editb->getWidth()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>ttw) ttw=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 ttw-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  filv->resize(ttw-10,filv->getHeight());
  editb->resize(ttw-5-editb->getX(),editb->getHeight());
  tth=okb->getY()+okb->getHeight()+5;
  
  id=tdcd->initEnum();
  tstr=(char*)tdcd->getFirstElement(id);
  pos=0;
  while(tstr!=NULL) {
    tlvc=new ListViewContent(tstr,1,1,2,2,0,0,1,1,pos++);
    filv->add(tlvc);
    tstr=(char*)tdcd->getNextElement(id);
  }
  tdcd->closeEnum(id);
  
  win->resize(ttw,tth);
  win->setMaxSize(ttw,tth);
  win->setMinSize(ttw,tth);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  
  req=new Requester(aguix);
  
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==newb) {
          textstr=catalog.getLocale(199);
          buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                      strlen(catalog.getLocale(8))+1);
          sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                                    catalog.getLocale(8));
          if(req->string_request(catalog.getLocale(123),textstr,"",buttonstr,&tstr)==0) {
            if(strlen(tstr)>0) {
              if(tstr[0]=='/') {
                tstr2=HandlePath(tstr);
                
                found=false;
                tlvc=filv->get(0);
                while(tlvc!=NULL) {
                  if(strcmp(tlvc->getText(),tstr2)==0) {
                    found=true;
                    break;
                  }
                  tlvc=filv->getNext();
                }
                if(found==false) {
                  tlvc=filv->add(new ListViewContent(tstr2,1,1,2,2,0,0,1,1,0));
                  tlvc->setActive(true);
                  filv->showActive();
                }
                _freesafe(tstr2);
              }
            }
            _freesafe(tstr);
          } else _freesafe(tstr);
          _freesafe(buttonstr);
        } else if(msg->button.button==delb) {
          tlvc=filv->getActiveLVC();
          if(tlvc!=NULL) filv->remove(tlvc);
        } else if(msg->button.button==editb) {
          tlvc=filv->getActiveLVC();
          if(tlvc!=NULL) {
            textstr=catalog.getLocale(199);
            buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                        strlen(catalog.getLocale(8))+1);
            sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                                      catalog.getLocale(8));
            if(req->string_request(catalog.getLocale(123),textstr,tlvc->getText(),buttonstr,&tstr)==0) {
              if(strlen(tstr)>0) {
                if(tstr[0]=='/') {
                  tstr2=HandlePath(tstr);

                  found=false;
                  tlvc2=filv->get(0);
                  while(tlvc2!=NULL) {
                    if(strcmp(tlvc2->getText(),tstr2)==0) {
                      found=true;
                      break;
                    }
                    tlvc2=filv->getNext();
                  }
                  if(found==false) {
                    tlvc->setText(tstr2);
                    filv->redraw();
                  }
                  _freesafe(tstr2);
                }
              }
              _freesafe(tstr);
            } else _freesafe(tstr);
            _freesafe(buttonstr);
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // insert in tdcd
    id=tdcd->initEnum();
    tstr=(char*)tdcd->getFirstElement(id);
    while(tstr!=NULL) {
      _freesafe(tstr);
      tstr=(char*)tdcd->getNextElement(id);
    }
    tdcd->closeEnum(id);
    tdcd->removeAllElements();

    tlvc=filv->get(0);
    while(tlvc!=NULL) {
      tdcd->addElement(dupstring(tlvc->getText()));
      tlvc=filv->getNext();
    }
  }
  
  win->close();
  delete win;
  delete req;
  return (ende==1)?0:1;
}

void WConfig::setListerBG(int color)
{
  listerbg=color;
}

int WConfig::getListerBG()
{
  return listerbg;
}

int WConfig::getStringForDirSizeLen()
{
  return stringForDirSizeLen;
}

int WConfig::im_export()
{
  AWindow *win;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty;
  AGMessage *msg;
  Button *b[3];
  
  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 396 ) );

  ty = 5;
  b[0] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 397 ), 1, 0, 0 ) );
  ty += b[0]->getHeight() + 5;

  b[1] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 398 ), 1, 0, 0 ) );
  ty += b[1]->getHeight() + 5;

  b[2] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  ty += b[2]->getHeight() + 5;

  win->maximizeX();
  w = win->getWidth();
  b[0]->resize( w - 10, b[0]->getHeight() );
  b[1]->resize( w - 10, b[1]->getHeight() );
  b[2]->resize( w - 10, b[2]->getHeight() );
  
  h = ty;
  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if (msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b[0] ) {
          // import
          win->hide();
          if ( cfg_import1() == 0 )
            ende = 1;
          else
            ende = -1;
        } else if ( msg->button.button == b[1] ) {
          // export
          win->hide();
          if ( cfg_export() == 0 )
            ende = 1;
          else
            ende = -1;
        } else if ( msg->button.button == b[2] ) {
          // Cancel
          ende = -1;
        }
      }

      aguix->ReplyMessage( msg );
    }
  }
  
  win->close();
  delete win;

  return ( ende == -1 ) ? 1 : 0;
}

int WConfig::cfg_export()
{
  AWindow *win;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty, tw, tx;
  AGMessage *msg;
  ChooseButton *cb[3];
  Button *b[3],*b2[2],*b3;
  WConfig *exportconfig;
  Text *ttext;
  StringGadget *sg;
  char *cur_name;
  FileRequester *freq;
  std::string str1;
  Requester *req;
  
  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 398 ) );

  ty = 5;
  
  win->addTextFromString( catalog.getLocale( 399 ), 5, ty, 5, NULL, NULL, &ty );
  ty += 5;
  
  cb[0] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
  b[0] = (Button*)win->add( new Button( aguix, cb[0]->getX() + cb[0]->getWidth() + 5,
                                        ty, catalog.getLocale( 401 ), 1, 0, 0 ) );
  b[0]->resize( b[0]->getWidth(), cb[0]->getHeight() );
  ty += cb[0]->getHeight() + 5;

  cb[1] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
  b[1] = (Button*)win->add( new Button( aguix, cb[1]->getX() + cb[1]->getWidth() + 5,
                                        ty, catalog.getLocale( 402 ), 1, 0, 0 ) );
  b[1]->resize( b[1]->getWidth(), cb[1]->getHeight() );
  ty += cb[1]->getHeight() + 5;

  cb[2] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
  b[2] = (Button*)win->add( new Button( aguix, cb[2]->getX() + cb[2]->getWidth() + 5,
                                        ty, catalog.getLocale( 403 ), 1, 0, 0 ) );
  b[2]->resize( b[2]->getWidth(), cb[2]->getHeight() );
  ty += cb[2]->getHeight() + 5;
  
  win->maximizeX();
  w = win->getWidth();
  
  cur_name = dupstring( "" );

  ttext = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 404 ), 1 ) );
  tx = ttext->getX() + ttext->getWidth() + 5;
  tw = w_max( w, 20 * aguix->getCharWidth() );
  sg = (StringGadget*)win->add( new StringGadget( aguix, tx, ty, tw, cur_name, 0 ) );
  tx += sg->getWidth();
  b3 = (Button*)win->add( new Button( aguix, tx, ty, catalog.getLocale( 405 ), 1, 0, 0 ) );
  b3->resize( b3->getWidth(), sg->getHeight() );

  AGUIX::centerElementsY( ttext, sg );  
  
  ty += b3->getHeight() + 5;
  
  win->maximizeX();
  w = win->getWidth();
  
  b2[0] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 398 ), 1, 0, 0 ) );
  b2[1] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  tw = AGUIX::scaleElementsW( w, win->getBorderWidth(), 10, -1, false, false, (GUIElement**)b2, 2 );
  if ( tw > w ) w = tw;
  
  ty += b2[0]->getHeight() + 5;
  
  h = ty;
  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  exportconfig = duplicate();
  
  freq = new FileRequester( aguix );
  req = new Requester( aguix );
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b2[0] ) {
          // Okay
          ende = 1;
        } else if ( msg->button.button == b2[1] ) {
          // Cancel
          ende = -1;
        } else if ( msg->button.button == b[0] ) {
          exportconfig->changeButtons();
        } else if ( msg->button.button == b[1] ) {
          exportconfig->changeHotkeys();
        } else if ( msg->button.button == b[2] ) {
          exportconfig->changeTypes( true, true );
        } else if ( msg->button.button == b3 ) {
          // choose file with requester
          if ( freq->request_entry( catalog.getLocale( 265 ),
                                    NULL,
                                    catalog.getLocale( 11 ),
                                    catalog.getLocale( 8 ),
                                    catalog.getLocale( 406 ),
                                    true ) > 0 ) {
            str1 = freq->getLastEntryStr();
            if ( str1.length() > 0 ) {
              sg->setText( str1.c_str() );
            }
          }
        }
      } else if ( msg->type == AG_STRINGGADGET_DEACTIVATE ) {
      }

      aguix->ReplyMessage( msg );
    }
    if ( ende == 1 ) {
      // try to export
      // in case of failure keep this window so we do this
      // inside the loop
      // export the exportconfig according to choosebuttons

      if ( ( ( cb[0]->getState() == true ) ||
             ( cb[1]->getState() == true ) ||
             ( cb[2]->getState() == true ) ) &&
           ( strlen( sg->getText() ) > 0 ) ) {
        // something to export
        // when export failed set ende back to 0

        if ( exportconfig->export2file( cb[0]->getState(),
                                        cb[1]->getState(),
                                        cb[2]->getState(),
                                        sg->getText() ) != 0 ) {
          ende = 0;
        }
      } else {
        req->request( catalog.getLocale( 124 ), catalog.getLocale( 407 ),
                      catalog.getLocale( 11 ) );
        ende = 0;
      }
    }
  }
  
  _freesafe( cur_name );
  win->close();
  delete win;
  
  delete exportconfig;
  delete freq;
  delete req;

  return ( ende == -1 ) ? 1 : 0;
}

int WConfig::export2file( bool export_buttons,
                          bool export_hotkeys,
                          bool export_types,
                          const char *filename )
{
  Datei fh;
  Datei::d_fe_t e;
  int erg, ret;
  Requester req( worker->getAGUIX() );
  char *tstr;
  std::string s1;
  unsigned long chunksize;
  int nr_of_b, nr_of_h, nr_of_f, id;
  WCButton *b1;
  WCHotkey *h1;
  WCFiletype *f1;
  
  ret = 0;
  
  if ( filename == NULL ) return 1;

  e = Datei::fileExistsExt( filename );
  if ( e != Datei::D_FE_NOFILE ) {
    // something exists with this name!
    if ( e == Datei::D_FE_DIR ) {
      // dir -> show request and exit
      tstr = (char*)_allocsafe( strlen( catalog.getLocale( 408 ) ) + strlen( filename ) + 1 );
      sprintf( tstr, catalog.getLocale( 408 ), filename );
      req.request( catalog.getLocale( 124 ), tstr, catalog.getLocale( 11 ) );
      _freesafe( tstr );
      return 1;
    }
    // ask for overwriting this file
    // otherwise return
    tstr = (char*)_allocsafe( strlen( catalog.getLocale( 409 ) ) + strlen( filename ) + 1 );
    sprintf( tstr, catalog.getLocale( 409 ), filename );
    s1 = catalog.getLocale( 11 );
    s1 += "|";
    s1 += catalog.getLocale( 8 );
    erg = req.request( catalog.getLocale( 123 ), tstr, s1.c_str() );
    _freesafe( tstr );
    
    if ( erg == 1 )
      return 1;
    
  }

  if ( fh.open( filename, "w" ) == 0 ) {
    // 1.write header
    //   should start with special IFF-format
    //   DATA-chunk with:
    //     worker version ( 3*int)
    //     number of buttons
    //     number of hotkeys
    //     number of types
    //   BTTN-chunks
    //   HOTK-chunks
    //   FITY-chunks
    fh.putString( "FORM" );
    fh.putULong( 0 );
    fh.putString( "WEXP" );
    fh.putString( "DATA" );
    
    chunksize = 6 * Datei::getIntSize();
    
    fh.putULong( chunksize );
    
    fh.putInt( WORKER_MAJOR );
    fh.putInt( WORKER_MINOR );
    fh.putInt( WORKER_PATCH );
    
    nr_of_b = ( export_buttons == true ) ? buttons->size() : 0;
    nr_of_h = ( export_hotkeys == true ) ? hotkeys->size() : 0;
    nr_of_f = ( export_types == true ) ? filetypes->size() : 0;
    
    fh.putInt( nr_of_b );
    fh.putInt( nr_of_h );
    fh.putInt( nr_of_f );
    
    if ( export_buttons == true ) {
      id = buttons->initEnum();
      b1 = (WCButton*)buttons->getFirstElement( id );
      while ( b1 != NULL ) {
        b1->save( &fh );
        b1 = (WCButton*)buttons->getNextElement( id );
      }
      buttons->closeEnum( id );
    }
    
    if ( export_hotkeys == true ) {
      id = hotkeys->initEnum();
      h1 = (WCHotkey*)hotkeys->getFirstElement( id );
      while ( h1 != NULL ) {
        h1->save( &fh );
        h1 = (WCHotkey*)hotkeys->getNextElement( id );
      }
      hotkeys->closeEnum( id );
    }
    
    if ( export_types == true ) {
      id = filetypes->initEnum();
      f1 = (WCFiletype*)filetypes->getFirstElement( id );
      while ( f1 != NULL ) {
        f1->save( &fh );
        f1 = (WCFiletype*)filetypes->getNextElement( id );
      }
      filetypes->closeEnum( id );
    }
    
    fh.close();
    tstr = (char*)_allocsafe( strlen( catalog.getLocale( 410 ) ) + strlen( filename ) + 1 );
    sprintf( tstr, catalog.getLocale( 410 ), filename );
    req.request( catalog.getLocale( 124 ), tstr, catalog.getLocale( 11 ) );
    _freesafe( tstr );
  } else {
    tstr = (char*)_allocsafe( strlen( catalog.getLocale( 411 ) ) + strlen( filename ) + 1 );
    sprintf( tstr, catalog.getLocale( 411 ), filename );
    req.request( catalog.getLocale( 124 ), tstr, catalog.getLocale( 11 ) );
    _freesafe( tstr );
    ret = 1;
  }

  return ret;
}

/*
 * Step 1 of import
 * asks for filename and calls cfg_import2 with this name
 *
 */
int WConfig::cfg_import1()
{
  AWindow *win;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty, tw, tx;
  AGMessage *msg;
  Button *b2[2],*b3;
  Text *ttext;
  StringGadget *sg;
  FileRequester *freq;
  std::string str1;
  Requester *req;
  
  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 397 ) );

  ty = 5;
  
  win->addTextFromString( catalog.getLocale( 415 ), 5, ty, 5, NULL, NULL, &ty );
  ty += 5;
  
  win->maximizeX();
  w = win->getWidth();
  
  ttext = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 404 ), 1 ) );
  tx = ttext->getX() + ttext->getWidth() + 5;
  tw = w_max( w, 20 * aguix->getCharWidth() );
  sg = (StringGadget*)win->add( new StringGadget( aguix, tx, ty, tw, "", 0 ) );
  tx += sg->getWidth();
  b3 = (Button*)win->add( new Button( aguix, tx, ty, catalog.getLocale( 405 ), 1, 0, 0 ) );
  b3->resize( b3->getWidth(), sg->getHeight() );

  AGUIX::centerElementsY( ttext, sg );  
  
  ty += b3->getHeight() + 5;
  
  win->maximizeX();
  w = win->getWidth();
  
  b2[0] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 11 ), 1, 0, 0 ) );//TODO: Vielleicht als Text continue
  b2[1] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  tw = AGUIX::scaleElementsW( w, win->getBorderWidth(), 10, -1, false, false, (GUIElement**)b2, 2 );
  if ( tw > w ) w = tw;
  
  ty += b2[0]->getHeight() + 5;
  
  h = ty;
  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  freq = new FileRequester( aguix );
  req = new Requester( aguix );
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b2[0] ) {
          // Okay
          ende = 1;
        } else if ( msg->button.button == b2[1] ) {
          // Cancel
          ende = -1;
        } else if ( msg->button.button == b3 ) {
          // choose file with requester
          if ( freq->request_entry( catalog.getLocale( 265 ),
                                    NULL,
                                    catalog.getLocale( 11 ),
                                    catalog.getLocale( 8 ),
                                    catalog.getLocale( 265 ),
                                    false ) > 0 ) {
            str1 = freq->getLastEntryStr();
            if ( str1.length() > 0 ) {
              sg->setText( str1.c_str() );
            }
          }
        }
      } else if ( msg->type == AG_STRINGGADGET_DEACTIVATE ) {
      }

      aguix->ReplyMessage( msg );
    }
    if ( ende == 1 ) {
      // try to import
      // in case of failure keep this window so we do this
      // inside the loop

      if ( strlen( sg->getText() ) > 0 ) {
        win->hide();

        if ( cfg_import2( sg->getText() ) != 0 ) {
          win->show();
          ende = 0;
        }
      } else {
        req->request( catalog.getLocale( 124 ), catalog.getLocale( 415 ),
                      catalog.getLocale( 11 ) );
        ende = 0;
      }
    }
  }
  
  win->close();
  delete win;
  
  delete freq;
  delete req;

  return ( ende == -1 ) ? 1 : 0;
}

/*
 * Step 2 of import
 * loads the file in a temp. config and calls cfg_import3 with it
 */
int WConfig::cfg_import2( const char *filename )
{
  AGUIX *aguix = worker->getAGUIX();
  WConfig *importconfig;
  Requester req( aguix );
  Datei fh;
  char buf[5];
  int erg = 0;
  List *bl, *hl, *fl;
  unsigned long chunksize;
  int wma, wmi, wp, nr_of_b, nr_of_h, nr_of_f, id, nrb;
  char *tstr;
  WCButton *b1;
  WCHotkey *h1;
  WCFiletype *f1;

  // first try to load the config
  if ( Datei::fileExistsExt( filename ) == Datei::D_FE_FILE ) {
    if ( fh.open( filename, "r" ) == 0 ) {
      importconfig = duplicate();
      bl = new List();
      hl = new List();
      fl = new List();
      
      fh.getString( buf, 4 );
      if ( strcmp( buf, "FORM" ) == 0 ) {
        fh.getULong();
        fh.getString( buf, 4 );
        if ( strcmp( buf, "WEXP" ) == 0 ) {
          fh.getString( buf, 4 );
          if ( strcmp( buf, "DATA" ) == 0 ) {
            chunksize = fh.getULong();
            if ( chunksize >= (unsigned long)( 6 * Datei::getIntSize() ) ) {
              wma = fh.getInt();
              wmi = fh.getInt();
              wp = fh.getInt();
              chunksize -= 3 * Datei::getIntSize();
              
              nr_of_b = fh.getInt();
              nr_of_h = fh.getInt();
              nr_of_f = fh.getInt();
              chunksize -= 3 * Datei::getIntSize();
              
              nrb = nr_of_b; // because nr_of_b gets changed below we need this for cfg_import3
              
              if ( ( ( wma == WORKER_MAJOR ) && ( wmi > WORKER_MINOR ) ) ||
                   ( ( wma == WORKER_MAJOR ) && ( wmi == WORKER_MINOR ) && ( wp > WORKER_PATCH ) ) ) {
                // from newer version
                tstr = (char*)_allocsafe( strlen( catalog.getLocale( 413 ) ) + ( 3 * sizeof(int) ) + 1 );
                sprintf( tstr, catalog.getLocale( 413 ), wma, wmi, wp );
                req.request( catalog.getLocale( 124 ),
                             tstr,
                             catalog.getLocale( 11 ) );
                _freesafe( tstr );
                erg = 1;
              } else {
                while ( chunksize > 0 ) {
                  fh.getUChar();
                  chunksize--;
                }
                
                while ( nr_of_b > 0 ) {
                  b1 = new WCButton();
                  b1->load( worker, &fh );
                  bl->addElement( b1 );
                  nr_of_b--;
                }
                while ( nr_of_h > 0 ) {
                  h1 = new WCHotkey();
                  h1->load( worker, &fh );
                  hl->addElement( h1 );
                  nr_of_h--;
                }
                while ( nr_of_f > 0 ) {
                  f1 = new WCFiletype();
                  f1->load( worker, &fh );
                  fl->addElement( f1 );
                  nr_of_f--;
                }
                
                importconfig->setButtons( bl );
                importconfig->setHotkeys( hl );
                importconfig->setFiletypes( fl );
                
                id = bl->initEnum();
                b1 = (WCButton*)bl->getFirstElement( id );
                while ( b1 != NULL ) {
                  delete b1;
                  bl->removeFirstElement();
                  b1 = (WCButton*)bl->getFirstElement( id );
                }
                bl->closeEnum( id );
  
                id = hl->initEnum();
                h1 = (WCHotkey*)hl->getFirstElement( id );
                while ( h1 != NULL ) {
                  delete h1;
                  hl->removeFirstElement();
                  h1 = (WCHotkey*)hl->getFirstElement( id );
                }
                hl->closeEnum( id );
  
                id = fl->initEnum();
                f1 = (WCFiletype*)fl->getFirstElement( id );
                while ( f1 != NULL ) {
                  delete f1;
                  fl->removeFirstElement();
                  f1 = (WCFiletype*)fl->getFirstElement( id );
                }
                fl->closeEnum( id );
                
                // everything is now in importconfig
                // now let the user decide...
                erg = cfg_import3( importconfig, nrb );
              }
            } else {
              tstr = (char*)_allocsafe( strlen( catalog.getLocale( 400 ) ) + strlen( filename ) + 1 );
              sprintf( tstr, catalog.getLocale( 400 ), filename );
              req.request( catalog.getLocale( 124 ),
                           tstr,
                           catalog.getLocale( 11 ) );
              _freesafe( tstr );
              erg = 1;
            }
          } else {
            // wrong file
            tstr = (char*)_allocsafe( strlen( catalog.getLocale( 400 ) ) + strlen( filename ) + 1 );
            sprintf( tstr, catalog.getLocale( 400 ), filename );
            req.request( catalog.getLocale( 124 ),
                         tstr,
                         catalog.getLocale( 11 ) );
            _freesafe( tstr );
            erg = 1;
          }
        } else {
          // no export file
          tstr = (char*)_allocsafe( strlen( catalog.getLocale( 400 ) ) + strlen( filename ) + 1 );
          sprintf( tstr, catalog.getLocale( 400 ), filename );
          req.request( catalog.getLocale( 124 ),
                       tstr,
                       catalog.getLocale( 11 ) );
          _freesafe( tstr );
          erg = 1;
        }
      } else {
        // no iff file
        tstr = (char*)_allocsafe( strlen( catalog.getLocale( 400 ) ) + strlen( filename ) + 1 );
        sprintf( tstr, catalog.getLocale( 400 ), filename );
        req.request( catalog.getLocale( 124 ),
                     tstr,
                     catalog.getLocale( 11 ) );
        _freesafe( tstr );
        erg = 1;
      }
      fh.close();
      delete bl;
      delete hl;
      delete fl;
      delete importconfig;
    } else {
      // can't open for reading
      tstr = (char*)_allocsafe( strlen( catalog.getLocale( 281 ) ) + strlen( filename ) + 1 );
      sprintf( tstr, catalog.getLocale( 281 ), filename );
      req.request( catalog.getLocale( 124 ),
                   tstr,
                   catalog.getLocale( 11 ) );
      _freesafe( tstr );
      erg = 1;
    }
  } else {
    // not a file
    tstr = (char*)_allocsafe( strlen( catalog.getLocale( 412 ) ) + strlen( filename ) + 1 );
    sprintf( tstr, catalog.getLocale( 412 ), filename );
    req.request( catalog.getLocale( 124 ),
                 tstr,
                 catalog.getLocale( 11 ) );
    _freesafe( tstr );
    erg = 1;
  }
  
  return erg;
}

/*
 * Step 3 of import
 * show the users a similar window to export
 * user can choose which part (buttons/hotkeys/filetypes) he want to import
 * and can configure them before import
 */
int WConfig::cfg_import3( WConfig *importconfig, int nrb )
{
  AWindow *win;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty, tw;
  AGMessage *msg;
  ChooseButton *cb[3];
  Button *b[3],*b2[2];
  Requester req( aguix );
  int nr_of_b, nr_of_h, nr_of_f;
  char *tstr;
  bool apply_b, apply_h, apply_f;

  if ( nrb < 1 ) {
    nr_of_b = 0;
  } else {
    nr_of_b = importconfig->getButtons()->size();
    nr_of_b /= ( importconfig->getRows() * importconfig->getColumns() * 2 );
  }
  
  nr_of_h = importconfig->getHotkeys()->size();
  nr_of_f = importconfig->getFiletypes()->size();
  
  if ( ( nr_of_b == 0 ) && ( nr_of_h == 0 ) && ( nr_of_f == 0 ) ) {
    req.request( catalog.getLocale( 124 ), catalog.getLocale( 418 ), catalog.getLocale( 11 ) );
    return 1;
  }
  
  tstr = (char*)_allocsafe( strlen( catalog.getLocale( 414 ) ) + ( 3 * sizeof(int) ) + 1 );
  sprintf( tstr, catalog.getLocale( 414 ), nr_of_b, nr_of_h, nr_of_f );
  req.request( catalog.getLocale( 124 ),
               tstr,
               catalog.getLocale( 11 ) );
  _freesafe( tstr );

  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 397 ) );

  ty = 5;
  
  win->addTextFromString( catalog.getLocale( 416 ), 5, ty, 5, NULL, NULL, &ty );
  ty += 5;
  
  if ( nr_of_b > 0 ) {
    cb[0] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
    b[0] = (Button*)win->add( new Button( aguix, cb[0]->getX() + cb[0]->getWidth() + 5,
                                          ty, catalog.getLocale( 401 ), 1, 0, 0 ) );
    b[0]->resize( b[0]->getWidth(), cb[0]->getHeight() );
    ty += cb[0]->getHeight() + 5;
  } else {
    cb[0] = NULL;
    b[0] = NULL;
  }

  if ( nr_of_h > 0 ) {
    cb[1] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
    b[1] = (Button*)win->add( new Button( aguix, cb[1]->getX() + cb[1]->getWidth() + 5,
                                          ty, catalog.getLocale( 402 ), 1, 0, 0 ) );
    b[1]->resize( b[1]->getWidth(), cb[1]->getHeight() );
    ty += cb[1]->getHeight() + 5;
  } else {
    cb[1] = NULL;
    b[1] = NULL;
  }

  if ( nr_of_f > 0 ) {
    cb[2] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
    b[2] = (Button*)win->add( new Button( aguix, cb[2]->getX() + cb[2]->getWidth() + 5,
                                          ty, catalog.getLocale( 403 ), 1, 0, 0 ) );
    b[2]->resize( b[2]->getWidth(), cb[2]->getHeight() );
    ty += cb[2]->getHeight() + 5;
  } else {
    cb[2] = NULL;
    b[2] = NULL;
  }
  
  win->maximizeX();
  w = win->getWidth();
  
  win->maximizeX();
  w = win->getWidth();
  
  b2[0] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 397 ), 1, 0, 0 ) );
  b2[1] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  tw = AGUIX::scaleElementsW( w, win->getBorderWidth(), 10, -1, false, false, (GUIElement**)b2, 2 );
  if ( tw > w ) w = tw;
  
  ty += b2[0]->getHeight() + 5;
  
  h = ty;
  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b2[0] ) {
          // Okay
          ende = 1;
        } else if ( msg->button.button == b2[1] ) {
          // Cancel
          ende = -1;
        } else if ( ( msg->button.button == b[0] ) && ( b[0] != NULL ) ) {
          importconfig->changeButtons();
        } else if ( ( msg->button.button == b[1] ) && ( b[1] != NULL ) )  {
          importconfig->changeHotkeys();
        } else if ( ( msg->button.button == b[2] ) && ( b[2] != NULL ) )  {
          importconfig->changeTypes( true, true );
        }
      } else if ( msg->type == AG_STRINGGADGET_DEACTIVATE ) {
      }

      aguix->ReplyMessage( msg );
    }
    if ( ende == 1 ) {
      // now try to import
      // in case of failure keep this window so we do this
      // inside the loop
      
      if ( cb[0] != NULL ) {
        apply_b = cb[0]->getState() ;
      } else apply_b = false;

      if ( cb[1] != NULL ) {
        apply_h = cb[1]->getState() ;
      } else apply_h = false;

      if ( cb[2] != NULL ) {
        apply_f = cb[2]->getState() ;
      } else apply_f = false;

      if ( ( apply_b == true ) ||
           ( apply_h == true ) ||
           ( apply_f == true ) ) {
        // something to import
        // when import failed set ende back to 0
        if ( cfg_import4( importconfig, apply_b, apply_h, apply_f ) != 0 ) {
          ende = 0;
        }
      } else {
        req.request( catalog.getLocale( 124 ), catalog.getLocale( 417 ),
                      catalog.getLocale( 11 ) );
        ende = 0;
      }
    }
  }
  
  win->close();
  delete win;
  
  return ( ende == -1 ) ? 1 : 0;
}

/*
 * Step 4 of import
 * now import the config
 *
 */
int WConfig::cfg_import4( WConfig *importconfig, bool apply_b, bool apply_h, bool apply_f )
{
  List *bl, *hl, *fl, l1, *im_fl;
  WCButton *im_b1, *b1;
  WCHotkey *im_h1, *h1;
  WCFiletype *im_f1, *f1;
  WCPath *p1;
  char *textstr;
  WCShortkey *tsk;
  int ende = 0, erg, id, im_id, maxcols;
  std::string str1;
  Requester req( worker->getAGUIX() );
  bool always_keep;

  /* 1.resolve any shortkey problem
   * 2.add buttons banks to this config
   *   colors could be wrong for the imported buttons!
   * 3.add hotkeys to this config
   * 4.add normal filetypes to this config
   * 5.ask for the special types (if any)
   *   leave the current
   *   or take the new
   */

  maxcols = getColors()->size();

  if ( apply_b == true ) {
    always_keep = false;

    bl = importconfig->getButtons();
    id = bl->initEnum();
    im_b1 = (WCButton*)bl->getFirstElement( id );
    while ( ( im_b1 != NULL ) && ( ende == 0 ) ) {
      tsk = im_b1->getKey();
      if ( tsk != NULL ) {
        if ( tsk->isReal() == true ) {
          if ( findShortkey( tsk, &b1, &p1, &h1 ) != 0 ) {
            // there is already an element with this shortkey
            if ( always_keep == true ) {
              im_b1->setKey( NULL );
            } else {
              if ( b1 != NULL ) {
                // "The new button %s uses the same shortkey as the button %s!"
                textstr = (char*)_allocsafe( strlen( catalog.getLocale( 419 ) ) +
                                             strlen( im_b1->getText() ) +
                                             strlen( b1->getText() ) + 1 );
                sprintf( textstr, catalog.getLocale( 419 ), im_b1->getText(), b1->getText() );
    
                str1 = catalog.getLocale( 425 );
                str1 += "|";
                str1 += catalog.getLocale( 431 );
                str1 += "|";
                str1 += catalog.getLocale( 426 );
                str1 += "|";
                str1 += catalog.getLocale( 8 );
                erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
                _freesafe(textstr);
    
                if ( erg == 2 ) {
                  // use new
                  b1->setKey( NULL );
                } else if ( erg == 1 ) {
                  im_b1->setKey( NULL );
                  always_keep = true;
                } else if ( erg == 0 ) {
                  // leave original
                  im_b1->setKey( NULL );
                } else ende = -1;
              } else if ( p1 != NULL ) {
                // "The new button %s uses the same shortkey as the path %s!"
                textstr = (char*)_allocsafe( strlen( catalog.getLocale( 423 ) ) +
                                             strlen( im_b1->getText() ) +
                                             strlen( p1->getName() ) + 1 );
                sprintf( textstr, catalog.getLocale( 423 ), im_b1->getText(), p1->getName() );
    
                str1 = catalog.getLocale( 425 );
                str1 += "|";
                str1 += catalog.getLocale( 431 );
                str1 += "|";
                str1 += catalog.getLocale( 426 );
                str1 += "|";
                str1 += catalog.getLocale( 8 );
                erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
                _freesafe(textstr);
    
                if ( erg == 2 ) {
                 // use new
                  p1->setKey( NULL );
                } else if ( erg == 1 ) {
                  im_b1->setKey( NULL );
                  always_keep = true;
                } else if ( erg == 0 )  {
                  // leave original
                  im_b1->setKey( NULL );
                } else ende = -1;
              } else if ( h1 != NULL ) {
                // "The new button %s uses the same shortkey as the hotkey %s!"
                textstr = (char*)_allocsafe( strlen( catalog.getLocale( 421 ) ) +
                                             strlen( im_b1->getText() ) +
                                             strlen( h1->getName() ) + 1 );
                sprintf( textstr, catalog.getLocale( 421 ), im_b1->getText(), h1->getName() );
    
                str1 = catalog.getLocale( 425 );
                str1 += "|";
                str1 += catalog.getLocale( 431 );
                str1 += "|";
                str1 += catalog.getLocale( 426 );
                str1 += "|";
                str1 += catalog.getLocale( 8 );
                erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
                _freesafe(textstr);
    
                if ( erg == 2 ) {
                  // use new
                  h1->setKey( NULL );
                } else if ( erg == 1 ) {
                  im_b1->setKey( NULL );
                  always_keep = true;
                } else if ( erg == 0 )  {
                  // leave original
                  im_b1->setKey( NULL );
                } else ende = -1;
              }
            }
          }
        }
      }
      if ( im_b1->getFG() >= maxcols ) im_b1->setFG( maxcols - 1 );
      if ( im_b1->getBG() >= maxcols ) im_b1->setBG( maxcols - 1 );
      im_b1 = (WCButton*)bl->getNextElement( id );
    }
    bl->closeEnum( id );
  }

  if ( ende != 0 ) return 1;

  if ( apply_h == true ) {
    always_keep = false;

    hl = importconfig->getHotkeys();
    id = hl->initEnum();
    im_h1 = (WCHotkey*)hl->getFirstElement( id );
    while ( ( im_h1 != NULL ) && ( ende == 0 ) ) {
      tsk = im_h1->getKey();
      if ( tsk != NULL ) {
        if ( tsk->isReal() == true ) {
          if ( findShortkey( tsk, &b1, &p1, &h1 ) != 0 ) {
            if ( always_keep == true ) {
              im_h1->setKey( NULL );
            } else {
              // there is already an element with this shortkey
              if ( b1 != NULL ) {
                // "The new hotkey %s uses the same shortkey as the button %s!"
                textstr = (char*)_allocsafe( strlen( catalog.getLocale( 420 ) ) +
                                             strlen( im_h1->getName() ) +
                                             strlen( b1->getText() ) + 1 );
                sprintf( textstr, catalog.getLocale( 420 ), im_h1->getName(), b1->getText() );
    
                str1 = catalog.getLocale( 425 );
                str1 += "|";
                str1 += catalog.getLocale( 431 );
                str1 += "|";
                str1 += catalog.getLocale( 426 );
                str1 += "|";
                str1 += catalog.getLocale( 8 );
                erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
                _freesafe(textstr);
    
                if ( erg == 2 ) {
                  // use new
                  b1->setKey( NULL );
                } else if ( erg == 1 ) {
                  im_h1->setKey( NULL );
                  always_keep = true;
                } else if ( erg == 0 )  {
                  // leave original
                  im_h1->setKey( NULL );
                } else ende = -1;
              } else if ( p1 != NULL ) {
                // "The new hotkey %s uses the same shortkey as the path %s!"
                textstr = (char*)_allocsafe( strlen( catalog.getLocale( 424 ) ) +
                                              strlen( im_h1->getName() ) +
                                             strlen( p1->getName() ) + 1 );
                sprintf( textstr, catalog.getLocale( 424 ), im_h1->getName(), p1->getName() );
    
                str1 = catalog.getLocale( 425 );
                str1 += "|";
                str1 += catalog.getLocale( 431 );
                str1 += "|";
                str1 += catalog.getLocale( 426 );
                str1 += "|";
                str1 += catalog.getLocale( 8 );
                erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
                _freesafe(textstr);
    
                if ( erg == 2 ) {
                  // use new
                  p1->setKey( NULL );
                } else if ( erg == 1 ) {
                  im_h1->setKey( NULL );
                  always_keep = true;
                } else if ( erg == 0 )  {
                  // leave original
                  im_h1->setKey( NULL );
                } else ende = -1;
              } else if ( h1 != NULL ) {
                // "The new hotkey %s uses the same shortkey as the hotkey %s!"
                textstr = (char*)_allocsafe( strlen( catalog.getLocale( 422 ) ) +
                                             strlen( im_h1->getName() ) +
                                             strlen( h1->getName() ) + 1 );
                sprintf( textstr, catalog.getLocale( 422 ), im_h1->getName(), h1->getName() );
    
                str1 = catalog.getLocale( 425 );
                str1 += "|";
                str1 += catalog.getLocale( 431 );
                str1 += "|";
                str1 += catalog.getLocale( 426 );
                str1 += "|";
                str1 += catalog.getLocale( 8 );
                erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
                _freesafe(textstr);
    
                if ( erg == 2 ) {
                  // use new
                  h1->setKey( NULL );
                } else if ( erg == 1 ) {
                  im_h1->setKey( NULL );
                  always_keep = true;
                } else if ( erg == 0 )  {
                  // leave original
                  im_h1->setKey( NULL );
                } else ende = -1;
              }
            }
          }
        }
      }
      im_h1 = (WCHotkey*)hl->getNextElement( id );
    }
    hl->closeEnum( id );
  }

  if ( ende != 0 ) return 1;

  // now all shortkey conflicts are resolved
  
  // now add buttons, hotkeys and normal filetypes
  // put original and new buttons in a list and call setButtons
  // so if I change something later in setButtons, I don't have to do it here too
  if ( apply_b == true ) {
    bl = getButtons();
    id = bl->initEnum();
    b1 = (WCButton*)bl->getFirstElement( id );
    while ( b1 != NULL ) {
      l1.addElement( b1->duplicate() );
      b1 = (WCButton*)bl->getNextElement( id );
    }
    bl->closeEnum( id );

    bl = importconfig->getButtons();
    id = bl->initEnum();
    im_b1 = (WCButton*)bl->getFirstElement( id );
    while ( im_b1 != NULL ) {
      l1.addElement( im_b1->duplicate() );
      im_b1 = (WCButton*)bl->getNextElement( id );
    }
    bl->closeEnum( id );
    
    setButtons( &l1 );
    
    b1 = (WCButton*)l1.getFirstElement();
    while ( b1 != NULL ) {
      delete b1;
      l1.removeFirstElement();
      b1 = (WCButton*)l1.getFirstElement();
    }
  }
  // like buttons
  if ( apply_h == true ) {
    hl = getHotkeys();
    id = hl->initEnum();
    h1 = (WCHotkey*)hl->getFirstElement( id );
    while ( h1 != NULL ) {
      l1.addElement( h1->duplicate() );
      h1 = (WCHotkey*)hl->getNextElement( id );
    }
    hl->closeEnum( id );

    hl = importconfig->getHotkeys();
    id = hl->initEnum();
    im_h1 = (WCHotkey*)hl->getFirstElement( id );
    while ( im_h1 != NULL ) {
      l1.addElement( im_h1->duplicate() );
      im_h1 = (WCHotkey*)hl->getNextElement( id );
    }
    hl->closeEnum( id );
    
    setHotkeys( &l1 );
    
    h1 = (WCHotkey*)l1.getFirstElement();
    while ( h1 != NULL ) {
      delete h1;
      l1.removeFirstElement();
      h1 = (WCHotkey*)l1.getFirstElement();
    }
  }
  if ( apply_f == true ) {
    // here we need a two-pass-run over the types
    // 1.For each unique type in importconfig
    //   find equal unique
    //   Ask which should be used and add it
    // 2.add all normal types from current config and then from importconfig
    fl = getFiletypes();
    im_fl = importconfig->getFiletypes();

    id = fl->initEnum();
    im_id = im_fl->initEnum();

    f1 = (WCFiletype*)fl->getFirstElement( id );
    while ( f1 != NULL ) {
      if ( f1->getinternID() != NORMALTYPE ) {
        // not a normal type
        // because special types are unique, ask the user
        // which should be used

        // find new type for this id
        im_f1 = (WCFiletype*)im_fl->getFirstElement( im_id );
        while ( im_f1 != NULL ) {
          if ( im_f1->getinternID() == f1->getinternID() ) break;
          im_f1 = (WCFiletype*)im_fl->getNextElement( im_id );
        }

        if ( im_f1 != NULL ) {
          // same unique type found
          textstr = (char*)_allocsafe( strlen( catalog.getLocale( 429 ) ) +
                                       strlen( im_f1->getName() ) +
                                       strlen( f1->getName() ) + 1 );
          sprintf( textstr, catalog.getLocale( 429 ), im_f1->getName(), f1->getName() );

          str1 = catalog.getLocale( 427 );
          str1 += "|";
          str1 += catalog.getLocale( 428 );
          erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
          _freesafe( textstr );
          if ( erg == 0 ) {
            l1.addElement( f1->duplicate() );
          } else {
            l1.addElement( im_f1->duplicate() );            
          }
        } else {
          l1.addElement( f1->duplicate() );
        }
      }
      f1 = (WCFiletype*)fl->getNextElement( id );
    }
    fl->closeEnum( id );
    im_fl->closeEnum( im_id );
    
    // now add all normal types beginning in fl, then in im_fl
    fl = getFiletypes();
    id = fl->initEnum();
    f1 = (WCFiletype*)fl->getFirstElement( id );
    while ( f1 != NULL ) {
      if ( f1->getinternID() == NORMALTYPE )
        l1.addElement( f1->duplicate() );
      f1 = (WCFiletype*)fl->getNextElement( id );
    }
    fl->closeEnum( id );

    fl = importconfig->getFiletypes();
    id = fl->initEnum();
    im_f1 = (WCFiletype*)fl->getFirstElement( id );
    while ( im_f1 != NULL ) {
      if ( im_f1->getinternID() == NORMALTYPE )
        l1.addElement( im_f1->duplicate() );
      im_f1 = (WCFiletype*)fl->getNextElement( id );
    }
    fl->closeEnum( id );
    
    setFiletypes( &l1 );
    
    f1 = (WCFiletype*)l1.getFirstElement();
    while ( f1 != NULL ) {
      delete f1;
      l1.removeFirstElement();
      f1 = (WCFiletype*)l1.getFirstElement();
    }
  }
  req.request( catalog.getLocale( 124 ), catalog.getLocale( 430 ), catalog.getLocale( 11 ) );
  return 0;
}

void WCFiletype::setFileExp( const char* nv )
{
  if ( nv == NULL ) return;
#if 0  // for filetype checking with file
  free_compexp();
#endif
  _freesafe( fileexp );
  fileexp = dupstring( nv );
}

const char *WCFiletype::getFileExp()
{
  return fileexp;
}

void WCFiletype::setUseFileExp( bool nv )
{
  usefileexp = nv;
}

bool WCFiletype::getUseFileExp()
{
  return usefileexp;
}

#if 0  // for filetype checking with file
void WCFiletype::free_compexp()
{
  if ( regex_compiled == true ) {
    regfree( &preg );
    regex_compiled = false;
  }
}

void WCFiletype::compile_exp()
{
  int erg;

  if ( regex_compiled == false ) {
    erg = regcomp( &preg, fileexp, REG_NOSUB );
    if ( erg == 0 ) {
      regex_compiled = true;
    } else {
      // error
    }
  }
}
#endif

//TODO: wenn es regex nicht gibt strstr benutzen
bool WCFiletype::fileExpMatchString( const char *mstr )
{
  bool matched = false;
#if 0  // for filetype checking with file
  int erg;
#endif

  if ( strlen( fileexp ) < 1 ) return false;
  if ( mstr == NULL ) return false;
  if ( strlen( mstr ) < 1 ) return false;
#if 0  // for filetype checking with file
  compile_exp();
  if ( regex_compiled == true ) {
    erg = regexec( &preg, mstr, 0, NULL, 0 );
    if ( erg == 0 ) matched = true;
  }
#endif
  return matched;
}

void WConfig::setDateFormat( int nv )
{
  date_format = nv;
  if ( date_format < -1 ) date_format = 0;
}

int WConfig::getDateFormat()
{
  return date_format;
}

void WConfig::setDateFormatString( const char *nv )
{
  _freesafe( date_formatstring );
  if ( nv == NULL ) {
    date_formatstring = dupstring( DEFAULT_DATE_STRING );
  } else {
    date_formatstring = dupstring( nv );
  }
}

const char *WConfig::getDateFormatString()
{
  return date_formatstring;
}

void WConfig::setDateSubst( bool nv )
{
  date_subst = nv;
}

bool WConfig::getDateSubst()
{
  return date_subst;
}

void WConfig::setTimeFormat( int nv )
{
  time_format = nv;
  if ( time_format < -1 ) time_format = 0;
}

int WConfig::getTimeFormat()
{
  return time_format;
}

void WConfig::setTimeFormatString( const char *nv )
{
  _freesafe( time_formatstring );
  if ( nv == NULL ) {
    time_formatstring = dupstring( DEFAULT_TIME_STRING );
  } else {
    time_formatstring = dupstring( nv );
  }
}

const char *WConfig::getTimeFormatString()
{
  return time_formatstring;
}

void WConfig::setDateBeforeTime( bool nv )
{
  date_before_time = nv;
}

bool WConfig::getDateBeforeTime()
{
  return date_before_time;
}

int WConfig::configureDateTime()
{
  AWindow *win,*swin1, *swin2;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty, tw, tx;
  AGMessage *msg;
  ChooseButton *cb1,*cb2;
  Button *b2[2];
  Text *ttext,*text1,*text2;
  StringGadget *sg1,*sg2;
  BevelBox *bb1,*bb2;
  CycleButton *cyc1,*cyc2;
  int nr_of_predates, nr_of_pretimes, i;
  char buf[128];
  time_t curtime;
  struct tm *loctime;
  
  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 439 ) );

  ty = 5;
  
  ttext = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 440 ), 1 ) );
  ty += ttext->getHeight() + 5;
  
  bb1 = (BevelBox*)win->add( new BevelBox( aguix, 5, ty, w, h, 1 ) );
  ty += 5;
  tx = 10;
  
  cyc1 = (CycleButton*)win->add( new CycleButton( aguix, tx, ty, 100, 1, 0, 0 ) );
  ty+= cyc1->getHeight() + 5;
  
  swin1 = new AWindow( aguix );
  swin1->create( win, tx, ty, 10, 10, 0, "" );
  text1 = (Text*)swin1->add( new Text( aguix, 0, 0, catalog.getLocale( 441 ), 1 ) );
  sg1 = (StringGadget*)swin1->add( new StringGadget( aguix, text1->getWidth() + 5, 0, 200, date_formatstring, 0 ) );
  AGUIX::centerElementsY( text1, sg1 );

  swin1->setBorderWidth( 0 );  
  swin1->maximizeY();
  swin1->maximizeX();
  
  ty += swin1->getHeight() + 5;
  swin1->show();
  
  cb1 = (ChooseButton*)win->add( new ChooseButton( aguix,
                                                   tx,
                                                   ty,
                                                   date_subst,
                                                   catalog.getLocale( 442 ),
                                                   LABEL_LEFT,
                                                   1,
                                                   0 ) );
  ty += cb1->getHeight() + 10;
  
  curtime = time( NULL );
  loctime = localtime( &curtime );
  nr_of_predates = sizeof( predefined_dates ) / sizeof( predefined_dates[0] );
  for ( i = 0; i < nr_of_predates; i++ ) {
    strftime( buf, 127, predefined_dates[i], loctime );
    cyc1->addOption( buf );
  }
  cyc1->addOption( catalog.getLocale( 443 ) );
  
  bb1->resize( bb1->getWidth(), cb1->getY() + cb1->getHeight() + 5 - bb1->getY() );
  tx = 5;

  // time
  ttext = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 444 ), 1 ) );
  ty += ttext->getHeight() + 5;
  
  bb2 = (BevelBox*)win->add( new BevelBox( aguix, 5, ty, w, h, 1 ) );
  ty += 5;
  tx = 10;
  
  cyc2 = (CycleButton*)win->add( new CycleButton( aguix, tx, ty, 100, 1, 0, 0 ) );
  ty+= cyc2->getHeight() + 5;
  
  swin2 = new AWindow( aguix );
  swin2->create( win, tx, ty, 10, 10, 0, "" );
  text2 = (Text*)swin2->add( new Text( aguix, 0, 0, catalog.getLocale( 441 ), 1 ) );
  sg2 = (StringGadget*)swin2->add( new StringGadget( aguix, text2->getWidth() + 5, 0, 200, time_formatstring, 0 ) );
  AGUIX::centerElementsY( text2, sg2 );

  swin2->setBorderWidth( 0 );
  swin2->maximizeY();
  swin2->maximizeX();
  
  ty += swin2->getHeight() + 10;
  swin2->show();
  
  nr_of_pretimes = sizeof( predefined_times ) / sizeof( predefined_times[0] );
  for ( i = 0; i < nr_of_pretimes; i++ ) {
    strftime( buf, 127, predefined_times[i], loctime );
    cyc2->addOption( buf );
  }
  cyc2->addOption( catalog.getLocale( 443 ) );
  
  bb2->resize( bb2->getWidth(), swin2->getY() + swin2->getHeight() + 5 - bb2->getY() );

  tx = 5;
  cb2 = (ChooseButton*)win->add( new ChooseButton( aguix,
                                                   tx,
                                                   ty,
                                                   date_before_time,
                                                   catalog.getLocale( 445),
                                                   LABEL_LEFT,
                                                   1,
                                                   0 ) );
  ty += cb2->getHeight() + 10;

  cyc1->resize( cyc1->getMaxSize(), cyc1->getHeight() );
  cyc2->resize( cyc2->getMaxSize(), cyc2->getHeight() );
  
  win->maximizeX();
  w = win->getWidth() + 5;
  
  bb1->resize( w - 10, bb1->getHeight() );
  bb2->resize( w - 10, bb2->getHeight() );
  
  b2[0] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 11 ), 1, 0, 0 ) );
  b2[1] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  tw = AGUIX::scaleElementsW( w, win->getBorderWidth(), 10, -1, false, false, (GUIElement**)b2, 2 );
  if ( tw > w ) w = tw;
  
  ty += b2[0]->getHeight() + 5;
  
  h = ty;

  if ( date_format == -1 ) {
    cyc1->setOption( nr_of_predates );
  } else {
    if ( ( date_format >= 0 ) && ( date_format < nr_of_predates ) ) {
      cyc1->setOption( date_format );
    } else {
      cyc1->setOption( 0 );
    }
    swin1->hide();
  }
  if ( time_format == -1 ) {
    cyc2->setOption( nr_of_pretimes );
  } else {
    if ( ( time_format >= 0 ) && ( time_format < nr_of_pretimes ) ) {
      cyc2->setOption( time_format );
    } else {
      cyc2->setOption( 0 );
    }
    swin2->hide();
  }

  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b2[0] ) {
          // Okay
          ende = 1;
        } else if ( msg->button.button == b2[1] ) {
          // Cancel
          ende = -1;
        }
      } else if ( msg->type == AG_CYCLEBUTTONCLICKED ) {
        if ( msg->cyclebutton.cyclebutton == cyc1 ) {
          if ( msg->cyclebutton.option == nr_of_predates )
            swin1->show();
          else
            swin1->hide();
        } else if ( msg->cyclebutton.cyclebutton == cyc2 ) {
          if ( msg->cyclebutton.option == nr_of_pretimes )
            swin2->show();
          else
            swin2->hide();
        }
      }

      aguix->ReplyMessage( msg );
    }
    if ( ende == 1 ) {
      i = cyc1->getSelectedOption();
      if ( i == nr_of_predates ) {
        setDateFormat( -1 );
        setDateFormatString( sg1->getText() );
      } else {
        setDateFormat( i );
      }
      setDateSubst( ( cb1->getState() == 1 ) ? true : false );

      i = cyc2->getSelectedOption();
      if ( i == nr_of_pretimes ) {
        setTimeFormat( -1 );
        setTimeFormatString( sg2->getText() );
      } else {
        setTimeFormat( i );
      }
      setDateBeforeTime( ( cb2->getState() == 1 ) ? true : false );     
    }
  }
  
  swin1->close();
  delete swin1;
  swin2->close();
  delete swin2;
  win->close();
  delete win;
  
  return ( ende == -1 ) ? 1 : 0;
}

int WConfig::getDatelen( const struct tm *timeptr )
{
  char buf[512];
  const char *format;
  int i, nr_of_predates, nr_of_pretimes, x, len, tlen;
  int datelen;
  
  if ( timeptr == NULL ) return 512;  // max length we will allow

  nr_of_predates = sizeof( predefined_dates ) / sizeof( predefined_dates[0] );
  nr_of_pretimes = sizeof( predefined_times ) / sizeof( predefined_times[0] );

  if ( date_format == -1 ) {
    format = date_formatstring;
  } else {
    i = 0;
    if ( ( date_format >= 0 ) && ( date_format < nr_of_predates ) ) {
      i = date_format;
    }
    format = predefined_dates[i];
  }
  
  len = strftime( buf, 511, format, timeptr );
  if ( date_subst == true ) {
    tlen = strlen( catalog.getLocale(436) );
    if ( tlen > len ) len = tlen;
    tlen = strlen( catalog.getLocale(437) );
    if ( tlen > len ) len = tlen;
    tlen = strlen( catalog.getLocale(438) );
    if ( tlen > len ) len = tlen;
  }
  
  datelen = len;
  
  // now for the time
  if ( time_format == -1 ) {
    format = time_formatstring;
  } else {
    i = 0;
    if ( ( time_format >= 0 ) && ( time_format < nr_of_pretimes ) ) {
      i = time_format;
    }
    format = predefined_times[i];
  }
  
  x = strftime( buf, 511, format, timeptr );
  return x + 1 + datelen;
}

int WConfig::writeDateToString( char *buf, int maxlen , struct tm *tptr )
{
  const char *tformat, *dformat;
  int i, nr_of_predates, nr_of_pretimes, len, offset;
  time_t now;
  struct tm *timeptr, todaytime, yesterdaytime, tomorrowtime, curtime;
  bool istoday = false, isyesterday = false, istomorrow = false;
  int ylen, tolen, tomlen, dlen;
  char tbuf[512];
  
  if ( tptr == NULL ) return 0;
  if ( buf == NULL ) return 0;
  if ( maxlen < 1 ) return 0;
  
  curtime = *tptr;

  now = time( NULL );
  timeptr = localtime( &now );
  todaytime = *timeptr;
  now -= 24*60*60;  // this is yesterday
  timeptr = localtime( &now );
  yesterdaytime = *timeptr;
  now += 2*24*60*60; // this is tomorrow
  timeptr = localtime( &now );
  tomorrowtime = *timeptr;
  
  if ( ( curtime.tm_mday == todaytime.tm_mday ) &&
       ( curtime.tm_mon == todaytime.tm_mon ) &&
       ( curtime.tm_year == todaytime.tm_year ) ) {
    istoday = true;
  } else {
    if ( ( curtime.tm_mday == yesterdaytime.tm_mday ) &&
         ( curtime.tm_mon == yesterdaytime.tm_mon ) &&
         ( curtime.tm_year == yesterdaytime.tm_year ) ) {
      isyesterday = true;
    } else {
      if ( ( curtime.tm_mday == tomorrowtime.tm_mday ) &&
           ( curtime.tm_mon == tomorrowtime.tm_mon ) &&
           ( curtime.tm_year == tomorrowtime.tm_year ) ) {
        istomorrow = true;
      }
    }
  }

  nr_of_predates = sizeof( predefined_dates ) / sizeof( predefined_dates[0] );
  nr_of_pretimes = sizeof( predefined_times ) / sizeof( predefined_times[0] );

  if ( date_format == -1 ) {
    dformat = date_formatstring;
  } else {
    i = 0;
    if ( ( date_format >= 0 ) && ( date_format < nr_of_predates ) ) {
      i = date_format;
    }
    dformat = predefined_dates[i];
  }

  dlen = strftime( tbuf, 511, dformat, &curtime );
  len = dlen;
  if ( date_subst == true ) {
    ylen = strlen( catalog.getLocale(436) );
    if ( ylen > len ) len = ylen;
    tolen = strlen( catalog.getLocale(437) );
    if ( tolen > len ) len = tolen;
    tomlen = strlen( catalog.getLocale(438) );
    if ( tomlen > len ) len = tomlen;
  }
  datelen = len;

  if ( time_format == -1 ) {
    tformat = time_formatstring;
  } else {
    i = 0;
    if ( ( time_format >= 0 ) && ( time_format < nr_of_pretimes ) ) {
      i = time_format;
    }
    tformat = predefined_times[i];
  }
  
  offset = 0;
  for ( i = 0; i < 2; i++ ) {
    if ( ( ( date_before_time == true ) && ( i == 0 ) ) ||
         ( ( date_before_time == false ) && ( i == 1 ) ) ) {
      if ( ( date_subst == true ) && ( istoday == true ) ) {
        len = strlen( catalog.getLocale(437) );
        len = w_min( len, maxlen - offset );
        strncpy( buf + offset, catalog.getLocale(437), len );
      } else if ( ( date_subst == true ) && ( isyesterday == true ) ) {
        len = strlen( catalog.getLocale(436) );
        len = w_min( len, maxlen - offset );
        strncpy( buf + offset, catalog.getLocale(436), len );
      } else if ( ( date_subst == true ) && ( istomorrow == true ) ) {
        len = strlen( catalog.getLocale(438) );
        len = w_min( len, maxlen - offset );
        strncpy( buf + offset, catalog.getLocale(438), len );
      } else {
//        len = strftime( buf + offset, maxlen - offset, dformat, timeptr );
        len = w_min( dlen, maxlen - offset );
        strncpy( buf + offset, tbuf, len );
      }
      buf[ offset + len ] = ' ';
      offset += datelen + 1;
    } else {
      len = strftime( buf + offset, maxlen - offset, tformat, &curtime );
      buf[ offset + len ] = ' ';
      offset += len + 1;
    }
  }
  return offset - 1;
}

