/* normalops.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: normalops.cc,v 1.8 2001/11/03 17:10:57 ralf Exp $ */

#include "normalops.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

/******
  ChangeListerSetOp
*******/

const char *ChangeListerSetOp::name="ChangeListerSetOp";

bool ChangeListerSetOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *ChangeListerSetOp::getName()
{
  return name;
}

ChangeListerSetOp::ChangeListerSetOp(Worker *tworker):FunctionProto(tworker)
{
  mode=CLS_ACTUAL_LISTER;
}

ChangeListerSetOp::~ChangeListerSetOp()
{
}

ChangeListerSetOp *ChangeListerSetOp::duplicate()
{
  ChangeListerSetOp *ta=new ChangeListerSetOp(worker);
  ta->mode=mode;
  return ta;
}

int ChangeListerSetOp::run(ActionMessage *msg)
{
  Lister *l1;
  switch(mode) {
    case CLS_LEFT_LISTER:
      l1=worker->getLister(0);
      break;
    case CLS_RIGHT_LISTER:
      l1=worker->getLister(1);
      break;
    case CLS_OTHER_LISTER:
      l1=worker->getOtherLister(worker->getActiveLister());
      break;
    default:
      l1=worker->getActiveLister();
  }
  if(l1!=NULL) l1->configure();
  return 0;
}

const char *ChangeListerSetOp::getDescription()
{
  return catalog.getLocaleCom(19);
}

int ChangeListerSetOp::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *rcyb;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(19))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(19));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(348),1));
  x+=ttext->getWidth()+5;
  rcyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  rcyb->addOption(catalog.getLocale(326));
  rcyb->addOption(catalog.getLocale(327));
  rcyb->addOption(catalog.getLocale(324));
  rcyb->addOption(catalog.getLocale(325));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());

  switch(mode) {
    case CLS_RIGHT_LISTER:
      rcyb->setOption(1);
      break;
    case CLS_ACTUAL_LISTER:
      rcyb->setOption(2);
      break;
    case CLS_OTHER_LISTER:
      rcyb->setOption(3);
      break;
    default:
      rcyb->setOption(0);
      break;
  }
  
  y+=rcyb->getHeight()+5;
  tw=x+rcyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  h=y;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    switch(rcyb->getSelectedOption()) {
      case 1:
        mode=CLS_RIGHT_LISTER;
        break;
      case 2:
        mode=CLS_ACTUAL_LISTER;
        break;
      case 3:
        mode=CLS_OTHER_LISTER;
        break;
      default:
        mode=CLS_LEFT_LISTER;
        break;
    }
  }
  
  win->close();
  delete win;

  return endmode;
}

bool ChangeListerSetOp::save(Datei *fh)
{
  int size=Datei::getUCharSize();
  fh->putInt(size);

  switch(mode) {
    case CLS_RIGHT_LISTER:
      fh->putUChar(1);
      break;
    case CLS_ACTUAL_LISTER:
      fh->putUChar(2);
      break;
    case CLS_OTHER_LISTER:
      fh->putUChar(3);
      break;
    default:
      fh->putUChar(0);
  }
  return true;
}

int ChangeListerSetOp::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int cs=Datei::getUCharSize();
  unsigned char c1;
  if(chunksize>=cs) {
    c1=fh->getUChar();
    switch(c1) {
      case 1:
        mode=CLS_RIGHT_LISTER;
        break;
      case 2:
        mode=CLS_ACTUAL_LISTER;
        break;
      case 3:
        mode=CLS_OTHER_LISTER;
        break;
      default:
        mode=CLS_LEFT_LISTER;
        break;
    }
    chunksize-=cs;
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return true;
}

void ChangeListerSetOp::setMode(int nv)
{
  switch(nv) {
    case CLS_RIGHT_LISTER:
      mode=nv;
      break;
    case CLS_ACTUAL_LISTER:
      mode=nv;
      break;
    case CLS_OTHER_LISTER:
      mode=nv;
      break;
    default:
      mode=CLS_LEFT_LISTER;
  }
}

/*************
 Ende ChangeListerSetOp
**************/

/******
  SwitchListerOp
*******/

const char *SwitchListerOp::name="SwitchListerOp";

bool SwitchListerOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SwitchListerOp::getName()
{
  return name;
}

SwitchListerOp::SwitchListerOp(Worker *tworker):FunctionProto(tworker)
{
}

SwitchListerOp::~SwitchListerOp()
{
}

SwitchListerOp *SwitchListerOp::duplicate()
{
  SwitchListerOp *ta=new SwitchListerOp(worker);
  return ta;
}

int SwitchListerOp::run(ActionMessage *msg)
{
  Lister *l1;
  l1=worker->getOtherLister(worker->getActiveLister());
  if(l1!=NULL) l1->makeActive();
  return 0;
}

const char *SwitchListerOp::getDescription()
{
  return catalog.getLocaleCom(20);
}

/*************
 Ende SwitchListerOp
**************/

/******
  FilterSelectOp
*******/

const char *FilterSelectOp::name="FilterSelectOp";

bool FilterSelectOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *FilterSelectOp::getName()
{
  return name;
}

FilterSelectOp::FilterSelectOp(Worker *tworker):FunctionProto(tworker)
{
  filter=(char*)_allocsafe(2);
  strcpy(filter,"*");
  actual_filter=(char*)_allocsafe(1);
  actual_filter[0]=0;
}

FilterSelectOp::~FilterSelectOp()
{
  _freesafe(filter);
  _freesafe(actual_filter);
}

FilterSelectOp *FilterSelectOp::duplicate()
{
  FilterSelectOp *ta=new FilterSelectOp(worker);
  _freesafe(ta->filter);
  ta->filter=dupstring(filter);
  return ta;
}

int FilterSelectOp::run(ActionMessage *msg)
{
  Lister *l1;
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          /* Requester oeffnen */
          if(requestfilter()==true) {
            nm1=(NormalMode*)lm1;
            nm1->filterselect(actual_filter,0);
          }
        }
      }
    }
  }
  return 0;
}

const char *FilterSelectOp::getDescription()
{
  return catalog.getLocaleCom(21);
}

int FilterSelectOp::configure()
{
  int w,h,tw,ty,tx;
  int t1,t2;
  StringGadget *sg;
  AGUIX *aguix=worker->getAGUIX();
  AWindow *win=new AWindow(aguix);
  char *tstr;

  w=h=10;
  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(21))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(21));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);
  
  ty=5;
  tx=5;
  Text *tt1=(Text*)win->add(new Text(aguix,tx,ty,catalog.getLocale(349),1));
  tw=tt1->getWidth();
  tx+=tw+5;

  sg=(StringGadget*)win->add(new StringGadget(aguix,tx,ty,100,
                                              filter,
                                              0));
  tw=tx+sg->getWidth()+5;
  if(tw>w) w=tw;
  ty+=sg->getHeight()+5;
  
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  sg->resize(w-10-tt1->getWidth()-5,sg->getHeight());
  win->resize(w,h);
  win->setMinSize(w,h);
  win->setMaxSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    _freesafe(filter);
    filter=dupstring(sg->getText());
  }
  win->close();
  delete win;
  return (ende==1)?0:1;
}

bool FilterSelectOp::save(Datei *fh)
{
  fh->putInt(Datei::getIntSize()+strlen(filter));
  fh->putInt(strlen(filter));
  fh->putString(filter);
  return true;
}

int FilterSelectOp::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int len;
  char *str;
  if(chunksize>=Datei::getIntSize()) {
    len=fh->getInt();
    chunksize-=Datei::getIntSize();
    str=fh->getString(len);
    _freesafe(filter);
    filter=str;
    chunksize-=len;
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

bool FilterSelectOp::requestfilter()
{
  int w,h,tw,ty;
  int t1,t2;
  StringGadget *sg;
  AGUIX *aguix=worker->getAGUIX();
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,10,10,0,catalog.getLocale(268));
  w=0;
  h=0;
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(270),1));
  tw=tt1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=tt1->getHeight()+5;
  tt1=(Text*)win->add(new Text(aguix,10,ty,catalog.getLocale(272),1));
  tw=tt1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=tt1->getHeight()+5;

  sg=(StringGadget*)win->add(new StringGadget(aguix,5,ty,tw-10,
                                              strlen(actual_filter)>0?actual_filter:filter,
                                              0));
  tw=sg->getWidth()+10;
  if(tw>w) w=tw;
  ty+=sg->getHeight()+5;
  
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  sg->resize(w-10,sg->getHeight());
  win->resize(w,h);
  win->setMinSize(w,h);
  win->setMaxSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  sg->activate();
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      } else if(msg->type==AG_STRINGGADGET_OK) {
        if(msg->stringgadget.sg==sg) ende=1;
      } else if(msg->type==AG_STRINGGADGET_CANCEL) {
        if(msg->stringgadget.sg==sg) ende=-1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    _freesafe(actual_filter);
    actual_filter=dupstring(sg->getText());
  }
  win->close();
  delete win;
  return (ende==1?true:false);
}

/*************
 Ende FilterSelectOp
**************/

/******
  FilterUnSelectOp
*******/

const char *FilterUnSelectOp::name="FilterUnSelectOp";

bool FilterUnSelectOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *FilterUnSelectOp::getName()
{
  return name;
}

FilterUnSelectOp::FilterUnSelectOp(Worker *tworker):FilterSelectOp(tworker)
{
}

FilterUnSelectOp::~FilterUnSelectOp()
{
}

FilterUnSelectOp *FilterUnSelectOp::duplicate()
{
  FilterUnSelectOp *ta=new FilterUnSelectOp(worker);
  _freesafe(ta->filter);
  ta->filter=dupstring(filter);
  return ta;
}

int FilterUnSelectOp::run(ActionMessage *msg)
{
  Lister *l1;
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          /* Requester oeffnen */
          if(requestfilter()==true) {
            nm1=(NormalMode*)lm1;
            nm1->filterselect(actual_filter,1);
          }
        }
      }
    }
  }
  return 0;
}

const char *FilterUnSelectOp::getDescription()
{
  return catalog.getLocaleCom(22);
}

int FilterUnSelectOp::configure()
{
  int w,h,tw,ty,tx;
  int t1,t2;
  StringGadget *sg;
  AGUIX *aguix=worker->getAGUIX();
  AWindow *win=new AWindow(aguix);
  char *tstr;

  w=h=10;
  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(22))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(22));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);
  
  ty=5;
  tx=5;
  Text *tt1=(Text*)win->add(new Text(aguix,tx,ty,catalog.getLocale(349),1));
  tw=tt1->getWidth();
  tx+=tw+5;

  sg=(StringGadget*)win->add(new StringGadget(aguix,tx,ty,100,
                                              filter,
                                              0));
  tw=tx+sg->getWidth()+5;
  if(tw>w) w=tw;
  ty+=sg->getHeight()+5;
  
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  sg->resize(w-10-tt1->getWidth()-5,sg->getHeight());
  win->resize(w,h);
  win->setMinSize(w,h);
  win->setMaxSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    _freesafe(filter);
    filter=dupstring(sg->getText());
  }
  win->close();
  delete win;
  return (ende==1)?0:1;
}

bool FilterUnSelectOp::requestfilter()
{
  int w,h,tw,ty;
  int t1,t2;
  StringGadget *sg;
  AGUIX *aguix=worker->getAGUIX();
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,10,10,0,catalog.getLocale(269));
  w=0;
  h=0;
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(271),1));
  tw=tt1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=tt1->getHeight()+5;
  tt1=(Text*)win->add(new Text(aguix,10,ty,catalog.getLocale(272),1));
  tw=tt1->getWidth()+10;
  if(tw>w) w=tw;
  ty+=tt1->getHeight()+5;

  sg=(StringGadget*)win->add(new StringGadget(aguix,5,ty,tw-10,
                                              strlen(actual_filter)>0?actual_filter:filter,
                                              0));
  tw=sg->getWidth()+10;
  if(tw>w) w=tw;
  ty+=sg->getHeight()+5;
  
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  sg->resize(w-10,sg->getHeight());
  win->resize(w,h);
  win->setMinSize(w,h);
  win->setMaxSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  sg->activate();
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      } else if(msg->type==AG_STRINGGADGET_OK) {
        if(msg->stringgadget.sg==sg) ende=1;
      } else if(msg->type==AG_STRINGGADGET_CANCEL) {
        if(msg->stringgadget.sg==sg) ende=-1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    _freesafe(actual_filter);
    actual_filter=dupstring(sg->getText());
  }
  win->close();
  delete win;
  return (ende==1?true:false);
}

/*************
 Ende FilterUnSelectOp
**************/

/******
  Path2OSideOp
*******/

const char *Path2OSideOp::name="Path2OSideOp";

bool Path2OSideOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *Path2OSideOp::getName()
{
  return name;
}

Path2OSideOp::Path2OSideOp(Worker *tworker):FunctionProto(tworker)
{
}

Path2OSideOp::~Path2OSideOp()
{
}

Path2OSideOp *Path2OSideOp::duplicate()
{
  Path2OSideOp *ta=new Path2OSideOp(worker);
  return ta;
}

int Path2OSideOp::run(ActionMessage *msg)
{
  Lister *l1;
  ListerMode *lm1;
  NormalMode *nm1;
  char *dir=NULL;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          dir=nm1->getActualDir();
        }
      }
    }
    if(dir!=NULL) {
      l1=worker->getOtherLister(worker->getActiveLister());
      if(l1!=NULL) {
        l1->switch2Mode(0);
        lm1=l1->getActiveMode();
        if(lm1!=NULL) {
          if(lm1->isType("NormalMode")==true) {
            nm1=(NormalMode*)lm1;
            nm1->enterDir(dir);
          }
        }
      }
    }
  }
  return 0;
}

const char *Path2OSideOp::getDescription()
{
  return catalog.getLocaleCom(23);
}

/*************
 Ende Path2OSideOp
**************/

/******
  QuitOp
*******/

const char *QuitOp::name="QuitOp";

bool QuitOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *QuitOp::getName()
{
  return name;
}

QuitOp::QuitOp(Worker *tworker):FunctionProto(tworker)
{
  mode=Q_NORMAL_QUIT;
}

QuitOp::~QuitOp()
{
}

QuitOp *QuitOp::duplicate()
{
  QuitOp *ta=new QuitOp(worker);
  ta->mode=mode;
  return ta;
}

int QuitOp::run(ActionMessage *msg)
{
  worker->quit(mode==Q_QUICK_QUIT?1:0);
  return 0;
}

const char *QuitOp::getDescription()
{
  return catalog.getLocaleCom(24);
}

int QuitOp::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *rcyb;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(24))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(24));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(350),1));
  x+=ttext->getWidth()+5;
  rcyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  rcyb->addOption(catalog.getLocale(351));
  rcyb->addOption(catalog.getLocale(352));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());

  switch(mode) {
    case Q_QUICK_QUIT:
      rcyb->setOption(1);
      break;
    default:
      rcyb->setOption(0);
      break;
  }
  
  y+=rcyb->getHeight()+5;
  tw=x+rcyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  h=y;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    switch(rcyb->getSelectedOption()) {
      case 1:
        mode=Q_QUICK_QUIT;
        break;
      default:
        mode=Q_NORMAL_QUIT;
        break;
    }
  }
  
  win->close();
  delete win;

  return endmode;
}

bool QuitOp::save(Datei *fh)
{
  int size=Datei::getUCharSize();
  fh->putInt(size);

  switch(mode) {
    case Q_QUICK_QUIT:
      fh->putUChar(1);
      break;
    default:
      fh->putUChar(0);
  }
  return true;
}

int QuitOp::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int cs=Datei::getUCharSize();
  unsigned char c1;
  if(chunksize>=cs) {
    c1=fh->getUChar();
    switch(c1) {
      case 1:
        mode=Q_QUICK_QUIT;
        break;
      default:
        mode=Q_NORMAL_QUIT;
        break;
    }
    chunksize-=cs;
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return true;
}

void QuitOp::setMode(int nmode)
{
  if(nmode==Q_QUICK_QUIT) mode=nmode;
  else mode=Q_NORMAL_QUIT;
}

/*************
 Ende QuitOp
**************/

