/* informationmode.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: informationmode.cc,v 1.10 2002/04/05 15:22:01 ralf Exp $ */

#include "informationmode.h"
#include "normalmode.h"
#include "locale.h"
#include "wconfig.h"
#include "worker.h"
#include "partspace.h"

const char *InformationMode::type="InformationMode";

InformationMode::InformationMode(Lister *parent):ListerMode(parent)
{
  x=0;
  y=0;
  w=0;
  h=0;
  lastactivefe=NULL;
  lv=NULL;
  blanked=false;
  nospaceinfo=false;
}

InformationMode::~InformationMode()
{
  lastactivefe=NULL;
}

void InformationMode::messageHandler(AGMessage *msg)
{
  int tx,ty,tw,th;
  bool ma=false;
  switch(msg->type) {
    case AG_SIZECHANGED:
      parentlister->getGeometry(&tx,&ty,&tw,&th);
      reconf(tx,ty,tw,th);
      break;
  }
  if(ma==true) parentlister->makeActive();
}

void InformationMode::on()
{
  parentlister->getGeometry(&x,&y,&w,&h);
  int side=parentlister->getSide();
  int m;

  lv=(ListView*)parentawindow->add(new ListView(aguix,x,y,w,h,1));
  m=(wconfig->getHBarTop(side)==true)?1:2;
  lv->setHBarState(m);
  m=(wconfig->getVBarLeft(side)==true)?1:2;
  lv->setVBarState(m);
  m=wconfig->getHBarHeight(side);
  lv->setHBarHeight(m);
  m=wconfig->getVBarWidth(side);
  lv->setVBarWidth(m);
  lv->setFont(wconfig->getFont(2+side));
  
  for(m=0;m<19;m++) {
    lv->add(new ListViewContent("",1,1,1,1,0,0,0,0,m));
  }

  parentlister->setActiveMode(this);
  setName();
}

void InformationMode::off()
{
  parentawindow->remove(lv);
  parentlister->setActiveMode(NULL);
  parentlister->setName("");
  lastactivefe=NULL;
}

void InformationMode::reconf(int tx,int ty,int tw,int th)
{
  if((tw!=w)||(th!=h)||(tx!=x)||(ty!=y)) {
    w=tw;
    h=th;
    x=tx;
    y=ty;
    lv->resize(w,h);
    lv->move(x,y);
    update(true);
  }
}

void InformationMode::activate()
{
}

void InformationMode::deactivate()
{
}

bool InformationMode::isType(const char *str)
{
  if(strcmp(str,type)==0) return true; else return false;
}

const char *InformationMode::getType()
{
  return type;
}

int InformationMode::configure()
{
  return 0;
}

void InformationMode::cyclicfunc(cyclicfunc_mode_t mode)
{
  update(false);
}

const char* InformationMode::getName()
{
  return catalog.getLocale(175);
}

int InformationMode::load(Datei *fh)
{
  int chunksize=fh->getInt();
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

bool InformationMode::save(Datei *fh)
{
  int cs=0;

  fh->putInt(cs);
  return false;
}

void InformationMode::setName()
{
  parentlister->setName(catalog.getLocale(175));
}

void InformationMode::reconfig()
{
}

void InformationMode::update(bool force)
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  Lister *ol=NULL;
  List *files;
  NM_specialsource *ss1;
  FileEntry *fe;
  
  ol=parentlister->getWorker()->getOtherLister(parentlister);
  if(ol!=NULL) {
    lm1=ol->getActiveMode();
    if(lm1!=NULL)
      if(lm1->isType("NormalMode")==true)
        nm1=(NormalMode*)lm1;
  }
  
  if ( ( force == true ) ||
       ( nospaceinfo == true ) )
    lastactivefe=NULL;
  
  if(nm1!=NULL) {
    files=new List();
    
    nm1->getSelFiles(files,NormalMode::NM_GETFILES_ONLYACTIVE);
    ss1=(NM_specialsource*)files->getFirstElement();
    if(ss1!=NULL) {
      fe=ss1->entry;
      if(fe!=lastactivefe) {
        lastactivefe=fe;
        if(lastactivefe!=NULL) {
          showinfos();
        }
      }
    } else {
      lastactivefe=NULL;
      for(int i=0;i<lv->getElements();i++) lv->get(i)->setText("");
    }
    
    ss1=(NM_specialsource*)files->getFirstElement();
    while(ss1!=NULL) {
      _freesafe(ss1);
      ss1=(NM_specialsource*)files->getNextElement();
    }
    
    delete files;
  }
}

void InformationMode::showinfos()
{
  FileEntry *fe;
  int x2,len,len2;
  char buffer[1024],buffer2[MAXPATHLEN],buffer3[10],rights[3][4],*str;
  char *mstr,*kstr,*tstr;
  bool showno;
  loff_t size;
  int size_size,ksize_size,msize_size;
  
  float percent;
  struct tm *timeptr;
  long f1,s1;
  
  showno=true;
  fe=lastactivefe;
  if(fe!=NULL) {
    showno=false;
    tstr=(char*)_allocsafe(strlen("%s: %s")+strlen(catalog.getLocale(176))+strlen(fe->name)+1);
    sprintf(tstr,"%s: %s",catalog.getLocale(176),fe->name);
    lv->get(1)->setText(tstr);
    _freesafe(tstr);
    
    if((fe->isDir()==true)&&(fe->isCorrupt==false)) {
      if(fe->dirsize>=0) size=fe->dirsize;
      else size=fe->size;
    } else size=fe->size;

    size_size=LongSize(size);
    str=(char*)_allocsafe(size_size+1);
    str[MakeLong2NiceStr(str,size)]='\0';

    ksize_size=LongSize((size+512)/1024);
    kstr=(char*)_allocsafe(LongSize((size+512)/1024)+1);
    kstr[MakeLong2NiceStr(kstr,(size+512)/1024)]='\0';

    msize_size=LongSize((size+524288)/1048576);
    mstr=(char*)_allocsafe(LongSize((size+524288)/1048576)+1);
    mstr[MakeLong2NiceStr(mstr,(size+524288)/1048576)]='\0';

    tstr=(char*)_allocsafe(strlen("%s: %s B, %s KB, %s MB")+
                          strlen(catalog.getLocale(177))+
                          size_size+
                          ksize_size+
                          msize_size+1);
    sprintf(tstr,"%s: %s B, %s KB, %s MB",catalog.getLocale(177),str,kstr,mstr);
    _freesafe(str);
    _freesafe(kstr);
    _freesafe(mstr);
    lv->get(2)->setText(tstr);
    _freesafe(tstr);
    
    if(fe->filetype!=NULL) {
      tstr=(char*)_allocsafe(strlen("%s: %s")+
                             strlen(catalog.getLocale(178))+
                             strlen(fe->filetype->getName())+1);
      sprintf(tstr,"%s: %s",catalog.getLocale(178),fe->filetype->getName());
    } else {
      if(fe->isDir()==true) {
//        tstr=(char*)_allocsafe(strlen("%s: %s")+
//                               strlen(catalog.getLocale(178))+
//                               strlen(catalog.getLocale(109))+1);
//        sprintf(tstr,"%s: %s",catalog.getLocale(178),catalog.getLocale(109));
        tstr=(char*)_allocsafe(strlen("%s: %s")+
                               strlen(catalog.getLocale(178))+
                               strlen(wconfig->getdirtype()->getName())+1);
        sprintf(tstr,"%s: %s",catalog.getLocale(178),wconfig->getdirtype()->getName());
      } else {
        tstr=(char*)_allocsafe(strlen("%s: %s")+
                               strlen(catalog.getLocale(178))+
                               strlen(wconfig->getnotyettype()->getName())+1);
        sprintf(tstr,"%s: %s",catalog.getLocale(178),wconfig->getnotyettype()->getName());
      }
    }
    lv->get(3)->setText(tstr);
    _freesafe(tstr);
    
    if(fe->isLink==true) {
      str=fe->getDestination();
      
      tstr=(char*)_allocsafe(strlen("  %s: %s")+
                             strlen(catalog.getLocale(179))+
                             strlen(str)+1);
      sprintf(tstr,"  %s: %s",catalog.getLocale(179),str);
      _freesafe(str);
      lv->get(4)->setText(tstr);
      _freesafe(tstr);
    } else lv->get(4)->setText("");
    
    str=fe->getSPermStr();
    strncpy(rights[0],str,3);
    rights[0][3]='\0';
    strncpy(rights[1],str+3,3);
    rights[1][3]='\0';
    strncpy(rights[2],str+6,3);
    rights[2][3]='\0';
    len=strlen(catalog.getLocale(180));
    len2=strlen(catalog.getLocale(214));
    for(x2=1;x2<3;x2++) if(strlen(catalog.getLocale(214+x2))>(size_t)len2) len2=strlen(catalog.getLocale(214+x2));
    sprintf(buffer2,"%%%ds %%%ds %%s",len,len2);
    
    tstr=(char*)_allocsafe(strlen(buffer2)+
                           strlen(catalog.getLocale(180))+
                           strlen(catalog.getLocale(214))+
                           strlen(catalog.getLocale(215))+
                           strlen(catalog.getLocale(216))+
                           4+1);   // don't need so much space but prevents more allocs or max-calculation
    
    sprintf(tstr,buffer2,catalog.getLocale(180),catalog.getLocale(214),rights[0]);
    lv->get(6)->setText(tstr);
    sprintf(tstr,buffer2,"",catalog.getLocale(215),rights[1]);
    lv->get(7)->setText(tstr);
    sprintf(tstr,buffer2,"",catalog.getLocale(216),rights[2]);
    lv->get(8)->setText(tstr);
    _freesafe(tstr);

    str=getOwnerString(fe->userid,fe->groupid);
    
    tstr=(char*)_allocsafe(strlen("%s: %s")+
                           strlen(catalog.getLocale(184))+
                           strlen(str)+1);
    sprintf(tstr,"%s: %s",catalog.getLocale(184),str);
    _freesafe(str);
    lv->get(9)->setText(tstr);
    _freesafe(tstr);

    len=strlen(catalog.getLocale(162));
    for(x2=1;x2<3;x2++) if(strlen(catalog.getLocale(162+x2))>(size_t)len) len=strlen(catalog.getLocale(162+x2));

    timeptr=localtime(&(fe->lastaccess));
    str=asctime(timeptr);
    str[strlen(str)-1]=0;
    sprintf(buffer2,"%%%ds: %%s",len);
    
    tstr=(char*)_allocsafe(strlen(buffer2)+
                           strlen(catalog.getLocale(162))+
                           strlen(str)+1);
    
    sprintf(tstr,buffer2,catalog.getLocale(162),str);
    lv->get(11)->setText(tstr);
    _freesafe(tstr);

    timeptr=localtime(&(fe->lastmod));
    str=asctime(timeptr);
    str[strlen(str)-1]=0;

    tstr=(char*)_allocsafe(strlen(buffer2)+
                           strlen(catalog.getLocale(163))+
                           strlen(str)+1);
    sprintf(tstr,buffer2,catalog.getLocale(163),str);
    lv->get(12)->setText(tstr);
    _freesafe(tstr);

    timeptr=localtime(&(fe->lastchange));
    str=asctime(timeptr);
    str[strlen(str)-1]=0;

    tstr=(char*)_allocsafe(strlen(buffer2)+
                           strlen(catalog.getLocale(164))+
                           strlen(str)+1);
    sprintf(tstr,buffer2,catalog.getLocale(164),str);
    lv->get(13)->setText(tstr);
    _freesafe(tstr);

    tstr=(char*)_allocsafe(strlen("%s: %s")+
                           strlen(catalog.getLocale(185))+
                           strlen(fe->fullname)+1);
    sprintf(tstr,"%s: %s",catalog.getLocale(185),fe->fullname);
    lv->get(15)->setText(tstr);
    _freesafe(tstr);

    if(realpath(fe->fullname,buffer2)!=NULL) {
      tstr=(char*)_allocsafe(strlen("%s: %s")+
                             strlen(catalog.getLocale(186))+
                             strlen(buffer2)+1);
      sprintf(tstr,"%s: %s",catalog.getLocale(186),buffer2);
    } else {
      tstr=(char*)_allocsafe(strlen("%s: ???")+
                             strlen(catalog.getLocale(186))+1);
      sprintf(tstr,"%s: ???",catalog.getLocale(186));
    }
    lv->get(16)->setText(tstr);
    _freesafe(tstr);

    if ( parentlister->getWorker()->PS_readSpace( fe->fullname ) == 0 ) {
      if ( parentlister->getWorker()->PS_getSpace() != 0 ) {
        percent = parentlister->getWorker()->PS_getFreeSpace() * 100 / 
                  parentlister->getWorker()->PS_getSpace() + .5;
      } else percent=0.0;

      tstr=buffer3;
      s1 = parentlister->getWorker()->PS_getSpaceH( &tstr );
      tstr=buffer2;
      f1 = parentlister->getWorker()->PS_getFreeSpaceH( &tstr );
      sprintf(buffer,"%s: %ld %s (%2.0f %%) %s %ld %s",catalog.getLocale(187),f1,buffer2,percent,
                                                       catalog.getLocale(188),s1,buffer3);
      nospaceinfo = false;
    } else {
      sprintf(buffer,"%s: ???",catalog.getLocale(187));
      nospaceinfo = true;
    }
    lv->get(18)->setText(buffer);
  }
  if(showno==true) {
    // fr alle anderen sind keine Informationen erhltlich
    for(int i=0;i<lv->getElements();i++) lv->get(i)->setText("");
    lv->get(2)->setText(catalog.getLocale(189));
  }
  lv->redraw();
}

