/*
 *  simple.h	
 *
 *  Written by:		Ullrich Hafner
 *  
 *  Copyright (C) 1999 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#ifndef _SIMPLE_H
#define _SIMPLE_H

#include <gtk/gtk.h>
#include <proplist.h>
#include "misc.h"


typedef struct omenudata
{
   const char	 **values;
   GtkOptionMenu *omenu;
} omenudata_t;

#ifdef HAVE_LIBWMFUN
typedef struct text_color
{
   GtkWidget  *option_menu;
   GtkWidget  *solid_color;
   GtkWidget  *color_set [3];
   proplist_t *key;
} text_color_t;

typedef enum {TCOLOR_SIMPLE, TCOLOR_COLORSET, TCOLOR_LAST} tcolor_e;

GtkWidget *
extended_color_dialog (GtkWidget *page, proplist_t *key, proplist_t *value,
		       GtkTooltips *tooltips, proplist_t *info,
		       proplist_t *title);
#endif /* HAVE_LIBWMFUN */

void
boolean_dialog (GtkWidget *table, proplist_t *key, proplist_t *value,
		proplist_t *info);
void
string_dialog (GtkWidget *table, proplist_t *key, proplist_t *value,
	       proplist_t *range, proplist_t *rinfo, proplist_t *info);
void
int_dialog (GtkWidget *table, proplist_t *key, proplist_t *value,
	    proplist_t *range, proplist_t *rinfo, proplist_t *info);
void
text_dialog (GtkWidget *table, proplist_t *key, proplist_t *value,
	     proplist_t *info);
GtkWidget *
font_dialog (GtkWidget *page, proplist_t *key, proplist_t *value,
	     proplist_t *info);
GtkWidget *
color_dialog (GtkWidget *page, proplist_t *key, proplist_t *value,
	      GtkTooltips *tooltips, proplist_t *info, proplist_t *title);
void
update_optionmenu (proplist_t *key, gpointer ptr, proplist_t *value,
		   const char *path);
bool_t
convert_bool (proplist_t *p);
void
iboolean_dialog (GtkWidget *table, proplist_t *key, proplist_t *value,
		 proplist_t *info);

#endif /* not _SIMPLE_H */
