/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_OUTMODULE_H
#define _WF_OUTMODULE_H

#include <iostream>
#include <string>

#include "wflogentries.h"
#include "config/wfconfig.h"

class wf_outmodule_conf {
 public:
  wf_outmodule_conf() {}
  virtual ~wf_outmodule_conf() {}
  // wf_outmodule_conf(wf_outmodule_conf&) {}

  virtual ostream& print(ostream& os) const = 0;

 public:
  wf_config config;
};

class wf_outmodule {
 public:
  wf_outmodule() {}
  virtual ~wf_outmodule() {}
  // wf_outmodule(wf_outmodule&) {}

  virtual string name() const = 0;

  virtual bool print(const wf_logentry* entry, ostream& os) = 0;
  /* is implemented here, and can be used by every module */
  virtual bool print(const wf_logentries& entries, ostream& os);

 public:
  wf_outmodule_conf* conf;
};

struct wf_outmodulelist {
  string name;
  wf_outmodule* (*initfunc)();
};

wf_outmodule* wf_outmodule_init(const string& name);
ostream& wf_outmodule_available_modules_print(ostream& os);

#endif
