# linux-lib.pl
# Functions for reading linux format last output

# passfiles_type()
# Returns 0 for old-style passwords (/etc/passwd only), 1 for FreeBSD-style
# (/etc/master.passwd) and 2 for SysV (/etc/passwd & /etc/shadow)
sub passfiles_type
{
return &password_file($config{'shadow_file'}) ? 2 : 0;
}

# groupfiles_type()
# Returns 0 for normal group file (/etc/group only) and 2 for shadowed
# (/etc/group and /etc/gshadow)
sub groupfiles_type
{
return &password_file($config{'gshadow_file'}) ? 2 : 0;
}

# open_last_command(handle, user)
sub open_last_command
{
local ($fh, $user) = @_;
open($fh, "last $user |");
}

# read_last_line(handle)
# Parses a line of output from last into an array of
#  user, tty, host, login, logout, period
sub read_last_line
{
$fh = $_[0];
while(1) {
	chop($line = <$fh>);
	if (!$line) { return (); }
	if ($line =~ /system boot/) { next; }
	if ($line =~ /^(\S+)\s+(\S+)\s+(\S+)?\s+(\S+\s+\S+\s+\d+\s+\d+:\d+)\s+\-\s+(\S+)\s+\((\d+:\d+)\)/) {
		return ($1, $2, $3, $4, $5 eq "down" ? "Shutdown" : $5, $6);
		}
	elsif ($line =~ /^(\S+)\s+(\S+)\s+(\S+)?\s+(\S+\s+\S+\s+\d+\s+\d+:\d+)\s+still/) {
		return ($1, $2, $3, $4);
		}
	}
}

# logged_in_users()
# Returns a list of hashes containing details of logged-in users
sub logged_in_users
{
local @rv;
open(WHO, "who |");
while(<WHO>) {
	if (/^(\S+)\s+(\S+)\s+(\S+\s+\d+\s+\d+:\d+)\s+(\((\S+)\))?/) {
		push(@rv, { 'user' => $1, 'tty' => $2,
			    'when' => $3, 'from' => $5 });
		}
	}
close(WHO);
return @rv;
}

# encrypt_password(password)
sub encrypt_password
{
local $md5 = 0;
if (&foreign_check("pam")) {
	# Use the PAM module if we can
	&foreign_require("pam", "pam-lib.pl");
	local @conf = &foreign_call("pam", "get_pam_config");
	local ($svc) = grep { $_->{'name'} eq 'passwd' } @conf;
	LOOP: foreach $m (@{$svc->{'mods'}}) {
		if ($m->{'type'} eq 'password') {
			if ($m->{'args'} =~ /md5/) { $md5++; }
			elsif ($m->{'module'} =~ /pam_stack\.so/ &&
			       $m->{'args'} =~ /service=(\S+)/) {
				# Referred to another service!
				($svc) = grep { $_->{'name'} eq $1 } @conf;
				if ($svc) { goto LOOP }
				else { last; }
				}
			}
		}
	}
elsif (open(PAM, "/etc/pam.d/passwd")) {
	# Otherwise try to check the PAM file directly
	while(<PAM>) {
		s/#.*$//g;
		$md5++ if (/^password.*md5/);
		}
	close(PAM);
	}
if (open(DEFS, "/etc/login.defs")) {
	# The login.defs file is used on debian sometimes
	while(<DEFS>) {
		s/#.*$//g;
		$md5++ if (/MD5_CRYPT_ENAB\s+yes/i);
		}
	close(DEFS);
	}
if ($md5 && !$config{'skip_md5'}) {
	# MD5 encrypt the password, using the same algorithm as PAM
	local $mode = 1;
	eval "use MD5";
	if ($@) {
		$mode = 2;
		eval "use Digest::MD5";
		if ($@) {
			&header($text{'error'}, "");
			print "<hr><p>\n";
			print &text('usave_emd5', "/config.cgi?$module_name",
			    "/cpan/download.cgi?source=3&cpan=MD5"),"<p>\n";
			print "<hr>\n";
			exit;
			}
		}
	local $passwd = $_[0];
	local $magic = '$1$';
	local $salt = substr(time(), -8);

	# Add the password, magic and salt
	local $ctx = ($mode == 1 ? new MD5 : new Digest::MD5);
	$ctx->add($passwd);
	$ctx->add($magic);
	$ctx->add($salt);

	# Add some more stuff from the hash of the password and salt
	local $ctx1 = ($mode == 1 ? new MD5 : new Digest::MD5);
	$ctx1->add($passwd);
	$ctx1->add($salt);
	$ctx1->add($passwd);
	local $final = $ctx1->digest();
	for($pl=length($passwd); $pl>0; $pl-=16) {
		$ctx->add($pl > 16 ? $final : substr($final, 0, $pl));
		}

	# This piece of code seems rather pointless, but it's in the C code that
	# does MD5 in PAM so it has to go in!
	local $j = 0;
	local ($i, $l);
	for($i=length($passwd); $i; $i >>= 1) {
		if ($i & 1) {
			$ctx->add("\0");
			}
		else {
			$ctx->add(substr($passwd, $j, 1));
			}
		}
	$final = $ctx->digest();

	# This loop exists only to waste time
	for($i=0; $i<1000; $i++) {
		$ctx1 = ($mode == 1 ? new MD5 : new Digest::MD5);
		$ctx1->add($i & 1 ? $passwd : $final);
		$ctx1->add($salt) if ($i % 3);
		$ctx1->add($passwd) if ($i % 7);
		$ctx1->add($i & 1 ? $final : $passwd);
		$final = $ctx1->digest();
		}

	# Convert the 16-byte final string into a readable form
	local $rv = $magic.$salt.'$';
	local @final = map { ord($_) } split(//, $final);
	$l = ($final[ 0]<<16) + ($final[ 6]<<8) + $final[12];
	$rv .= &to64($l, 4);
	$l = ($final[ 1]<<16) + ($final[ 7]<<8) + $final[13];
	$rv .= &to64($l, 4);
	$l = ($final[ 2]<<16) + ($final[ 8]<<8) + $final[14];
	$rv .= &to64($l, 4);
	$l = ($final[ 3]<<16) + ($final[ 9]<<8) + $final[15];
	$rv .= &to64($l, 4);
	$l = ($final[ 4]<<16) + ($final[10]<<8) + $final[ 5];
	$rv .= &to64($l, 4);
	$l = $final[11];
	$rv .= &to64($l, 2);

	return $rv;
	}
else {
	local $salt = chr(int(rand(26))+65) . chr(int(rand(26))+65);
	return crypt($_[0], $salt);
	}
}

@itoa64 = split(//, "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
sub to64
{
local ($v, $n) = @_;
local $r;
while(--$n >= 0) {
        $r .= $itoa64[$v & 0x3f];
        $v >>= 6;
        }
return $r;
}

1;
